package com.tandbergtv.cms.portal.reports.server.jreport;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

import javax.servlet.http.HttpServletRequest;

import org.apache.log4j.Logger;

import com.tandbergtv.cms.portal.reports.server.integration.ReportsSSOIntegrationManager;

public class CMSTokenAuthorizer {

    private static final String CMS_SESSION_ID = "cms_session_id";
    
    private static final String CMS_SESSION_REC_ID = "cms_session_rec_id";
    
    private static final String CMS_URL = "cms_url";
    
    private static Logger logger = Logger.getLogger(CMSTokenAuthorizer.class);
    
    public static boolean authorize(HttpServletRequest request) {
        boolean isAuthorized = false;
        
        ReportsSSOIntegrationManager integrationManager = new ReportsSSOIntegrationManager();
        
        Long recordId = null;
        if (request.getParameter(CMS_SESSION_REC_ID) != null) {
            try {
                recordId = new Long(request.getParameter(CMS_SESSION_REC_ID));
            } catch (NumberFormatException n) {
                // Not a number, user cheating... Nothing to do.                
            }
        }
        String cmsSessionId = request.getParameter(CMS_SESSION_ID);
        
        String userName = integrationManager.validateSessionTicket(recordId, cmsSessionId);

        if (userName != null) {
            isAuthorized = true;
            request.getSession().setAttribute("cms_user_id", userName);
        }
        
        return isAuthorized;
    }
    

    public static String getCMSUrl() {
        String url = CMSProperties.getInstance().get(CMS_URL);
        logger.debug("URL = " + url);
        try {
            url = replaceURLWithIP(url);
            logger.debug("replaced url =" + url);
        } catch (MalformedURLException e) {
            System.out.println("Invalid value for CMS_URL property: " + url);
            e.printStackTrace();
        } catch (UnknownHostException e) {
            System.out.println("Invalid host for url: " + url);
            e.printStackTrace();
        }
        return url;
    }
    
    /**
     * Resolves the hostname in the specified string representation of a URL and generates a new URL
     * containing the IP address in place of the hostname. If the hostname in the specified URL is
     * an IP address, the return value is equal to the input
     *
     * @param urlValue the URL string in which to replace all hostnames with IP addresses
     * @return the updated URL
     * @throws MalformedURLException the input URL is not a valid URL
     * @throws UnknownHostException the input URL has a host which cannot be resolved
     */
    private static String replaceURLWithIP(String urlValue) throws MalformedURLException, UnknownHostException {
        URL url = new URL(urlValue);
        String ip = getIPByHostname(url.getHost());
        URL updatedUrl = new URL(url.getProtocol(), ip, url.getPort(), url.getFile());
        
        String result = updatedUrl.toExternalForm();
        if (url.getRef() != null) {
            result+= "#" + url.getRef();
        }
        
        return result;
    }

    private static String getIPByHostname(String hostname) throws UnknownHostException {
        return InetAddress.getByName(hostname).getHostAddress();
    }
    
}
