<!DOCTYPE html>
<%@ include file="nlsResource.jsp" %>
<%@ include file="AuthCheck2.jsp" %>
<%@page contentType="text/html;charset=UTF-8" language="java" %>
<%@ page import="java.io.File,
		java.util.*,
		jet.cs.util.*,
		jet.server.util.WebSecurityUtil,
		jet.server.util.nls.*,
		jet.server.api.*,
                jet.server.api.http.*,
                jet.server.api.admin.cfg.ConfigurationCluster" %>
<%@ include file="welcomeInc.jsp" %>

<%!
	String getRealmPath(HttpServletRequest request) {
        String ret;
	    HttpRptServer httpRptServer = HttpUtil.getHttpRptServer(request);
	    ConfigurationCluster conCluster = httpRptServer.getAdminService().getConfigService().getConfigurationCluster();
	    String sharedRealmPath = conCluster.getShareRealmDirectory();
	    if (sharedRealmPath == null || sharedRealmPath.length() == 0) {
	        ret = httpRptServer.getResourceManager().getRealmDir();
	    } else {
    	    boolean existing = new File(sharedRealmPath).exists();
    	    if (existing) {    	    
	            ret = sharedRealmPath;
	        } else {
    	        ret = httpRptServer.getResourceManager().getRealmDir();
	      	}
	    }
	    if (!ret.endsWith(File.separator)) {
	        ret += File.separator;
	    }
	    return ret;
	}
%>
<%@ page errorPage="errorpage.jsp" %>
<%
	HttpRptServer httpRptServer = HttpUtil.getHttpRptServer(request);
	String user = HttpUtil.getUser(request);

    if("cms".equals(user)) {
	response.sendRedirect("welcome.jsp");
    }

	UserPreferenceManager preferenceManager = httpRptServer.getUserPreferenceManager();
	Properties preference = preferenceManager.getUserPreference(user);
	boolean useSection508 = APIUtil.getBoolean(preference.getProperty(APIConst.USE_SECTION508_COMPLIANT_PAGE));
    if(useSection508) {    
         //response.sendRedirect("accessibleIndex.jsp");
%>
<html>
<head>
<title><%=getNLSMessage(serverResourceForClass, "2221086")%></title>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<link href="../style/jinfonet/style.css" rel="stylesheet" type="text/css">
</head>

<body>
<p><img src="../images/Logo.gif" alt="<%=getNLSMessage(serverResourceForClass, "2110096")%>" border="0"></p>
<h5><%=getNLSMessage(serverResourceForClass, "2221087")%></h5>
<p><a href=# onClick="if (confirm('<%=getNLSMessage(serverResourceForClass, "2221496")%>')) {
                                        document.location.href='default.jsp';
                                    } else {
                                        return false;
                                    }" title="<%=getNLSMessage(serverResourceForClass, "2110097")%>"><%=getNLSMessage(serverResourceForClass, "2221088")%></a></p>
<h5><%=getNLSMessage(serverResourceForClass, "2221089")%> </h5>
  <table border="1">
    <tr>
      <th scope="col"><%=getNLSMessage(serverResourceForClass, "2220394")%></th>
      <th scope="col"><%=getNLSMessage(serverResourceForClass, "2220018")%></th>
      <th scope="col"><%=getNLSMessage(serverResourceForClass, "2220397")%></th>
      <th scope="col"><%=getNLSMessage(serverResourceForClass, "2220466")%></th>
    </tr>
    <tr>
<%
  String taskUrl = "getTableFormPage.jsp?" + APIConst.TAG_PATH + "=" 
	        + HttpUtil.encodeEsc(APIConst.USER_FOLDER_PATH + "/" + user);
%>
      <td scope="row"><a href="<%= WebSecurityUtil.escapeHTMLAttribute(taskUrl)%>" title="<%=getNLSMessage(serverResourceForClass, "2110098")%>"><%=getNLSMessage(serverResourceForClass, "2220407")%> </a></td>
      <td><%=getNLSMessage(serverResourceForClass, "2220469")%> </td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
    </tr>
    <tr>
<%
        taskUrl = "getTableFormPage.jsp?" + APIConst.TAG_PATH + HttpUtil.encodeEsc("/");
%>
      <td scope="row"><a href="<%= taskUrl%>" title="<%=getNLSMessage(serverResourceForClass, "2110099")%>"><%=getNLSMessage(serverResourceForClass, "2220408")%> </a></td>
      <td><%=getNLSMessage(serverResourceForClass, "2220469")%> </td>
      <td>&nbsp;</td>
      <td>&nbsp;</td>
    </tr>
  </table>
</body>
</html>
<%
    } else {
%>
		<script language="JavaScript" type="text/javascript">
			window.location.href = "default.jsp";
		</script>
<%
    }
%>
