<!DOCTYPE html>
<%@ include file="nlsResource.jsp" %>
<%@page contentType="text/html;charset=UTF-8" language="java" %>
<%@ page import="java.util.*, 
                 jet.cs.util.*, 
                 jet.server.api.*, 
                 jet.server.api.paramlist.*, 
		 jet.JSvrResource,
                 jet.server.api.http.*, 
                 jet.server.log.*,
                 jet.server.util.*,
                 java.net.URLEncoder,
                 com.jinfonet.web.beans.ResourceDef" %>
<%@ page errorPage="errorpage.jsp" %>
<%@ include file="AuthCheck.jsp" %>
<%@ include file="executeInc.jsp" %>
<%@ include file="checkParam.jsp" %>
<%@ include file="reportParameters.jsp" %>

<%!
	boolean isNoSupported (ReportInfo rptInfo, Hashtable ht) throws RptServerException {
		if (rptInfo.hasPageSecurity() && isToApplet(ht)) {
			return true;
		}
		return false;
	}

	boolean isToApplet(Hashtable ht) {
		int rstType = HttpUtil.getResultType((String)ht.get(APIConst.TAG_RESULT_TYPE), APIConst.RST);
		return rstType == APIConst.RST;
	}

	private void printNoSupportedMsg(PropertyMessageResourcesFactory serverResourceForClass, HttpServletResponse resp) throws IOException {
		String msg = getNLSMessage(serverResourceForClass, "2150336");
		PrintWriter writer = resp.getWriter();
		writer.println("<small><font face=\"Arial\">");
		writer.println("<h1>" + HttpServletResponse.SC_INTERNAL_SERVER_ERROR + " "+ getNLSMessage(serverResourceForClass, "2221436")  + "</h1><p>");
		writer.println(msg);
		writer.println("<p>");
		writer.println("</font></small>");
	}
%>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<title><%=getNLSMessage(serverResourceForClass, "2220056")%></title>
<link href="../style/main.css" rel="stylesheet" type="text/css">
<link href="../style/jquery.dialog.css" rel="stylesheet" type="text/css" />
<script src="../javascript/jquery-1.5.2.min.js" type="text/javascript"></script>
<script src="../javascript/jquery-ui-1.7.1.draggable.min.js" type="text/javascript"></script>
<script src="../javascript/jquery.dialog.js"  type="text/javascript"></script>
</head>
<body>

<%
    HttpRptServer httpRptServer = HttpUtil.getHttpRptServer(request);
    String user = HttpUtil.getUser(request);

    if(user == null) {
	throw new RuntimeException("User is null");
    }

    // Get HTTP query fields for running the report
    Properties ht = HttpUtil.getParameters(request);

    String catalogName = request.getParameter(APIConst.TAG_CATALOG);
    if(catalogName == null) {
	catalogName = request.getParameter("catalogName");
	if(catalogName == null) {
	    throw new RuntimeException("Catalog is null");
	}

	ht.put(APIConst.TAG_CATALOG, catalogName);
    }

    String reportName = request.getParameter(APIConst.TAG_REPORT);
    if(reportName == null) {
	reportName = request.getParameter("reportName");
	if(reportName == null) {
	    throw new RuntimeException("Report is null");
	}

	ht.put(APIConst.TAG_REPORT, reportName);
    }

    PathInfo originalPathInfo = httpRptServer.getResourceManager().getPathInfo(user, reportName);
    if (!originalPathInfo.isVA() && !originalPathInfo.isJDashboard() && originalPathInfo.getStatus() != APIConst.STATUS_REPORT_ACTIVE) {
%>

<script language="JavaScript" type="text/JavaScript">

<%
    String userAgent = request.getHeader("User-Agent");
    boolean isIE = (userAgent!=null && userAgent.indexOf("MSIE")>=0);
%>

	var isIE = <%= isIE%>;
	Jinfo("<%=WebSecurityUtil.escapeJavaScript(getNLSMessage(serverResourceForClass, "22221603", new Object[]{reportName}))%>", function(re){
		if (isIE) {
			if(history.length > 0){
				history.back();
			}else {
				window.close();
			}
		} else {
			window.close();
			history.back();
		}
	}); 
</script>
<%  
		return;
	}
    
    boolean relaceWithSession = !originalPathInfo.isJDashboard();
    
    if(relaceWithSession){
		ParamUtil.replaceWithSessionParameter(request.getSession(), ht);
	}
	
    String cat = ht.getProperty(APIConst.TAG_CATALOG);
    String rptName = ht.getProperty(APIConst.TAG_REPORT);
    
    boolean useSection508 = APIUtil.getBoolean(ht.getProperty("useSection508"));

	if (ServiceLogger.isLoggable(ServiceLogger.ACCESS, ServiceLogger.LEVEL_TRIVIAL)) {
		HttpSession ssn = request.getSession(false);
		String id = ssn == null ? null : ssn.getId();
		ServiceLogger.logAccessSuccessEvent(httpRptServer.getResourceManager().getRealm(), user, id, 
				" tryView " + " catFullName=" + cat + " rptName=" + rptName, ServiceLogger.LEVEL_TRIVIAL);
	}	
	String url;

	String paramKey = (String) ht.get(APIConst.TAG_ENGINE_ID);
	if (paramKey == null) {
		paramKey = ht.getProperty(APIConst.TAG_ENGINE_ID);
	}
	Vector vParams = null;
	int catVersion = APIUtil.parseInt((String)ht.get(APIConst.TAG_CAT_VERSION), -1);
    if (catVersion == -1 && cat != null) {
        catVersion = httpRptServer.getResourceManager().getPathInfo(user, cat).getLatestVersionNumber();
        ht.put(APIConst.TAG_CAT_VERSION, String.valueOf(catVersion));
    }
    int rptVersion = APIUtil.parseInt((String)ht.get(APIConst.TAG_RPT_VERSION), -1);
    if (rptVersion == -1) {
        rptVersion = httpRptServer.getResourceManager().getPathInfo(user, rptName).getLatestVersionNumber();
        ht.put(APIConst.TAG_RPT_VERSION, String.valueOf(rptVersion));
    }
    if (useSection508) {
    	ht.put(APIConst.TAG_USE_HTML_TABLE, "true");
    	ht.put(APIConst.TAG_USE_SECTION508_OUTPUT, "true");
    	ht.put(APIConst.TAG_RELATIVE_FONT_SIZE, "true");
    	ht.put(APIConst.TAG_IS_CHART_APPLET, "false");
    	ht.put(APIConst.TAG_FORMAT_CHART, "0");
    }
    String timeStr = ht.getProperty("currTime");
    if (timeStr == null){
    GregorianCalendar currCal = new GregorianCalendar();
    long currTime = currCal.getTimeInMillis();
    ht.put("currTime", String.valueOf(currTime));
    }
	ht.put("is_direct_run", "true");


	// for 62692-1364
	UserPreferenceManager preferenceManager = httpRptServer.getUserPreferenceManager();
	Properties preference = preferenceManager.getUserPreference(user);
	String isEnableDefaultNLSStr = (String)ht.get(APIConst.TAG_ENABLE_DEFAULT_NLS);
	if (null != isEnableDefaultNLSStr && isEnableDefaultNLSStr.length() > 0) {
		boolean isEnableDefaultNLS = APIUtil.getBoolean(isEnableDefaultNLSStr);
		if (isEnableDefaultNLS) {
			String nlsLocale = (String)ht.get(APIConst.TAG_NLS_LOCALE);

			String[] tmp = nlsLocale.split("_");
			Locale locale = tmp.length == 3 ? new Locale(tmp[0], tmp[1],  tmp[2]) : (tmp.length == 2 ? new Locale(tmp[0], tmp[1]) : new Locale(tmp[0]));

			if(!ht.containsKey(APIConst.TAG_REPORT_LANGUAGE)){
				ht.put(APIConst.TAG_REPORT_LANGUAGE, locale.getLanguage());
				ht.put(APIConst.TAG_REPORT_COUNTRY, locale.getCountry());
				ht.put(APIConst.TAG_REPORT_VARIANT, locale.getVariant());
			}

			String nlsEncoding = (String)ht.get(APIConst.TAG_NLS_ENCODING);
			if(!ht.containsKey(APIConst.TAG_REPORT_ENCODING)){
				ht.put(APIConst.TAG_REPORT_ENCODING, nlsEncoding);
			}

			if(!ht.containsKey(APIConst.TAG_ENABLE_NLS)){
				ht.put(APIConst.TAG_ENABLE_NLS, "true");
			}
		} else {
			Locale locale = nlsClientResourceForClass.getLocale();
			if (locale == null) {
				locale = Locale.getDefault();
			}

			if(!ht.containsKey(APIConst.TAG_REPORT_LANGUAGE)){
				ht.put(APIConst.TAG_REPORT_LANGUAGE, locale.getLanguage());
				ht.put(APIConst.TAG_REPORT_COUNTRY, locale.getCountry());
				ht.put(APIConst.TAG_REPORT_VARIANT, locale.getVariant());
			}

			if(!ht.containsKey(APIConst.TAG_ENABLE_NLS)){
				ht.put(APIConst.TAG_ENABLE_NLS, "false");
			}
		}
	} else {

		boolean isEnableDefaultNLS = APIUtil.getBoolean(preference.getProperty(APIConst.TAG_ENABLE_DEFAULT_NLS));

		if (isEnableDefaultNLS) {
			String nlsLocale = preference.getProperty(APIConst.TAG_NLS_LOCALE);
			String nlsEncoding = preference.getProperty(APIConst.TAG_NLS_ENCODING);

			String[] tmp = nlsLocale.split("_");
			Locale locale = tmp.length == 3 ? new Locale(tmp[0], tmp[1],  tmp[2]) : (tmp.length == 2 ? new Locale(tmp[0], tmp[1]) : new Locale(tmp[0]));

			if(!ht.containsKey(APIConst.TAG_REPORT_LANGUAGE)){
				ht.put(APIConst.TAG_REPORT_LANGUAGE, locale.getLanguage());
				ht.put(APIConst.TAG_REPORT_COUNTRY, locale.getCountry());
				ht.put(APIConst.TAG_REPORT_VARIANT, locale.getVariant());
			}

			if(!ht.containsKey(APIConst.TAG_REPORT_ENCODING)){
				ht.put(APIConst.TAG_REPORT_ENCODING, nlsEncoding);
			}

			if(!ht.containsKey(APIConst.TAG_ENABLE_NLS)){
				ht.put(APIConst.TAG_ENABLE_NLS, "true");
			}
		} else {
			Locale locale = nlsClientResourceForClass.getLocale();
			if (locale == null) {
				locale = Locale.getDefault();
			}

			if(!ht.containsKey(APIConst.TAG_REPORT_LANGUAGE)){
				ht.put(APIConst.TAG_REPORT_LANGUAGE, locale.getLanguage());
				ht.put(APIConst.TAG_REPORT_COUNTRY, locale.getCountry());
				ht.put(APIConst.TAG_REPORT_VARIANT, locale.getVariant());
			}

			if(!ht.containsKey(APIConst.TAG_ENABLE_NLS)){
				ht.put(APIConst.TAG_ENABLE_NLS, "false");
			}
		}

	}
	//ht.put(APIConst.TAG_ENABLE_NLS, "true");
	//isEnableDefaultNLSStr = preference.getProperty(APIConst.TAG_ENABLE_DEFAULT_NLS);
	boolean isEnableDefaultNLS = APIUtil.getBoolean(isEnableDefaultNLSStr);
	if (isEnableDefaultNLS) {
		String nlsLocaleStr = preference.getProperty(APIConst.TAG_NLS_LOCALE);
		String[] tmp = nlsLocaleStr.split("_");
		Locale nlsLocale = tmp.length == 3 ? new Locale(tmp[0], tmp[1],  tmp[2]) : (tmp.length == 2 ? new Locale(tmp[0], tmp[1]) : new Locale(tmp[0]));

		ht.put(APIConst.TAG_PARAM_LOCALE, nlsLocale);
	}/* else {

		ht.put(APIConst.TAG_PARAM_LOCALE, nlsClientResource.getLocale());
	}*/



    
	String lang = (String) ht.get(APIConst.TAG_REPORT_LANGUAGE);
	String country = (String) ht.get(APIConst.TAG_REPORT_COUNTRY);
	String variant = (String) ht.get(APIConst.TAG_REPORT_VARIANT);
	Locale clientLocale = nlsClientResourceForClass.getLocale();
	if (clientLocale == null) {
		clientLocale = Locale.getDefault();
	}
	ht.put(APIConst.TAG_CLIENT_LOCALE, clientLocale);
	if(!ht.containsKey(APIConst.TAG_REPORT_LANGUAGE)){
		ht.put(APIConst.TAG_REPORT_LANGUAGE, clientLocale.getLanguage());
		ht.put(APIConst.TAG_REPORT_COUNTRY, clientLocale.getCountry());
		ht.put(APIConst.TAG_REPORT_VARIANT, clientLocale.getVariant());
	}

	boolean hasParam = false;
	boolean paramPageDisabled = APIUtil.getBoolean((String)ht.getProperty("paramPageDisabled"), false);
	boolean paramPage = APIUtil.getBoolean((String)ht.getProperty(APIConst.TAG_PARAM_PAGE), true);
	if(
		!httpRptServer.getResourceManager().getPathInfo(user, rptName).isJDashboard()
		&& !httpRptServer.getResourceManager().getPathInfo(user, rptName).isVA()
	){
	String currentSheet = null;
	String currentSheetDisplayname = null;
	ReportInfo rptInfo = httpRptServer.getReportInfo(user, cat, catVersion, rptName, rptVersion, ht);
	int rstTp = APIUtil.parseInt((String)ht.getProperty(APIConst.TAG_RESULT_TYPE), 0);
	int rptStatus = (rstTp == APIConst.DHTML)? APIConst.RPT_STATUS_OPEN : APIConst.RPT_STATUS_CURRENT;
	Vector<ReportSheetInfo> sheets = rptInfo.getReportSheetInfos(rptStatus);
	boolean hasNormalRpt = false;
	int size = sheets.size();
	for(ReportSheetInfo sheet:sheets) {
		if(!sheet.isBurstingReport()){
			hasNormalRpt = true;
			break;
		}
	}
	if (!hasNormalRpt) {
	    rptInfo.removeParamEngineById(rptInfo.getParamEngineId());
%>
<script language="JavaScript" type="text/JavaScript">
<%
    String userAgent = request.getHeader("User-Agent");
    boolean isIE = (userAgent!=null && userAgent.indexOf("MSIE")>=0);
%>
	var isIE = <%= isIE%>;
	Jinfo("<%=getNLSMessage(serverResourceForClass, "2221672")%>", function(re){
		if (isIE) {
			if(history.length > 0){
				history.back();
			}else {
				window.close();
			}
		} else {
			window.close();
			history.back();
		}
	});  
</script>
<%  
	return;
	}
	if (rptInfo.getParamEngineId() != null) {
    	ht.put(APIConst.TAG_ENGINE_ID, rptInfo.getParamEngineId());
	}
	String DHTMLSheets = "";
	Hashtable formatOptions = null;
	try {
		if (!useSection508) {
		  for ( Enumeration e = ht.keys() ; e.hasMoreElements() ; ) {
    		String key = (String)e.nextElement();
    		if (key.startsWith(APIConst.TAG_REPORT_SHEET)) {
    			currentSheet = key.substring(key.indexOf("$") + 1);
    			break;
    		} 
		  }
			if (currentSheet != null) {
			  for(int j=0; j<size; j++) {
					ReportSheetInfo sheet = ((ReportSheetInfo)sheets.get(j));
					if (currentSheet.equals(sheet.getName())) {
						int temp = sheet.getExportFormat();
						if (temp >= 0) {
							rstTp = temp;
							formatOptions = sheet.getExportOptionProperties();
							ht.put(APIConst.TAG_RESULT_TYPE, String.valueOf(rstTp));
						}
					}
			  }
			} else {
				ReportSheetInfo rptSheetInfo = rptInfo.getCurrentReportSheet();
				if(rptSheetInfo!=null && !rptSheetInfo.isBurstingReport()) {
					int temp = rptSheetInfo.getExportFormat();
					if (temp >= 0) {
						rstTp = temp;
						formatOptions = rptSheetInfo.getExportOptionProperties();
						ht.put(APIConst.TAG_RESULT_TYPE, String.valueOf(rstTp));
					}
				}
			}
		}
		if (formatOptions != null) {
			ht.putAll(formatOptions);
		}
		vParams = getAllParamInfos(ht, rptInfo, paramKey, rptStatus); //exlude burst sheets
	    hasParam = vParams.size()>0;
	    if(rstTp == APIConst.DHTML && hasParam) {
	        for (ReportSheetInfo sheet:sheets) {
				DHTMLSheets += sheet.getName() + ",";
	        }
		}
		if (!useSection508) {
			if (currentSheet != null) {
			  for(int j=0; j<size; j++) {
					ReportSheetInfo sheet = ((ReportSheetInfo)sheets.get(j));
					if (currentSheet.equals(sheet.getName())) {
						if (!sheet.isBurstingReport()) {
							currentSheetDisplayname = sheet.getDisplayName();
							break;
						} else if (rstTp != APIConst.DHTML) {
%>							
<script language="JavaScript" type="text/JavaScript">
	Jinfo("<%=getNLSMessage(serverResourceForClass, "2221675")%>", function(re){
		history.back(1);	
	});
</script>	
<%
						return;
						}
					}
				}												
			} else {
		    ReportSheetInfo rptSheetInfo = rptInfo.getCurrentReportSheet();
		    if(rptSheetInfo!=null && !rptSheetInfo.isBurstingReport()) {
		        currentSheet = rptSheetInfo.getName();
						currentSheetDisplayname = rptSheetInfo.getDisplayName();
		    } else if (rstTp != APIConst.DHTML) {
%>	    	
<script language="JavaScript" type="text/JavaScript">
	Jinfo("<%=getNLSMessage(serverResourceForClass, "2221674")%>", function(re){
		history.back(1);
	});
</script>	
<%    
    	return;	
	   	}
	   }
	  }
	} catch (RptServerException e) {
		ServiceLogger.logError(e);
		String eMsg = e.getMessage();
    	if (eMsg == null) eMsg = e.getOriginalThrowable().getMessage();
    	else if (eMsg.length() == 0) eMsg = e.getOriginalThrowable().getMessage();
%>
&nbsp;&nbsp;<b><%=getNLSMessage(serverResourceForClass, "2221128")%></b><br>
&nbsp;&nbsp;<%= jet.server.util.HtmlEncoder.encode(eMsg) %>
<%        
        return;
	}
	boolean bNoSupported = isNoSupported(rptInfo, ht);
	if (bNoSupported) {
		printNoSupportedMsg(serverResourceForClass, response);
		return;
	}	
	ReportSheetInfo sheetInfo = rptInfo.getCurrentReportSheet();
	String rptSheet = sheetInfo.getName();
	ht.put("rptsheet", rptSheet);
	ht.put(APIConst.REPORT_SHEET_DISPLAYNAME+"$"+rptSheet, sheetInfo.getDisplayName());
	//int rstTp = APIUtil.parseInt((String)ht.getProperty(APIConst.TAG_RESULT_TYPE), 0);
  if (rstTp == APIConst.DHTML && !DHTMLSheets.equals("")) {
		DHTMLSheets = DHTMLSheets.substring(0, DHTMLSheets.length() -1);
	    ht.put("dhtmlrptsheet", DHTMLSheets);
  }
  if (rstTp == APIConst.RST) {
	  ht.put(APIConst.TAG_FRAMEAPPLET, true);
  }
  if (currentSheet != null && rstTp != APIConst.DHTML && !useSection508) {
	   ht.put(APIConst.TAG_REPORT_SHEET + "$" + currentSheet, "true");
	   ht.put(APIConst.REPORT_SHEET_DISPLAYNAME + "$" + currentSheet, currentSheetDisplayname);
	}
}	
	boolean showParamPage = true;
	if (hasParam && !isParameterReady(ht, vParams)) {
							
		String User = HttpUtil.getUser(request);
		String RptName = ht.getProperty(APIConst.TAG_REPORT);
		PathInfo RptPathInfo = httpRptServer.getResourceManager().getPathInfo(User, RptName);

		UserPreferenceManager preferenceMgr = httpRptServer.getUserPreferenceManager();
		Properties _preference = preferenceMgr.getUserPreference(User);

		boolean enableSet4JReportViewer = APIUtil.getBoolean(_preference.getProperty(APIConst.TAG_ENABLE_SETTING_DEFAULT_PARAMETER_VALUES_4_JREPORT_VIEWER));
		boolean enableSet4JReportStudio = APIUtil.getBoolean(_preference.getProperty(APIConst.TAG_ENABLE_SETTING_DEFAULT_PARAMETER_VALUES_4_JREPORT_STUDIO));

		boolean enableHide4JReportViewer = APIUtil.getBoolean(_preference.getProperty(APIConst.TAG_ENABLE_HIDING_INITIAL_PARAMETER_DIALOG_4_JREPORT_VIEWER));
		boolean enableHide4JReportStudio = APIUtil.getBoolean(_preference.getProperty(APIConst.TAG_ENABLE_HIDING_INITIAL_PARAMETER_DIALOG_4_JREPORT_STUDIO));

		boolean isStudio = RptPathInfo.isStudioReport();
		boolean isPageReport = RptPathInfo.isReport() && !RptPathInfo.isStudioReport() && !RptPathInfo.isJDashboard() && !RptPathInfo.isVA();

		//boolean disableParamInput = ((isPageReport && !enableSet4JReportViewer) || (isStudio && !enableSet4JReportStudio));

		boolean disableDontShowParamDialog = ((isPageReport && !enableHide4JReportViewer) || (isStudio && !enableHide4JReportStudio));
							
		if(disableDontShowParamDialog){
			showParamPage = true;
		}else{
			if(!paramPageDisabled){
				showParamPage = paramPage;
			}else{
				showParamPage = !ParamUtil.isDontShowParamPage(user, ht);
				if(!showParamPage){
					ht.put(APIConst.TAG_SAVED_PARAM_LIST_TYPE, ReportParamList.TYPE_DEFAULT);
					ParamUtil.resetParamValues(user, "", ht);
					ht.remove(APIConst.TAG_SAVED_PARAM_LIST_TYPE);
				}
			}
		}
	} else {
		showParamPage = false;
	}
	
	//patch: 64663 bug: 60220
    if(relaceWithSession){
		ParamUtil.removeSessionParameter(request.getSession(), ht);
	}
	
	if(showParamPage){
		url = "getRptParam.jsp?" + HttpUtil.makeQuery(ht);
	}else{
		url = "runReport.jsp?" + HttpUtil.makeQuery(ht);
	}
	
	//base on implementation of JSP compiler.
	out.clearBuffer();
	response.setStatus(HttpServletResponse.SC_MOVED_TEMPORARILY);
	response.setHeader("Location", WebSecurityUtil.validateResponseHeader(url));
	response.setHeader("Content-Location", WebSecurityUtil.validateResponseHeader(url));
%>
<H1><%=getNLSMessage(serverResourceForClass, "2221085")%></H1>
<%=getNLSMessage(serverResourceForClass, "2150235")%>
<a href="<%= WebSecurityUtil.escapeHTMLAttribute(url) %>"><%= WebSecurityUtil.escapeHTML(url) %></a>
</body>
</html>
<%
	//return;
%>
