/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTexturePattern;
import chart.graphics.RoundGradientPaint;
import chart.properties.ChartNodeProperties;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;

public class Graph2DLineNode {
    public static final int RECTANGLE = 0;
    public static final int DIAMOND = 1;
    public static final int TRIANGLEUP = 2;
    public static final int TRIANGLEDOWN = 3;
    public static final int TRIANGLELEFT = 4;
    public static final int TRIANGLERIGHT = 5;
    public static final int CIRCLE = 6;
    public static final int CROSS1 = 7;
    public static final int CROSS2 = 8;
    public static final int NONE = 9;
    public static final int STAR1 = 10;
    public static final int STAR2 = 11;
    public static final int ARROW = 12;
    public static final int ARROW1 = 13;
    public static final int DEFAULT_SIZE = 3;
    public static final int DEFAULT_STYLE = 1;
    public static final int MAX_SIZE = 14;
    public static final Color DEFAULT_COLOR = Color.black;
    public static final String[] styleNames = new String[]{"Rectangle", "Diamond", "Triangle Up", "Triangle Down", "Triangle Left", "Triangle Right", "Circle", "Cross1", "Cross2", "None", "Star1", "Star2"};
    protected int x;
    protected int y;
    protected int style = 9;
    protected int size;
    protected int maxSize = -1;
    protected ChartPenStyle pen;
    protected ChartFillPattern pattern;
    private GeneralPath SEDU = new GeneralPath();
    private int addPoint = 3;
    private int append = 5;
    private int black = 5;
    private int clone = 2;
    private int draw = 2;
    private int drawNode;
    private int err;
    private int fill;
    private int getBorderClr;
    private int getBorderClrTrans;
    private int getBorderPen;
    private int getBorderStyle;
    private int getBorderThickness;
    private int getForeground;
    private int getNFillClr;
    private int getNFillClrTrans;
    private int getPointColor;
    private int getShapeHeight;
    private int getShapeStyle;
    private int getShapeWidth;
    private int getStartColor;

    public Graph2DLineNode() {
        this.pen = new ChartPenStyle("Solid Line");
        this.pen.setPenWidth(this.addPoint);
        this.pattern = new ChartColorPattern(DEFAULT_COLOR);
    }

    public Graph2DLineNode(int n, int n2) {
        this();
        this.x = n;
        this.y = n2;
    }

    public Graph2DLineNode(int n, int n2, int n3) {
        this(n, n2);
        this.style = n3;
    }

    public Graph2DLineNode(int n) {
        this();
        this.style = n;
    }

    public Graph2DLineNode(int n, int n2, int n3, ChartPenStyle chartPenStyle, ChartFillPattern chartFillPattern) {
        this(n, n2, n3);
        this.pen = chartPenStyle;
        this.pattern = chartFillPattern;
    }

    public Graph2DLineNode(int n, int n2, int n3, int n4, int n5) {
        this(n, n2, n3);
        this.append = n4;
        this.black = n5;
    }

    public Graph2DLineNode(int n, int n2, int n3, int n4, int n5, ChartPenStyle chartPenStyle, ChartFillPattern chartFillPattern) {
        this(n, n2, n3, n4, n5);
        this.pen = chartPenStyle;
        this.pattern = chartFillPattern;
    }

    public void drawNode(Graphics graphics) {
        this.drawNode(graphics, this.x, this.y, this.style);
    }

    public void drawNode(Graphics graphics, int n, int n2, int n3, int n4, int n5) {
        this.append = n4;
        this.black = n5;
        this.drawNode(graphics, n, n2, n3);
    }

    public void drawNode(Graphics graphics, int n, int n2, int n3) {
        ChartPenStyle chartPenStyle = new ChartPenStyle("Solid Line");
        ChartColorPattern chartColorPattern = new ChartColorPattern();
        chartPenStyle.setPenColor(chartColorPattern);
        this.clone = this.append / 2;
        this.draw = this.black / 2;
        switch (n3) {
            case 0: {
                this.addPoint(graphics, n, n2);
                break;
            }
            case 1: {
                this.drawNode(graphics, n, n2);
                break;
            }
            case 2: {
                this.SEDU(graphics, n, n2);
                break;
            }
            case 3: {
                this.err(graphics, n, n2);
                break;
            }
            case 4: {
                this.fill(graphics, n, n2);
                break;
            }
            case 5: {
                this.getBorderClr(graphics, n, n2);
                break;
            }
            case 6: {
                this.DEFAULT_COLOR(graphics, n, n2);
                break;
            }
            case 7: {
                this.append(graphics, n, n2);
                break;
            }
            case 8: {
                this.draw(graphics, n, n2);
                break;
            }
            case 10: {
                this.black(graphics, n, n2);
                break;
            }
            case 11: {
                this.clone(graphics, n, n2);
                break;
            }
            case 12: {
                this.getBorderClrTrans(graphics, n, n2);
                break;
            }
            case 13: {
                this.getBorderPen(graphics, n, n2);
                break;
            }
            case 9: {
                return;
            }
            default: {
                System.err.println("Invalid line node style " + n3);
                return;
            }
        }
    }

    private void DEFAULT_COLOR(Graphics graphics, int n, int n2) {
        this.drawNode = n - this.clone;
        this.getForeground = n2 - this.draw;
        Arc2D.Float float_ = new Arc2D.Float(this.drawNode, this.getForeground, this.append, this.black, 0.0f, 360.0f, 0);
        if (this.pattern != null) {
            this.pattern.fill((Graphics2D)graphics, float_);
        }
        if (this.pen != null) {
            this.pen.draw((Graphics2D)graphics, float_);
        }
    }

    private void SEDU(Graphics graphics, int n, int n2) {
        this.drawNode = n - this.clone;
        this.getForeground = n2 + this.draw;
        this.err = n;
        this.getNFillClr = n2 - this.draw;
        this.fill = n + this.clone;
        this.getNFillClrTrans = n2 + this.draw;
        int[] nArray = new int[]{this.drawNode, this.err, this.fill};
        int[] nArray2 = new int[]{this.getForeground, this.getNFillClr, this.getNFillClrTrans};
        int n3 = 3;
        Polygon polygon = new Polygon();
        for (int i = 0; i < n3; ++i) {
            polygon.addPoint(nArray[i], nArray2[i]);
        }
        if (this.pattern != null) {
            this.pattern.fill((Graphics2D)graphics, polygon);
        }
        if (this.pen != null) {
            this.pen.draw((Graphics2D)graphics, polygon);
        }
    }

    private void addPoint(Graphics graphics, int n, int n2) {
        this.drawNode = n - this.clone;
        this.getForeground = n2 - this.draw;
        Rectangle rectangle = new Rectangle(this.drawNode, this.getForeground, this.append, this.black);
        if (this.pattern != null) {
            this.pattern.fill((Graphics2D)graphics, rectangle);
        }
        if (this.pen != null) {
            this.pen.draw((Graphics2D)graphics, rectangle);
        }
    }

    private void append(Graphics graphics, int n, int n2) {
        this.drawNode = n - this.clone;
        this.getForeground = n2;
        this.err = n + this.clone;
        this.getNFillClr = n2;
        this.fill = n;
        this.getNFillClrTrans = n2 - this.draw;
        this.getBorderClr = n;
        this.getPointColor = n2 + this.draw;
        if (this.pen != null) {
            this.getBorderStyle(graphics, this.drawNode, this.getForeground, this.err, this.getNFillClr);
            this.getBorderStyle(graphics, this.fill, this.getNFillClrTrans, this.getBorderClr, this.getPointColor);
        }
    }

    private void black(Graphics graphics, int n, int n2) {
        this.drawNode = n - this.clone;
        this.getForeground = n2 - this.draw;
        this.err = n + this.clone;
        this.getNFillClr = n2 + this.draw;
        this.fill = n - this.clone;
        this.getNFillClrTrans = n2 + this.draw;
        this.getBorderClr = n + this.clone;
        this.getPointColor = n2 - this.draw;
        this.getBorderClrTrans = n;
        this.getShapeHeight = n2 - this.draw;
        this.getBorderPen = n;
        this.getShapeStyle = n2 + this.draw;
        if (this.pen != null) {
            this.getBorderStyle(graphics, this.drawNode, this.getForeground, this.err, this.getNFillClr);
            this.getBorderStyle(graphics, this.fill, this.getNFillClrTrans, this.getBorderClr, this.getPointColor);
            this.getBorderStyle(graphics, this.getBorderClrTrans, this.getShapeHeight, this.getBorderPen, this.getShapeStyle);
        }
    }

    private void clone(Graphics graphics, int n, int n2) {
        this.drawNode = n - this.clone;
        this.getForeground = n2 - this.draw;
        this.err = n + this.clone;
        this.getNFillClr = n2 + this.draw;
        this.fill = n - this.clone;
        this.getNFillClrTrans = n2 + this.draw;
        this.getBorderClr = n + this.clone;
        this.getPointColor = n2 - this.draw;
        this.getBorderClrTrans = n;
        this.getShapeHeight = n2 - this.draw;
        this.getBorderPen = n;
        this.getShapeStyle = n2 + this.draw;
        this.getBorderStyle = n - this.clone;
        this.getShapeWidth = n2;
        this.getBorderThickness = n + this.clone;
        this.getStartColor = n2;
        if (this.pen != null) {
            this.getBorderStyle(graphics, this.drawNode, this.getForeground, this.err, this.getNFillClr);
            this.getBorderStyle(graphics, this.fill, this.getNFillClrTrans, this.getBorderClr, this.getPointColor);
            this.getBorderStyle(graphics, this.getBorderClrTrans, this.getShapeHeight, this.getBorderPen, this.getShapeStyle);
            this.getBorderStyle(graphics, this.getBorderStyle, this.getShapeWidth, this.getBorderThickness, this.getStartColor);
        }
    }

    private void draw(Graphics graphics, int n, int n2) {
        this.drawNode = n - this.clone;
        this.getForeground = n2 - this.draw;
        this.err = n + this.draw;
        this.getNFillClr = n2 + this.draw;
        this.fill = n - this.clone;
        this.getNFillClrTrans = n2 + this.draw;
        this.getBorderClr = n + this.clone;
        this.getPointColor = n2 - this.draw;
        if (this.pen != null) {
            this.getBorderStyle(graphics, this.drawNode, this.getForeground, this.err, this.getNFillClr);
            this.getBorderStyle(graphics, this.fill, this.getNFillClrTrans, this.getBorderClr, this.getPointColor);
        }
    }

    private void drawNode(Graphics graphics, int n, int n2) {
        this.drawNode = n;
        this.getForeground = n2 - this.draw;
        this.err = n - this.clone;
        this.getNFillClr = n2;
        this.fill = n;
        this.getNFillClrTrans = n2 + this.draw;
        this.getBorderClr = n + this.clone;
        this.getPointColor = n2;
        int[] nArray = new int[]{this.drawNode, this.err, this.fill, this.getBorderClr};
        int[] nArray2 = new int[]{this.getForeground, this.getNFillClr, this.getNFillClrTrans, this.getPointColor};
        int n3 = 4;
        Polygon polygon = new Polygon();
        for (int i = 0; i < n3; ++i) {
            polygon.addPoint(nArray[i], nArray2[i]);
        }
        if (this.pattern != null) {
            this.pattern.fill((Graphics2D)graphics, polygon);
        }
        if (this.pen != null) {
            this.pen.draw((Graphics2D)graphics, polygon);
        }
    }

    private void err(Graphics graphics, int n, int n2) {
        this.drawNode = n - this.clone;
        this.getForeground = n2 - this.draw;
        this.err = n;
        this.getNFillClr = n2 + this.draw;
        this.fill = n + this.clone;
        this.getNFillClrTrans = n2 - this.draw;
        int[] nArray = new int[]{this.drawNode, this.err, this.fill};
        int[] nArray2 = new int[]{this.getForeground, this.getNFillClr, this.getNFillClrTrans};
        int n3 = 3;
        Polygon polygon = new Polygon();
        for (int i = 0; i < n3; ++i) {
            polygon.addPoint(nArray[i], nArray2[i]);
        }
        if (this.pattern != null) {
            this.pattern.fill((Graphics2D)graphics, polygon);
        }
        if (this.pen != null) {
            this.pen.draw((Graphics2D)graphics, polygon);
        }
    }

    private void fill(Graphics graphics, int n, int n2) {
        this.drawNode = n - this.clone;
        this.getForeground = n2;
        this.err = n + this.clone;
        this.getNFillClr = n2 - this.draw;
        this.fill = n + this.clone;
        this.getNFillClrTrans = n2 + this.draw;
        int[] nArray = new int[]{this.drawNode, this.err, this.fill};
        int[] nArray2 = new int[]{this.getForeground, this.getNFillClr, this.getNFillClrTrans};
        int n3 = 3;
        Polygon polygon = new Polygon();
        for (int i = 0; i < n3; ++i) {
            polygon.addPoint(nArray[i], nArray2[i]);
        }
        if (this.pattern != null) {
            this.pattern.fill((Graphics2D)graphics, polygon);
        }
        if (this.pen != null) {
            this.pen.draw((Graphics2D)graphics, polygon);
        }
    }

    private void getBorderClr(Graphics graphics, int n, int n2) {
        this.drawNode = n - this.clone;
        this.getForeground = n2 - this.draw;
        this.err = n - this.clone;
        this.getNFillClr = n2 + this.draw;
        this.fill = n + this.clone;
        this.getNFillClrTrans = n2;
        int[] nArray = new int[]{this.drawNode, this.err, this.fill};
        int[] nArray2 = new int[]{this.getForeground, this.getNFillClr, this.getNFillClrTrans};
        int n3 = 3;
        Polygon polygon = new Polygon();
        for (int i = 0; i < n3; ++i) {
            polygon.addPoint(nArray[i], nArray2[i]);
        }
        if (this.pattern != null) {
            this.pattern.fill((Graphics2D)graphics, polygon);
        }
        if (this.pen != null) {
            this.pen.draw((Graphics2D)graphics, polygon);
        }
    }

    private void getBorderClrTrans(Graphics graphics, int n, int n2) {
        int n3 = 4;
        this.err = n - 2 * n3;
        this.fill = n;
        this.getBorderClr = n + 2 * n3;
        this.getBorderClrTrans = n;
        this.getNFillClr = n2 + 2 * n3;
        this.getNFillClrTrans = n2 - 2 * n3;
        this.getPointColor = n2 + 2 * n3;
        this.getShapeHeight = n2 + 1;
        int[] nArray = new int[]{this.err, this.fill, this.getBorderClr, this.getBorderClrTrans};
        int[] nArray2 = new int[]{this.getNFillClr, this.getNFillClrTrans, this.getPointColor, this.getShapeHeight};
        int n4 = 4;
        Polygon polygon = new Polygon();
        for (int i = 0; i < n4; ++i) {
            polygon.addPoint(nArray[i], nArray2[i]);
        }
        if (this.pattern != null) {
            this.pattern.fill((Graphics2D)graphics, polygon);
        }
        if (this.pen != null) {
            this.pen.draw((Graphics2D)graphics, polygon);
        }
    }

    private void getBorderPen(Graphics graphics, int n, int n2) {
        int n3 = 5;
        this.err = n - n3;
        this.fill = n + n3;
        this.getBorderClr = n;
        this.getNFillClr = n2 + 2 * n3;
        this.getNFillClrTrans = n2 + 2 * n3;
        this.getPointColor = n2 - 2 * n3;
        int[] nArray = new int[]{this.err, this.fill, this.getBorderClr};
        int[] nArray2 = new int[]{this.getNFillClr, this.getNFillClrTrans, this.getPointColor};
        int n4 = 3;
        Polygon polygon = new Polygon();
        for (int i = 0; i < n4; ++i) {
            polygon.addPoint(nArray[i], nArray2[i]);
        }
        if (this.pattern != null) {
            this.pattern.fill((Graphics2D)graphics, polygon);
        }
        if (this.pen != null) {
            this.pen.draw((Graphics2D)graphics, polygon);
        }
    }

    public void setPenStyle(ChartPenStyle chartPenStyle) {
        this.pen = chartPenStyle;
    }

    public void setFillPattern(ChartFillPattern chartFillPattern) {
        this.pattern = chartFillPattern;
    }

    public ChartFillPattern getFillPattern() {
        return this.pattern;
    }

    public void setSize(int n) {
        if (n >= 0 && n <= 14) {
            this.size = n;
        } else {
            n = 3;
        }
    }

    private void getBorderStyle(Graphics graphics, int n, int n2, int n3, int n4) {
        this.SEDU.reset();
        this.SEDU.moveTo(n, n2);
        this.SEDU.lineTo(n3, n4);
        ChartPenStyle chartPenStyle = (ChartPenStyle)this.pen.clone();
        chartPenStyle.setPenColor(this.getBorderThickness());
        chartPenStyle.draw((Graphics2D)graphics, this.SEDU);
    }

    public ChartPenStyle getBorderPen() {
        return this.pen;
    }

    public void setWidth(int n) {
        this.append = n;
    }

    public void setHeight(int n) {
        this.black = n;
    }

    public void setLoc(int n, int n2) {
        this.x = n;
        this.y = n2;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int n) {
        this.style = n;
    }

    ChartColorPattern getBorderThickness() {
        if (this.pattern == null) {
            return null;
        }
        if (this.pattern instanceof ChartGradientPattern) {
            return ((ChartGradientPattern)this.pattern).getStartColor();
        }
        if (this.pattern instanceof ChartTexturePattern) {
            return ((ChartTexturePattern)this.pattern).getForeground();
        }
        if (this.pattern instanceof ChartColorPattern) {
            return (ChartColorPattern)this.pattern;
        }
        if (this.pattern instanceof RoundGradientPaint) {
            return ((RoundGradientPaint)((Object)this.pattern)).getPointColor();
        }
        return new ChartColorPattern();
    }

    public void setProperties(ChartNodeProperties chartNodeProperties) {
        if (chartNodeProperties != null) {
            ChartColorPattern chartColorPattern = new ChartColorPattern(chartNodeProperties.getNFillClr());
            chartColorPattern.setAlpha(chartNodeProperties.getNFillClrTrans() / 100.0f);
            this.setFillPattern(chartColorPattern);
            this.setWidth(chartNodeProperties.getShapeWidth());
            this.setHeight(chartNodeProperties.getShapeHeight());
            this.setStyle(chartNodeProperties.getShapeStyle());
            if (this.getBorderPen() != null) {
                this.getBorderPen().setPenWidth(chartNodeProperties.getBorderThickness());
                this.getBorderPen().setPenColor(new ChartColorPattern(chartNodeProperties.getBorderClr()));
                this.getBorderPen().setDashPattern(chartNodeProperties.getBorderStyle());
                this.getBorderPen().setTransparency(chartNodeProperties.getBorderClrTrans() / 100.0f);
            }
        }
    }
}

