/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

import chart.ChartWall;
import chart.chart3d.Chart3DGraphicsUtil;
import chart.chart3d.Chart3DPaper;
import chart.chart3d.ChartBlock;
import chart.chart3d.ChartCompass;
import chart.chart3d.ChartMatrix;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartPenStyle;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class Chart3DWalls {
    protected static int floor = 3;
    protected ChartWall[] wall = new ChartWall[3];
    protected Chart3DPaper paper;
    protected ChartCompass compass;
    protected ChartBlock walls;
    protected float[] len;
    protected ChartFillPattern[] pattern;
    protected ChartFillPattern pattern2;
    protected ChartPenStyle[] wallBorder;
    boolean SEDU = true;
    Point2D.Float[][] I;

    public Chart3DWalls(Chart3DPaper chart3DPaper) {
        this.paper = chart3DPaper;
        this.walls = new ChartBlock();
    }

    public void paint(Graphics2D graphics2D) {
        this.drawWalls(graphics2D, this.walls.tVertex);
        this.boundFillWalls(graphics2D);
        this.drawSidesOfWalls(graphics2D, this.walls.tVertex);
    }

    public void drawWalls(Graphics2D graphics2D, float[][] fArray2) {
        this.compass = this.paper.getCompass();
        int n = 0;
        int n2 = 0;
        if (this.compass != null) {
            n2 = this.compass.shownFace(fArray2, 0);
        }
        this.I = new Point2D.Float[3][];
        for (int i = 0; i < 3; ++i) {
            if ((n2 >> i * 2 & 1) != 1) {
                n = i * 2;
            }
            if ((n2 >> i * 2 + 1 & 1) != 1) {
                n = i * 2 + 1;
            } else if (i * 2 + 1 == floor) continue;
            if (fArray2 == null) continue;
            Point2D.Float[] floatArray = Chart3DGraphicsUtil.getFace(fArray2, 0, n);
            this.I[i] = floatArray;
            if (i == 1) {
                if (!this.paper.properties.isShowFloor()) continue;
                this.wall[i].setPoint(floatArray);
                this.wall[i].draw(graphics2D);
                continue;
            }
            if (!this.paper.properties.isShowWall()) continue;
            this.wall[i].setPoint(floatArray);
            this.wall[i].draw(graphics2D);
        }
    }

    public void drawSidesOfWalls(Graphics2D graphics2D, float[][] fArray2) {
        for (int i = 0; i < 3; ++i) {
            if (!this.paper.properties.isShowWall() || fArray2 == null || this.I[i] == null) continue;
            this.wall[i].setPoint(this.I[i]);
            this.wall[i].drawSides(graphics2D);
        }
    }

    boolean I(float f, float f2, Point2D.Float[] floatArray, Point2D.Float[] floatArray2) {
        return this.SEDU(f, f2, floatArray) || this.SEDU(f, f2, floatArray2);
    }

    private boolean SEDU(float f, float f2, Point2D.Float[] floatArray) {
        if (floatArray != null) {
            Line2D.Float float_ = new Line2D.Float(floatArray[0], floatArray[1]);
            Line2D.Float float_2 = new Line2D.Float(floatArray[1], floatArray[2]);
            Line2D.Float float_3 = new Line2D.Float(floatArray[2], floatArray[3]);
            Line2D.Float float_4 = new Line2D.Float(floatArray[3], floatArray[0]);
            if (float_.ptLineDist(f, f2) < 1.0 || float_2.ptLineDist(f, f2) < 1.0 || float_3.ptLineDist(f, f2) < 1.0 || float_4.ptLineDist(f, f2) < 1.0) {
                return true;
            }
        }
        return false;
    }

    public void boundFillWalls(Graphics2D graphics2D) {
        this.SEDU = this.paper.getProperties().getWallProperties().isBoundFill();
        if (this.paper.properties.isShowWall() && this.SEDU) {
            int n;
            int n2;
            boolean bl;
            boolean bl2;
            boolean bl3;
            boolean bl4;
            int n3 = this.paper.getShownFace();
            ChartBlock chartBlock = this.paper.getAxes().yTickPos;
            float[][] fArray2 = chartBlock.tVertex;
            int n4 = this.paper.getAxes().getStake()[1];
            int n5 = chartBlock.vCount / 4;
            float[][] fArray3 = new float[4][2];
            float[][] fArray4 = new float[4][2];
            Point2D.Float[][] floatArray = new Point2D.Float[n5 - 1][4];
            boolean bl5 = false;
            if ((n3 >> 5 & 1) == 1) {
                bl5 = true;
            }
            boolean bl6 = true;
            if (n4 == 1) {
                n4 = 3;
            } else if (n4 == 2) {
                n4 = 0;
            }
            if (bl5) {
                n4 = (n4 + 2) % 4;
            } else if (n4 < 0) {
                n4 += 2;
                bl6 = false;
            }
            ChartWall chartWall = new ChartWall();
            if (bl6 && this.SEDU) {
                bl4 = false;
                bl3 = false;
                bl2 = this.I(fArray2[(n5 - 1) * 4 + n4][0], fArray2[(n5 - 1) * 4 + n4][1], this.I[0], this.I[2]);
                bl = this.I(fArray2[(n5 - 1) * 4 + n4 - 1][0], fArray2[(n5 - 1) * 4 + n4 - 1][1], this.I[0], this.I[2]);
                n2 = 0;
                switch (n4) {
                    case 0: {
                        bl4 = this.I(fArray2[0][0], fArray2[0][1], this.I[0], this.I[2]);
                        bl3 = this.I(fArray2[3][0], fArray2[3][1], this.I[0], this.I[2]);
                        bl2 = this.I(fArray2[(n5 - 1) * 4 + n4][0], fArray2[(n5 - 1) * 4 + n4][1], this.I[0], this.I[2]);
                        bl = this.I(fArray2[(n5 - 1) * 4 + n4 + 3][0], fArray2[(n5 - 1) * 4 + n4 + 3][1], this.I[0], this.I[2]);
                        if (bl4 && bl3 && bl2 && bl) {
                            n2 = 1;
                            break;
                        }
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        bl4 = this.I(fArray2[1][0], fArray2[1][1], this.I[0], this.I[2]);
                        bl3 = this.I(fArray2[0][0], fArray2[0][1], this.I[0], this.I[2]);
                        if (bl4 && bl3 && bl2 && bl) {
                            n2 = 3;
                            break;
                        }
                        n2 = 4;
                        break;
                    }
                    case 2: {
                        bl4 = this.I(fArray2[2][0], fArray2[2][1], this.I[0], this.I[2]);
                        bl3 = this.I(fArray2[1][0], fArray2[1][1], this.I[0], this.I[2]);
                        if (bl4 && bl3 && bl2 && bl) {
                            n2 = 5;
                            break;
                        }
                        n2 = 6;
                        break;
                    }
                    case 3: {
                        bl4 = this.I(fArray2[3][0], fArray2[3][1], this.I[0], this.I[2]);
                        bl3 = this.I(fArray2[2][0], fArray2[2][1], this.I[0], this.I[2]);
                        n2 = bl4 && bl3 && bl2 && bl ? 7 : 8;
                    }
                }
                for (n = 0; n < n5 - 1; ++n) {
                    switch (n2) {
                        case 1: {
                            fArray3[0] = fArray2[n * 4 + n4];
                            fArray3[1] = fArray2[n * 4 + n4 + 3];
                            fArray3[2] = fArray2[(n + 1) * 4 + n4];
                            fArray3[3] = fArray2[(n + 1) * 4 + n4 + 3];
                            break;
                        }
                        case 2: {
                            fArray3[0] = fArray2[n * 4 + n4 + 1];
                            fArray3[1] = fArray2[n * 4 + n4 + 2];
                            fArray3[2] = fArray2[(n + 1) * 4 + n4 + 1];
                            fArray3[3] = fArray2[(n + 1) * 4 + n4 + 2];
                            break;
                        }
                        case 3: {
                            fArray3[0] = fArray2[n * 4 + n4];
                            fArray3[1] = fArray2[n * 4 + n4 - 1];
                            fArray3[2] = fArray2[(n + 1) * 4 + n4];
                            fArray3[3] = fArray2[(n + 1) * 4 + n4 - 1];
                            break;
                        }
                        case 4: {
                            fArray3[0] = fArray2[n * 4 + n4 + 1];
                            fArray3[1] = fArray2[n * 4 + n4 + 2];
                            fArray3[2] = fArray2[(n + 1) * 4 + n4 + 1];
                            fArray3[3] = fArray2[(n + 1) * 4 + n4 + 2];
                            break;
                        }
                        case 5: {
                            fArray3[0] = fArray2[n * 4 + n4];
                            fArray3[1] = fArray2[n * 4 + n4 - 1];
                            fArray3[2] = fArray2[(n + 1) * 4 + n4];
                            fArray3[3] = fArray2[(n + 1) * 4 + n4 - 1];
                            break;
                        }
                        case 6: {
                            fArray3[0] = fArray2[n * 4 + n4 + 1];
                            fArray3[1] = fArray2[n * 4 + n4 - 2];
                            fArray3[2] = fArray2[(n + 1) * 4 + n4 + 1];
                            fArray3[3] = fArray2[(n + 1) * 4 + n4 - 2];
                            break;
                        }
                        case 7: {
                            fArray3[0] = fArray2[n * 4 + n4];
                            fArray3[1] = fArray2[n * 4 + n4 - 1];
                            fArray3[2] = fArray2[(n + 1) * 4 + n4];
                            fArray3[3] = fArray2[(n + 1) * 4 + n4 - 1];
                            break;
                        }
                        case 8: {
                            fArray3[0] = fArray2[n * 4 + n4 - 3];
                            fArray3[1] = fArray2[n * 4 + n4 - 2];
                            fArray3[2] = fArray2[(n + 1) * 4 + n4 - 3];
                            fArray3[3] = fArray2[(n + 1) * 4 + n4 - 2];
                        }
                    }
                    fArray4[0] = fArray3[0];
                    fArray4[1] = fArray3[1];
                    fArray4[2][0] = (fArray3[0][0] + fArray3[2][0]) / 2.0f;
                    fArray4[2][1] = (fArray3[0][1] + fArray3[2][1]) / 2.0f;
                    fArray4[3][0] = (fArray3[1][0] + fArray3[3][0]) / 2.0f;
                    fArray4[3][1] = (fArray3[1][1] + fArray3[3][1]) / 2.0f;
                    floatArray[n][0] = new Point2D.Float(fArray4[0][0], fArray4[0][1]);
                    floatArray[n][1] = new Point2D.Float(fArray4[1][0], fArray4[1][1]);
                    floatArray[n][2] = new Point2D.Float(fArray4[3][0], fArray4[3][1]);
                    floatArray[n][3] = new Point2D.Float(fArray4[2][0], fArray4[2][1]);
                }
                chartWall.setPattern(this.wall[0].getProperties().getPattern2());
                chartWall.setPen(this.wall[0].getProperties().getBorder());
                chartWall.setBoundFillPoint(floatArray);
                chartWall.boundFill(graphics2D);
            }
            if (this.SEDU) {
                bl4 = false;
                bl3 = false;
                bl2 = false;
                bl = false;
                n2 = 0;
                switch (n4) {
                    case 0: {
                        bl4 = this.I(fArray2[2][0], fArray2[2][1], this.I[0], this.I[2]);
                        bl3 = this.I(fArray2[3][0], fArray2[3][1], this.I[0], this.I[2]);
                        bl2 = this.I(fArray2[(n5 - 1) * 4 + n4 + 2][0], fArray2[(n5 - 1) * 4 + n4 + 2][1], this.I[0], this.I[2]);
                        bl = this.I(fArray2[(n5 - 1) * 4 + n4 + 3][0], fArray2[(n5 - 1) * 4 + n4 + 3][1], this.I[0], this.I[2]);
                        if (bl4 && bl3 && bl2 && bl) {
                            n2 = 1;
                            break;
                        }
                        n2 = 2;
                        break;
                    }
                    case 1: {
                        bl4 = this.I(fArray2[0][0], fArray2[0][1], this.I[0], this.I[2]);
                        bl3 = this.I(fArray2[3][0], fArray2[3][1], this.I[0], this.I[2]);
                        bl2 = this.I(fArray2[(n5 - 1) * 4 + n4 - 1][0], fArray2[(n5 - 1) * 4 + n4 - 1][1], this.I[0], this.I[2]);
                        bl = this.I(fArray2[(n5 - 1) * 4 + n4 + 2][0], fArray2[(n5 - 1) * 4 + n4 + 2][1], this.I[0], this.I[2]);
                        if (bl4 && bl3 && bl2 && bl) {
                            n2 = 3;
                            break;
                        }
                        n2 = 4;
                        break;
                    }
                    case 2: {
                        n2 = 7;
                        break;
                    }
                    case 3: {
                        bl4 = this.I(fArray2[2][0], fArray2[2][1], this.I[0], this.I[2]);
                        bl3 = this.I(fArray2[1][0], fArray2[1][1], this.I[0], this.I[2]);
                        bl2 = this.I(fArray2[(n5 - 1) * 4 + n4 - 1][0], fArray2[(n5 - 1) * 4 + n4 - 1][1], this.I[0], this.I[2]);
                        bl = this.I(fArray2[(n5 - 1) * 4 + n4 - 2][0], fArray2[(n5 - 1) * 4 + n4 - 2][1], this.I[0], this.I[2]);
                        n2 = bl4 && bl3 && bl2 && bl ? 5 : 6;
                    }
                }
                for (n = 0; n < n5 - 1; ++n) {
                    switch (n2) {
                        case 1: {
                            fArray3[0] = fArray2[n * 4 + n4 + 2];
                            fArray3[1] = fArray2[n * 4 + n4 + 3];
                            fArray3[2] = fArray2[(n + 1) * 4 + n4 + 2];
                            fArray3[3] = fArray2[(n + 1) * 4 + n4 + 3];
                            break;
                        }
                        case 2: {
                            fArray3[0] = fArray2[n * 4 + n4 + 1];
                            fArray3[1] = fArray2[n * 4 + n4];
                            fArray3[2] = fArray2[(n + 1) * 4 + n4 + 1];
                            fArray3[3] = fArray2[(n + 1) * 4 + n4];
                            break;
                        }
                        case 3: {
                            fArray3[0] = fArray2[n * 4 + n4 - 1];
                            fArray3[1] = fArray2[n * 4 + n4 + 2];
                            fArray3[2] = fArray2[(n + 1) * 4 + n4 - 1];
                            fArray3[3] = fArray2[(n + 1) * 4 + n4 + 2];
                            break;
                        }
                        case 4: {
                            fArray3[0] = fArray2[n * 4 + n4];
                            fArray3[1] = fArray2[n * 4 + n4 + 1];
                            fArray3[2] = fArray2[(n + 1) * 4 + n4];
                            fArray3[3] = fArray2[(n + 1) * 4 + n4 + 1];
                            break;
                        }
                        case 5: {
                            fArray3[0] = fArray2[n * 4 + n4 - 1];
                            fArray3[1] = fArray2[n * 4 + n4 - 2];
                            fArray3[2] = fArray2[(n + 1) * 4 + n4 - 1];
                            fArray3[3] = fArray2[(n + 1) * 4 + n4 - 2];
                            break;
                        }
                        case 6: {
                            fArray3[0] = fArray2[n * 4 + n4];
                            fArray3[1] = fArray2[n * 4 + n4 - 3];
                            fArray3[2] = fArray2[(n + 1) * 4 + n4];
                            fArray3[3] = fArray2[(n + 1) * 4 + n4 - 3];
                            break;
                        }
                        case 7: {
                            fArray3[0] = fArray2[n * 4 + n4 - 2];
                            fArray3[1] = fArray2[n * 4 + n4 - 1];
                            fArray3[2] = fArray2[(n + 1) * 4 + n4 - 2];
                            fArray3[3] = fArray2[(n + 1) * 4 + n4 - 1];
                        }
                    }
                    fArray4[0] = fArray3[0];
                    fArray4[1] = fArray3[1];
                    fArray4[2][0] = (fArray3[0][0] + fArray3[2][0]) / 2.0f;
                    fArray4[2][1] = (fArray3[0][1] + fArray3[2][1]) / 2.0f;
                    fArray4[3][0] = (fArray3[1][0] + fArray3[3][0]) / 2.0f;
                    fArray4[3][1] = (fArray3[1][1] + fArray3[3][1]) / 2.0f;
                    floatArray[n][0] = new Point2D.Float(fArray4[0][0], fArray4[0][1]);
                    floatArray[n][1] = new Point2D.Float(fArray4[1][0], fArray4[1][1]);
                    floatArray[n][2] = new Point2D.Float(fArray4[3][0], fArray4[3][1]);
                    floatArray[n][3] = new Point2D.Float(fArray4[2][0], fArray4[2][1]);
                }
                chartWall.setPattern(this.wall[0].getProperties().getPattern2());
                chartWall.setPen(this.wall[0].getProperties().getBorder());
                chartWall.setBoundFillPoint(floatArray);
                chartWall.boundFill(graphics2D);
            }
        }
    }

    public void transform(ChartMatrix chartMatrix) {
        this.walls.transform(chartMatrix);
    }

    public ChartBlock getWalls() {
        return this.walls;
    }

    public void init() {
        for (int i = 0; i < 3; ++i) {
            this.wall[i] = new ChartWall();
        }
        this.wall[0].setProperties(this.paper.properties.getWallProperties());
        this.wall[1].setProperties(this.paper.properties.getFloorProperties());
        this.wall[2].setProperties(this.paper.properties.getWallProperties());
    }

    public void locate() {
        this.walls.clear();
        this.addVertex();
    }

    private void addVertex() {
        this.len = this.paper.getLength();
        this.walls.addVertex(0.0f, 0.0f, 0.0f);
        this.walls.addVertex(this.len[0], 0.0f, 0.0f);
        this.walls.addVertex(this.len[0], 0.0f, this.len[2]);
        this.walls.addVertex(0.0f, 0.0f, this.len[2]);
        this.walls.addVertex(0.0f, this.len[1], 0.0f);
        this.walls.addVertex(this.len[0], this.len[1], 0.0f);
        this.walls.addVertex(this.len[0], this.len[1], this.len[2]);
        this.walls.addVertex(0.0f, this.len[1], this.len[2]);
    }

    public Shape getWallXYAreaPath() {
        return this.wall[2].getSelectedAreaPath();
    }

    public Shape getWallYZAreaPath() {
        return this.wall[0].getSelectedAreaPath();
    }

    public Shape getWallFloorAreaPath() {
        return this.wall[1].getSelectedAreaPath();
    }

    public boolean searchSelectedWallXY(int n, int n2) {
        return this.wall[2].searchSelectedWall(n, n2);
    }

    public boolean searchSelectedWallYZ(int n, int n2) {
        return this.wall[0].searchSelectedWall(n, n2);
    }

    public boolean searchSelectedWallFloor(int n, int n2) {
        return this.wall[1].searchSelectedWall(n, n2);
    }

    public ChartWall getWallXY() {
        return this.wall[2];
    }

    public ChartWall getWallYZ() {
        return this.wall[0];
    }

    public ChartWall getWallFloor() {
        return this.wall[1];
    }
}

