/*
 * Decompiled with CFR 0.152.
 */
package guitools.toolkit;

import com.jinfonet.awt.JGraphics;
import com.jinfonet.awt.JImage;
import guitools.toolkit.RepaintImageListener;
import guitools.toolkit.TransparentPeer;
import guitools.toolkit.Unit;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.peer.LightweightPeer;
import java.util.Vector;

public class TPaintBoard
extends Container {
    private Image SEDU;
    private int abs;
    private int addElement;
    private int addImpl;
    private int afterDrawImage;
    private boolean beforeDrawImage;
    private Rectangle calculateChildrenArea = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE, Short.MIN_VALUE, Short.MIN_VALUE);
    private int calculateImageArea;
    protected boolean hasXorFigure;
    private int clipRect;
    private int compareTo;
    private int contains;
    private Vector create = new Vector(2);

    public static Vector minusRect(Rectangle rectangle, Rectangle rectangle2) {
        Vector<Rectangle> vector = new Vector<Rectangle>();
        if (rectangle.intersects(rectangle2) && !rectangle2.isEmpty()) {
            if (!(rectangle.equals(rectangle2) || rectangle2.contains(rectangle.x, rectangle.y) && rectangle2.contains(rectangle.x + rectangle.width, rectangle.y + rectangle.height))) {
                Rectangle rectangle3 = rectangle.contains(rectangle2.x, rectangle2.y) && rectangle.contains(rectangle2.x + rectangle2.width, rectangle2.y + rectangle2.height) ? rectangle2 : rectangle.intersection(rectangle2);
                int n = rectangle.x + rectangle.width;
                int n2 = rectangle.y + rectangle.height;
                int n3 = rectangle3.x + rectangle3.width;
                int n4 = rectangle3.y + rectangle3.height;
                int n5 = rectangle3.y - rectangle.y;
                if (n5 > 0) {
                    vector.addElement(new Rectangle(rectangle.x, rectangle.y, rectangle.width, n5));
                }
                if ((n5 = rectangle3.x - rectangle.x) > 0) {
                    vector.addElement(new Rectangle(rectangle.x, rectangle3.y, n5, rectangle3.height));
                }
                if ((n5 = n2 - n4) > 0) {
                    vector.addElement(new Rectangle(rectangle.x, n4, rectangle.width, n5));
                }
                if ((n5 = n - n3) > 0) {
                    vector.addElement(new Rectangle(n3, rectangle3.y, n5, rectangle3.height));
                }
            }
        } else {
            vector.addElement(new Rectangle(rectangle));
        }
        return vector;
    }

    public TPaintBoard() {
        this.setLayout(null);
        this.enableEvents(1L);
    }

    @Override
    public void update(Graphics graphics) {
        if (this.calculateImageArea == 0) {
            if (this.SEDU == null || !this.calculateChildrenArea.isEmpty()) {
                this.updateImage(this.calculateChildrenArea.x, this.calculateChildrenArea.y, this.calculateChildrenArea.width, this.calculateChildrenArea.height);
            } else {
                Rectangle rectangle = this.calculateImageArea();
                if (this.abs != rectangle.x || this.addElement != rectangle.y || this.addImpl != rectangle.width || this.afterDrawImage != rectangle.height) {
                    this.updateImage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            }
            this.updateImage(graphics);
        }
    }

    protected void updateImage(Graphics graphics) {
        Rectangle rectangle = new Rectangle(this.abs, this.addElement, this.addImpl, this.afterDrawImage);
        Rectangle rectangle2 = graphics.getClipBounds();
        if (rectangle2 != null && rectangle2.intersects(rectangle)) {
            Vector vector = TPaintBoard.minusRect(rectangle2, rectangle);
            graphics.setColor(this.getBackground());
            for (int i = vector.size() - 1; i >= 0; --i) {
                rectangle2 = (Rectangle)vector.elementAt(i);
                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            }
            this.drawImage(graphics);
        }
    }

    @Override
    public void paint(Graphics graphics) {
        graphics = JGraphics.createGraphics(graphics);
        if (this.calculateImageArea == 0) {
            Rectangle rectangle = this.calculateImageArea();
            if (this.SEDU == null || !this.calculateChildrenArea.isEmpty()) {
                this.updateImage(this.calculateChildrenArea.x, this.calculateChildrenArea.y, this.calculateChildrenArea.width, this.calculateChildrenArea.height);
            } else if (this.abs != rectangle.x || this.addElement != rectangle.y || this.addImpl != rectangle.width || this.afterDrawImage != rectangle.height) {
                this.updateImage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.updateImage(graphics);
        } else {
            this.paintFace(graphics);
            if (this.hasXorFigure) {
                if (this.SEDU != null) {
                    graphics.clipRect(this.abs, this.addElement, this.addImpl, this.afterDrawImage);
                }
                this.paintXorFigure(graphics);
            }
        }
    }

    protected void paintFace(Graphics graphics) {
    }

    protected void drawImage(Graphics graphics) {
        RepaintImageListener repaintImageListener;
        int n;
        for (n = this.create.size() - 1; n >= 0; --n) {
            repaintImageListener = (RepaintImageListener)this.create.elementAt(n);
            repaintImageListener.beforeDrawImage();
        }
        if (this.SEDU != null) {
            graphics.drawImage(this.SEDU, this.abs, this.addElement, this.abs + this.addImpl, this.addElement + this.afterDrawImage, 0, 0, this.addImpl, this.afterDrawImage, this);
        }
        for (n = this.create.size() - 1; n >= 0; --n) {
            repaintImageListener = (RepaintImageListener)this.create.elementAt(n);
            repaintImageListener.afterDrawImage();
        }
        this.paintFace(graphics);
        if (this.hasXorFigure) {
            graphics.clipRect(this.abs, this.addElement, this.addImpl, this.afterDrawImage);
            this.paintXorFigure(graphics);
        }
    }

    protected void paintXorFigure(Graphics graphics) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        if (!this.beforeDrawImage) {
            Rectangle rectangle = this.getBounds();
            rectangle.x = 0;
            rectangle.y = 0;
            if (!(rectangle = rectangle.intersection(new Rectangle(n, n2, n3, n4))).isEmpty()) {
                if (this.calculateImageArea == 0 && this.isShowing()) {
                    this.updateImage(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    Graphics graphics = this.getGraphics();
                    if (graphics != null) {
                        try {
                            graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                            this.updateImage(graphics);
                        }
                        finally {
                            graphics.dispose();
                        }
                    } else {
                        this.calculateChildrenArea = rectangle.union(this.calculateChildrenArea);
                    }
                } else {
                    this.calculateChildrenArea = rectangle.union(this.calculateChildrenArea);
                }
            }
        }
    }

    @Override
    public Graphics getGraphics() {
        Graphics graphics = super.getGraphics();
        if (graphics != null) {
            graphics = JGraphics.createGraphics(graphics);
        }
        return graphics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawArea(Graphics graphics, Rectangle rectangle) {
        int n = this.getComponentCount();
        if (n > 0) {
            Component[] componentArray = this.getComponents();
            for (int i = n - 1; i >= 0; --i) {
                Rectangle rectangle2;
                Rectangle rectangle3;
                Component component = componentArray[i];
                if (component == null || !component.isVisible() || !(component.getPeer() instanceof LightweightPeer) || (rectangle3 = (rectangle2 = component.getBounds()).intersection(rectangle)) == null || rectangle3.isEmpty()) continue;
                Graphics graphics2 = graphics.create(rectangle2.x - rectangle.x, rectangle2.y - rectangle.y, rectangle2.width, rectangle2.height);
                graphics2.setClip(rectangle3.x - rectangle2.x, rectangle3.y - rectangle2.y, rectangle3.width, rectangle3.height);
                try {
                    component.paint(graphics2);
                    continue;
                }
                finally {
                    graphics2.dispose();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateImage(int n, int n2, int n3, int n4) {
        Graphics graphics;
        Rectangle rectangle;
        Rectangle rectangle2 = this.calculateImageArea();
        if (rectangle2.isEmpty()) {
            this.SEDU = null;
            return;
        }
        n += rectangle2.x - this.abs;
        n2 += rectangle2.y - this.addElement;
        this.abs = rectangle2.x;
        this.addElement = rectangle2.y;
        this.addImpl = rectangle2.width;
        this.afterDrawImage = rectangle2.height;
        if (this.SEDU == null || this.SEDU.getWidth(this) < this.addImpl || this.SEDU.getHeight(this) < this.afterDrawImage) {
            Image image = this.SEDU;
            this.SEDU = this.createImage(this.addImpl, this.afterDrawImage);
            if (image == null || this.abs != rectangle2.x || this.addElement != rectangle2.y) {
                rectangle = rectangle2;
            } else {
                graphics = this.getImageGraphic();
                try {
                    graphics.drawImage(image, 0, 0, this);
                }
                finally {
                    graphics.dispose();
                }
                Rectangle rectangle3 = new Rectangle(n, n2, n3, n4);
                if (!this.calculateChildrenArea.isEmpty()) {
                    rectangle3 = this.calculateChildrenArea.union(rectangle3);
                }
                rectangle = rectangle2.intersection(rectangle3);
            }
        } else {
            Rectangle rectangle4 = new Rectangle(n, n2, n3, n4);
            if (!this.calculateChildrenArea.isEmpty()) {
                rectangle4 = this.calculateChildrenArea.union(rectangle4);
            }
            rectangle = rectangle2.intersection(rectangle4);
        }
        if (this.SEDU != null && !rectangle.isEmpty()) {
            this.calculateChildrenArea.setBounds(Short.MAX_VALUE, Short.MAX_VALUE, Short.MIN_VALUE, Short.MIN_VALUE);
            rectangle.x -= this.abs;
            rectangle.y -= this.addElement;
            graphics = this.getImageGraphic();
            try {
                graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.setColor(this.getBackground());
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                this.updateComponents(graphics, rectangle);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateComponents(Graphics graphics, Rectangle rectangle) {
        int n = this.getComponentCount();
        if (n > 0) {
            Component[] componentArray = this.getComponents();
            for (int i = n - 1; i >= 0; --i) {
                Component component = componentArray[i];
                if (component == null || !component.isVisible() || !(component.getPeer() instanceof LightweightPeer)) continue;
                Rectangle rectangle2 = component.getBounds();
                rectangle2.translate(-this.abs, -this.addElement);
                if (!rectangle2.intersects(rectangle)) continue;
                Graphics graphics2 = graphics.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                try {
                    component.paint(graphics2);
                    continue;
                }
                finally {
                    graphics2.dispose();
                }
            }
        }
    }

    public Rectangle calculateImageArea() {
        Dimension dimension = Unit.screenSize();
        Rectangle rectangle = this.getBounds();
        rectangle.x = 0;
        rectangle.y = 0;
        rectangle.width = rectangle.width > dimension.width ? dimension.width : rectangle.width;
        rectangle.height = rectangle.height > dimension.height ? dimension.height : rectangle.height;
        return rectangle.intersection(this.calculateChildrenArea());
    }

    public Rectangle calculateChildrenArea() {
        Rectangle rectangle = new Rectangle(Short.MAX_VALUE, Short.MAX_VALUE, Short.MIN_VALUE, Short.MIN_VALUE);
        int n = this.getComponentCount();
        if (n != 0) {
            Component[] componentArray = this.getComponents();
            for (int i = n - 1; i >= 0; --i) {
                Component component = componentArray[i];
                if (component == null || !component.isVisible() || !(component.getPeer() instanceof LightweightPeer)) continue;
                rectangle = rectangle.union(component.getBounds());
            }
        }
        return rectangle;
    }

    @Override
    public void print(Graphics graphics) {
        this.updateComponents(graphics, this.calculateChildrenArea());
    }

    @Override
    public void printAll(Graphics graphics) {
        this.print(graphics);
    }

    public int lockCursor() {
        return ++this.contains;
    }

    public int lockCursor(Cursor cursor) {
        if (this.contains == 0) {
            this.setCursor(cursor);
        }
        ++this.contains;
        return this.contains;
    }

    public int getCursorLock() {
        return this.contains;
    }

    public int releasCursorLock() {
        if (this.contains > 0) {
            --this.contains;
            if (this.contains == 0) {
                this.setCursor(Cursor.getDefaultCursor());
            }
        }
        return this.contains;
    }

    public int releasCursorLock(Cursor cursor) {
        if (this.contains > 0) {
            --this.contains;
            if (this.contains == 0) {
                this.setCursor(cursor);
            }
        }
        return this.contains;
    }

    @Override
    public synchronized void setCursor(Cursor cursor) {
        if (this.contains == 0) {
            super.setCursor(cursor);
        }
    }

    public TransparentPeer getTransparentPeerAt(int n, int n2) {
        int n3 = this.getComponentCount();
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < n3; ++i) {
            Component component = componentArray[i];
            if (component == null || !(component instanceof TransparentPeer) || !component.isVisible()) continue;
            Point point = component.getLocation();
            point.x = n - point.x;
            point.y = n2 - point.y;
            if (!component.contains(point)) continue;
            return (TransparentPeer)((Object)component);
        }
        return null;
    }

    public boolean isLockingUpdate() {
        return this.calculateImageArea > 0;
    }

    public void lockUpdate() {
        ++this.calculateImageArea;
    }

    public void unlockUpdate() {
        if (this.calculateImageArea > 0) {
            --this.calculateImageArea;
            if (this.calculateImageArea == 0 && !this.calculateChildrenArea.isEmpty()) {
                this.repaint(this.calculateChildrenArea.x, this.calculateChildrenArea.y, this.calculateChildrenArea.width, this.calculateChildrenArea.height);
            }
        }
    }

    public void unlockUpdate(Rectangle rectangle) {
        if (this.calculateImageArea > 0) {
            --this.calculateImageArea;
            if (this.calculateImageArea == 0) {
                this.calculateChildrenArea.setBounds(rectangle);
                this.unlockUpdate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scrolls(int n, int n2) {
        int n3 = n - this.clipRect;
        int n4 = n2 - this.compareTo;
        if (n3 != 0 || n4 != 0) {
            int n5 = this.getComponentCount();
            if (n5 > 0) {
                this.beforeDrawImage = true;
                ++this.calculateImageArea;
                Component[] componentArray = this.getComponents();
                for (int i = n5 - 1; i >= 0; --i) {
                    Component component = componentArray[i];
                    if (component == null) continue;
                    Point point = component.getLocation();
                    component.setLocation(point.x + n3, point.y + n4);
                }
                --this.calculateImageArea;
                this.beforeDrawImage = false;
            }
            this.clipRect = n;
            this.compareTo = n2;
            if (this.calculateImageArea == 0) {
                Graphics graphics;
                Rectangle rectangle = this.calculateImageArea();
                int n6 = rectangle.x - this.abs;
                int n7 = rectangle.y - this.addElement;
                int n8 = rectangle.width - this.addImpl;
                int n9 = rectangle.height - this.afterDrawImage;
                this.abs = rectangle.x;
                this.addElement = rectangle.y;
                this.addImpl = rectangle.width;
                this.afterDrawImage = rectangle.height;
                if (rectangle.isEmpty()) {
                    this.SEDU = null;
                } else {
                    Image image;
                    if (this.SEDU == null || this.SEDU.getWidth(this) < this.addImpl || this.SEDU.getHeight(this) < this.afterDrawImage || System.getProperty("java.version").compareTo("1.2") >= 0 && (System.getProperty("java.vendor").equals("Sun Microsystems Inc.") || System.getProperty("java.vendor").equals("IBM Corporation")) && (n3 > 0 || n4 > 0)) {
                        image = this.SEDU;
                        this.SEDU = this.createImage(this.addImpl, this.afterDrawImage);
                    } else {
                        image = null;
                    }
                    if (this.SEDU != null) {
                        graphics = this.getImageGraphic();
                        try {
                            if (Math.abs(n3) >= this.addImpl || Math.abs(n4) >= this.afterDrawImage) {
                                Rectangle rectangle2 = new Rectangle(0, 0, this.addImpl, this.afterDrawImage);
                                graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                                graphics.setColor(this.getBackground());
                                graphics.fillRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
                                this.updateComponents(graphics, rectangle2);
                            } else {
                                Rectangle rectangle3;
                                graphics.drawImage(image == null ? this.SEDU : image, n3 - n6, n4 - n7, this);
                                if (n3 != 0) {
                                    rectangle3 = new Rectangle(n3 < 0 ? this.addImpl + n3 + n6 : 0, n4 <= 0 ? 0 : n4 + n7, (n3 < 0 ? -n3 : n3) - n6, this.afterDrawImage + (n4 <= 0 ? n4 : -n4) + n7);
                                    graphics.clipRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                                    graphics.setColor(this.getBackground());
                                    graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                                    this.updateComponents(graphics, rectangle3);
                                }
                                if (n8 > 0) {
                                    rectangle3 = new Rectangle(this.addImpl - n8, 0, n8, this.afterDrawImage - (n9 > 0 ? n9 : 0));
                                    graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                                    graphics.setColor(this.getBackground());
                                    graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                                    this.updateComponents(graphics, rectangle3);
                                }
                                if (n4 != 0) {
                                    rectangle3 = new Rectangle(0, n4 < 0 ? this.afterDrawImage + n4 + n7 : 0, this.addImpl, (n4 < 0 ? -n4 : n4) - n7);
                                    graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                                    graphics.setColor(this.getBackground());
                                    graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                                    this.updateComponents(graphics, rectangle3);
                                }
                                if (n9 > 0) {
                                    rectangle3 = new Rectangle(0, this.afterDrawImage - n9, this.addImpl, n9);
                                    graphics.setClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                                    graphics.setColor(this.getBackground());
                                    graphics.fillRect(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                                    this.updateComponents(graphics, rectangle3);
                                }
                            }
                        }
                        finally {
                            graphics.dispose();
                        }
                    }
                }
                graphics = this.getGraphics();
                if (graphics != null) {
                    try {
                        Dimension dimension = this.getSize();
                        graphics.clipRect(0, 0, dimension.width, dimension.height);
                        this.updateImage(graphics);
                    }
                    finally {
                        graphics.dispose();
                    }
                }
            } else {
                Rectangle rectangle = this.getBounds();
                rectangle.x = 0;
                rectangle.y = 0;
                this.calculateChildrenArea = this.calculateChildrenArea.union(rectangle);
            }
            this.scrolling(n3, n4);
        }
    }

    protected void scrolling(int n, int n2) {
    }

    public Point getClientAreaOffsets() {
        return new Point(this.clipRect, this.compareTo);
    }

    public Point getImageOffsets() {
        return new Point(this.abs, this.addElement);
    }

    public Dimension getImageSize() {
        return new Dimension(this.SEDU.getWidth(this), this.SEDU.getHeight(this));
    }

    public Graphics getImageGraphic() {
        if (this.SEDU != null) {
            return this.SEDU.getGraphics();
        }
        return null;
    }

    public void prepareRepaintImage(Rectangle rectangle) {
        this.calculateChildrenArea = rectangle.union(this.calculateChildrenArea);
    }

    public void addRepaintImageListener(RepaintImageListener repaintImageListener) {
        this.create.addElement(repaintImageListener);
    }

    public void removeRepaintImageListener(RepaintImageListener repaintImageListener) {
        this.create.removeElement(repaintImageListener);
    }

    public Rectangle getRectanglesArea(Vector vector) {
        int n = Short.MAX_VALUE;
        int n2 = Short.MAX_VALUE;
        int n3 = Short.MIN_VALUE;
        int n4 = Short.MIN_VALUE;
        Rectangle rectangle = new Rectangle(n, n2, n3 - n + 1, n4 - n2 + 1);
        for (int i = vector.size() - 1; i >= 0; --i) {
            rectangle = (Rectangle)vector.elementAt(i);
            int n5 = rectangle.x + rectangle.width;
            int n6 = rectangle.y + rectangle.height;
            n = rectangle.x < n ? rectangle.x : n;
            n2 = rectangle.y < n2 ? rectangle.y : n2;
            n3 = n5 > n3 ? n5 : n3;
            n4 = n6 > n4 ? n6 : n4;
        }
        return rectangle;
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        Point point = component.getLocation();
        point.translate(this.clipRect, this.compareTo);
        component.setLocation(point);
        super.addImpl(component, object, n);
    }

    @Override
    public void remove(int n) {
        Component component = this.getComponent(n);
        Point point = component.getLocation();
        point.translate(-this.clipRect, -this.compareTo);
        super.remove(n);
        component.setLocation(point);
    }

    @Override
    public void removeAll() {
        this.lockUpdate();
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            Point point = component.getLocation();
            point.translate(-this.clipRect, -this.compareTo);
            component.setLocation(point);
        }
        super.removeAll();
        this.unlockUpdate();
    }

    public Image getImage() {
        return this.SEDU;
    }

    @Override
    protected void processComponentEvent(ComponentEvent componentEvent) {
        int n = componentEvent.getID();
        if (n == 101 && this.isShowing()) {
            Dimension dimension = this.getSize();
            if (this.SEDU == null) {
                if (this.calculateImageArea == 0) {
                    this.updateImage(0, 0, dimension.width, dimension.height);
                } else {
                    this.calculateChildrenArea.union(new Rectangle(0, 0, dimension.width, dimension.height));
                }
            } else {
                int n2 = this.addImpl;
                int n3 = this.afterDrawImage;
                int n4 = dimension.width - n2;
                int n5 = dimension.height - n3;
                if (n4 > 0) {
                    this.updateImage(n2, 0, n4, n3);
                }
                if (n5 > 0) {
                    this.updateImage(0, n3, dimension.width, n5);
                }
            }
        }
        super.processComponentEvent(componentEvent);
    }

    @Override
    public Image createImage(int n, int n2) {
        Image image = super.createImage(n, n2);
        return new JImage(image);
    }
}

