/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import com.sun.org.apache.xml.internal.security.utils.Base64;
import java.sql.ResultSet;
import java.sql.SQLException;
import jet.connect.DbColDesc;
import jet.connect.DbNumber;
import jet.datasource.JRHierarchicalDataset;

public class DbDouble
extends DbNumber {
    public double value;

    public DbDouble() {
    }

    public DbDouble(double d) {
        this.value = d;
        this.bNull = false;
    }

    public DbDouble(DbColDesc dbColDesc) {
        super(dbColDesc);
    }

    public double get() {
        return this.value;
    }

    public void set(double d) {
        this.value = d;
        this.bNull = false;
    }

    @Override
    public void set(ResultSet resultSet, int n) throws SQLException {
        this.value = resultSet.getDouble(n);
        this.bNull = resultSet.wasNull();
    }

    @Override
    public void set(JRHierarchicalDataset jRHierarchicalDataset, int n) throws SQLException {
        this.value = jRHierarchicalDataset.getDouble(n);
        this.bNull = jRHierarchicalDataset.wasNull();
    }

    @Override
    public String toString() {
        if (this.bNull) {
            return "NULL";
        }
        return String.valueOf(this.value);
    }

    @Override
    public Object clone() {
        DbDouble dbDouble = new DbDouble(this.desc);
        dbDouble.bNull = this.bNull;
        dbDouble.value = this.value;
        return dbDouble;
    }

    @Override
    public boolean equals(DbNumber dbNumber) {
        if (this == dbNumber) {
            return true;
        }
        if (dbNumber == null) {
            return false;
        }
        if (dbNumber.bNull != this.bNull) {
            return false;
        }
        if (this.bNull) {
            return true;
        }
        return this.value == dbNumber.doubleValue();
    }

    @Override
    protected int compareToWithSameSQLType(DbNumber dbNumber) {
        DbDouble dbDouble = (DbDouble)dbNumber;
        if (dbDouble.bNull) {
            if (this.bNull) {
                return 0;
            }
            return 1;
        }
        if (this.bNull) {
            if (dbDouble.bNull) {
                return 0;
            }
            return -1;
        }
        if (this.value == dbDouble.value) {
            return 0;
        }
        if (this.value < dbDouble.value) {
            return -1;
        }
        return 1;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return (long)this.value;
    }

    @Override
    public float floatValue() {
        return (float)this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public void setValue(DbNumber dbNumber) {
        boolean bl = this.bNull = dbNumber == null || dbNumber.bNull;
        if (dbNumber instanceof DbDouble) {
            this.value = ((DbDouble)dbNumber).value;
        } else if (!this.bNull) {
            this.value = dbNumber.doubleValue();
        }
    }

    @Override
    public void setValue(String string) {
        try {
            this.value = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.value = Double.NaN;
        }
        this.bNull = false;
    }

    @Override
    public String toStringValue() {
        byte[] byArray = null;
        if (this.isNull()) {
            byArray = new byte[1];
        } else {
            byArray = new byte[9];
            byArray[0] = 1;
            int n = 1;
            long l = Double.doubleToRawLongBits(this.value);
            byArray[n++] = (byte)l;
            byArray[n++] = (byte)(l >> 8);
            byArray[n++] = (byte)(l >> 16);
            byArray[n++] = (byte)(l >> 24);
            byArray[n++] = (byte)(l >> 32);
            byArray[n++] = (byte)(l >> 40);
            byArray[n++] = (byte)(l >> 48);
            byArray[n++] = (byte)(l >> 56);
        }
        return Base64.encode(byArray);
    }
}

