/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.sql.ResultSet;
import java.sql.SQLException;
import jet.connect.DbArray;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbTinyInt;
import jet.datasource.JRHierarchicalDataset;
import jet.util.DbValueable;
import jet.util.QuickSortableNode;

public abstract class DbValue
implements QuickSortableNode,
DbValueable {
    public DbColDesc desc = null;
    public boolean bNull = true;
    public static DbColDesc DOUBLE_DESC = new DbColDesc("", 8, 15, 2, 2);
    public static DbColDesc CURRENCY_DESC = new DbColDesc("", 3, 19, 2, 2, true);
    public static DbColDesc DATE_DESC = new DbColDesc("", 91, 15, 0, 2);
    public static DbColDesc TIME_DESC = new DbColDesc("", 92, 15, 0, 2);
    public static DbColDesc CHAR_DESC = new DbColDesc("", 1, 30, 0, 2);
    public static DbColDesc INTEGER_DESC = new DbColDesc("", 4, 15, 0, 2);

    public DbValue() {
    }

    public DbValue(DbColDesc dbColDesc) {
        this.desc = dbColDesc;
    }

    public int getSqlType() {
        return this.desc.sqlType;
    }

    public int getPrecision() {
        return this.desc.precision;
    }

    public int getScale() {
        return this.desc.scale;
    }

    public DbColDesc getColDesc() {
        return this.desc;
    }

    public void setColDesc(DbColDesc dbColDesc) {
        this.desc = dbColDesc;
    }

    public boolean isCurrency() {
        return this.desc.isCurrency();
    }

    @Override
    public boolean isNull() {
        return this.bNull;
    }

    public void setNull() {
        this.bNull = true;
    }

    public abstract void set(ResultSet var1, int var2) throws SQLException;

    public void set(JRHierarchicalDataset jRHierarchicalDataset, int n) throws SQLException {
    }

    public abstract void set(DbValue var1);

    public final void setValue(DbValue dbValue) {
        this.set(dbValue);
    }

    public void setfoo(DbValue dbValue) {
        if (dbValue.desc != null) {
            this.desc = dbValue.desc;
        }
        this.set(dbValue);
    }

    @Override
    public abstract Object clone();

    public abstract boolean equals(DbValue var1);

    public final boolean equals(Object object) {
        if (object instanceof DbValue) {
            return this.equals((DbValue)object);
        }
        return false;
    }

    public abstract void setValue(String var1);

    public abstract int compareTo(DbValue var1);

    @Override
    public int compareTo(QuickSortableNode quickSortableNode) {
        return this.compareTo((DbValue)quickSortableNode);
    }

    @Override
    public int compareTo(DbValueable dbValueable) {
        return this.compareTo((DbValue)dbValueable);
    }

    public static final DbValue makeDbValue(DbColDesc dbColDesc) {
        DbValue dbValue = null;
        if (dbColDesc.isArray()) {
            dbValue = new DbArray(dbColDesc);
            return dbValue;
        }
        switch (dbColDesc.sqlType) {
            case 5: {
                dbValue = new DbSmallInt(dbColDesc);
                break;
            }
            case -6: {
                dbValue = new DbTinyInt(dbColDesc);
                break;
            }
            case 4: {
                dbValue = new DbInteger(dbColDesc);
                break;
            }
            case -5: {
                dbValue = new DbBigInt(dbColDesc);
                break;
            }
            case 7: {
                dbValue = new DbReal(dbColDesc);
                break;
            }
            case 2: 
            case 3: {
                dbValue = new DbDecimal(dbColDesc);
                break;
            }
            case 6: 
            case 8: {
                dbValue = new DbDouble(dbColDesc);
                break;
            }
            case -7: {
                dbValue = new DbBit(dbColDesc);
                break;
            }
            case 91: {
                dbValue = new DbDate(dbColDesc);
                break;
            }
            case 92: {
                dbValue = new DbTime(dbColDesc);
                break;
            }
            case 93: {
                dbValue = new DbTimestamp(dbColDesc);
                break;
            }
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                dbValue = new DbChar(dbColDesc);
                break;
            }
            case -4: 
            case -3: 
            case -2: 
            case 2004: {
                dbValue = new DbBinary(dbColDesc);
                break;
            }
            default: {
                throw new Error("unknow sql type : " + dbColDesc.getSqlType() + " of the column " + dbColDesc.colName);
            }
        }
        return dbValue;
    }

    public abstract String toString();

    public abstract String toStringValue();
}

