/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import java.awt.Color;
import java.awt.Rectangle;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.crosstab.layout.CTTemplateField;
import jet.datastream.DSCTField;
import jet.datastream.DSCrossTab;
import jet.datastream.DSDataStreamable;
import jet.util.VersionControlable;

public class CTGridInfo {
    public static final int TYPE_COL_HEADER = 1;
    public static final int TYPE_ROW_HEADER = 2;
    public static final int TYPE_CELL = 3;
    public static final int TYPE_TOTAL_CELL = 5;
    public static final int TYPE_AGGLABEL_CELL = 6;
    public int type;
    public int xCoord;
    public int yCoord;
    public Color fillColor;
    public Rectangle bgRect;
    private Vector SEDU = new Vector();
    private int add = 1;
    private int addElement = 1;
    private boolean booleanValue = false;
    private CTTemplateField copyObject = null;
    private DSCrossTab duplicate;

    public Object copyObject() {
        return this.duplicate();
    }

    public CTGridInfo duplicate() {
        CTGridInfo cTGridInfo = new CTGridInfo();
        cTGridInfo.fillColor = this.fillColor;
        cTGridInfo.type = this.type;
        cTGridInfo.xCoord = this.xCoord;
        cTGridInfo.yCoord = this.yCoord;
        cTGridInfo.setSplittedHeaderGrid(this.booleanValue);
        cTGridInfo.add = this.add;
        cTGridInfo.addElement = this.addElement;
        cTGridInfo.bgRect = new Rectangle(this.bgRect.x, this.bgRect.y, this.bgRect.width, this.bgRect.height);
        Vector vector = new Vector();
        Vector vector2 = this.SEDU;
        cTGridInfo.setChildList(vector);
        int n = vector2.size();
        for (int i = 0; i < n; ++i) {
            cTGridInfo.setChild(i, (DSCTField)((DSCTField)vector2.get(i)).copyObject());
        }
        cTGridInfo.copyObject = this.copyObject;
        return cTGridInfo;
    }

    protected void read(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        int n = ((VersionControlable)((Object)dataInput)).getVersion();
        if (n >= 262704 || n == 0) {
            this.booleanValue = dataInput.readBoolean();
        }
        int n2 = 0;
        if (n >= 262176 || n == 0) {
            this.add = dataInput.readShort();
            this.addElement = dataInput.readShort();
            n2 = dataInput.readShort();
        } else if (n >= 262145 || n == 0) {
            this.add = dataInput.readInt();
            this.addElement = dataInput.readInt();
            n2 = dataInput.readInt();
        }
        if (n >= 262145 || n == 0) {
            if (n2 > 0) {
                this.SEDU = new Vector(n2);
                for (int i = 0; i < n2; ++i) {
                    DSCTField dSCTField = new DSCTField();
                    if (n >= 131097 || n == 0) {
                        dataInput.readInt();
                    } else {
                        dataInput.readShort();
                    }
                    dSCTField.read(dataInput, dSDataStreamable);
                    dSCTField.setParentGridInfo(this);
                    this.duplicate.add(dSCTField);
                    this.SEDU.addElement(dSCTField);
                }
            } else {
                this.SEDU = new Vector();
            }
        }
        if (n >= 262176 || n == 0) {
            this.type = dataInput.readShort();
        } else if (n >= 9 || n == 0) {
            this.type = dataInput.readInt();
        }
        if (n >= 9 || n == 0) {
            this.xCoord = dataInput.readInt();
            this.yCoord = dataInput.readInt();
        }
        this.bgRect = n >= 131087 || n == 0 ? new Rectangle(dataInput.readInt(), dataInput.readInt(), dataInput.readInt(), dataInput.readInt()) : new Rectangle((int)Math.round((double)dataInput.readInt() * 5760.0 / 65535.0), (int)Math.round((double)dataInput.readInt() * 5760.0 / 65535.0), (int)Math.round((double)dataInput.readInt() * 5760.0 / 65535.0), (int)Math.round((double)dataInput.readInt() * 5760.0 / 65535.0));
        if (dataInput.readBoolean()) {
            this.fillColor = new Color(dataInput.readInt());
        }
    }

    protected void write(DataOutput dataOutput) throws IOException {
        dataOutput.writeBoolean(this.booleanValue);
        dataOutput.writeShort(this.add);
        dataOutput.writeShort(this.addElement);
        int n = this.SEDU.size();
        if (n > 0 && this.SEDU.get(0) == null) {
            n = 0;
        }
        dataOutput.writeShort(n);
        for (int i = 0; i < n; ++i) {
            DSCTField dSCTField = (DSCTField)this.SEDU.get(i);
            if (dSCTField == null) continue;
            dSCTField.write(dataOutput);
        }
        dataOutput.writeShort(this.type);
        dataOutput.writeInt(this.xCoord);
        dataOutput.writeInt(this.yCoord);
        dataOutput.writeInt(this.bgRect.x);
        dataOutput.writeInt(this.bgRect.y);
        dataOutput.writeInt(this.bgRect.width);
        dataOutput.writeInt(this.bgRect.height);
        if (this.fillColor != null) {
            dataOutput.writeBoolean(true);
            dataOutput.writeInt(0xFF000000 | this.fillColor.getRed() << 16 | this.fillColor.getGreen() << 8 | this.fillColor.getBlue());
        } else {
            dataOutput.writeBoolean(false);
        }
    }

    int length() {
        int n = 26;
        n += 8;
        if (this.fillColor != null) {
            n += 4;
        }
        int n2 = this.SEDU.size();
        for (int i = 0; i < n2; ++i) {
            if (this.SEDU.get(i) == null) continue;
            n += ((DSCTField)this.SEDU.get(i)).length();
        }
        return n;
    }

    public Vector getChildren() {
        return this.SEDU;
    }

    public int getColSpan() {
        return this.add;
    }

    public void setColSpan(int n) {
        this.add = n;
    }

    public int getRowSpan() {
        return this.addElement;
    }

    public void setRowSpan(int n) {
        this.addElement = n;
    }

    public boolean isExpanded() {
        Boolean bl;
        DSCTField dSCTField;
        if ((this.type == 1 || this.type == 2) && this.SEDU.size() != 0 && (dSCTField = (DSCTField)this.SEDU.get(0)).isDBField() && (bl = (Boolean)dSCTField.getTemplate().getPropertyByName("isExpandData").getObject()) != null) {
            return bl;
        }
        return true;
    }

    public boolean canExpanded() {
        Boolean bl;
        DSCTField dSCTField;
        if ((this.type == 1 || this.type == 2) && this.SEDU.size() != 0 && (dSCTField = (DSCTField)this.SEDU.get(0)).isDBField() && (bl = (Boolean)dSCTField.getTemplate().getPropertyByName("ExpandData").getObject()) != null) {
            return bl;
        }
        return false;
    }

    public void setChildList(Vector vector) {
        this.SEDU = vector;
    }

    public boolean isDbHeader() {
        DSCTField dSCTField;
        return (this.type == 1 || this.type == 2) && this.SEDU.size() != 0 && (dSCTField = (DSCTField)this.SEDU.get(0)).isDBField();
    }

    public boolean isDbHeaderTitle() {
        DSCTField dSCTField;
        return (this.type == 1 || this.type == 2) && this.SEDU.size() != 0 && (dSCTField = (DSCTField)this.SEDU.get(0)).isLabelField();
    }

    public boolean isAggLabelOrTotalCell() {
        return this.type == 5 || this.type == 6;
    }

    public boolean isAggCell() {
        return this.type == 3 || this.type == 5 || this.type == 6;
    }

    public void add(DSCTField dSCTField) {
        this.SEDU.addElement(dSCTField);
        dSCTField.setParentGridInfo(this);
    }

    public void setChild(int n, DSCTField dSCTField) {
        int n2 = this.SEDU.size();
        if (n2 == 0 || n2 < n + 1) {
            this.SEDU.add(dSCTField);
        } else {
            this.SEDU.set(n, dSCTField);
        }
        dSCTField.setParentGridInfo(this);
    }

    public DSCrossTab getParentCrosstab() {
        return this.duplicate;
    }

    public void setParentCrosstab(DSCrossTab dSCrossTab) {
        this.duplicate = dSCrossTab;
    }

    public void setForDhtml(boolean bl) {
    }

    public boolean isEmptyAggGrid() {
        return this.SEDU.size() == 0;
    }

    public void setEmptyAggGrid(boolean bl) {
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public CTTemplateField getPosition() {
        return this.copyObject;
    }

    public void setPosition(CTTemplateField cTTemplateField) {
        this.copyObject = cTTemplateField;
    }

    public boolean isSplittedHeaderGrid() {
        return this.booleanValue;
    }

    public void setSplittedHeaderGrid(boolean bl) {
        this.booleanValue = bl;
    }
}

