/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.resstore.ResourceStore;
import com.jinfonet.util.JRLog;
import java.util.Date;
import java.util.Hashtable;
import jet.JRStopEngineException;
import jet.connect.Record;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.dataengine.api.dbbuffer.JRecordModel;
import jet.datastream.Communicator;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSTemplatible;
import jet.datastream.JRObjectResult;
import jet.datastream.ReportHeaderInfo;
import jet.util.JFieldValueNLSManager;
import jet.util.JRInterruptedException;

public class DSSubStream
implements DSDataStreamable {
    protected JRecordModel recordModel;
    protected JRecord record;
    protected JRecord calculateRecord;
    protected JDbBufferCursor dbBuffer;
    protected Communicator communicator;
    protected int subIdx;
    private Date SEDU;
    private boolean createRecord;

    public DSSubStream() {
        this.SEDU = new Date();
        this.createRecord = false;
    }

    public DSSubStream(Communicator communicator, int n) {
        block5: {
            this.SEDU = new Date();
            this.createRecord = false;
            this.communicator = communicator;
            this.subIdx = n;
            this.dbBuffer = communicator.getDbBuffer(n);
            this.recordModel = this.dbBuffer.getRecordModel();
            if (communicator.getFieldNLSManager() != null) {
                this.createRecord = communicator.getFieldNLSManager().isContainSelfDefinedMapping();
            }
            try {
                this.record = this.dbBuffer.createRecord();
                this.calculateRecord = this.dbBuffer.createRecord();
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block5;
                JRLog.error(2, exception);
            }
        }
    }

    public Date getPrintDate() {
        return this.SEDU;
    }

    @Override
    public JRecord getCalculateRecord(int n) {
        this.calculateRecord.setRecordIndex(n);
        this.calculateRecord.refresh(false);
        return this.calculateRecord;
    }

    @Override
    public JRecord getRecord(int n) {
        this.record.setRecordIndex(n);
        this.record.refresh(false);
        return this.record;
    }

    public Record getLastRecord() {
        return this.getRecord(this.dbBuffer.getCurrentEnd());
    }

    @Override
    public JRecord getSynRecord(int n) {
        return this.getRecord(n);
    }

    @Override
    public JRecord getSynRecord2(int n) {
        return this.getRecord(n);
    }

    @Override
    public DSTemplatible getTemplate(short s) {
        Hashtable hashtable = this.communicator.getTemplates(this.subIdx);
        return (DSTemplatible)hashtable.get(s);
    }

    @Override
    public Communicator getCommunicator() {
        return this.communicator;
    }

    @Override
    public ReportHeaderInfo getHeaderInfo() {
        return this.communicator.getHeaderInfo(this.subIdx);
    }

    @Override
    public int getSubIndex() {
        return this.subIdx;
    }

    public static int getLinkPage(JRObjectResult jRObjectResult, Communicator communicator) throws JRStopEngineException {
        Communicator communicator2;
        int n = -1;
        int n2 = jRObjectResult.getLinkComm();
        int n3 = -1;
        if (n2 != -1) {
            communicator2 = communicator.getLinkedComm(n2);
            n3 = communicator2.getLinkedPage(jRObjectResult.getLinkCondition());
        }
        if (n2 != -1 || n3 != -1) {
            communicator2 = communicator.getLinkedComm(n2);
            int n4 = 0;
            int n5 = 0;
            Communicator communicator3 = null;
            while ((communicator3 = communicator.getLinkedComm(n4)) != communicator2) {
                n5 += communicator3.getPageNum();
                ++n4;
            }
            n = n5 += n3;
        }
        return n;
    }

    public void clearMem() {
        this.recordModel = null;
        this.record = null;
        this.dbBuffer = null;
        this.communicator = null;
    }

    public JRecord getSRecord() {
        return this.record;
    }

    public JRecord getSCRecord() {
        return this.calculateRecord;
    }

    @Override
    public JFieldValueNLSManager getNlsManager() {
        if (this.createRecord) {
            return this.communicator.getFieldNLSManager();
        }
        return null;
    }

    @Override
    public ResourceStore getResourceStore() {
        return null;
    }

    @Override
    public void setResourceStore(ResourceStore resourceStore) {
    }
}

