/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xls.chart;

import java.awt.Color;
import java.io.IOException;
import jet.export.excel.imp.xls.Biff;
import jet.export.excel.imp.xls.ColorTable;
import util.RandomAccessStream;

public class LineFormat
extends Biff {
    public static final short AUTOFORMAT = 1;
    public static final short DRAWTICK = 4;
    public static final short PATTERN_SOLID = 0;
    public static final short PATTERN_DASH = 1;
    public static final short PATTERN_DOT = 2;
    public static final short PATTERN_DASH_DOT = 3;
    public static final short PATTERN_DASHDOT_DOT = 4;
    public static final short PATTERN_NONE = 5;
    public static final short PATTERN_DARKGRAYPATTERN = 6;
    public static final short PATTERN_MEDIUMGRAYPATTERN = 7;
    public static final short PATTERN_LIGHTGRAYPATTERN = 8;
    public static final short WEIGHT_HAIRLINE = -1;
    public static final short WEIGHT_NARROW = 0;
    public static final short WEIGHT_MEDIUM = 1;
    public static final short WEIGHT_WIDE = 2;
    short SEDU;
    short addColor;
    short getColorRGB;
    short needUpdateIndex;
    int output;
    private ColorTable readInt;

    public LineFormat(ColorTable colorTable) {
        this.length = 12;
        this.readInt = colorTable;
    }

    public void setColorIndex(short s) {
        this.needUpdateIndex = s;
    }

    public void setColorRgb(int n) {
        this.output = n;
    }

    public LineFormat(int n, short s, short s2, short s3, short s4, ColorTable colorTable) {
        this(colorTable);
        this.output = n;
        this.SEDU = s;
        this.addColor = s2;
        this.getColorRGB = s3;
        this.needUpdateIndex = s4;
    }

    public LineFormat(Color color, byte by, int n, ColorTable colorTable) {
        this(colorTable);
        this.output = colorTable.getColorRGB(color);
        this.SEDU = by;
        this.needUpdateIndex = colorTable.addColor(color);
        this.addColor = (short)(n < 20 ? (n < 10 ? -1 : 0) : (n > 35 ? 2 : 1));
    }

    @Override
    public final int opcode() {
        return 4103;
    }

    @Override
    public int output(RandomAccessStream randomAccessStream) throws IOException {
        super.output(randomAccessStream);
        if (this.readInt.needUpdateIndex() && this.needUpdateIndex >= 0) {
            this.needUpdateIndex = this.readInt.updateColorIndex(this.needUpdateIndex);
        }
        if (this.output == -1) {
            this.output = 0;
        }
        this.writeInt(randomAccessStream, this.output);
        this.writeShort(randomAccessStream, this.SEDU);
        this.writeShort(randomAccessStream, this.addColor);
        this.writeShort(randomAccessStream, this.getColorRGB);
        this.writeShort(randomAccessStream, this.needUpdateIndex);
        return this.length + 4;
    }

    @Override
    public void input(RandomAccessStream randomAccessStream) throws IOException {
        this.output = this.readInt(randomAccessStream);
        this.SEDU = this.readShort(randomAccessStream);
        this.addColor = this.readShort(randomAccessStream);
        this.getColorRGB = this.readShort(randomAccessStream);
        this.needUpdateIndex = this.readShort(randomAccessStream);
    }

    public void setPattern(short s) {
        this.SEDU = s;
    }

    public short getPattern() {
        return this.SEDU;
    }

    public void setWeight(short s) {
        this.addColor = s;
    }

    public short getWeight() {
        return this.addColor;
    }

    public boolean isAutoFormat() {
        return (this.getColorRGB & 1) == 1;
    }

    public boolean isDrawTick() {
        return (this.getColorRGB & 4) == 4;
    }

    public void setDrawTick(boolean bl) {
        this.getColorRGB = (short)(bl ? this.getColorRGB | 4 : this.getColorRGB & 0xFFFFFFFB);
    }

    public void setAutoColor(boolean bl) {
        this.getColorRGB = (short)(bl ? this.getColorRGB | 8 : this.getColorRGB & 0xFFFFFFF7);
    }
}

