/*
 * Decompiled with CFR 0.152.
 */
package jet.export.pdf;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfSignatureAppearance;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.PdfWriter;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.util.HashMap;
import java.util.Hashtable;
import jet.bean.PDFParameter;
import jet.datastream.TOCNode;
import jet.export.ExportAuxInfo;
import jet.export.pdf.PDFConstants;
import jet.export.pdf.PDFFont;
import jet.export.pdf.PdfExt;
import jet.export.util.ImageEncoder;
import jet.export.util.URLEncoder;
import jet.util.MessageDigestMaker;

public class PDFWriter
implements PDFConstants {
    static Toolkit I = Toolkit.getDefaultToolkit();
    static HashMap SEDU = new HashMap();
    PDFFont SELF_SIGNED;
    Dimension VERISIGN_SIGNED;
    PdfExt Z;
    boolean WINCER_SIGNED = false;
    PdfWriter addImage;
    PdfContentByte aliases;
    Hashtable arc;
    MessageDigestMaker beginText;
    int clear = -1;
    HashMap clip = new HashMap();
    private ExportAuxInfo close;
    private File convertUnitToPixel;

    public PDFWriter(PdfExt pdfExt, String string, PDFParameter pDFParameter, ExportAuxInfo exportAuxInfo) throws IOException, DocumentException, OutOfSpaceException {
        this.close = exportAuxInfo;
        this.Z = pdfExt;
        this.convertUnitToPixel = this.close.getDiskStore().createFile(string);
        this.addImage = PdfWriter.getInstance((Document)pdfExt, (OutputStream)new BufferedOutputStream(new FileOutputStream(this.convertUnitToPixel)));
        int n = pDFParameter.getImageCompressRatio();
        if (pDFParameter.isTransparent()) {
            n = -1;
        } else {
            this.clear = n < 0 || n > 100 ? -1 : 100 - n;
        }
        this.arc = new Hashtable();
        this.beginText = new MessageDigestMaker();
        if (!pDFParameter.hasSignature()) {
            PDFWriter.encrypt(this.addImage, pDFParameter);
        }
    }

    public PDFWriter(PdfExt pdfExt, OutputStream outputStream, PDFParameter pDFParameter, ExportAuxInfo exportAuxInfo) throws DocumentException {
        this.Z = pdfExt;
        this.addImage = PdfWriter.getInstance((Document)pdfExt, (OutputStream)outputStream);
        int n = pDFParameter.getImageCompressRatio();
        if (pDFParameter.isTransparent()) {
            n = -1;
        } else {
            this.clear = n < 0 || n > 100 ? -1 : 100 - n;
        }
        this.arc = new Hashtable();
        this.beginText = new MessageDigestMaker();
        if (!pDFParameter.hasSignature()) {
            PDFWriter.encrypt(this.addImage, pDFParameter);
        }
        this.close = exportAuxInfo;
    }

    public void open(Dimension dimension, Color color) {
        this.VERISIGN_SIGNED = dimension;
        Rectangle rectangle = new Rectangle(0.0f, 0.0f, (float)this.VERISIGN_SIGNED.width, (float)this.VERISIGN_SIGNED.height);
        rectangle.setBackgroundColor(color);
        this.Z.setPageSize(rectangle);
        this.Z.open();
        this.aliases = this.addImage.getDirectContent();
    }

    void I(Dimension dimension, Color color) throws DocumentException {
        this.VERISIGN_SIGNED = dimension;
        Rectangle rectangle = new Rectangle(0.0f, 0.0f, (float)this.VERISIGN_SIGNED.width, (float)this.VERISIGN_SIGNED.height);
        rectangle.setBackgroundColor(color);
        this.Z.setPageSize(rectangle);
        this.Z.newPage();
    }

    void I(float f, float f2, float f3, float f4) {
        this.aliases.rectangle(f, this.convertY(f2 + f4), f3, f4);
        this.aliases.clip();
        this.aliases.newPath();
    }

    void I(float f, float f2, float f3, float f4, float f5) {
        float f6 = f5;
        if (f6 > f4 || f6 > f3) {
            f6 = f4 < f3 ? f4 : f3;
        }
        this.aliases.roundRectangle(f, this.convertY(f2 + f4), f3, f4, f6 / 2.0f);
        this.aliases.clip();
        this.aliases.newPath();
    }

    void I() {
        this.aliases.saveState();
    }

    void Z() {
        this.aliases.restoreState();
    }

    public static void encrypt(PdfWriter pdfWriter, PDFParameter pDFParameter) throws DocumentException {
        if (pDFParameter != null && pDFParameter.hasEncryption()) {
            String string = pDFParameter.getOwnerPassword();
            String string2 = pDFParameter.getUserPassword();
            int n = pDFParameter.getPermissions();
            if (string == null || string.length() == 0) {
                string = string2;
                n = 2108;
            }
            pdfWriter.setEncryption(pDFParameter.isStrength128Bits(), string2, string, n);
        }
    }

    public static void encrypt(PdfStamper pdfStamper, PDFParameter pDFParameter) throws DocumentException {
        if (pDFParameter != null && pDFParameter.hasEncryption()) {
            String string = pDFParameter.getOwnerPassword();
            String string2 = pDFParameter.getUserPassword();
            int n = pDFParameter.getPermissions();
            if (string == null || string.length() == 0) {
                string = string2;
                n = 2108;
            }
            pdfStamper.setEncryption(pDFParameter.isStrength128Bits(), string2, string, n);
        }
    }

    public static void signAndEncrypt(KeyStore keyStore, PdfStamper pdfStamper, PDFParameter pDFParameter) throws DocumentException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        PDFWriter.encrypt(pdfStamper, pDFParameter);
        if (pDFParameter != null && pDFParameter.hasSignature()) {
            String string = keyStore.aliases().nextElement();
            PrivateKey privateKey = (PrivateKey)keyStore.getKey(string, pDFParameter.getDigitalIDFilePassword().toCharArray());
            Certificate[] certificateArray = keyStore.getCertificateChain(string);
            PdfSignatureAppearance pdfSignatureAppearance = pdfStamper.getSignatureAppearance();
            pdfSignatureAppearance.setCrypto(privateKey, certificateArray, null, PDFWriter.I(pDFParameter.getSignatureMethod()));
            pdfSignatureAppearance.setReason(pDFParameter.getSigningReason());
            pdfSignatureAppearance.setLocation(pDFParameter.getSigningLocation());
            pdfSignatureAppearance.setContact(pDFParameter.getSigningContact());
        }
    }

    private static PdfName I(int n) {
        PdfName pdfName = null;
        switch (n) {
            case 0: {
                pdfName = PdfSignatureAppearance.SELF_SIGNED;
                break;
            }
            case 2: {
                pdfName = PdfSignatureAppearance.WINCER_SIGNED;
                break;
            }
            case 1: {
                pdfName = PdfSignatureAppearance.VERISIGN_SIGNED;
                break;
            }
            default: {
                pdfName = PdfSignatureAppearance.SELF_SIGNED;
            }
        }
        return pdfName;
    }

    public void setEncryption(String string) {
        block3: {
            if (string != null && string.length() != 0) {
                try {
                    this.addImage.setEncryption(true, string, string, 2108);
                }
                catch (DocumentException documentException) {
                    if (!JRLog.isError(2)) break block3;
                    JRLog.error(2, 2401006, (Throwable)documentException);
                }
            }
        }
    }

    void I(TOCNode tOCNode) {
        if (tOCNode != null) {
            String string = tOCNode.getNodeDisplayValue();
            float f = Unit.convertUnitToPixel(tOCNode.getX(), 72);
            float f2 = this.convertY(Unit.convertUnitToPixel(tOCNode.getY(), 72));
            int n = tOCNode.getPage();
            PdfAction pdfAction = PdfAction.gotoLocalPage((int)n, (PdfDestination)new PdfDestination(0, f, f2, 0.0f), (PdfWriter)this.addImage);
            PdfOutline pdfOutline = new PdfOutline(this.aliases.getRootOutline(), pdfAction, string);
            int n2 = tOCNode.getNodeCount();
            for (int i = 0; i < n2; ++i) {
                TOCNode tOCNode2 = (TOCNode)tOCNode.getNode(i);
                this.SEDU(pdfOutline, tOCNode2);
            }
        }
    }

    private void SEDU(PdfOutline pdfOutline, TOCNode tOCNode) {
        if (tOCNode != null) {
            String string = tOCNode.getNodeDisplayValue();
            float f = Unit.convertUnitToPixel(tOCNode.getX(), 72);
            float f2 = this.convertY(Unit.convertUnitToPixel(tOCNode.getY(), 72));
            int n = tOCNode.getPage();
            PdfAction pdfAction = PdfAction.gotoLocalPage((int)n, (PdfDestination)new PdfDestination(0, f, f2, 0.0f), (PdfWriter)this.addImage);
            PdfOutline pdfOutline2 = new PdfOutline(pdfOutline, pdfAction, string);
            int n2 = tOCNode.getNodeCount();
            for (int i = 0; i < n2; ++i) {
                TOCNode tOCNode2 = (TOCNode)tOCNode.getNode(i);
                this.SEDU(pdfOutline2, tOCNode2);
            }
        }
    }

    public void setEncoding(String string) {
        this.Z.setEncoding(string);
    }

    public void setFont(PDFFont pDFFont, boolean bl) {
        this.SELF_SIGNED = pDFFont;
        this.WINCER_SIGNED = bl;
    }

    public static FontMetrics getFontMetrics(Font font) {
        Object v = SEDU.get(font);
        if (v != null) {
            return (FontMetrics)v;
        }
        FontMetrics fontMetrics = I.getFontMetrics(font);
        SEDU.put(font, fontMetrics);
        return fontMetrics;
    }

    public void dispose() throws OutOfSpaceException, IOException {
        this.Z.close();
        this.arc.clear();
        this.arc = null;
        this.addImage = null;
        this.aliases = null;
        this.Z = null;
        SEDU.clear();
        if (this.convertUnitToPixel != null) {
            this.close.getDiskStore().fileUpdated(this.convertUnitToPixel);
        }
    }

    public void setBorderStyle(float f, int n) {
        if (n > 0) {
            float f2 = this.SELF_SIGNED(f, n);
            this.WINCER_SIGNED(f2);
        }
    }

    private float SELF_SIGNED(float f, int n) {
        float f2 = 1.0f;
        float f3 = 1.0f;
        float f4 = 0.0f;
        float f5 = f;
        switch (n) {
            case 6: {
                f5 = this.VERISIGN_SIGNED(f5);
            }
            case 1: {
                this.aliases.setLineDash(0.0f);
                break;
            }
            case 2: {
                f2 = f5 * 4.0f;
                f3 = f5 * 3.0f;
                this.aliases.setLineDash(f2, f3, f4);
                break;
            }
            case 9: {
                f5 = this.VERISIGN_SIGNED(f5);
            }
            case 3: {
                f2 = f5;
                f3 = 5.0f;
                this.aliases.setLineDash(f2, f3, f4);
                break;
            }
            case 12: {
                f5 = this.VERISIGN_SIGNED(f5);
            }
            case 4: {
                float[] fArray2 = new float[]{f5 * 5.0f, f5 * 3.0f, f5, f5 * 3.0f};
                this.aliases.setLineDash(fArray2, f4);
                break;
            }
            case 8: {
                f5 = this.VERISIGN_SIGNED(f5);
            }
            case 7: {
                f2 = f5 * 5.0f;
                f3 = f5 * 3.0f;
                this.aliases.setLineDash(f2, f3, f4);
                break;
            }
            case 11: {
                f5 = this.VERISIGN_SIGNED(f5);
            }
            case 10: {
                f2 = 12.0f;
                f3 = 7.0f;
                this.aliases.setLineDash(f2, f3, f4);
                break;
            }
            case 14: {
                f5 = this.VERISIGN_SIGNED(f5);
            }
            case 13: {
                float[] fArray3 = new float[]{f5 * 5.0f, f5 * 3.0f, f5, f5 * 3.0f, f5, f5 * 3.0f};
                this.aliases.setLineDash(fArray3, f4);
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                this.aliases.setLineDash(0.0f);
            }
        }
        return f5;
    }

    private float VERISIGN_SIGNED(float f) {
        return f * 1.5f;
    }

    private void WINCER_SIGNED(float f) {
        this.aliases.setLineWidth(f);
    }

    public void drawLine(float f, float f2, float f3, float f4, float f5, int n, Color color) {
        if (color != null) {
            this.setStrokeColor(color);
        }
        this.setBorderStyle(f5, n);
        if (n == 6 || n == 1 || n == 15 || n == 16 || n == 17) {
            this.aliases.setLineCap(2);
        }
        this.aliases.moveTo(f, this.convertY(f2));
        this.aliases.lineTo(f3, this.convertY(f4));
        this.aliases.stroke();
    }

    public void fillRect(float f, float f2, float f3, float f4, Color color) {
        if (color != null) {
            this.setColor(color);
        }
        this.aliases.rectangle(f, this.convertY(f2 + f4), f3, f4);
        this.aliases.fill();
    }

    public void fillRect(java.awt.Rectangle rectangle, Color color) {
        this.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, color);
    }

    public void drawRect(float f, float f2, float f3, float f4, float f5, int n, Color color) {
        if (color != null) {
            this.setStrokeColor(color);
        }
        this.setBorderStyle(f5, n);
        this.aliases.rectangle(f, this.convertY(f2 + f4), f3, f4);
        this.aliases.stroke();
    }

    public void drawRect(java.awt.Rectangle rectangle, float f, int n, Color color) {
        this.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, f, n, color);
    }

    public void drawRoundRect(float f, float f2, float f3, float f4, float f5, float f6, float f7, int n, Color color) {
        if (color != null) {
            this.setStrokeColor(color);
        }
        this.setBorderStyle(f7, n);
        if (f5 > f4 || f5 > f3) {
            f5 = f4 < f3 ? f4 : f3;
        }
        this.aliases.roundRectangle(f, this.convertY(f2 + f4), f3, f4, f5 / 2.0f);
        this.aliases.stroke();
    }

    public void fillRoundRect(float f, float f2, float f3, float f4, float f5, float f6, Color color) {
        if (color != null) {
            this.setColor(color);
        }
        if (f5 > f4 || f5 > f3) {
            f5 = f4 < f3 ? f4 : f3;
        }
        this.aliases.roundRectangle(f, this.convertY(f2 + f4), f3, f4, f5 / 2.0f);
        this.aliases.fill();
    }

    public void drawOval(float f, float f2, float f3, float f4, float f5, int n, Color color) {
        if (color != null) {
            this.setStrokeColor(color);
        }
        this.setBorderStyle(f5, n);
        this.aliases.ellipse(f, this.convertY(f2), f + f3, this.convertY(f2 + f4));
        this.aliases.stroke();
    }

    public void fillOval(float f, float f2, float f3, float f4, Color color) {
        if (color != null) {
            this.setColor(color);
        }
        this.aliases.ellipse(f, this.convertY(f2), f + f3, this.convertY(f2 + f4));
        this.aliases.fill();
    }

    public void drawArc(float f, float f2, float f3, float f4, float f5, float f6, float f7, int n, Color color) {
        if (color != null) {
            this.setStrokeColor(color);
        }
        this.setBorderStyle(f7, n);
        this.aliases.arc(f, this.convertY(f2), f + f3, this.convertY(f2 + f4), f5, f6);
        this.aliases.stroke();
    }

    public void fillArc(float f, float f2, float f3, float f4, float f5, float f6, Color color) {
        if (color != null) {
            this.setColor(color);
        }
        this.aliases.arc(f, this.convertY(f2), f + f3, this.convertY(f2 + f4), f5, f6);
        this.aliases.fill();
    }

    public void drawFileLink(String string, float f, float f2, float f3, float f4) {
        PdfAction pdfAction = new PdfAction(string, 1);
        this.aliases.setAction(pdfAction, f, this.convertY(f2) - f4, f + f3, this.convertY(f2));
    }

    public void drawLocalLink(int n, float f, float f2, float f3, float f4) {
        PdfAction pdfAction = PdfAction.gotoLocalPage((int)n, (PdfDestination)new PdfDestination(0, -1.0f, 10000.0f, 0.0f), (PdfWriter)this.addImage);
        this.aliases.setAction(pdfAction, f, this.convertY(f2) - f4, f + f3, this.convertY(f2));
    }

    public void drawURLLink(String string, float f, float f2, float f3, float f4) {
        PdfAction pdfAction;
        block5: {
            string = string.trim();
            pdfAction = null;
            if (string.startsWith("\\")) {
                pdfAction = new PdfAction(string, null, null, null);
            } else {
                try {
                    pdfAction = new PdfAction(URLEncoder.encode(string, URLEncoder.getSystemURLEncoding()));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    if (!JRLog.isError(2)) break block5;
                    JRLog.error(2, unsupportedEncodingException);
                }
            }
        }
        if (pdfAction != null) {
            this.aliases.setAction(pdfAction, f, this.convertY(f2) - f4, f + f3, this.convertY(f2));
        }
    }

    public void drawString(String string, BaseFont baseFont, int n, float f, float f2, float f3, Color color) {
        this.setColor(color);
        this.aliases.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
        com.lowagie.text.Font font = new com.lowagie.text.Font(baseFont, f, n);
        Phrase phrase = new Phrase(string, font);
        ColumnText.showTextAligned((PdfContentByte)this.aliases, (int)0, (Phrase)phrase, (float)f2, (float)this.convertY(f3), (float)0.0f);
    }

    public void drawString(String string, BaseFont baseFont, float f, float f2, float f3, Color color) {
        this.setColor(color);
        this.aliases.beginText();
        this.aliases.setFontAndSize(baseFont, f);
        this.aliases.setTextMatrix(f2, this.convertY(f3));
        this.aliases.showText(string);
        this.aliases.endText();
    }

    public void drawString(String string, float f, float f2, Color color) throws IOException, DocumentException {
        if (string != null && string.length() != 0 && color != null) {
            BaseFont baseFont = this.Z.getBaseFont(string, this.SELF_SIGNED, this.WINCER_SIGNED, false);
            this.drawString(string, baseFont, this.SELF_SIGNED.getSize(), f, f2, color);
        }
    }

    protected String getImgID(java.awt.Image image) {
        String string = (String)this.clip.get(image);
        if (string != null) {
            return string;
        }
        string = this.beginText.generateString(image);
        this.clip.put(image, string);
        return string;
    }

    public void drawImage(java.awt.Image image, float f, float f2, float f3, float f4, String string) {
        block8: {
            if (image != null) {
                String string2 = null;
                string2 = string == null ? this.beginText.generateString(image) : string;
                Image image2 = (Image)this.arc.get(string2);
                try {
                    if (image2 == null) {
                        if (this.clear == -1) {
                            image2 = Image.getInstance((java.awt.Image)image, null);
                        } else {
                            ImageEncoder imageEncoder = new ImageEncoder();
                            byte[] byArray = imageEncoder.encoderImage(image, (float)this.clear / 100.0f);
                            image2 = Image.getInstance((byte[])byArray);
                        }
                        this.arc.put(string2, image2);
                    }
                    image2.setAbsolutePosition(f, this.convertY(f2 + f4));
                    image2.scaleAbsolute(f3, f4);
                    this.aliases.addImage(image2);
                }
                catch (IOException iOException) {
                    if (JRLog.isError(2)) {
                        JRLog.error(2, 2401007, (Throwable)iOException);
                    }
                }
                catch (DocumentException documentException) {
                    if (!JRLog.isError(2)) break block8;
                    JRLog.error(2, 2401007, (Throwable)documentException);
                }
            }
        }
    }

    public final void setColor(Color color) {
        this.aliases.setRGBColorFill(color.getRed(), color.getGreen(), color.getBlue());
    }

    public final void setStrokeColor(Color color) {
        this.aliases.setRGBColorStroke(color.getRed(), color.getGreen(), color.getBlue());
    }

    public final float convertY(double d) {
        return (float)((double)this.VERISIGN_SIGNED.height - d);
    }

    public Graphics2D getGraphics(float f, float f2) {
        return this.aliases.createGraphicsShapes(f, f2);
    }
}

