/*
 * Decompiled with CFR 0.152.
 */
package jet.export.print;

import com.jinfonet.util.JRLog;
import guitools.toolkit.TPaintBoard;
import java.awt.Canvas;
import java.awt.Component;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import jet.JRStopEngineException;
import jet.datastream.Communicator;
import jet.export.print.JReportPrintListener;
import jet.thinviewer.JReportViewer;
import jet.util.AwtTreeIterater;
import jet.util.JRInterruptedException;

abstract class JReportPrintViewer
extends JReportViewer {
    protected TPaintBoard holder;
    protected Vector listeners = new Vector();

    public JReportPrintViewer(Communicator communicator, float f) {
        String string = System.getProperty("os.name");
        if ("Windows 95".equals(string) || "Windows 98".equals(string)) {
            communicator.waitFinished();
        }
    }

    protected abstract void doPrint();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread printReport(boolean bl) {
        this.thread = new Thread(this);
        this.thread.start();
        if (bl) {
            Thread thread = this.thread;
            synchronized (thread) {
                while (this.thread.isAlive()) {
                    try {
                        this.thread.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!JRLog.isError(2)) continue;
                        JRLog.error(2, interruptedException);
                    }
                }
            }
        }
        return this.thread;
    }

    @Override
    protected void addChild() throws JRStopEngineException {
        block7: {
            Component component;
            if (this.viewerClient.getParent() != null) {
                this.viewerClient.getParent().remove(this.viewerClient);
            }
            this.viewerClient.removeAll();
            super.addChildWithoutNotify();
            AwtTreeIterater awtTreeIterater = new AwtTreeIterater(this.viewerClient, false);
            Vector<Component> vector = new Vector<Component>();
            while ((component = (Component)awtTreeIterater.next()) != null) {
                if (!(component instanceof Canvas) && !(component instanceof JPanel) && !(component instanceof JScrollBar)) continue;
                vector.addElement(component);
            }
            try {
                for (int i = 0; i < vector.size(); ++i) {
                    Component component2 = (Component)vector.elementAt(i);
                    component2.getParent().remove(component2);
                }
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, "JRInterruptedException", (Throwable)jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block7;
                JRLog.error(2, exception);
            }
        }
        super.addChildNotify();
    }

    public void addPrintListener(JReportPrintListener jReportPrintListener) {
        if (!this.listeners.contains(jReportPrintListener)) {
            this.listeners.addElement(jReportPrintListener);
        }
    }

    public void removePrintListener(JReportPrintListener jReportPrintListener) {
        if (this.listeners.contains(jReportPrintListener)) {
            this.listeners.removeElement(jReportPrintListener);
        }
    }

    @Override
    public void run() {
        this.addNotify();
        this.printStart();
        this.doPrint();
        this.printEnd();
    }

    public void printEnd() {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ((JReportPrintListener)this.listeners.elementAt(i)).printEnd();
        }
    }

    public void printStart() {
        int n = this.listeners.size();
        for (int i = 0; i < n; ++i) {
            ((JReportPrintListener)this.listeners.elementAt(i)).printStart();
        }
    }
}

