/*
 * Decompiled with CFR 0.152.
 */
package jet.export.rtf.api;

import java.awt.Color;
import jet.export.rtf.api.CharSpaceInfo;
import jet.export.rtf.api.FontEffectInfo;
import jet.export.rtf.api.UnderLineInfo;

public final class FontInfo {
    public static final byte TEXT_AFFECT_BLINKING = 0;
    public static final byte TEXT_AFFECT_LAS_VEGAS = 1;
    public static final byte TEXT_AFFECT_BLACK_ANT = 2;
    public static final byte TEXT_AFFECT_RED_ANT = 3;
    public static final byte TEXT_AFFECT_SHIMMER = 4;
    public static final byte TEXT_AFFECT_SPARKLE = 5;
    private String SEDU;
    private double getCharacterSpace;
    private boolean getEffect;
    private boolean getLineColor;
    private boolean getStyle;
    private UnderLineInfo length;
    private FontEffectInfo reInitial;
    private String trim;
    private CharSpaceInfo I;

    public FontInfo() {
        this.reInitial();
    }

    public void reInitial() {
        this.SEDU = "Times New Roman";
        this.getCharacterSpace = 12.0;
        this.getEffect = false;
        this.getLineColor = false;
        this.length = null;
        this.reInitial = null;
        this.trim = "";
        this.I = null;
    }

    public void setFontName(String string) {
        if (string == null || string.trim().length() == 0) {
            return;
        }
        this.SEDU = string;
    }

    public String getFontName() {
        return this.SEDU;
    }

    public void setFontSize(double d) {
        if (d <= 0.0) {
            this.getCharacterSpace = -1.0;
            return;
        }
        this.getCharacterSpace = d;
    }

    public long getFontSize() {
        return (long)(this.getCharacterSpace * 2.0);
    }

    public void setItaliac(boolean bl) {
        this.getEffect = bl;
    }

    public boolean isItalic() {
        return this.getEffect;
    }

    public void setBold(boolean bl) {
        this.getLineColor = bl;
    }

    public boolean isBold() {
        return this.getLineColor;
    }

    public void setUnderLine(UnderLineInfo underLineInfo) {
        this.length = underLineInfo;
    }

    public String getUnderLineStyle() {
        if (this.length == null) {
            return null;
        }
        return this.length.getStyle();
    }

    public Color getUnderLineColor() {
        if (this.length == null) {
            return null;
        }
        return this.length.getLineColor();
    }

    public void setEffect(FontEffectInfo fontEffectInfo) {
        this.reInitial = fontEffectInfo;
    }

    public String getEffect() {
        if (this.reInitial == null) {
            return "";
        }
        return this.reInitial.getEffect();
    }

    public void setTextEffect(byte by) {
        if (by < 0 || by <= 5) {
            // empty if block
        }
    }

    public String getTextEffect() {
        return this.trim;
    }

    public void setCharacterSpace(CharSpaceInfo charSpaceInfo) {
        this.I = charSpaceInfo;
    }

    public String getCharSpace() {
        if (this.I == null) {
            return "";
        }
        return this.I.getCharacterSpace();
    }

    public void setEmphasis(boolean bl) {
        this.getStyle = bl;
    }

    public boolean isEmphasis() {
        return this.getStyle;
    }
}

