/*
 * Decompiled with CFR 0.152.
 */
package jet.formula;

import java.util.Hashtable;
import jet.connect.DbBigInt;
import jet.connect.DbBinary;
import jet.connect.DbBit;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbDate;
import jet.connect.DbDateTime;
import jet.connect.DbDouble;
import jet.connect.DbNumber;
import jet.connect.DbSecurityContext;
import jet.connect.DbTime;
import jet.connect.DbTimestamp;
import jet.connect.DbValue;
import jet.formula.DataType;
import jet.formula.fArray;
import jet.formula.fBinaryArray;
import jet.formula.fBoolArray;
import jet.formula.fBoolRange;
import jet.formula.fCurArray;
import jet.formula.fCurRange;
import jet.formula.fCurrency;
import jet.formula.fDateArray;
import jet.formula.fDateRange;
import jet.formula.fDateTimeArray;
import jet.formula.fDateTimeRange;
import jet.formula.fEnumeration;
import jet.formula.fImage;
import jet.formula.fImageArray;
import jet.formula.fIntArray;
import jet.formula.fIntRange;
import jet.formula.fNumArray;
import jet.formula.fNumRange;
import jet.formula.fRange;
import jet.formula.fStrArray;
import jet.formula.fStrRange;
import jet.formula.fText;
import jet.formula.fTextArray;
import jet.formula.fTimeArray;
import jet.formula.fTimeRange;
import jet.log.JRLogger;

public class DataTypeDef
extends DataType {
    public static final int array = 11;
    public static final int INTEGERARRAY = 12;
    public static final int NUMBERARRAY = 13;
    public static final int CURRENCYARRAY = 14;
    public static final int BOOLEANARRAY = 15;
    public static final int STRINGARRAY = 16;
    public static final int DATEARRAY = 17;
    public static final int TIMEARRAY = 18;
    public static final int DATETIMEARRAY = 19;
    public static final int BINARYARRAY = 20;
    public static final int TEXTARRAY = 21;
    public static final int IMAGEARRAY = 22;
    public static final int range = 22;
    public static final int INTEGERRANGE = 23;
    public static final int NUMBERRANGE = 24;
    public static final int CURRENCYRANGE = 25;
    public static final int BOOLEANRANGE = 26;
    public static final int STRINGRANGE = 27;
    public static final int DATERANGE = 28;
    public static final int TIMERANGE = 29;
    public static final int DATETIMERANGE = 30;
    public static final int SECURITYCONTEXT = 31;
    public static final int ENUMERATION = 32;
    public static final int TOTALTYPE = 33;
    public static final int NUMVARIANCE = 34;
    public static final int TIMEVARIANCE = 35;
    public static final int ARYVARIANCE = 36;
    public static final int RNGVARIANCE = 37;
    private static final String[] SEDU = new String[]{"'UNKNOWN TYPE'", "'INTEGER'", "'NUMBER'", "'CURRENCY'", "'BOOLEAN'", "'STRING'", "'DATE'", "'TIME'", "'DATETIME'", "'BINARY'", "'LONGSTRING'", "'IMAGE'", "'INTEGERARRAY'", "'NUMBERARRAY'", "'CURRENCYARRAY'", "'BOOLEANARRAY'", "'STRINGARRAY'", "'DATEARRAY'", "'TIMEARRAY'", "'DATETIMEARRAY'", "'BINARYARRAY'", "'LONGSTRINGARRAY'", "'IMAGEARRAY'", "'INTEGERRANGE'", "'NUMBERRANGE'", "'CURRENCYRANGE'", "'BOOLEANRANGE'", "'STRINGRANGE'", "'DATERANGE'", "'TIMERANGE'", "'DATETIMERANGE'", "'SECURITYCONTEXT'", "'ENUMERATION'"};
    public static final String[] typeClass = new String[]{"fDbField", "DbBigInt", "DbDouble", "fCurrency", "DbBit", "DbChar", "DbDate", "DbTime", "DbTimestamp", "DbBinary", "fText", "fImage", "fIntArray", "fNumArray", "fCurArray", "fBoolArray", "fStrArray", "fDateArray", "fTimeArray", "fDateTimeArray", "fBinaryArray", "fTextArray", "fImageArray", "fIntRange", "fNumRange", "fCurRange", "fBoolRange", "fStrRange", "fDateRange", "fTimeRange", "fDateTimeRange", "DbSecurityContext", "fEnumeration"};
    private static Class[] error = new Class[38];
    private static Hashtable get;
    private static JRLogger getLogger;

    public static String toString(int n) {
        return SEDU[n];
    }

    public static String toTypeString(int n) {
        return SEDU[n].substring(1, SEDU[n].length() - 1);
    }

    public static DbValue makeData(int n) {
        try {
            DbColDesc dbColDesc = DataTypeDef.isBasic(n) ? DataTypeDef.toDbColDesc(n, -1, -1) : null;
            switch (n) {
                case 1: {
                    return new DbBigInt(dbColDesc);
                }
                case 2: {
                    return new DbDouble(dbColDesc);
                }
                case 3: {
                    return new fCurrency(dbColDesc);
                }
                case 4: {
                    return new DbBit(dbColDesc);
                }
                case 5: {
                    return new DbChar(dbColDesc);
                }
                case 6: {
                    return new DbDate(dbColDesc);
                }
                case 7: {
                    return new DbTime(dbColDesc);
                }
                case 8: {
                    return new DbTimestamp(dbColDesc);
                }
                case 9: {
                    return new DbBinary(dbColDesc);
                }
                case 10: {
                    return new fText(dbColDesc);
                }
                case 11: {
                    return new fImage(dbColDesc);
                }
            }
            return (DbValue)error[n].newInstance();
        }
        catch (Exception exception) {
            if (getLogger.isErrorEnabled()) {
                getLogger.error("", exception);
            }
            return null;
        }
    }

    public static int ClassToDataType(Class clazz) throws Exception {
        return (Integer)get.get(clazz);
    }

    public static Class DataTypeToClass(int n) {
        return error[n];
    }

    public static final boolean isBasic(int n) {
        return n <= 11;
    }

    public static final boolean isArray(int n) {
        return n > 11 && n <= 22;
    }

    public static final boolean isRange(int n) {
        return n > 22 && n < 31;
    }

    public static final boolean isCurrency(int n) {
        int n2 = -1;
        n2 = DataTypeDef.isArray(n) ? n - 11 : n;
        return n2 == 3;
    }

    public static final boolean isVariance(int n) {
        switch (n) {
            case 0: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                return true;
            }
        }
        return false;
    }

    public static final int SqlToFml(int n, boolean bl) {
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                return bl ? 3 : 1;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                return bl ? 3 : 2;
            }
            case -7: {
                return 4;
            }
            case 1: 
            case 12: {
                return 5;
            }
            case 91: {
                return 6;
            }
            case 92: {
                return 7;
            }
            case 93: {
                return 8;
            }
            case -3: 
            case -2: {
                return 9;
            }
            case -1: 
            case 2005: {
                return 10;
            }
            case -4: 
            case 2004: {
                return 11;
            }
        }
        return 0;
    }

    public static boolean isAssignableFrom(int n, int n2) {
        boolean bl = false;
        block0 : switch (n) {
            case 0: {
                bl = true;
                break;
            }
            case 1: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        bl = true;
                        break block0;
                    }
                }
                bl = false;
                break;
            }
            case 2: {
                switch (n2) {
                    case 1: 
                    case 2: {
                        bl = true;
                        break block0;
                    }
                }
                bl = false;
                break;
            }
            case 3: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: {
                        bl = true;
                        break block0;
                    }
                }
                bl = false;
                break;
            }
            case 34: {
                switch (n2) {
                    case 1: 
                    case 2: 
                    case 3: {
                        bl = true;
                        break block0;
                    }
                }
                bl = false;
                break;
            }
            case 35: {
                switch (n2) {
                    case 6: 
                    case 7: 
                    case 8: {
                        bl = true;
                        break block0;
                    }
                }
                bl = false;
                break;
            }
            case 36: {
                bl = DataTypeDef.isArray(n2);
                break;
            }
            case 37: {
                bl = DataTypeDef.isRange(n2);
                break;
            }
            default: {
                bl = n2 == n;
            }
        }
        return bl;
    }

    static {
        DataTypeDef.error[0] = DbValue.class;
        DataTypeDef.error[1] = DbBigInt.class;
        DataTypeDef.error[2] = DbDouble.class;
        DataTypeDef.error[3] = fCurrency.class;
        DataTypeDef.error[4] = DbBit.class;
        DataTypeDef.error[5] = DbChar.class;
        DataTypeDef.error[6] = DbDate.class;
        DataTypeDef.error[7] = DbTime.class;
        DataTypeDef.error[8] = DbTimestamp.class;
        DataTypeDef.error[9] = DbBinary.class;
        DataTypeDef.error[10] = fText.class;
        DataTypeDef.error[11] = fImage.class;
        DataTypeDef.error[12] = fIntArray.class;
        DataTypeDef.error[13] = fNumArray.class;
        DataTypeDef.error[14] = fCurArray.class;
        DataTypeDef.error[15] = fBoolArray.class;
        DataTypeDef.error[16] = fStrArray.class;
        DataTypeDef.error[17] = fDateArray.class;
        DataTypeDef.error[18] = fTimeArray.class;
        DataTypeDef.error[19] = fDateTimeArray.class;
        DataTypeDef.error[20] = fBinaryArray.class;
        DataTypeDef.error[21] = fTextArray.class;
        DataTypeDef.error[22] = fImageArray.class;
        DataTypeDef.error[23] = fIntRange.class;
        DataTypeDef.error[24] = fNumRange.class;
        DataTypeDef.error[25] = fCurRange.class;
        DataTypeDef.error[26] = fBoolRange.class;
        DataTypeDef.error[27] = fStrRange.class;
        DataTypeDef.error[28] = fDateRange.class;
        DataTypeDef.error[29] = fTimeRange.class;
        DataTypeDef.error[30] = fDateTimeRange.class;
        DataTypeDef.error[31] = DbSecurityContext.class;
        DataTypeDef.error[32] = fEnumeration.class;
        DataTypeDef.error[34] = DbNumber.class;
        DataTypeDef.error[35] = DbDateTime.class;
        DataTypeDef.error[36] = fArray.class;
        DataTypeDef.error[37] = fRange.class;
        get = new Hashtable(50);
        for (int i = 0; i < error.length; ++i) {
            if (i == 33) continue;
            get.put(error[i], new Integer(i));
        }
        getLogger = JRLogger.getLogger(DataTypeDef.class.getName());
    }
}

