/*
 * Decompiled with CFR 0.152.
 */
package jet.thinviewer;

import guitools.Painter;
import guitools.PainterConstants;
import guitools.toolkit.TComponent;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.List;
import jet.datastream.DSParagraph;
import jet.datastream.DSParagraphText;
import jet.export.ExportAuxInfo;
import jet.export.util.CCUtil;
import jet.export.util.ExportingInfo;
import jet.export.util.FontInfo;
import jet.naming.PropertyNames;
import jet.thinviewer.JReportObjectRender;
import jet.thinviewer.JReportViewer;
import jet.thinviewer.UnderLinePainter;
import jet.util.FontSets;
import jet.util.PropertySetable;

public class JReportParagraphText
extends TComponent
implements JReportObjectRender,
PainterConstants {
    private int HorizontalAlignment;
    private List I = new ArrayList();
    private ExportingInfo KEY_FRACTIONALMETRICS;

    @Override
    public void setProperty(PropertySetable propertySetable) {
        DSParagraphText dSParagraphText = (DSParagraphText)propertySetable;
        this.HorizontalAlignment = dSParagraphText.getResolution();
        Color color = CCUtil.getColorPropertyByName(dSParagraphText, "Background");
        if (color != null) {
            this.setBackground(color);
            this.setEraser(true);
        } else {
            this.setEraser(false);
        }
        this.I = this.KEY_FRACTIONALMETRICS(dSParagraphText);
    }

    @Override
    public void paint(Graphics graphics) {
        if (graphics instanceof Graphics2D) {
            if (JReportViewer.Z) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            } else {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
            }
        }
        this.I(graphics);
        for (int i = 0; i < this.I.size(); ++i) {
            ExportText exportText = (ExportText)this.I.get(i);
            this.HorizontalAlignment(graphics, exportText);
        }
    }

    private void HorizontalAlignment(Graphics graphics, ExportText exportText) {
        if (exportText != null && exportText.C != null) {
            graphics.setColor(exportText.C);
            if (exportText.I != null && exportText.Z != null && exportText.Z.length() > 0) {
                int n;
                int n2;
                graphics.setFont(exportText.I);
                FontMetrics fontMetrics = graphics.getFontMetrics();
                int n3 = fontMetrics.getHeight();
                int n4 = fontMetrics.getAscent();
                int n5 = fontMetrics.getLeading();
                int n6 = exportText.x;
                int n7 = exportText.y + n4;
                graphics.drawString(exportText.Z, n6, n7);
                ExportLine exportLine = exportText.B;
                if (exportLine != null) {
                    n2 = n6 + exportLine.I;
                    n = n7;
                    int n8 = Math.min((exportText.I.getSize() + (exportText.I.isBold() ? 2 : 0)) / 10, 2);
                    UnderLinePainter.paint(graphics, n6, n7 + n8, n2, n + n8, exportLine.Z, exportLine.C);
                }
                if ((exportLine = exportText.D) != null) {
                    n7 = exportText.y + n3 / 2 + (n5 > 0 ? 1 : 3);
                    n2 = n6 + exportLine.I;
                    n = n7;
                    Painter.drawLine(graphics, n6, n7, n2, n, exportLine.C, 1, exportLine.Z);
                }
            }
        }
    }

    private void I(Graphics graphics) {
        Dimension dimension = this.getSize();
        Color color = this.getBackground();
        if (color != null && this.hasEraser()) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
    }

    private List KEY_FRACTIONALMETRICS(DSParagraphText dSParagraphText) {
        String string = dSParagraphText.getText();
        if (string != null && string.length() > 0) {
            int n;
            Color color = CCUtil.getColorPropertyByName(dSParagraphText, "Foreground");
            FontInfo fontInfo = this.KEY_FRACTIONALMETRICS.getFontInfo(dSParagraphText);
            String string2 = fontInfo.getFontName();
            int n2 = 0;
            if (CCUtil.getBooleanPropertyByName(dSParagraphText, "Bold")) {
                n2 |= 1;
            }
            if (CCUtil.getBooleanPropertyByName(dSParagraphText, "Italic")) {
                n2 |= 2;
            }
            boolean bl = CCUtil.getIntPropertyByName(dSParagraphText, "SupersubScript") != 0;
            float f = fontInfo.getFontSize();
            if (bl) {
                f = f * 2.0f / 3.0f;
            }
            Font font = FontSets.getFont(string2, n2, f, this.HorizontalAlignment);
            ExportLine exportLine = this.VALUE_FRACTIONALMETRICS_OFF(dSParagraphText);
            ExportLine exportLine2 = this.Z(dSParagraphText);
            int n3 = CCUtil.getIntPropertyByName((DSParagraph)dSParagraphText.getParent(), PropertyNames.getDefinitionName(PropertyNames.HorizontalAlignment));
            if (n3 == 3 && (n = dSParagraphText.getWords().size()) > 0) {
                for (int i = 0; i < n; ++i) {
                    string = (String)dSParagraphText.getWords().elementAt(i);
                    int n4 = Unit.convertUnitToPixel(dSParagraphText.getWordsPosition()[i] + dSParagraphText.getTextX(), this.HorizontalAlignment);
                    int n5 = Unit.convertUnitToPixel(dSParagraphText.getTextY(), this.HorizontalAlignment);
                    ExportText exportText = this.SEDU(string, n4, n5, font, color, exportLine, exportLine2);
                    this.I.add(exportText);
                }
                return this.I;
            }
            int n6 = Unit.convertUnitToPixel(dSParagraphText.getTextX(), this.HorizontalAlignment);
            int n7 = Unit.convertUnitToPixel(dSParagraphText.getTextY(), this.HorizontalAlignment);
            ExportText exportText = this.SEDU(string, n6, n7, font, color, exportLine, exportLine2);
            this.I.add(exportText);
        }
        return this.I;
    }

    private ExportText SEDU(String string, int n, int n2, Font font, Color color, ExportLine exportLine, ExportLine exportLine2) {
        ExportText exportText = null;
        if (string != null && string.length() > 0) {
            exportText = new ExportText(string);
            exportText.C = color;
            exportText.I = font;
            exportText.x = n;
            exportText.y = n2;
            exportText.D = exportLine2;
            exportText.B = exportLine;
        }
        return exportText;
    }

    private ExportLine VALUE_FRACTIONALMETRICS_OFF(DSParagraphText dSParagraphText) {
        ExportLine exportLine = null;
        boolean bl = CCUtil.getBooleanPropertyByName(dSParagraphText, "Underline");
        if (bl) {
            exportLine = new ExportLine();
            exportLine.Z = this.VALUE_FRACTIONALMETRICS_ON(CCUtil.getIntPropertyByName(dSParagraphText, "UnderlineStyle"));
            exportLine.C = CCUtil.getColorPropertyByName(dSParagraphText, "UnderlineColor");
            exportLine.x = Unit.convertUnitToPixel(dSParagraphText.getX(), this.HorizontalAlignment);
            exportLine.y = Unit.convertUnitToPixel(dSParagraphText.getY(), this.HorizontalAlignment);
            exportLine.I = Unit.convertUnitToPixel(dSParagraphText.getWidth(), this.HorizontalAlignment);
        }
        return exportLine;
    }

    private int VALUE_FRACTIONALMETRICS_ON(int n) {
        switch (n) {
            case 11: {
                return 11;
            }
            case 5: {
                return 5;
            }
            case 3: {
                return 3;
            }
            case 9: {
                return 9;
            }
            case 7: {
                return 7;
            }
            case 13: {
                return 13;
            }
            case 15: {
                return 15;
            }
            case 10: {
                return 10;
            }
            case 4: {
                return 4;
            }
            case 2: {
                return 2;
            }
            case 16: {
                return 16;
            }
            case 1: {
                return 1;
            }
            case 8: {
                return 8;
            }
            case 6: {
                return 6;
            }
            case 12: {
                return 12;
            }
            case 14: {
                return 14;
            }
        }
        return 1;
    }

    private ExportLine Z(DSParagraphText dSParagraphText) {
        ExportLine exportLine = null;
        boolean bl = CCUtil.getBooleanPropertyByName(dSParagraphText, "StrikeOut");
        if (bl) {
            exportLine = new ExportLine();
            exportLine.Z = this.add(CCUtil.getIntPropertyByName(dSParagraphText, "StrikeoutStyle"));
            exportLine.C = CCUtil.getColorPropertyByName(dSParagraphText, "StrikeoutlineColor");
            exportLine.x = Unit.convertUnitToPixel(dSParagraphText.getX(), this.HorizontalAlignment);
            exportLine.y = Unit.convertUnitToPixel(dSParagraphText.getY(), this.HorizontalAlignment);
            exportLine.I = Unit.convertUnitToPixel(dSParagraphText.getWidth(), this.HorizontalAlignment);
        }
        return exportLine;
    }

    private int add(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 5;
            }
        }
        return 0;
    }

    @Override
    public void getAuxinfo() {
    }

    @Override
    public void setauxinfo(ExportAuxInfo exportAuxInfo) {
    }

    @Override
    public void setLcView(boolean bl) {
    }

    @Override
    public void setExportInfo(ExportingInfo exportingInfo) {
        this.KEY_FRACTIONALMETRICS = exportingInfo;
    }

    class ExportLine {
        int x;
        int y;
        int I;
        int Z;
        Color C;

        ExportLine() {
        }
    }

    class ExportText {
        int x = 0;
        int y = 0;
        Font I;
        String Z = null;
        Color C;
        ExportLine B;
        ExportLine D;

        ExportText(String string) {
            this.Z = string;
        }
    }
}

