/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.awt.Color;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import jet.log.JRLogger;

public class BitmapReader {
    Color[] SEDU;
    MemoryImageSource close = null;
    DataInput error;
    private static JRLogger exists = JRLogger.getLogger(BitmapReader.class.getName());

    public BitmapReader(DataInput dataInput) {
        this.error = dataInput;
        this.close = this.SEDU();
    }

    public static BitmapReader loadFromBMP(DataInput dataInput) {
        try {
            int n = BitmapReader.getRGB(dataInput);
            if (n != 19778) {
                return null;
            }
            int n2 = BitmapReader.isErrorEnabled(dataInput);
            int n3 = BitmapReader.getRGB(dataInput);
            int n4 = BitmapReader.getRGB(dataInput);
            int n5 = BitmapReader.isErrorEnabled(dataInput);
        }
        catch (IOException iOException) {
            return null;
        }
        BitmapReader bitmapReader = new BitmapReader(dataInput);
        if (bitmapReader.close == null) {
            return null;
        }
        return bitmapReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BitmapReader loadFromBMP(File file) {
        if (!file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        BitmapReader bitmapReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            bitmapReader = BitmapReader.loadFromBMP(new DataInputStream(new BufferedInputStream(fileInputStream)));
        }
        catch (IOException iOException) {
            BitmapReader bitmapReader2 = null;
            return bitmapReader2;
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return bitmapReader;
    }

    public MemoryImageSource getMemImgSrc() {
        return this.close;
    }

    private MemoryImageSource SEDU() {
        MemoryImageSource memoryImageSource;
        block10: {
            memoryImageSource = null;
            try {
                int n = BitmapReader.isErrorEnabled(this.error);
                int n2 = BitmapReader.isErrorEnabled(this.error);
                int n3 = BitmapReader.isErrorEnabled(this.error);
                int n4 = BitmapReader.getRGB(this.error);
                int n5 = BitmapReader.getRGB(this.error);
                int n6 = BitmapReader.isErrorEnabled(this.error);
                int n7 = BitmapReader.isErrorEnabled(this.error);
                int n8 = BitmapReader.isErrorEnabled(this.error);
                int n9 = BitmapReader.isErrorEnabled(this.error);
                int n10 = BitmapReader.isErrorEnabled(this.error);
                int n11 = BitmapReader.isErrorEnabled(this.error);
                if (n6 != 0) {
                    return null;
                }
                if (n == 40) {
                    switch (n5) {
                        case 1: {
                            this.SEDU = this.close(n5, n10, this.error);
                            memoryImageSource = this.getLogger(n2, n3, this.error);
                            break;
                        }
                        case 4: {
                            this.SEDU = this.close(n5, n10, this.error);
                            memoryImageSource = this.getName(n2, n3, this.error);
                            break;
                        }
                        case 8: {
                            this.SEDU = this.close(n5, n10, this.error);
                            memoryImageSource = this.error(n2, n3, this.error);
                            break;
                        }
                        case 24: {
                            memoryImageSource = this.exists(n2, n3, this.error);
                            break;
                        }
                    }
                }
            }
            catch (IOException iOException) {
                if (!exists.isErrorEnabled()) break block10;
                exists.error("", iOException);
            }
        }
        return memoryImageSource;
    }

    private Color[] close(int n, int n2, DataInput dataInput) {
        Color[] colorArray;
        block3: {
            int n3 = 1 << n;
            n3 = n2 == 0 ? 1 << n : n2;
            colorArray = new Color[n3];
            try {
                for (int i = 0; i < n3; ++i) {
                    int n4 = dataInput.readUnsignedByte();
                    int n5 = dataInput.readUnsignedByte();
                    int n6 = dataInput.readUnsignedByte();
                    dataInput.readUnsignedByte();
                    colorArray[i] = new Color(n6, n5, n4);
                }
            }
            catch (IOException iOException) {
                if (!exists.isErrorEnabled()) break block3;
                exists.error("", iOException);
            }
        }
        return colorArray;
    }

    private MemoryImageSource error(int n, int n2, DataInput dataInput) {
        int[] nArray;
        block4: {
            int n3 = n * n2;
            nArray = new int[n3];
            int n4 = n;
            int n5 = n4 % 4 == 0 ? n4 : (n4 + 3) / 4 * 4;
            int n6 = n5 - n4;
            try {
                for (int i = n2 - 1; i >= 0; --i) {
                    for (int j = 0; j < n; ++j) {
                        int n7 = dataInput.readUnsignedByte();
                        nArray[n * i + j] = this.SEDU[n7].getRGB();
                    }
                    dataInput.skipBytes(n6);
                }
            }
            catch (IOException iOException) {
                if (!exists.isErrorEnabled()) break block4;
                exists.error("", iOException);
            }
        }
        return new MemoryImageSource(n, n2, nArray, 0, n);
    }

    private MemoryImageSource exists(int n, int n2, DataInput dataInput) {
        int[] nArray;
        block4: {
            int n3 = n * n2;
            nArray = new int[n3];
            int n4 = n * 3;
            int n5 = n4 % 4 == 0 ? n4 : (n4 + 3) / 4 * 4;
            int n6 = n5 - n4;
            try {
                for (int i = n2 - 1; i >= 0; --i) {
                    for (int j = 0; j < n; ++j) {
                        int n7 = dataInput.readUnsignedByte();
                        int n8 = dataInput.readUnsignedByte();
                        int n9 = dataInput.readUnsignedByte();
                        nArray[n * i + j] = 0xFF000000 | (n9 & 0xFF) << 16 | (n8 & 0xFF) << 8 | (n7 & 0xFF) << 0;
                    }
                    dataInput.skipBytes(n6);
                }
            }
            catch (IOException iOException) {
                if (!exists.isErrorEnabled()) break block4;
                exists.error("", iOException);
            }
        }
        return new MemoryImageSource(n, n2, nArray, 0, n);
    }

    private MemoryImageSource getLogger(int n, int n2, DataInput dataInput) {
        int[] nArray;
        block5: {
            int n3 = n * n2;
            nArray = new int[n3];
            int n4 = 0;
            int n5 = n % 8 == 0 ? n / 8 : n / 8 + 1;
            int n6 = n5 % 4 == 0 ? n5 : (n5 + 3) / 4 * 4;
            try {
                for (int i = n2 - 1; i >= 0; --i) {
                    int n7 = 0;
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n8 = dataInput.readUnsignedByte();
                        for (int j = 7; j >= 0; --j) {
                            if (n7 >= n) continue;
                            int n9 = 1 << j;
                            int n10 = (n8 & n9) >> j;
                            nArray[n * i + n7++] = this.SEDU[n10].getRGB();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                if (!exists.isErrorEnabled()) break block5;
                exists.error("", iOException);
            }
        }
        return new MemoryImageSource(n, n2, nArray, 0, n);
    }

    private MemoryImageSource getName(int n, int n2, DataInput dataInput) {
        int[] nArray;
        block5: {
            int n3 = n * n2;
            nArray = new int[n3];
            int n4 = 0;
            int n5 = n % 2 == 0 ? n / 2 : n / 2 + 1;
            int n6 = n5 % 4 == 0 ? n5 : (n5 + 3) / 4 * 4;
            try {
                for (int i = n2 - 1; i >= 0; --i) {
                    int n7 = 0;
                    for (n4 = 0; n4 < n6; ++n4) {
                        int n8 = dataInput.readUnsignedByte();
                        for (int j = 1; j >= 0; --j) {
                            if (n7 >= n) continue;
                            int n9 = 15 << j * 4;
                            int n10 = (n8 & n9) >> j * 4;
                            nArray[n * i + n7++] = this.SEDU[n10].getRGB();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                if (!exists.isErrorEnabled()) break block5;
                exists.error("", iOException);
            }
        }
        return new MemoryImageSource(n, n2, nArray, 0, n);
    }

    private static final int getRGB(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        int n2 = dataInput.readUnsignedByte();
        return (n2 << 8) + (n << 0);
    }

    private static final int isErrorEnabled(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedByte();
        int n2 = dataInput.readUnsignedByte();
        int n3 = dataInput.readUnsignedByte();
        int n4 = dataInput.readUnsignedByte();
        return (n4 << 24) + (n3 << 16) + (n2 << 8) + (n << 0);
    }
}

