/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import jet.ReportEnv;
import jet.util.Filter;

public class FileUtil {
    public static int BUFFER_SIZE = 262140;
    static final String SEDU = ".." + File.separator;
    static final String append = File.separator;

    public static void copy(File file, File file2) throws IOException {
        int n;
        if (file == null || file2 == null) {
            throw new NullPointerException();
        }
        if (file == file2 || file.equals(file2)) {
            return;
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        byte[] byArray = new byte[BUFFER_SIZE];
        while ((n = fileInputStream.read(byArray)) != -1) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static void copyFile(String string, String string2, String string3) throws IOException {
        if (string.equalsIgnoreCase(string2 + File.separator)) {
            return;
        }
        FileUtil.copy(new File(string, string3), new File(string2, string3));
    }

    public static void copyFile(String string, String string2) throws IOException {
        if (string.equalsIgnoreCase(string2)) {
            return;
        }
        FileUtil.copy(new File(string), new File(string2));
    }

    public static void copyFiles(String string, String string2, Vector vector) throws IOException {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string3 = (String)vector.elementAt(i);
            FileUtil.copyFile(string, string2, string3);
        }
    }

    public static void copyFiles(Vector vector, String string) throws IOException {
        for (int i = 0; i < vector.size(); ++i) {
            File file = new File((String)vector.elementAt(i));
            FileUtil.copyFile(file.getParent(), string, file.getName());
        }
    }

    public static void transferFile(File file, OutputStream outputStream) throws IOException {
        int n;
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[BUFFER_SIZE];
        while ((n = fileInputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
        }
        fileInputStream.close();
        outputStream.close();
    }

    public static String[] getStyleGroups() {
        String string = ReportEnv.stylePath != null ? ReportEnv.stylePath : System.getProperty("reporthome") + File.separator + "style";
        File file = new File(string);
        Filter filter = new Filter(file, "_stl.xsd");
        File[] fileArray = file.listFiles(filter);
        String[] stringArray = new String[fileArray.length + 1];
        stringArray[0] = "None";
        for (int i = 0; i < fileArray.length; ++i) {
            String string2;
            String string3 = fileArray[i].getName();
            stringArray[i + 1] = string2 = string3.substring(0, string3.lastIndexOf("_"));
        }
        return stringArray;
    }

    public static boolean isFileFormat(String string) {
        if (string == null || string.trim().length() == 0) {
            return false;
        }
        boolean bl = new File(string).isFile();
        if (string.indexOf(":") == -1) {
            bl = true;
        } else if (string.indexOf(":") == 1) {
            bl = true;
        } else if (string.indexOf("root") == 0) {
            bl = true;
        } else if (string.indexOf("ROOT") == 0) {
            bl = true;
        }
        return bl;
    }

    public static String getFilePath(String string, String string2) {
        if (!FileUtil.isFileFormat(string2)) {
            return string2;
        }
        if (string2.indexOf(":") != -1) {
            return string2;
        }
        File file = new File(string == null ? "" : string);
        String string3 = "";
        String string4 = "";
        if (string2.indexOf("../") == 0) {
            string3 = string2.substring("../".length(), string2.length());
            string3 = file.getParent() + File.separator + string3;
        } else if (string2.indexOf(SEDU) == 0) {
            string3 = string2.substring(SEDU.length(), string2.length());
            string3 = file.getParent() + File.separator + string3;
        } else if (string2.indexOf(append) == 0) {
            string3 = string2.substring(append.length(), string2.length());
            string3 = FileUtil.BUFFER_SIZE(string) + string3;
        } else {
            string3 = string + File.separator + string2;
        }
        string4 = string3;
        File file2 = new File(string4);
        return file2.getAbsolutePath();
    }

    private static String BUFFER_SIZE(String string) {
        File file = new File(string);
        while (file.exists() && file.getParentFile() != null && file.getParentFile().exists()) {
            file = file.getParentFile();
        }
        if (file.exists()) {
            return file.getAbsolutePath();
        }
        return null;
    }
}

