/*
 * Decompiled with CFR 0.152.
 */
package jet.util.loader;

import com.jinfonet.resstore.ResourceLoadException;
import com.jinfonet.resstore.ResourceNotFoundException;
import com.jinfonet.resstore.SpaceAllocator;
import com.jinfonet.resstore.loader.CacheableLoader;
import com.jinfonet.resstore.loader.CachedObject;
import com.jinfonet.util.JRLog;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jet.util.JRInterruptedException;
import jet.util.loader.AbsCacherKey;
import jet.util.loader.AbsCacherValue;

public abstract class AbsCacheableLoader<K, V, T extends AbsCacherKey<K>>
implements CacheableLoader<K, V> {
    private final ReentrantReadWriteLock SEDU = new ReentrantReadWriteLock(true);
    private final LinkedList<T> add = new LinkedList();
    private final Hashtable<T, AbsCacherValue<K, V, T>> allocate = new Hashtable();
    private final Hashtable<T, AbsCacherValue<K, V, T>> append = new Hashtable();
    private SpaceAllocator clear = null;
    private long containsKey = 0L;
    private long convertToCacherKey = 0L;
    private int createObjectItemInst = 0;
    private int currentThread = 0;
    private boolean currentTimeMillis = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V load(K k, boolean bl) throws ResourceNotFoundException, ResourceLoadException, JRInterruptedException {
        long l = System.currentTimeMillis();
        T t = this.convertToCacherKey(k);
        if (bl || !this.currentTimeMillis || this.convertToCacherKey <= 0L || this.currentThread <= 0) {
            AbsCacherValue<K, V, T> absCacherValue = this.createObjectItemInst(t);
            try {
                V v = absCacherValue.foreceLoadValue();
                return v;
            }
            catch (Throwable throwable) {
                throw new ResourceNotFoundException(throwable);
            }
            finally {
                if (JRLog.isTrace(7)) {
                    long l2 = System.currentTimeMillis();
                    JRLog.trace(7, this.theLoaderName() + ": Load(cacher=notused/disable/0,  key=" + k + ", tid=" + Thread.currentThread().getId() + ") end. Elapsed(MS): " + (l2 - l));
                }
            }
        }
        AbsCacherValue<K, V, T> absCacherValue = this.add(t);
        try {
            absCacherValue.updateContent();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5) && JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException, tid=LDD" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        catch (Throwable throwable) {
            throw new ResourceNotFoundException(throwable);
        }
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, this.theLoaderName() + ": Load(cacher=used,  key=" + k + ", inner=" + t + ", tid=" + Thread.currentThread().getId() + ") WAITING");
        }
        try {
            this.SEDU.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5) && JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.write in cacher, tid=LDX" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            this.append.remove(t);
            if (this.currentTimeMillis && this.currentThread > 0 && this.convertToCacherKey > 0L) {
                if (JRLog.isTrace(7)) {
                    JRLog.trace(7, this.theLoaderName() + ": Load(cacher=enable,  key=" + k + ", inner=" + t + ", tid=" + Thread.currentThread().getId() + ") RUNING");
                }
                this.SEDU(t, absCacherValue);
            } else {
                if (JRLog.isTrace(7)) {
                    JRLog.trace(7, this.theLoaderName() + ": Load(cacher=disable,  key=" + k + ", inner=" + t + ", tid=" + Thread.currentThread().getId() + ") RUNING");
                }
                absCacherValue.setIsCached(false, 0L);
            }
            V v = absCacherValue.getValueObject();
            return v;
        }
        finally {
            this.SEDU.writeLock().unlock();
            long l3 = System.currentTimeMillis();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, this.theLoaderName() + ": Load(cacher=used,  key=" + k + ", inner=" + t + ", tid=" + Thread.currentThread().getId() + ") is ENDING. Elapsed(MS): " + (l3 - l));
            }
        }
    }

    protected abstract T convertToCacherKey(K var1);

    protected abstract AbsCacherValue<K, V, T> createObjectItemInst(T var1);

    private void SEDU(T t, AbsCacherValue<K, V, T> absCacherValue) {
        Object object;
        Vector<Object> vector;
        boolean bl;
        long l;
        long l2;
        long l3;
        long l4;
        boolean bl2;
        block30: {
            long l5;
            bl2 = absCacherValue.isCahed();
            boolean bl3 = absCacherValue.sureCanPutInfoCacher();
            l4 = 0L;
            if (bl3) {
                l4 = bl2 ? absCacherValue.getLengthInCacher() : 0L;
            } else {
                if (bl2) {
                    this.add.remove(t);
                    this.allocate.remove(t);
                    ++this.createObjectItemInst;
                    this.containsKey += l4;
                    this.clear.deallocate(l4);
                }
                absCacherValue.setIsCached(false, 0L);
                absCacherValue.resetItemLocked(false);
                return;
            }
            l3 = absCacherValue.getValueLength();
            l2 = l3 - l4;
            LinkedList<T> linkedList = null;
            if (bl2) {
                if (l2 == 0L) {
                    absCacherValue.setIsCached(true, l3);
                    this.add.remove(t);
                    this.add.add(t);
                    return;
                }
                if (l2 < 0L) {
                    absCacherValue.setIsCached(true, l3);
                    this.add.remove(t);
                    this.add.add(t);
                    this.containsKey -= l2;
                    this.clear.deallocate(-1L * l2);
                    return;
                }
                linkedList = new LinkedList<T>(this.add);
                linkedList.remove(t);
            } else {
                linkedList = this.add;
            }
            l = 0L;
            bl = false;
            vector = new Vector<Object>();
            int n = 0;
            int n2 = linkedList.size();
            if (bl2 || this.createObjectItemInst >= 1) {
                block0: while (true) {
                    AbsCacherValue<K, V, T> absCacherValue2;
                    if ((l5 = l2 - l) <= 0L || this.containsKey >= l5 && this.clear.allocate(l5)) {
                        bl = true;
                        break block30;
                    }
                    if (n >= n2) {
                        bl = false;
                        break block30;
                    }
                    do {
                        if (n >= n2) continue block0;
                        object = (AbsCacherKey)linkedList.get(n);
                        absCacherValue2 = this.allocate.get(object);
                        ++n;
                    } while (absCacherValue2.isItemLocked());
                    l += absCacherValue2.getLengthInCacher();
                    vector.add(object);
                }
            }
            while (n2 >= 1) {
                while (n < n2) {
                    AbsCacherKey absCacherKey = (AbsCacherKey)linkedList.get(n);
                    Object object2 = this.allocate.get(absCacherKey);
                    ++n;
                    if (((AbsCacherValue)object2).isItemLocked()) continue;
                    l += ((AbsCacherValue)object2).getLengthInCacher();
                    vector.add(absCacherKey);
                    break;
                }
                if ((l5 = l2 - l) <= 0L || this.containsKey >= l5 && this.clear.allocate(l5)) {
                    bl = true;
                    break;
                }
                if (n < n2) continue;
                bl = false;
                break;
            }
        }
        if (JRLog.isTrace(7)) {
            if (bl) {
                if (vector.isEmpty()) {
                    JRLog.trace(7, this.theLoaderName() + ": Load(TaskID=" + Thread.currentThread().getId() + ":" + absCacherValue.hashCode() + ") : can put/update into cacher directly");
                } else {
                    JRLog.trace(7, this.theLoaderName() + ": Load(TaskID=" + Thread.currentThread().getId() + ":" + absCacherValue.hashCode() + ") : will put/update into cacher after release " + vector.size() + " existed(s)");
                }
            } else if (bl2) {
                JRLog.trace(7, this.theLoaderName() + ": Load(TaskID=" + Thread.currentThread().getId() + ":" + absCacherValue.hashCode() + ") : no enough space to update, it will be removed from cacher");
            } else {
                JRLog.trace(7, this.theLoaderName() + ": Load(TaskID=" + Thread.currentThread().getId() + ":" + absCacherValue.hashCode() + ") : no enough space to put into cacher");
            }
        }
        if (bl) {
            for (Object object2 : vector) {
                this.add.remove(object2);
                object = this.allocate.remove(object2);
                ((AbsCacherValue)object).setIsCached(false, 0L);
                ((AbsCacherValue)object).resetItemLocked(false);
            }
            if (bl2) {
                absCacherValue.setIsCached(true, l3);
                this.add.remove(t);
                this.add.add(t);
                this.createObjectItemInst += vector.size();
            } else {
                absCacherValue.setIsCached(true, l3);
                this.add.add(t);
                this.allocate.put(t, absCacherValue);
                this.createObjectItemInst += vector.size() - 1;
            }
            this.containsKey += l - l2;
            if (l > l2) {
                this.clear.deallocate(l - l2);
            }
        } else if (bl2) {
            this.add.remove(t);
            this.allocate.remove(t);
            absCacherValue.resetItemLocked(false);
            absCacherValue.setIsCached(false, 0L);
            ++this.createObjectItemInst;
            this.containsKey += l4;
            this.clear.deallocate(l4);
        } else {
            absCacherValue.setIsCached(false, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AbsCacherValue<K, V, T> add(T t) throws JRInterruptedException {
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "REQ on lock.read in cacher,  tid=" + Thread.currentThread().getId());
            }
            this.SEDU.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.read in cacher, tid=PFL" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            Object object;
            AbsCacherValue<K, V, T> absCacherValue = this.allocate.get(t);
            if (absCacherValue == null && (absCacherValue = this.append.get(t)) == null) {
                object = this.append;
                synchronized (object) {
                    absCacherValue = this.append.get(t);
                    if (absCacherValue == null) {
                        absCacherValue = this.createObjectItemInst(t);
                        this.append.put(t, absCacherValue);
                    }
                }
            }
            object = absCacherValue;
            return object;
        }
        finally {
            this.SEDU.readLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "RELEASE on lock.read in cacher, tid=" + Thread.currentThread().getId());
            }
        }
    }

    @Override
    public void setSpaceAllocator(SpaceAllocator spaceAllocator) {
        this.clear = spaceAllocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCacheEnabled() throws JRInterruptedException {
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "REQ on lock.read in cacher, tid=GCE" + Thread.currentThread().getId());
            }
            this.SEDU.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.read in cacher, tid=GCE" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "DOING on lock.read in cacher, tid=GCE" + Thread.currentThread().getId());
            }
            boolean bl = this.currentTimeMillis;
            return bl;
        }
        finally {
            this.SEDU.readLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "RELEASE on lock.read in cacher, tid=GCE" + Thread.currentThread().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCacheEnabled(boolean bl) throws JRInterruptedException {
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, this.theLoaderName() + ": Submit Ability Task with {Enable= " + bl + "}===>SCE(TaskID=" + Thread.currentThread().getId() + ", enabled=" + bl + ") is WAITING");
            }
            this.SEDU.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.write in cacher, for tid=SCE" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, this.theLoaderName() + ": SCE(TaskID=" + Thread.currentThread().getId() + ", enabled=" + bl + ") is RUNNING");
            }
            if (this.currentTimeMillis && !bl) {
                this.currentTimeMillis = false;
                for (AbsCacherKey absCacherKey : this.add) {
                    AbsCacherValue<K, V, T> absCacherValue = this.allocate.remove(absCacherKey);
                    absCacherValue.resetItemLocked(false);
                    absCacherValue.setIsCached(false, 0L);
                }
                this.add.clear();
                long l = this.convertToCacherKey - this.containsKey;
                this.createObjectItemInst = this.currentThread;
                this.containsKey = this.convertToCacherKey;
                this.clear.deallocate(l);
            } else {
                this.currentTimeMillis = bl;
            }
        }
        finally {
            this.SEDU.writeLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, this.theLoaderName() + ": SCE(TaskID=" + Thread.currentThread().getId() + ", enabled=" + bl + ") is ENDING");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxSize(int n) throws JRInterruptedException {
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, this.theLoaderName() + ": Submit SetSize Task with {newSize=" + n + "}===>Size(TaskID=" + Thread.currentThread().getId() + ",size=" + n + ") is WAITING");
            }
            this.SEDU.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.write in cacher, for tid=SMS" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            int n2;
            int n3;
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, this.theLoaderName() + ": Size(TaskID=" + Thread.currentThread().getId() + ", size=" + n + ") is RUNNING");
            }
            if ((n3 = (n2 = this.add.size()) - n) <= 0) {
                this.createObjectItemInst = n - n2;
                this.currentThread = n;
            } else {
                if (JRLog.isTrace(7)) {
                    JRLog.trace(7, this.theLoaderName() + ": Size(TaskID=" + Thread.currentThread().getId() + ", size=" + n + "):New size is not enough, need release " + n3);
                }
                long l = 0L;
                for (int i = 0; i < 2; ++i) {
                    int n4 = 0;
                    while (n3 > 0 && n4 < n2) {
                        AbsCacherKey absCacherKey = (AbsCacherKey)this.add.get(n4);
                        AbsCacherValue<K, V, T> absCacherValue = this.allocate.get(absCacherKey);
                        if (i == 1 || !absCacherValue.isItemLocked()) {
                            l += absCacherValue.getLengthInCacher();
                            this.add.remove(n4);
                            this.allocate.remove(absCacherKey);
                            absCacherValue.setIsCached(false, 0L);
                            absCacherValue.resetItemLocked(false);
                            --n2;
                            --n3;
                            continue;
                        }
                        ++n4;
                    }
                }
                this.createObjectItemInst = 0;
                this.currentThread = n;
                this.containsKey += l;
                this.clear.deallocate(l);
            }
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "Cacher status after Size(TaskID=" + Thread.currentThread().getId() + ", size=" + n + "): current free size:" + this.createObjectItemInst + ", current free space:" + this.containsKey);
            }
        }
        finally {
            this.SEDU.writeLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, this.theLoaderName() + ": Size(TaskID=" + Thread.currentThread().getId() + ", size=" + n + ") is ENDING");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMaxSpace(long l) throws JRInterruptedException {
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, this.theLoaderName() + ": Submit SetSpace Task with {newSpace=" + l + "}===>Space(TaskID=" + Thread.currentThread().getId() + ",space=" + l + ") is WAITING");
            }
            this.SEDU.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.write in cacher, for tid=SMP:" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            long l2;
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, this.theLoaderName() + ": Space(TaskID=" + Thread.currentThread().getId() + ",space=" + l + ") is RUNNING");
            }
            if (l >= (l2 = this.convertToCacherKey - this.containsKey)) {
                this.containsKey = l - l2;
                this.convertToCacherKey = l;
            } else {
                int n = 0;
                long l3 = 0L;
                long l4 = l2 - l;
                if (JRLog.isTrace(7)) {
                    JRLog.trace(7, this.theLoaderName() + ": Space(TaskID=" + Thread.currentThread().getId() + ",space=" + l + "):New space is not enough,need release " + l4 + " at least");
                }
                int n2 = this.add.size();
                for (int i = 0; i < 2; ++i) {
                    int n3 = 0;
                    while (l3 < l4 && n3 < n2) {
                        AbsCacherKey absCacherKey = (AbsCacherKey)this.add.get(n3);
                        AbsCacherValue<K, V, T> absCacherValue = this.allocate.get(absCacherKey);
                        if (i == 1 || !absCacherValue.isItemLocked()) {
                            l3 += absCacherValue.getLengthInCacher();
                            this.add.remove(n3);
                            this.allocate.remove(absCacherKey);
                            absCacherValue.resetItemLocked(false);
                            absCacherValue.setIsCached(false, 0L);
                            --n2;
                            ++n;
                            continue;
                        }
                        ++n3;
                    }
                }
                this.createObjectItemInst += n;
                this.containsKey = l - (l2 - l3);
                this.convertToCacherKey = l;
                this.clear.deallocate(l3);
            }
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "Cacher status after Space(TaskID=" + Thread.currentThread().getId() + ",space=" + l + "):, current free size:" + this.createObjectItemInst + ", current free space:" + this.containsKey);
            }
        }
        finally {
            this.SEDU.writeLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, this.theLoaderName() + ": Space(TaskID=" + Thread.currentThread().getId() + ",space=" + l + ") is ENDING");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getMaxSize() throws JRInterruptedException {
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "REQ on lock.read in cacher, tid=GMZ" + Thread.currentThread().getId());
            }
            this.SEDU.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.read in cacher, tid=GMZ" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "DOING on lock.read in cacher, tid=GMZ" + Thread.currentThread().getId());
            }
            int n = this.currentThread;
            return n;
        }
        finally {
            this.SEDU.readLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "RELEASE on lock.read in cacher, tid=GMZ" + Thread.currentThread().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getMaxSpace() throws JRInterruptedException {
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "REQ on lock.read in cacher, tid=GMP" + Thread.currentThread().getId());
            }
            this.SEDU.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.read in cacher, tid=GMP" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "DOING on lock.read in cacher, tid=GMP" + Thread.currentThread().getId());
            }
            long l = this.convertToCacherKey;
            return l;
        }
        finally {
            this.SEDU.readLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "RELEASE on lock.read in cacher, tid=GMP" + Thread.currentThread().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getSize() throws JRInterruptedException {
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "REQ on lock.read in cacher, tid=GUZ" + Thread.currentThread().getId());
            }
            this.SEDU.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.read in cacher, tid=GUZ" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "DOING on lock.read in cacher, tid=GUZ" + Thread.currentThread().getId());
            }
            int n = this.currentThread - this.createObjectItemInst;
            return n;
        }
        finally {
            this.SEDU.readLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "RELEASE on lock.read in cacher, tid=GUZ" + Thread.currentThread().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getUsedSpace() throws JRInterruptedException {
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "REQ on lock.read in cacher, tid=GUP" + Thread.currentThread().getId());
            }
            this.SEDU.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.read in cacher, tid=GUP" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "DOING on lock.read in cacher, tid=GUP" + Thread.currentThread().getId());
            }
            long l = this.convertToCacherKey - this.containsKey;
            return l;
        }
        finally {
            this.SEDU.readLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "REQ on lock.read in cacher, tid=GUP" + Thread.currentThread().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFreeSpace() throws JRInterruptedException {
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "REQ on lock.read in cacher, tid=GFP" + Thread.currentThread().getId());
            }
            this.SEDU.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.read in cacher, tid=GFP" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "DOING on lock.read in cacher, tid=GFP" + Thread.currentThread().getId());
            }
            long l = this.containsKey;
            return l;
        }
        finally {
            this.SEDU.readLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "REQ on lock.read in cacher, tid=GFP" + Thread.currentThread().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(K k) throws JRInterruptedException {
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "REQ on lock.read in cacher, tid=CK" + Thread.currentThread().getId());
            }
            this.SEDU.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.read in cacher, tid=CK" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "DOING on lock.read in cacher, tid=CK" + Thread.currentThread().getId());
            }
            T t = this.convertToCacherKey(k);
            boolean bl = this.allocate.containsKey(t);
            return bl;
        }
        finally {
            this.SEDU.readLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "RELEASE on lock.read in cacher, tid=CK" + Thread.currentThread().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<K> getKeys() throws JRInterruptedException {
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "REQ on lock.read in cacher, tid=GKS" + Thread.currentThread().getId());
            }
            this.SEDU.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.read in cacher, tid=GKS" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "DOING on lock.read in cacher, tid=GKS" + Thread.currentThread().getId());
            }
            int n = this.add.size();
            Vector vector = new Vector(n);
            for (AbsCacherKey absCacherKey : this.add) {
                vector.add(absCacherKey.getOuterUsedID());
            }
            Vector vector2 = vector;
            return vector2;
        }
        finally {
            this.SEDU.readLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "RELEASE on lock.read in cacher, tid=GKS" + Thread.currentThread().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CachedObject<K, V>> getCachedObjects() throws JRInterruptedException {
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "REQ on lock.read in cacher, tid=GVS" + Thread.currentThread().getId());
            }
            this.SEDU.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.read in cacher, tid=GVS" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "DOING on lock.read in cacher, tid=GVS" + Thread.currentThread().getId());
            }
            Vector<CachedObject<K, V>> vector = new Vector<CachedObject<K, V>>(this.allocate.values());
            return vector;
        }
        finally {
            this.SEDU.readLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "RELEASE on lock.read in cacher, tid=GVS" + Thread.currentThread().getId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedObject<K, V> get(K k) throws JRInterruptedException {
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, this.theLoaderName() + ": Submit Get Item Task with {key=" + k + "}==>Get(TaskID=" + Thread.currentThread().getId() + ") is WAITING");
        }
        T t = this.convertToCacherKey(k);
        try {
            this.SEDU.readLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.read in cacher, tid=GET" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "Get(TaskID=" + Thread.currentThread().getId() + ":" + k + ") is RUNING");
            }
            CachedObject cachedObject = this.allocate.get(t);
            return cachedObject;
        }
        finally {
            this.SEDU.readLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "Get(TaskID=" + Thread.currentThread().getId() + ":" + k + ") is ENDING");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(K k) throws JRInterruptedException {
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, this.theLoaderName() + ": Submit Lock Item Task with {key=" + k + "}===>Lock(TaskID=" + Thread.currentThread().getId() + ":" + k + ") is WAITING");
        }
        T t = this.convertToCacherKey(k);
        try {
            this.SEDU.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.write in cacher, tid=DLK:" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            AbsCacherValue<K, V, T> absCacherValue;
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "Lock(TaskID=" + Thread.currentThread().getId() + ":" + k + ") is RUNING");
            }
            if ((absCacherValue = this.allocate.get(t)) != null) {
                absCacherValue.resetItemLocked(true);
            }
        }
        finally {
            this.SEDU.writeLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "Lock(TaskID=" + Thread.currentThread().getId() + ":" + k + ") is ENDING");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(K k) throws JRInterruptedException {
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, this.theLoaderName() + ": Submit Unlock Item Task with {key=" + k + "}===>Unlock(TaskID=" + Thread.currentThread().getId() + ":" + k + ") is WAITING");
        }
        T t = this.convertToCacherKey(k);
        try {
            this.SEDU.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.write in cacher, tid=ULK:" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            AbsCacherValue<K, V, T> absCacherValue;
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "UnLock(TaskID=" + Thread.currentThread().getId() + ":" + k + ") is RUNING");
            }
            if ((absCacherValue = this.allocate.get(t)) != null) {
                absCacherValue.resetItemLocked(false);
            }
        }
        finally {
            this.SEDU.writeLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "UnLock(TaskID=" + Thread.currentThread().getId() + ":" + k + ") is ENDING");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K k) throws JRInterruptedException {
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, this.theLoaderName() + ": Submit Remove Task with {key=" + k + "}===>Remove(TaskID=" + Thread.currentThread().getId() + ":" + k + ") is WAITING");
        }
        T t = this.convertToCacherKey(k);
        try {
            this.SEDU.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.write in cacher, tid=RMS:" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            AbsCacherValue<K, V, T> absCacherValue;
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "Remove(TaskID=" + Thread.currentThread().getId() + ":" + k + ") is RUNING");
            }
            if ((absCacherValue = this.allocate.get(t)) != null) {
                long l = absCacherValue.getLengthInCacher();
                this.add.remove(t);
                this.allocate.remove(t);
                absCacherValue.resetItemLocked(false);
                absCacherValue.setIsCached(false, 0L);
                ++this.createObjectItemInst;
                this.containsKey += l;
                this.clear.deallocate(l);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.SEDU.writeLock().unlock();
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "Remove(TaskID=" + Thread.currentThread().getId() + ":" + k + ") is ENDING");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(List<K> list) throws JRInterruptedException {
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, this.theLoaderName() + ": Submit RemoveList Task with {keys=" + list + "}===>RemoveList(TaskID=" + Thread.currentThread().getId() + ") is WAITING");
        }
        try {
            this.SEDU.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.write in cacher, tid=RML:" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "RemoveList(TaskID=" + Thread.currentThread().getId() + ") is RUNING");
            }
            long l = 0L;
            int n = 0;
            for (K k : list) {
                T t;
                AbsCacherValue<K, V, T> absCacherValue;
                if (k == null || (absCacherValue = this.allocate.get(t = this.convertToCacherKey(k))) == null) continue;
                long l2 = absCacherValue.getLengthInCacher();
                this.add.remove(t);
                this.allocate.remove(t);
                absCacherValue.resetItemLocked(false);
                absCacherValue.setIsCached(false, 0L);
                ++n;
                l += l2;
            }
            this.createObjectItemInst += n;
            this.containsKey += l;
            this.clear.deallocate(l);
        }
        finally {
            this.SEDU.writeLock().unlock();
            JRLog.trace(7, this.theLoaderName() + ": RemoveList(TaskID=" + Thread.currentThread().getId() + " is ENDING");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        if (JRLog.isTrace(7)) {
            JRLog.trace(7, this.theLoaderName() + ": Submit Destroy Task ===>Destroy(TaskID=" + Thread.currentThread().getId() + ") is WAITING");
        }
        try {
            this.SEDU.writeLock().lockInterruptibly();
        }
        catch (InterruptedException interruptedException) {
            if (JRLog.isTrace(5)) {
                JRLog.trace(5, "InterruptedException on lock.write in cacher, tid=DTY" + Thread.currentThread().getId());
            }
            throw new JRInterruptedException();
        }
        try {
            if (JRLog.isTrace(7)) {
                JRLog.trace(7, "Destroy(TaskID=" + Thread.currentThread().getId() + ") is RUNING");
            }
            for (AbsCacherKey absCacherKey : this.add) {
                AbsCacherValue<K, V, T> absCacherValue = this.allocate.remove(absCacherKey);
                absCacherValue.resetItemLocked(false);
                absCacherValue.setIsCached(false, 0L);
            }
            this.add.clear();
            this.clear.deallocate(this.convertToCacherKey - this.containsKey);
            this.createObjectItemInst = this.currentThread;
            this.containsKey = this.convertToCacherKey;
        }
        finally {
            this.SEDU.writeLock().unlock();
            JRLog.trace(7, this.theLoaderName() + ": Destroy(TaskID=" + Thread.currentThread().getId() + " is ENDING");
        }
    }

    protected String theLoaderName() {
        return "CacheableLoader(" + this + ")";
    }
}

