/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.ChartLabelBase;
import chart.ChartShowValueCondition;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Graph2DGuageBall;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartTextStyle;
import chart.util.ChartHintLabel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.List;

public class Graph2DGuageBalls
extends Chart2DObject {
    Graph2DGuageBall[][] append;
    ChartLabelBase[] contains;
    ChartLabelBase[] draw;
    String[][][] drawCategoryNames;
    float[] equals;
    float[] floatValue;
    float[][] get;
    private Shape[] getAxisXProperties;
    private Shape[][] getAxisY;
    int getAxisZProperties;
    int getBounds;
    float[][] getCategorySize;
    float[][] getChartDataSetModel;
    boolean[][] getChartLink;
    ChartGradientPattern[][] getChartLinkInfo;
    Color[] getColor;
    int getCondition;
    int getContourPen;
    Line2D[] getFilteredCategoryNames;
    Line2D[] getFilteredSeriesNames;
    float[][] getFormatedHintValue;
    float[][] getGaugeAlertValueMax;
    float getGaugeAlertValueMin;
    float getGaugeErrorValueMax;

    Graph2DGuageBalls(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    @Override
    public void init() {
        super.init();
        boolean bl = this.dataset.getChartDataSetModel().isOneGroup();
        this.getAxisZProperties = bl ? 3 : this.dataset.getSeriesSize();
        this.getBounds = this.dataset.getCategorySize();
        if (this.getAxisZProperties == 0 || this.getBounds == 0) {
            return;
        }
        this.getGaugeAlertValueMin = this.paper.getProperties().getScaleX() == 1.0f ? 1.0f : this.paper.getProperties().getScaleX();
        this.getGaugeErrorValueMax = this.paper.getProperties().getScaleY() == 1.0f ? 1.0f : this.paper.getProperties().getScaleY();
        this.SEDU();
        this.append();
        this.contains();
        this.dataset();
        this.drilldown();
        this.append = new Graph2DGuageBall[this.getAxisZProperties][this.getBounds];
        this.getAxisXProperties = new Shape[this.getAxisZProperties];
        this.getAxisY = new Shape[this.getAxisZProperties][this.getBounds];
        this.getCategorySize = new float[this.getAxisZProperties][this.getBounds];
        this.getChartDataSetModel = new float[this.getAxisZProperties][this.getBounds];
        for (int i = 0; i < this.getAxisZProperties; ++i) {
            for (int j = 0; j < this.getBounds; ++j) {
                this.append[i][j] = new Graph2DGuageBall();
                this.append[i][j].setContour(this.objectProperties.isContour());
                this.append[i][j].setContourPen(this.objectProperties.getContourPen());
            }
        }
    }

    private void SEDU() {
        this.getColor = new Color[3];
        if (this.objectProperties.getGuagePatterns()[0] instanceof ChartColorPattern) {
            this.getColor[0] = ((ChartColorPattern)this.objectProperties.getGuagePatterns()[0]).getColor();
        } else if (this.objectProperties.getGuagePatterns()[0] instanceof ChartGradientPattern) {
            this.getColor[0] = ((ChartGradientPattern)this.objectProperties.getGuagePatterns()[0]).getStartColor().getColor();
        }
        if (this.objectProperties.getGuagePatterns()[1] instanceof ChartColorPattern) {
            this.getColor[1] = ((ChartColorPattern)this.objectProperties.getGuagePatterns()[1]).getColor();
        } else if (this.objectProperties.getGuagePatterns()[1] instanceof ChartGradientPattern) {
            this.getColor[1] = ((ChartGradientPattern)this.objectProperties.getGuagePatterns()[1]).getStartColor().getColor();
        }
        if (this.objectProperties.getGuagePatterns()[2] instanceof ChartColorPattern) {
            this.getColor[2] = ((ChartColorPattern)this.objectProperties.getGuagePatterns()[2]).getColor();
        } else if (this.objectProperties.getGuagePatterns()[2] instanceof ChartGradientPattern) {
            this.getColor[2] = ((ChartGradientPattern)this.objectProperties.getGuagePatterns()[2]).getStartColor().getColor();
        }
    }

    private void append() {
        int n;
        int n2;
        String[] stringArray = this.dataset.getChartDataSetModel().getFilteredCategoryNames();
        String[] stringArray2 = this.dataset.getChartDataSetModel().getFilteredSeriesNames();
        if (stringArray != null) {
            n2 = stringArray.length;
            this.contains = new ChartLabelBase[n2];
            for (n = 0; n < n2; ++n) {
                this.contains[n] = new ChartLabelBase(stringArray[n]);
                this.contains[n].setChartTextStyle(this.paper.getProperties().getAxisXProperties().getLabelTextStyle());
            }
        }
        if (stringArray2 != null) {
            n2 = stringArray2.length;
            this.draw = new ChartLabelBase[n2];
            for (n = 0; n < n2; ++n) {
                this.draw[n] = new ChartLabelBase(stringArray2[n]);
                this.draw[n].setChartTextStyle(this.paper.getProperties().getAxisZProperties().getLabelTextStyle());
            }
        }
    }

    private void contains() {
        float f = (float)((ChartNumericAxis)this.layer.getAxisY()).getMax();
        float f2 = (float)((ChartNumericAxis)this.layer.getAxisY()).getMin();
        this.equals = new float[3];
        this.floatValue = new float[3];
        this.equals[0] = (float)this.objectProperties.getGaugeNormalValueMin();
        this.equals[1] = (float)this.objectProperties.getGaugeAlertValueMin();
        this.equals[2] = (float)this.objectProperties.getGaugeErrorValueMin();
        this.floatValue[0] = (float)this.objectProperties.getGaugeNormalValueMax();
        this.floatValue[1] = (float)this.objectProperties.getGaugeAlertValueMax();
        this.floatValue[2] = (float)this.objectProperties.getGaugeErrorValueMax();
        boolean bl = true;
        for (int i = 0; i < 3; ++i) {
            if (this.equals[i] > this.floatValue[i]) {
                float f3 = this.equals[i];
                this.equals[i] = this.floatValue[i];
                this.floatValue[i] = f3;
            }
            bl = this.floatValue[i] == this.floatValue[i] && this.floatValue[i] == 0.0f && bl;
        }
        if (bl) {
            float f4 = (f - f2) / 3.0f;
            for (int i = 0; i < 3; ++i) {
                this.equals[i] = f2 + (float)i * f4;
                this.floatValue[i] = this.equals[i] + f4;
            }
        }
    }

    private void dataset() {
        boolean bl = this.dataset.getChartDataSetModel().isOneGroup();
        this.getChartLink = ((Chart1DDataSet)this.dataset).isNullValue();
        if (bl) {
            this.get = new float[1][this.getBounds];
            this.drawCategoryNames = new String[1][this.getBounds][3];
            for (int i = 0; i < this.getBounds; ++i) {
                if (this.getChartLink[0][i]) continue;
                Number number = ((Chart1DDataSet)this.dataset).getValue(0, i);
                this.get[0][i] = number.floatValue();
                if (this.layer.isShowCategoryAndSeries()) {
                    ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                    this.drawCategoryNames[0][i] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(0, i);
                    continue;
                }
                this.drawCategoryNames[0][i][0] = this.dataset.getFormatedHintValue(number);
            }
        } else {
            this.get = new float[this.getAxisZProperties][this.getBounds];
            this.drawCategoryNames = new String[this.getAxisZProperties][this.getBounds][3];
            for (int i = 0; i < this.getAxisZProperties; ++i) {
                for (int j = 0; j < this.getBounds; ++j) {
                    if (this.getChartLink[i][j]) continue;
                    Number number = ((Chart1DDataSet)this.dataset).getValue(i, j);
                    this.get[i][j] = number.floatValue();
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        this.drawCategoryNames[i][j] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(i, j);
                        continue;
                    }
                    this.drawCategoryNames[i][j][0] = this.dataset.getFormatedHintValue(number);
                }
            }
        }
    }

    @Override
    public void locate() {
        this.drawCategoryNames();
        this.draw();
        for (int i = 0; i < this.getAxisZProperties; ++i) {
            for (int j = 0; j < this.getBounds; ++j) {
                this.append[i][j].setArc((Arc2D)this.getAxisY[i][j]);
                this.append[i][j].setPattern(this.getChartLinkInfo[i][j]);
            }
        }
        this.getAxisY();
        this.getAxisZProperties();
        this.get();
        this.getAxisXProperties();
    }

    private void draw() {
        int n;
        if (this.draw != null) {
            for (n = 0; n < this.draw.length; ++n) {
                this.draw[n].locate();
            }
        }
        if (this.contains != null) {
            for (n = 0; n < this.contains.length; ++n) {
                this.contains[n].locate();
            }
        }
    }

    private void drawCategoryNames() {
        float f = this.objectProperties.getHorizonalMargin();
        float f2 = this.objectProperties.getVerticalMargin();
        this.getCondition = (int)(((float)this.paper.getBounds().width * this.getGaugeAlertValueMin - f) / (float)this.getBounds);
        this.getContourPen = (int)(((float)this.paper.getBounds().height * this.getGaugeErrorValueMax - f2) / (float)this.getAxisZProperties);
        float f3 = (float)Math.min(this.getCondition / 2, this.getContourPen / 2) * this.paper.getProperties().getGraphProperties().getRadiusRange();
        float f4 = (float)this.paper.getBounds().width * (1.0f - this.getGaugeAlertValueMin) / 2.0f;
        float f5 = (float)this.paper.getBounds().height * (1.0f - this.getGaugeErrorValueMax) / 2.0f;
        boolean bl = this.dataset.getChartDataSetModel().isOneGroup();
        for (int i = 0; i < this.getAxisZProperties; ++i) {
            this.getAxisXProperties[i] = new GeneralPath();
            for (int j = 0; j < this.getBounds; ++j) {
                if (bl ? this.getChartLink[0][j] : this.getChartLink[i][j]) continue;
                this.getCategorySize[i][j] = f4 + (float)(j * this.getCondition) + (float)(this.getCondition / 2) - f3 + f;
                this.getChartDataSetModel[i][j] = f5 + (float)(i * this.getContourPen) + (float)(this.getContourPen / 2) - f3 + f2;
                this.getAxisY[i][j] = new Arc2D.Float(this.getCategorySize[i][j], this.getChartDataSetModel[i][j], 2.0f * f3, 2.0f * f3, 0.0f, 360.0f, 0);
                ((GeneralPath)this.getAxisXProperties[i]).append(this.getAxisY[i][j], false);
            }
        }
    }

    private void drilldown() {
        boolean bl = this.dataset.getChartDataSetModel().isOneGroup();
        this.getChartLinkInfo = new ChartGradientPattern[this.getAxisZProperties][this.getBounds];
        if (bl) {
            this.equals();
        } else {
            this.floatValue();
        }
    }

    private void equals() {
        for (int i = 0; i < this.getBounds; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (this.get[0][i] > this.equals[j] && this.get[0][i] <= this.floatValue[j]) {
                    ChartColorPattern chartColorPattern = new ChartColorPattern(new Color(255, 255, 255));
                    ChartColorPattern chartColorPattern2 = new ChartColorPattern(this.getColor[j]);
                    this.getChartLinkInfo[j][i] = new ChartGradientPattern(3);
                    this.getChartLinkInfo[j][i].setStartColor(chartColorPattern);
                    this.getChartLinkInfo[j][i].setEndColor(chartColorPattern2);
                    continue;
                }
                this.getChartLinkInfo[j][i] = new ChartGradientPattern(3);
                this.getChartLinkInfo[j][i].setStartColor(new ChartColorPattern(new Color(255, 255, 255)));
                this.getChartLinkInfo[j][i].setEndColor(new ChartColorPattern(new Color(0, 0, 0)));
            }
        }
    }

    private void floatValue() {
        for (int i = 0; i < this.getAxisZProperties; ++i) {
            for (int j = 0; j < this.getBounds; ++j) {
                boolean bl = false;
                for (int k = 0; k < 3; ++k) {
                    if (!(this.get[i][j] > this.equals[k]) || !(this.get[i][j] <= this.floatValue[k])) continue;
                    ChartColorPattern chartColorPattern = new ChartColorPattern(new Color(255, 255, 255));
                    ChartColorPattern chartColorPattern2 = new ChartColorPattern(this.getColor[k]);
                    this.getChartLinkInfo[i][j] = new ChartGradientPattern(3);
                    this.getChartLinkInfo[i][j].setStartColor(chartColorPattern);
                    this.getChartLinkInfo[i][j].setEndColor(chartColorPattern2);
                    bl = true;
                    break;
                }
                if (bl) continue;
                this.getChartLinkInfo[i][j] = new ChartGradientPattern(3);
                this.getChartLinkInfo[i][j].setStartColor(new ChartColorPattern(new Color(255, 255, 255)));
                this.getChartLinkInfo[i][j].setEndColor(new ChartColorPattern(new Color(0, 0, 0)));
            }
        }
    }

    private void get() {
        if (this.contains == null || this.contains.length == 0) {
            return;
        }
        float f = this.paper.getProperties().getGraphProperties().getHorizonalMargin();
        float f2 = this.paper.getProperties().getGraphProperties().getVerticalMargin();
        float f3 = (float)this.paper.getBounds().width * (1.0f - this.getGaugeAlertValueMin) / 2.0f;
        float f4 = (float)this.paper.getBounds().height * (1.0f - this.getGaugeErrorValueMax) / 2.0f;
        ChartTextStyle chartTextStyle = this.paper.getProperties().getAxisXProperties().getLabelTextStyle();
        this.getFormatedHintValue = new float[this.contains.length][2];
        for (int i = 0; i < this.contains.length; ++i) {
            if (this.contains[i] == null || this.contains[i].getLabelText().equals("")) continue;
            this.contains[i].locate();
            Dimension dimension = this.contains[i].getLabelBaseDimension();
            float f5 = (float)((double)(f3 + f + (float)(i * this.getCondition)) + ((double)this.getCondition - dimension.getWidth()) / 2.0);
            float f6 = f4 + (float)((double)f2 - dimension.getHeight()) / 2.0f;
            this.getFormatedHintValue[i][0] = f5;
            this.getFormatedHintValue[i][1] = f6;
        }
    }

    private void getAxisXProperties() {
        if (this.draw == null || this.draw.length == 0) {
            return;
        }
        float f = this.paper.getProperties().getGraphProperties().getHorizonalMargin();
        float f2 = this.paper.getProperties().getGraphProperties().getVerticalMargin();
        float f3 = (float)this.paper.getBounds().width * (1.0f - this.getGaugeAlertValueMin) / 2.0f;
        float f4 = (float)this.paper.getBounds().height * (1.0f - this.getGaugeErrorValueMax) / 2.0f;
        ChartTextStyle chartTextStyle = this.paper.getProperties().getAxisZProperties().getLabelTextStyle();
        this.getGaugeAlertValueMax = new float[this.draw.length][2];
        for (int i = 0; i < this.draw.length; ++i) {
            if (this.draw[i] == null || this.draw[i].getLabelText().equals("")) continue;
            this.draw[i].locate();
            Dimension dimension = this.draw[i].getLabelBaseDimension();
            float f5 = (float)((double)f3 + ((double)f - dimension.getWidth()) / 2.0);
            float f6 = (float)((double)(f4 + f2 + (float)(i * this.getContourPen)) + ((double)this.getContourPen - dimension.getHeight()) / 2.0);
            this.getGaugeAlertValueMax[i][0] = f5;
            this.getGaugeAlertValueMax[i][1] = f6;
        }
    }

    private void getAxisY() {
        float f = 0.0f;
        float f2 = 0.0f;
        if (this.dataset.getChartDataSetModel().isOneGroup()) {
            f = (float)this.paper.getBounds().width * (1.0f - this.getGaugeAlertValueMin) / 2.0f + (float)this.objectProperties.getHorizonalMargin();
            f2 = f + (float)(this.getBounds * this.getCondition);
        } else {
            f = (float)this.paper.getBounds().width * (1.0f - this.getGaugeAlertValueMin) / 2.0f;
            f2 = f + (float)this.objectProperties.getHorizonalMargin() + (float)(this.getBounds * this.getCondition);
        }
        float f3 = (float)this.paper.getBounds().height * (1.0f - this.getGaugeErrorValueMax) / 2.0f;
        float f4 = f3 + (float)this.objectProperties.getVerticalMargin() + (float)(this.getAxisZProperties * this.getContourPen);
        this.getFilteredSeriesNames = new Line2D[this.getAxisZProperties + 2];
        this.getFilteredSeriesNames[0] = new Line2D.Float(f, f3, f2, f3);
        for (int i = 0; i < this.getAxisZProperties + 1; ++i) {
            float f5 = f3 + (float)(i * this.getContourPen) + (float)this.objectProperties.getVerticalMargin();
            this.getFilteredSeriesNames[i + 1] = new Line2D.Float(f, f5, f2, f5);
        }
    }

    private void getAxisZProperties() {
        float f = (float)this.paper.getBounds().width * (1.0f - this.paper.getProperties().getScaleX()) / 2.0f;
        float f2 = f + (float)this.objectProperties.getHorizonalMargin() + (float)(this.getBounds * this.getCondition);
        float f3 = (float)this.paper.getBounds().height * (1.0f - this.getGaugeErrorValueMax) / 2.0f;
        float f4 = f3 + (float)this.objectProperties.getVerticalMargin() + (float)(this.getAxisZProperties * this.getContourPen);
        if (this.dataset.getChartDataSetModel().isOneGroup()) {
            this.getFilteredCategoryNames = new Line2D[this.getBounds + 1];
            for (int i = 0; i < this.getBounds + 1; ++i) {
                float f5 = f + (float)(i * this.getCondition) + (float)this.objectProperties.getHorizonalMargin();
                this.getFilteredCategoryNames[i] = new Line2D.Float(f5, f3, f5, f4);
            }
        } else {
            this.getFilteredCategoryNames = new Line2D[this.getBounds + 2];
            this.getFilteredCategoryNames[0] = new Line2D.Float(f, f3, f, f4);
            for (int i = 0; i < this.getBounds + 1; ++i) {
                float f6 = f + (float)(i * this.getCondition) + (float)this.objectProperties.getHorizonalMargin();
                this.getFilteredCategoryNames[i + 1] = new Line2D.Float(f6, f3, f6, f4);
            }
        }
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        for (int i = 0; i < this.getAxisZProperties; ++i) {
            for (int j = 0; j < this.getBounds; ++j) {
                this.append[i][j].paint(graphics2D);
            }
        }
        if (this.paper.getProperties().getAxisXProperties().isShowTickMarkLabels()) {
            this.drawCategoryNames(graphics2D);
        }
        if (this.paper.getProperties().getAxisZProperties().isShowTickMarkLabels()) {
            this.getBounds(graphics2D);
        }
        if (this.paper.getProperties().getAxisZProperties().isShowGrid()) {
            this.getCategorySize(graphics2D);
        }
        if (this.paper.getProperties().getAxisXProperties().isShowGrid()) {
            this.getChartDataSetModel(graphics2D);
        }
    }

    public void drawCategoryNames(Graphics2D graphics2D) {
        if (this.contains == null || this.contains.length == 0) {
            return;
        }
        for (int i = 0; i < this.contains.length; ++i) {
            if (this.contains[i] == null || this.contains[i].getLabelText().equals("")) continue;
            this.contains[i].locate();
            this.contains[i].paint(graphics2D, this.getFormatedHintValue[i][0], this.getFormatedHintValue[i][1]);
        }
    }

    private void getBounds(Graphics2D graphics2D) {
        if (this.draw == null || this.draw.length == 0) {
            return;
        }
        for (int i = 0; i < this.draw.length; ++i) {
            if (this.draw[i] == null || this.draw[i].getLabelText().equals("")) continue;
            this.draw[i].locate();
            this.draw[i].paint(graphics2D, this.getGaugeAlertValueMax[i][0], this.getGaugeAlertValueMax[i][1]);
        }
    }

    private void getCategorySize(Graphics2D graphics2D) {
        int n = this.getFilteredSeriesNames.length;
        for (int i = 0; i < n; ++i) {
            this.paper.getProperties().getAxisZProperties().getGridPen().draw(graphics2D, this.getFilteredSeriesNames[i]);
        }
    }

    private void getChartDataSetModel(Graphics2D graphics2D) {
        int n = this.getFilteredCategoryNames.length;
        for (int i = 0; i < n; ++i) {
            this.paper.getProperties().getAxisXProperties().getGridPen().draw(graphics2D, this.getFilteredCategoryNames[i]);
        }
    }

    @Override
    float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    Shape[][] getItemShapes() {
        return this.getAxisY;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return this.getAxisXProperties[n];
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return this.getAxisY[n][n2];
    }

    @Override
    public String[] search(int n, int n2) {
        boolean bl = this.dataset.getChartDataSetModel().isOneGroup();
        this.drilldown = null;
        if (bl) {
            for (int i = 0; i < this.getAxisZProperties; ++i) {
                for (int j = 0; j < this.getBounds; ++j) {
                    if (this.getAxisY[i][j] == null || !this.getAxisY[i][j].contains(n, n2)) continue;
                    this.drilldown = new int[2];
                    this.drilldown[0] = i;
                    this.drilldown[1] = j;
                    return this.drawCategoryNames[0][j];
                }
            }
        } else {
            for (int i = 0; i < this.getAxisZProperties; ++i) {
                for (int j = 0; j < this.getBounds; ++j) {
                    if (this.getAxisY[i][j] == null || !this.getAxisY[i][j].contains(n, n2)) continue;
                    this.drilldown = new int[2];
                    return this.drawCategoryNames[i][j];
                }
            }
        }
        return null;
    }

    @Override
    public int searchSeries(int n, int n2) {
        for (int i = 0; i < this.getAxisZProperties; ++i) {
            if (!this.getAxisXProperties[i].contains(n, n2)) continue;
            return i;
        }
        return -1;
    }

    public boolean searchHorizonalGrid(int n, int n2) {
        if (this.getFilteredSeriesNames == null || !this.paper.properties.getAxisZProperties().isShowGrid()) {
            return false;
        }
        int n3 = this.getFilteredSeriesNames.length;
        for (int i = 0; i < n3; ++i) {
            if (!this.getFilteredSeriesNames[i].intersects(n - 2, n2 - 2, 5.0, 5.0)) continue;
            return true;
        }
        return false;
    }

    public boolean searchVerticalGrid(int n, int n2) {
        if (this.getFilteredCategoryNames == null || !this.paper.properties.getAxisXProperties().isShowGrid()) {
            return false;
        }
        int n3 = this.getFilteredCategoryNames.length;
        for (int i = 0; i < n3; ++i) {
            if (!this.getFilteredCategoryNames[i].intersects(n - 2, n2 - 2, 5.0, 5.0)) continue;
            return true;
        }
        return false;
    }

    public Shape[] getHorizonalGrid() {
        return this.getFilteredSeriesNames;
    }

    public Shape[] getVerticalGrid() {
        return this.getFilteredCategoryNames;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        int n3 = this.dataset.getShowValueBeginIndex();
        int n4 = this.dataset.getShowValueEndIndex();
        int n5 = n4 - n3;
        int n6 = this.getAxisZProperties / n5;
        for (int i = 0; i < this.getAxisZProperties; ++i) {
            for (int j = 0; j < this.getBounds; ++j) {
                if (this.getAxisY[i][j] == null || !this.getAxisY[i][j].contains(n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                int n7 = 0;
                n7 = i + 1 > n6 ? i - i / n6 * n6 : i;
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n7)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

