/*
 * Decompiled with CFR 0.152.
 */
package chart.chart3d;

import chart.GridLine;
import chart.axis.ChartCategoryAxis;
import chart.axis.ChartNumericAxis;
import chart.chart3d.Chart3DPaper;
import chart.chart3d.Chart3DWalls;
import chart.chart3d.ChartBlock;
import chart.chart3d.ChartCompass;
import chart.chart3d.ChartMatrix;
import chart.graphics.ChartPenStyle;
import chart.util.ChartRenderTools;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.util.List;

public class Chart3DAxes {
    protected static int floor = 3;
    protected ChartCategoryAxis axisX;
    protected ChartNumericAxis axisY;
    protected ChartCategoryAxis axisZ;
    protected Chart3DPaper paper;
    protected ChartBlock xTickPos = new ChartBlock();
    protected ChartBlock xLabelPos = new ChartBlock();
    protected ChartBlock yTickPos = new ChartBlock();
    protected ChartBlock zTickPos = new ChartBlock();
    protected ChartBlock zLabelPos = new ChartBlock();
    protected ChartBlock floorFace = new ChartBlock();
    protected ChartBlock originYFace = new ChartBlock();
    protected ChartCompass compass;
    protected int[] type;
    protected float originY;
    protected float[] unit;
    protected float xLen;
    protected float yLen;
    protected float zLen;
    protected int shownFace = 0;
    private boolean SEDU = false;
    private ChartPenStyle addVertex;
    private GeneralPath append = new GeneralPath();
    private GridLine[] availableOriginY;
    private float[][] clear = new float[2][2];
    private GeneralPath[] clone;
    private GeneralPath[] convertUnitToPixel;
    private GeneralPath[] custommerConstant;
    private GeneralPath draw;
    private GeneralPath formatMinorTickMark;
    private GeneralPath get;
    private float getAngleX;
    private int getAngleY;
    private int getAxisXProperties;
    private int getAxisYProperties;
    protected ChartBlock yLabelPos = new ChartBlock();

    public Chart3DAxes(Chart3DPaper chart3DPaper) {
        this.paper = chart3DPaper;
    }

    public void init() {
        this.draw = new GeneralPath();
        this.formatMinorTickMark = new GeneralPath();
        this.get = new GeneralPath();
        this.type = this.paper.getIntType();
        this.axisX = (ChartCategoryAxis)this.paper.Z;
        this.axisY = (ChartNumericAxis)this.paper.C;
        this.axisZ = (ChartCategoryAxis)this.paper.B;
        this.addVertex = new ChartPenStyle();
        this.addVertex.setPenColor(this.paper.getProperties().getFloorProperties().getBorder().getPenColor());
        if (this.type[1] != 768) {
            this.paper.getProperties().setShowAxisZ(false);
        }
        this.getAngleX = ChartRenderTools.convertUnitToPixel(this.paper.getChartPlatform().getProperties().getMinTickMarkerSpace(), this.paper.getChartPlatform().resolution);
        this.axisX.setMinTickmarkDis((int)this.getAngleX);
        this.axisY.setMinTickmarkDis((int)this.getAngleX);
        this.axisZ.setMinTickmarkDis((int)this.getAngleX);
        this.getAngleY = this.axisX.getLabelN();
        this.getAxisXProperties = this.axisY.getLabelN();
        this.getAxisYProperties = this.axisZ.getLabelN();
    }

    private void SEDU() {
        float[] fArray = this.clear[0];
        this.clear[0] = this.clear[1];
        this.clear[1] = fArray;
    }

    public void paintGridLines(Graphics2D graphics2D) {
        int n;
        int n2;
        this.shownFace = this.paper.getShownFace();
        int n3 = this.append(this.shownFace);
        int n4 = this.xTickPos.vCount / 4;
        this.availableOriginY = new GridLine[n4];
        if (this.paper.getProperties().getAxisXProperties().isShowGrid()) {
            this.clone = new GeneralPath[this.availableOriginY.length];
            this.draw.reset();
            for (n2 = 0; n2 < n4; ++n2) {
                this.clone[n2] = new GeneralPath();
                this.addVertex(graphics2D, n3, n2, 0, false, false, this.paper.getProperties().getAxisXProperties().getGridPen(), this.clone[n2]);
                this.draw.append(this.clone[n2], false);
            }
        }
        n2 = 0;
        n3 = this.availableOriginY(this.shownFace);
        n4 = this.yTickPos.vCount / 4;
        this.availableOriginY = new GridLine[n4];
        if ((this.shownFace >> 5 & 1) == 1) {
            n2 = 1;
        }
        if (this.paper.getProperties().getAxisYProperties().isShowGrid() && n3 >= 0) {
            this.convertUnitToPixel = new GeneralPath[this.availableOriginY.length];
            this.formatMinorTickMark.reset();
            this.clear[0] = this.yTickPos.tVertex[n3];
            this.clear[1] = this.yTickPos.tVertex[n3 + (n4 - 1) * 4];
            if (this.axisY(this.clear[0], this.clear[1])) {
                this.SEDU();
            }
            for (n = 0; n < n4; ++n) {
                this.convertUnitToPixel[n] = new GeneralPath();
                int n5 = n3;
                if (n5 == 1) {
                    n5 = 3;
                } else if (n5 == 2) {
                    n5 = 0;
                }
                this.addVertex(graphics2D, n5, n, 1, true, n2 != 0, this.paper.getProperties().getAxisYProperties().getGridPen(), this.convertUnitToPixel[n]);
                this.formatMinorTickMark.append(this.convertUnitToPixel[n], false);
            }
        }
        n3 = this.axisX(this.shownFace);
        n4 = this.zTickPos.vCount / 4;
        this.availableOriginY = new GridLine[n4];
        if (this.paper.getProperties().getAxisZProperties().isShowGrid()) {
            this.get.reset();
            this.custommerConstant = new GeneralPath[this.availableOriginY.length];
            for (n = 0; n < n4; ++n) {
                this.custommerConstant[n] = new GeneralPath();
                this.addVertex(graphics2D, n3, n, 2, false, false, this.paper.getProperties().getAxisZProperties().getGridPen(), this.custommerConstant[n]);
                this.get.append(this.custommerConstant[n], false);
            }
        }
        if (this.SEDU) {
            if ((this.shownFace >> 4 & 1) == 1) {
                this.clear[0] = this.originYFace.tVertex[2];
                this.clear[1] = this.originYFace.tVertex[3];
            } else {
                this.clear[0] = this.originYFace.tVertex[0];
                this.clear[1] = this.originYFace.tVertex[1];
            }
            this.append.reset();
            this.append.moveTo(this.clear[0][0], this.clear[0][1]);
            this.append.lineTo(this.clear[1][0], this.clear[1][1]);
            this.addVertex.draw(graphics2D, this.append);
            if ((this.shownFace >> 0 & 1) == 1) {
                this.clear[0] = this.originYFace.tVertex[1];
                this.clear[1] = this.originYFace.tVertex[2];
            } else {
                this.clear[0] = this.originYFace.tVertex[3];
                this.clear[1] = this.originYFace.tVertex[0];
            }
            this.append.reset();
            this.append.moveTo(this.clear[0][0], this.clear[0][1]);
            this.append.lineTo(this.clear[1][0], this.clear[1][1]);
            this.addVertex.draw(graphics2D, this.append);
        }
    }

    public void paint(Graphics2D graphics2D) {
        Object object;
        float[][] fArray;
        float[][] fArray2;
        int n;
        ChartBlock chartBlock = this.paper.getWalls().getWalls();
        this.shownFace = this.paper.getShownFace();
        int n2 = this.append(this.shownFace);
        String[] stringArray = this.axisX.getLabels();
        if (this.paper.getProperties().isShowAxisX() && n2 >= 0) {
            int n3;
            this.clear[0] = this.floorFace.tVertex[n2 * 2 + 1];
            this.clear[1] = this.floorFace.tVertex[n2 * 2];
            if (this.type[0] == 1) {
                this.SEDU();
            }
            n = this.xTickPos.vCount / 4;
            fArray2 = new float[n][2];
            for (n3 = 0; n3 < n; ++n3) {
                fArray2[n3] = this.xTickPos.tVertex[n3 * 4 + n2];
            }
            n = this.xLabelPos.vCount / 4;
            fArray = new float[n][2];
            for (n3 = 0; n3 < n; ++n3) {
                fArray[n3] = this.xLabelPos.tVertex[n3 * 4 + n2];
            }
            object = new float[2][2];
            object = (float[][])this.clear.clone();
            this.axisX.setAxisPoint((float[][])object);
            this.axisX.setMajorTickMarkPoint(fArray2);
            this.axisX.setMinorTickMarkPoint(ChartRenderTools.formatMinorTickMark(fArray2, (float[][])object, this.unit[0]));
            this.axisX.setLabelPoint(fArray);
            this.axisX.paint(graphics2D);
        }
        n2 = this.availableOriginY(this.shownFace);
        if (this.paper.getProperties().isShowAxisY() && n2 >= 0) {
            int n4;
            n = this.yTickPos.vCount / 4;
            fArray2 = new float[n][2];
            object = this.paper.getWalls();
            Point2D.Float[][] floatArray = ((Chart3DWalls)object).I;
            boolean bl = ((Chart3DWalls)object).I(chartBlock.tVertex[n2][0], chartBlock.tVertex[n2][1], floatArray[0], floatArray[2]);
            boolean bl2 = ((Chart3DWalls)object).I(chartBlock.tVertex[n2 + 4][0], chartBlock.tVertex[n2 + 4][1], floatArray[0], floatArray[2]);
            this.clear[0] = chartBlock.tVertex[n2];
            this.clear[1] = chartBlock.tVertex[n2 + 4];
            for (n4 = 0; n4 < n; ++n4) {
                fArray2[n4] = this.yTickPos.tVertex[n4 * 4 + n2];
            }
            if (!bl || !bl2) {
                if (n2 == 0) {
                    this.clear[0] = chartBlock.tVertex[n2 + 3];
                    this.clear[1] = chartBlock.tVertex[n2 + 7];
                    for (n4 = 0; n4 < n; ++n4) {
                        fArray2[n4] = this.yTickPos.tVertex[n4 * 4 + n2 + 3];
                    }
                } else if (n2 == 3) {
                    this.clear[0] = chartBlock.tVertex[n2 - 3];
                    this.clear[1] = chartBlock.tVertex[n2 + 1];
                    for (n4 = 0; n4 < n; ++n4) {
                        fArray2[n4] = this.yTickPos.tVertex[n4 * 4 + n2 - 3];
                    }
                }
            }
            n = this.yLabelPos.vCount / 4;
            fArray = new float[n][2];
            for (n4 = 0; n4 < n; ++n4) {
                fArray[n4] = this.yLabelPos.tVertex[n4 * 4 + n2];
            }
            if (!bl || !bl2) {
                if (n2 == 0) {
                    this.clear[0] = chartBlock.tVertex[n2 + 3];
                    this.clear[1] = chartBlock.tVertex[n2 + 7];
                    for (n4 = 0; n4 < n; ++n4) {
                        fArray[n4] = this.yLabelPos.tVertex[n4 * 4 + n2 + 3];
                    }
                } else if (n2 == 3) {
                    this.clear[0] = chartBlock.tVertex[n2 - 3];
                    this.clear[1] = chartBlock.tVertex[n2 + 1];
                    for (n4 = 0; n4 < n; ++n4) {
                        fArray[n4] = this.yLabelPos.tVertex[n4 * 4 + n2 - 3];
                    }
                }
            }
            if (this.axisY(this.clear[0], this.clear[1])) {
                this.SEDU();
            }
            float[][] fArray3 = new float[2][2];
            fArray3 = (float[][])this.clear.clone();
            this.axisY.setAxisPoint(fArray3);
            this.axisY.setMajorTickMarkPoint(fArray2);
            this.axisY.setMinorTickMarkPoint(ChartRenderTools.formatMinorTickMark(fArray2, fArray3, this.unit[1]));
            this.axisY.setLabelPoint(fArray);
            this.axisY.paint(graphics2D);
        }
        n2 = this.axisX(this.shownFace);
        if (this.paper.getProperties().isShowAxisZ() && n2 >= 0) {
            int n5;
            this.clear[0] = this.floorFace.tVertex[n2 * 2];
            this.clear[1] = this.floorFace.tVertex[(n2 * 2 + 3) % 4];
            if (this.type[0] == 1) {
                this.SEDU();
            }
            n = this.zTickPos.vCount / 4;
            fArray2 = new float[n][2];
            for (n5 = 0; n5 < n; ++n5) {
                fArray2[n5] = this.zTickPos.tVertex[n5 * 4 + n2];
            }
            n = this.zLabelPos.vCount / 4;
            fArray = new float[n][2];
            for (n5 = 0; n5 < n; ++n5) {
                fArray[n5] = this.zLabelPos.tVertex[n5 * 4 + n2];
            }
            float[][] fArray4 = new float[2][2];
            fArray4 = (float[][])this.clear.clone();
            this.axisZ.setAxisPoint(fArray4);
            this.axisZ.setMajorTickMarkPoint(fArray2);
            this.axisZ.setMinorTickMarkPoint(ChartRenderTools.formatMinorTickMark(fArray2, fArray4, this.unit[2]));
            this.axisZ.setLabelPoint(fArray);
            this.axisZ.paint(graphics2D);
        }
        if (this.SEDU) {
            if ((this.shownFace >> 4 & 1) == 1) {
                this.clear[0] = this.originYFace.tVertex[0];
                this.clear[1] = this.originYFace.tVertex[1];
            } else {
                this.clear[0] = this.originYFace.tVertex[2];
                this.clear[1] = this.originYFace.tVertex[3];
            }
            this.append.reset();
            this.append.moveTo(this.clear[0][0], this.clear[0][1]);
            this.append.lineTo(this.clear[1][0], this.clear[1][1]);
            this.addVertex.draw(graphics2D, this.append);
            if ((this.shownFace >> 0 & 1) == 1) {
                this.clear[0] = this.originYFace.tVertex[3];
                this.clear[1] = this.originYFace.tVertex[0];
            } else {
                this.clear[0] = this.originYFace.tVertex[1];
                this.clear[1] = this.originYFace.tVertex[2];
            }
            this.append.reset();
            this.append.moveTo(this.clear[0][0], this.clear[0][1]);
            this.append.lineTo(this.clear[1][0], this.clear[1][1]);
            this.addVertex.draw(graphics2D, this.append);
        }
    }

    private void addVertex(Graphics2D graphics2D, int n, int n2, int n3, boolean bl, boolean bl2, ChartPenStyle chartPenStyle, GeneralPath generalPath) {
        float[][] fArray = new float[2][2];
        boolean bl3 = true;
        if (bl && bl2) {
            n = (n + 2) % 4;
        } else if (n < 0) {
            n += 2;
            bl3 = false;
        }
        float[][] fArray2 = null;
        switch (n3) {
            case 0: {
                fArray2 = this.xTickPos.tVertex;
                break;
            }
            case 1: {
                fArray2 = this.yTickPos.tVertex;
                break;
            }
            case 2: {
                fArray2 = this.zTickPos.tVertex;
                break;
            }
            default: {
                fArray2 = this.xTickPos.tVertex;
            }
        }
        this.availableOriginY[n2] = new GridLine();
        int n4 = this.yTickPos.vCount / 4;
        Chart3DWalls chart3DWalls = this.paper.getWalls();
        Point2D.Float[][] floatArray = this.paper.getWalls().I;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        if (bl3) {
            fArray[0] = fArray2[n2 * 4 + n];
            if (n == 0) {
                if (!bl) {
                    fArray[1] = fArray2[n2 * 4 + n + 1];
                } else {
                    bl4 = chart3DWalls.I(fArray2[0][0], fArray2[0][1], floatArray[0], floatArray[2]);
                    bl5 = chart3DWalls.I(fArray2[3][0], fArray2[3][1], floatArray[0], floatArray[2]);
                    bl6 = chart3DWalls.I(fArray2[(n4 - 1) * 4 + n][0], fArray2[(n4 - 1) * 4 + n][1], floatArray[0], floatArray[2]);
                    bl7 = chart3DWalls.I(fArray2[(n4 - 1) * 4 + n + 3][0], fArray2[(n4 - 1) * 4 + n + 3][1], floatArray[0], floatArray[2]);
                    fArray[1] = fArray2[n2 * 4 + n + 3];
                    if (!(bl4 && bl5 && bl6 && bl7)) {
                        fArray[0] = fArray2[n2 * 4 + n + 1];
                        fArray[1] = fArray2[n2 * 4 + n + 2];
                    }
                }
            } else {
                fArray[1] = fArray2[n2 * 4 + n - 1];
            }
            this.availableOriginY[n2].setPenStyle(chartPenStyle);
            this.availableOriginY[n2].setLocation(fArray);
            this.availableOriginY[n2].draw(graphics2D);
            generalPath.moveTo(fArray[0][0], fArray[0][1]);
            generalPath.lineTo(fArray[1][0], fArray[1][1]);
        }
        if (!bl) {
            if (n == 0) {
                fArray[0] = fArray2[n2 * 4 + n + 1];
                fArray[1] = fArray2[n2 * 4 + n + 2];
            } else {
                fArray[0] = fArray2[n2 * 4 + n - 1];
                fArray[1] = fArray2[n2 * 4 + n + 2];
            }
        } else if (n == 0) {
            bl4 = chart3DWalls.I(fArray2[2][0], fArray2[2][1], floatArray[0], floatArray[2]);
            bl5 = chart3DWalls.I(fArray2[3][0], fArray2[3][1], floatArray[0], floatArray[2]);
            bl6 = chart3DWalls.I(fArray2[(n4 - 1) * 4 + n + 2][0], fArray2[(n4 - 1) * 4 + n + 2][1], floatArray[0], floatArray[2]);
            bl7 = chart3DWalls.I(fArray2[(n4 - 1) * 4 + n + 3][0], fArray2[(n4 - 1) * 4 + n + 3][1], floatArray[0], floatArray[2]);
            fArray[0] = fArray2[n2 * 4 + n + 2];
            fArray[1] = fArray2[n2 * 4 + n + 3];
            if (!(bl4 && bl5 && bl6 && bl7)) {
                fArray[0] = fArray2[n2 * 4 + n + 1];
                fArray[1] = fArray2[n2 * 4 + n];
            }
        } else if (n == 1) {
            bl4 = chart3DWalls.I(fArray2[0][0], fArray2[0][1], floatArray[0], floatArray[2]);
            bl5 = chart3DWalls.I(fArray2[3][0], fArray2[3][1], floatArray[0], floatArray[2]);
            bl6 = chart3DWalls.I(fArray2[(n4 - 1) * 4 + n - 1][0], fArray2[(n4 - 1) * 4 + n - 1][1], floatArray[0], floatArray[2]);
            bl7 = chart3DWalls.I(fArray2[(n4 - 1) * 4 + n + 2][0], fArray2[(n4 - 1) * 4 + n + 2][1], floatArray[0], floatArray[2]);
            fArray[0] = fArray2[n2 * 4 + n - 1];
            fArray[1] = fArray2[n2 * 4 + n + 2];
            if (!(bl4 && bl5 && bl6 && bl7)) {
                fArray[0] = fArray2[n2 * 4 + n];
                fArray[1] = fArray2[n2 * 4 + n + 1];
            }
        } else if (n == 2) {
            fArray[0] = fArray2[n2 * 4 + n - 2];
            fArray[1] = fArray2[n2 * 4 + n - 1];
        } else {
            bl4 = chart3DWalls.I(fArray2[2][0], fArray2[2][1], floatArray[0], floatArray[2]);
            bl5 = chart3DWalls.I(fArray2[1][0], fArray2[1][1], floatArray[0], floatArray[2]);
            bl6 = chart3DWalls.I(fArray2[(n4 - 1) * 4 + n - 1][0], fArray2[(n4 - 1) * 4 + n - 1][1], floatArray[0], floatArray[2]);
            bl7 = chart3DWalls.I(fArray2[(n4 - 1) * 4 + n - 2][0], fArray2[(n4 - 1) * 4 + n - 2][1], floatArray[0], floatArray[2]);
            fArray[0] = fArray2[n2 * 4 + n - 1];
            fArray[1] = fArray2[n2 * 4 + n - 2];
            if (!(bl4 && bl5 && bl6 && bl7)) {
                fArray[0] = fArray2[n2 * 4 + n];
                fArray[1] = fArray2[n2 * 4 + n - 3];
            }
        }
        this.availableOriginY[n2].setPenStyle(chartPenStyle);
        this.availableOriginY[n2].setLocation(fArray);
        this.availableOriginY[n2].draw(graphics2D);
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(fArray[0][0], fArray[0][1]);
        generalPath2.lineTo(fArray[1][0], fArray[1][1]);
        generalPath.append(generalPath2, false);
    }

    private int append(int n) {
        if ((n >> floor & 1) == 1 || this.paper.properties.getAngleX() % 360.0f == 0.0f) {
            if ((n >> 4 & 1) == 1) {
                return 0;
            }
            return 1;
        }
        if ((n >> 4 & 1) == 1) {
            return -2;
        }
        return -1;
    }

    private int availableOriginY(int n) {
        int n2 = -1;
        if ((n >> 1 & 1) == 1 || this.paper.properties.getAngleX() % 360.0f == 0.0f) {
            if ((n >> 4 & 1) == 1) {
                n2 = this.compass.max(1, 4) == 1 ? 0 : 2;
            } else if ((n >> 5 & 1) == 1) {
                n2 = this.compass.max(1, 5) == 1 ? 3 : 1;
            }
        } else if ((n & 1) == 1) {
            if ((n >> 4 & 1) == 1) {
                n2 = this.compass.max(0, 4) == 0 ? 1 : 3;
            } else if ((n >> 5 & 1) == 1) {
                n2 = this.compass.max(0, 5) == 0 ? 2 : 0;
            }
        }
        return n2;
    }

    private int axisX(int n) {
        if ((n >> floor & 1) == 1 || (this.paper.properties.getAngleY() % 90.0f == 0.0f || this.paper.properties.getAngleY() % 270.0f == 0.0f) && this.paper.properties.getAngleY() % 180.0f != 0.0f && this.paper.properties.getAngleY() % 360.0f != 0.0f) {
            if ((n >> 0 & 1) == 1) {
                return 0;
            }
            return 1;
        }
        if ((n >> 0 & 1) == 1) {
            return -2;
        }
        return -1;
    }

    private boolean axisY(float[] fArray, float[] fArray2) {
        if (fArray[0] == fArray2[0]) {
            if (fArray[0] < this.paper.D[0]) {
                return fArray[1] < fArray2[1];
            }
            return fArray[1] > fArray2[1];
        }
        float f = (fArray2[1] - fArray[1]) / (fArray2[0] - fArray[0]);
        float f2 = fArray[1] - fArray[0] * f;
        if ((f2 = f * this.paper.D[0] + f2) > this.paper.D[1]) {
            return fArray[0] < fArray2[0];
        }
        return fArray[0] > fArray2[0];
    }

    public void transform(ChartMatrix chartMatrix) {
        this.xTickPos.transform(chartMatrix);
        this.xLabelPos.transform(chartMatrix);
        this.yTickPos.transform(chartMatrix);
        this.zTickPos.transform(chartMatrix);
        this.zLabelPos.transform(chartMatrix);
        this.yLabelPos.transform(chartMatrix);
        this.floorFace.transform(chartMatrix);
        this.originYFace.transform(chartMatrix);
    }

    public void locate() {
        this.compass = this.paper.getCompass();
        this.xTickPos.clear();
        this.xLabelPos.clear();
        this.yTickPos.clear();
        this.zTickPos.clear();
        this.zLabelPos.clear();
        this.yLabelPos.clear();
        this.floorFace.clear();
        this.originYFace.clear();
        float[] fArray = this.paper.getLength();
        this.xLen = fArray[0];
        this.yLen = fArray[1];
        this.zLen = fArray[2];
        this.unit = this.paper.getUnit();
        this.floorFace.addVertex(0.0f, 0.0f, 0.0f);
        this.floorFace.addVertex(this.xLen, 0.0f, 0.0f);
        this.floorFace.addVertex(this.xLen, 0.0f, this.zLen);
        this.floorFace.addVertex(0.0f, 0.0f, this.zLen);
        this.originY = this.paper.getOriginY();
        this.originYFace.clear();
        this.originYFace.addVertex(0.0f, this.paper.availableOriginY(this.originY), 0.0f);
        this.originYFace.addVertex(this.xLen, this.paper.availableOriginY(this.originY), 0.0f);
        this.originYFace.addVertex(this.xLen, this.paper.availableOriginY(this.originY), this.zLen);
        this.originYFace.addVertex(0.0f, this.paper.availableOriginY(this.originY), this.zLen);
        this.axisZ();
        this.clear();
        this.compass();
    }

    private void axisZ() {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        String[] stringArray = this.axisX.getLabels();
        int n = 1;
        if (!this.axisX.custommerConstant()) {
            if (this.unit[0] < this.getAngleX && this.unit[0] != 0.0f) {
                float f4 = this.getAngleX / this.unit[0];
                n = f4 > (float)((int)f4) ? (int)f4 + 1 : (int)f4;
            }
            this.axisX.setLabelN(this.getAngleY * n);
            if (stringArray != null) {
                if (this.axisX.isLineUnit()) {
                    int n2;
                    f = 0.0f;
                    for (n2 = 0; n2 < stringArray.length; n2 += n) {
                        this.xTickPos.addVertex(f, f2, f3);
                        this.xTickPos.addVertex(f, f2, this.zLen);
                        this.xTickPos.addVertex(f, this.yLen, this.zLen);
                        this.xTickPos.addVertex(f, this.yLen, f3);
                        f += this.unit[0] * (float)n;
                    }
                    f = 0.0f;
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        this.xLabelPos.addVertex(f, f2, f3);
                        this.xLabelPos.addVertex(f, f2, this.zLen);
                        this.xLabelPos.addVertex(f, this.yLen, this.zLen);
                        this.xLabelPos.addVertex(f, this.yLen, f3);
                        f += this.unit[0];
                    }
                } else {
                    int n3;
                    f = 0.0f;
                    for (n3 = 0; n3 <= stringArray.length; n3 += n) {
                        this.xTickPos.addVertex(f, f2, f3);
                        this.xTickPos.addVertex(f, f2, this.zLen);
                        this.xTickPos.addVertex(f, this.yLen, this.zLen);
                        this.xTickPos.addVertex(f, this.yLen, f3);
                        f += this.unit[0] * (float)n;
                    }
                    f = this.unit[0] / 2.0f;
                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                        this.xLabelPos.addVertex(f, f2, f3);
                        this.xLabelPos.addVertex(f, f2, this.zLen);
                        this.xLabelPos.addVertex(f, this.yLen, this.zLen);
                        this.xLabelPos.addVertex(f, this.yLen, f3);
                        f += this.unit[0];
                    }
                }
            }
        } else if (stringArray != null) {
            List list = this.axisX.getLabelList();
            f = 0.0f;
            for (int i = 0; i < list.size(); i += n) {
                f = this.axisX.getX(list.get(i), this.unit[0]);
                this.xTickPos.addVertex(f, f2, f3);
                this.xTickPos.addVertex(f, f2, this.zLen);
                this.xTickPos.addVertex(f, this.yLen, this.zLen);
                this.xTickPos.addVertex(f, this.yLen, f3);
            }
            this.xLabelPos = this.xTickPos;
        }
    }

    private void clear() {
        int n;
        float f = (float)this.axisY.getTickPace() * this.unit[1];
        float f2 = (float)(-(this.axisY.getMin() - this.axisY.getLabelStartValue())) * this.unit[1];
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        int n2 = this.axisY.getNumOfTick();
        int n3 = 1;
        if (f < this.getAngleX && f != 0.0f) {
            float f6 = this.getAngleX / f;
            n3 = f6 > (float)((int)f6) ? (int)f6 + 1 : (int)f6;
        }
        this.axisY.setLabelN(this.getAxisXProperties * n3);
        f4 = f2;
        boolean bl = true;
        for (n = 0; n <= n2; n += n3) {
            this.yTickPos.addVertex(f3, f4, f5);
            this.yTickPos.addVertex(this.xLen, f4, f5);
            this.yTickPos.addVertex(this.xLen, f4, this.zLen);
            this.yTickPos.addVertex(f3, f4, this.zLen);
            f4 += f * (float)n3;
        }
        f4 = f2;
        for (n = 0; n <= n2; ++n) {
            this.yLabelPos.addVertex(f3, f4, f5);
            this.yLabelPos.addVertex(this.xLen, f4, f5);
            this.yLabelPos.addVertex(this.xLen, f4, this.zLen);
            this.yLabelPos.addVertex(f3, f4, this.zLen);
            f4 += f;
        }
    }

    private void compass() {
        block7: {
            this.unit[2] = this.axisZ.getUnit(this.zLen);
            float f = 0.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            String[] stringArray = this.axisZ.getLabels();
            int n = 1;
            if (this.unit[2] < this.getAngleX && this.unit[2] != 0.0f) {
                float f4 = this.getAngleX / this.unit[2];
                n = f4 > (float)((int)f4) ? (int)f4 + 1 : (int)f4;
            }
            this.axisZ.setLabelN(this.getAxisYProperties * n);
            if (stringArray == null) break block7;
            if (this.axisZ.isLineUnit()) {
                int n2;
                f3 = 0.0f;
                for (n2 = 0; n2 < stringArray.length; n2 += n) {
                    this.zTickPos.addVertex(f, f2, f3);
                    this.zTickPos.addVertex(this.xLen, f2, f3);
                    this.zTickPos.addVertex(this.xLen, this.yLen, f3);
                    this.zTickPos.addVertex(f, this.yLen, f3);
                    f3 += this.unit[2] * (float)n;
                }
                f3 = 0.0f;
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    this.zLabelPos.addVertex(f, f2, f3);
                    this.zLabelPos.addVertex(this.xLen, f2, f3);
                    this.zLabelPos.addVertex(this.xLen, this.yLen, f3);
                    this.zLabelPos.addVertex(f, this.yLen, f3);
                    f3 += this.unit[2];
                }
            } else {
                int n3;
                f3 = 0.0f;
                for (n3 = 0; n3 <= stringArray.length; n3 += n) {
                    this.zTickPos.addVertex(f, f2, f3);
                    this.zTickPos.addVertex(this.xLen, f2, f3);
                    this.zTickPos.addVertex(this.xLen, this.yLen, f3);
                    this.zTickPos.addVertex(f, this.yLen, f3);
                    f3 += this.unit[2] * (float)n;
                }
                f3 = this.unit[2] / 2.0f;
                for (n3 = 0; n3 < stringArray.length; ++n3) {
                    this.zLabelPos.addVertex(f, f2, f3);
                    this.zLabelPos.addVertex(this.xLen, f2, f3);
                    this.zLabelPos.addVertex(this.xLen, this.yLen, f3);
                    this.zLabelPos.addVertex(f, this.yLen, f3);
                    f3 += this.unit[2];
                }
            }
        }
    }

    protected int[] getStake() {
        this.shownFace = this.paper.getShownFace();
        int[] nArray = new int[]{this.append(this.shownFace), this.availableOriginY(this.shownFace), this.axisX(this.shownFace)};
        return nArray;
    }

    public GeneralPath getGridXAreaPath() {
        return this.draw;
    }

    public GeneralPath getGridYAreaPath() {
        return this.formatMinorTickMark;
    }

    public GeneralPath getGridZAreaPath() {
        return this.get;
    }

    public boolean searchSelectedGridX(int n, int n2) {
        return this.draw.intersects(n - 5, n2 - 5, 10.0, 10.0);
    }

    public boolean searchSelectedGridY(int n, int n2) {
        return this.formatMinorTickMark.intersects(n - 5, n2 - 5, 10.0, 10.0);
    }

    public boolean searchSelectedGridZ(int n, int n2) {
        return this.get.intersects(n - 5, n2 - 5, 10.0, 10.0);
    }
}

