package com.jinfonet.jdbc.demo;
import com.jinfonet.jdbc.obj.JCollection;
import com.jinfonet.jdbc.obj.JIterator;
import com.jinfonet.interfaces.query.*;
import com.jinfonet.jdbc.obj.TableFilterImpl;
import java.sql.*;

public class FilterSQLReader extends TableFilterImpl 
{
	/*
		return type must be the class that implement the Collection interface
		This collection can be one of the following three classes 
		java.util.collection for Java2
		java.util.Vector for Java1.1 
		com.jinfonet.jdbc.obj.JCollection for both.
	*/
	private String[] myRealNames={"Product ID", "Product Name", "Product Type ID", "Category", "Price"};
	
	public FilterSQLReader()
	{
		this.realNames=myRealNames;
	}
	
	public JCollection execSQL(String jdbcDriver, String url, String sql)
	{
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		int colSize = 0;
		int[] selectedIdxes = null;

		try{
			//init driver
			Class.forName(jdbcDriver).newInstance();
		}catch(Exception e)	{
			System.out.println("class not found");
		}
		try	{
			//connect to url
			conn = DriverManager.getConnection(url);
			
			System.out.println("*****intit sql="+sql);
			//sql=refreshSQL(sql); // call TableFilterImpl method
			
		}catch(SQLException e)	{
			System.out.println("connection fail");
		}
			//exec sql
		try	{
			System.out.println("********SQL= "+sql);
			stmt = conn.createStatement();
			rs = stmt.executeQuery(sql);
		}catch(SQLException e)	{
			System.out.println("execute fail");
		}

		try	{	
			ResultSetMetaData rsmd = rs.getMetaData();
			if(rsmd!=null)
			{
				colSize = rsmd.getColumnCount();
				selectedIdxes = getSelColIndex(rsmd);
			}
			else
			{
				System.err.println( "Fail get MetaData!!!" );
			}
		
		}catch(Exception e)	{
			System.out.println("get column size error");
		}
			//create the collection		

			
		JCollection jc = new SQLCollection(stmt, rs, colSize,selectedIdxes);
		try	{
		rs.close();
		}catch(SQLException e)	{
			System.out.println("close error");
		}
		return jc;

	}
}

/*
	JCollection is we define the interface, you can replace it with other implements
*/
class SQLCollection implements JCollection
{
	Statement stmt;
	ResultSet rs;
	java.util.Vector v = new java.util.Vector();
	int colSize = 0;
	static final int totalColSize = 5 ;
	private int[] selectedIdx = null;
	SQLCollection(Statement stmt, ResultSet rs,int colSize, int[] selected)
	{
		this.stmt = stmt;
		this.rs = rs;
		this.colSize = colSize;
		this.selectedIdx = selected;
		init();
	}

	void init()
	{
		try	{
		boolean filterSelected = (selectedIdx != null) ;
		while(rs.next())
		{
			Products row = new Products(colSize);
			if(filterSelected)
			{
					for (int i = 0; i < selectedIdx.length; i ++)
					{
						row.row[selectedIdx[i]] = rs.getObject(i+1);
					}
			}
			else
			{
					for(int i=0; i<totalColSize; i++)
					row.row[i] = rs.getObject(i+1);	
			}
			v.addElement(row);
		}
		}catch(SQLException e)	{
		}
	}

	public int size()
	{
		return v.size();
	}

	public JIterator getIterator()
	{
		return new FltIterator(v);
	}

	public void setCollection(Object obj)
	{
	}
}

class FltIterator implements JIterator
{
	java.util.Vector iterator;
	int row = 0;
	FltIterator(java.util.Vector iter)
	{
		this.iterator = iter;
	}

	public boolean hasNext()
	{
		return row < iterator.size();
	}

	public Object next()
	{
		return iterator.elementAt(row++);
	}
}