import java.sql.Date;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Properties;

import jet.server.api.RptServerException;
import jet.server.api.ServerInfo;
import jet.server.api.custom.schedule.*;

/**
 * <code>DemoParameterGenerator</code> provides an example of how to write a implement a
 * class of interface <code>ParameterGenerator</code> Note this example must be
 * used with the report "/SampleReports/CustomerAnalysis.cls" and catalog
 * "/SampleReports/SampleReports.cat", otherwise, you should modify the method
 * "getParameterValue(String)" for your report
 * 
 * @author jinsheng.zhang
 *  
 */
public class DemoParameterGenerator implements ParameterGenerator {
    //user defines a variable
    private Hashtable ht = null;

    private Properties scheduleProp = null;

    /**
     * init the generator by report context.
     *  
     */
    public void initByReportContext(ServerInfo srvInfo) {
        System.out.println("###ParameterGeneratorDemo.initByReportContext!");
        try {
            //TODO this method will be invoked by server every time the
            // schedule is executed.
            // You can get the report context from ServerInfo.
            // For example,you can use the method "getScheduleProperties()" to
            // get schedule infos and join them to generate parameters.
            scheduleProp = srvInfo.getScheduleProperties();
            //use the schedule properties to sth.

            //here init the user defined variable
            ht = new Hashtable();
        } catch (RptServerException e) {
            e.printStackTrace();
        }
    }

    public String getParameterValue(String pmName) {
        System.out.println("###ParameterGeneratorDemo.getParameterValue!");
        /**
         * p_Region='NA','APAC','EMAC','LATAM' p_Startdate=January 1, 2006 p_Country=USA
         * p_Enddate=December 31, 2009 p_Today=December 31, 2011
         */
        if (pmName.equalsIgnoreCase("p_Region")) {
            return getCusRegion();
        } else if (pmName.equalsIgnoreCase("p_Startdate")) {
            return getStartDate();
        } else if (pmName.equalsIgnoreCase("p_Country")) {
            return getPCountry();
        } else if (pmName.equalsIgnoreCase("p_Enddate")) {
            return getEndDate();
        } else if (pmName.equalsIgnoreCase("p_Month")) {
            return String.valueOf(Calendar.getInstance().get(Calendar.MONTH));
        } else if (pmName.equalsIgnoreCase("p_Year")) {
            return String.valueOf(Calendar.getInstance().get(Calendar.YEAR));
        }
        return null;
    }

    private String getCusRegion() {
        return "'NA', 'APAC', 'EMAC', 'LATAM'";
    }

    private String getStartDate() {
        return "January 1, 2006";
    }

    private String getPCountry() {
        return "AUST";
    }

    private String getEndDate() {
        return "December 31, 2009";
    }

    public void close() {
        //user can use the method to release some resource of this generator
        ht = null;
    }

    // Here user writes a method to get current time
    private String getPToday() {
        Date date = new Date(System.currentTimeMillis());
        //can do some calculations for the date here
        return date.toString();
    }

}
