import java.util.Enumeration;
import java.util.Vector;

import jet.cs.util.APIConst;
import jet.server.api.admin.AdminService;
import jet.server.api.admin.SecurityAdminService;
import jet.server.api.admin.cfg.ConfigService;
import jet.server.api.admin.cfg.ConfigurationLDAPServer;
import jet.server.api.admin.security.JGroup;
import jet.server.api.admin.security.JRole;
import jet.server.api.admin.security.JUser;
import jet.server.api.exception.BadRealmException;
import jet.server.api.exception.NoSuchGroupException;
import jet.server.api.exception.NoSuchRealmException;
import jet.server.api.exception.NoSuchRoleException;
import jet.server.api.exception.NoSuchUserException;
import jet.server.api.exception.RoleExistsException;
import jet.server.api.exception.UserExistsException;
import jet.server.api.http.HttpRptServer;
import jet.server.api.http.HttpUtil;

/**
 * This demo is created to demonstrate the usage of the JReport Server API methods to create role to server.
 * You can add roles,which you wish to be added on server,in "addGroupTest".
 * 
 * Announcements:1.Please confirm your server is shutdown.
 *               2.If the role to be added is exist,it will occur "RoleExistsException".
 *               3.This demo is use to create security testing environment, please use this demo as your requirements.
 * 
 */

public  class SecurityRoleCover {
	
	String submiter = "admin";
	static String reporthome = "";
	
	
	CatchInfo uu = new CatchInfo();
	/**
	 * Add role and other security configuration,get roles information.
	 * Please set your server install path as "reporthome".
	 * @param args
	 */
	public static void main(String[] args)
	{
//	    for(int i = 0; i < args.length; i++){
//	    	String arg = args[i]; 
//	    	System.out.println("SecurityRoleCover:"  + arg);
//	    	if(arg.indexOf("-reporthome") == 0){
//	    		reporthome = args[i].substring(args[i].indexOf(":") + 1);
//	    	}
//	    }
		reporthome= "D:\\JReport\\V11Update1\\B201206291505";
	    SecurityRoleCover ss = new  SecurityRoleCover();
	    ss.doSecurity();
	}
	/**
	 * Start server,call addRolerTest and getRoles.
	 */
	public void doSecurity() {	
		HttpRptServer httpRptServer = null;
		try {
			// Set report home
			System.getProperties().put("reporthome", reporthome);
			System.out.println("start server:");
			// Creates instance of RptServer (JReport Server can not be running already)
			HttpUtil.initEnv(System.getProperties());
			System.out.println("end start server:");
			
			httpRptServer = HttpUtil.getHttpRptServer();
			AdminService adminServ = httpRptServer.getAdminService();
			SecurityAdminService secServ = adminServ.getSecurityAdminService();
			String curRealm = secServ.getCurRealm();
			addRolerTest(secServ,curRealm );
			ConfigService sConf = adminServ.getConfigService() ;
			ConfigurationLDAPServer confLSer = sConf.getConfigurationLDAPServer();
//			getUserFromLDAP(confLSer);
			getRoles(secServ,curRealm );
			
		} catch (Throwable t){
			t.printStackTrace();
		}
		finally{
			// Make sure server is shutdown or there will be a 2 minute wait to start again
			httpRptServer.shutdown();
			System.out.println("Server "+ httpRptServer +" shutdown.");
		}
		System.exit(0);
    }
	/**
	 * Add roles,and add other information for security configuration.
	 * Please configure the "addRole\addUser\addSubUserToRole\addUserIntoRole\
	 * addGroupIntoRole\addSubRoleToRole\addNewParentRolesToUser\addPrivilegedRoles" parameters as you need.
	 * 
	 * @param secServ
	 * @param curRealm
	 */
	private void addRolerTest(SecurityAdminService secServ, String curRealm){
		String tmp = "";
		    //add roles.
			try {
				secServ.addRole(curRealm,"addRole", "add role test", submiter);
			} catch (NoSuchRealmException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (BadRealmException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (RoleExistsException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			try {
				secServ.addRole(curRealm,"addSubRole", "add role test", submiter);
			} catch (NoSuchRealmException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (BadRealmException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (RoleExistsException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			//add users for security configuration.
			try {
				try {
					secServ.addUser(curRealm,submiter,"addsunUserToRole","1234","test add user by addUser()",
							 "test add user by addUser()","addUser@email", false, 1000, false, 4, false);
				} catch (UserExistsException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}

				try {
					secServ.addUser(curRealm,submiter,"addUserIntoRole","1234","test add user by addUser()",
						 "test add user by addUser()","addUser@email", false, 1000, false, 4, false);
				} catch (UserExistsException e) {
				// TODO Auto-generated catch block
					e.printStackTrace();
				}
				
				//add the subroutine user to role.
				secServ.addSubUserToRole(curRealm, submiter, "addsunUserToRole", "addSubRole");
			} catch (NoSuchRoleException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (NoSuchUserException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (NoSuchRealmException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (BadRealmException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			//add user to role.
			try {
				secServ.addUserIntoRole(curRealm,"addSubRole", "addUserIntoRole", submiter);
			} catch (NoSuchRealmException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (BadRealmException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (NoSuchUserException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (NoSuchRoleException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			
			//add group to role.
			try {
				secServ.addGroupIntoRole(curRealm,"addSubRole", "addGroupIntosubRole", submiter);
			} catch (NoSuchRealmException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (BadRealmException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (NoSuchGroupException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (NoSuchRoleException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			//add subroutine roles for "addSubRoleToRole"
			try {
				secServ.addRole(curRealm,"addRole1", "add role1 test", submiter);
				secServ.addRole(curRealm,"addRole2", "add role2 test", submiter);
				secServ.addRole(curRealm,"addRole3", "add role3 test", submiter);
				secServ.addRole(curRealm,"addRole4", "add role4 test", submiter);
				secServ.addRole(curRealm,"addRole5", "add role5 test", submiter);
			} catch (NoSuchRealmException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (BadRealmException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			} catch (RoleExistsException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
               
			    //add subroutine roles to role
				try {
					secServ.addSubRoleToRole(curRealm, submiter, "addRole1", "addRole");
					secServ.addSubRoleToRole(curRealm, submiter, "addRole2", "addRole1");
					secServ.addSubRoleToRole(curRealm, submiter, "addRole3", "addRole2");
					secServ.addSubRoleToRole(curRealm, submiter, "addRole4", "addRole3");
					secServ.addSubRoleToRole(curRealm, submiter, "addRole", "addRole4");
				} catch (NoSuchRoleException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				} catch (NoSuchRealmException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				} catch (BadRealmException e1) {
					// TODO Auto-generated catch block
					e1.printStackTrace();
				}
		
		//
		try {
			tmp = secServ.addNewParentRolesToUser(curRealm, submiter, "addUserIntoRole", "addRole4");
		} catch (NoSuchRoleException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchUserException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		//configure the role's  privilege.
		Vector vv;
		try {
			vv = secServ.getAllRoleNames(curRealm, submiter);
			try {
				tmp = secServ.addPrivilegedRoles(curRealm, submiter,APIConst.PRIVILEGE_PUBLISH_REPORT, vv);
			} catch (NoSuchRoleException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}

/**
 * Get roles information.
 * @param secServ
 * @param curRealm
 */
	private void getRoles(SecurityAdminService secServ, String curRealm){
	
		Vector jr = null;
		Vector vv = null;
		String[] sv = null;
		
		try {
			int i = secServ.getRoleMemberCount(curRealm, "addSubRole");
			uu.printSring("get role member count:", String.valueOf(i));
		} catch (NoSuchRealmException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (BadRealmException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (NoSuchRoleException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		
		int j;
		try {
			j = secServ.getUserParentRolesCount(curRealm, "addUserIntoRole");
			uu.printSring("get User Parent Roles Count:", String.valueOf(j));
		} catch (NoSuchUserException e2) {
			// TODO Auto-generated catch block
			e2.printStackTrace();
		}
		
		JRole[] gj = null;
		try {
			gj = secServ.getAllJRoles(curRealm, submiter);
			for (int i = 0; i < gj.length ; i++) {
				uu.JRolePrint(gj[i]);
			}		
		} catch (NoSuchRealmException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		} catch (BadRealmException e1) {
			// TODO Auto-generated catch block
			e1.printStackTrace();
		}
		
		
		try {
			jr = secServ.getAllRoles(curRealm, submiter);
			uu.printList("get all roles:", jr);
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		try {
			vv = secServ.getAllRoleNames(curRealm, submiter);
			uu.printList("get all role names:", vv);
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		try {
			Enumeration ee = secServ.getAllUserNamesByRole(submiter, curRealm, "addRole");
			uu.printEnumeration("get all user names by role(addRole):", ee);
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchRoleException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		
		try {
			JGroup[] jg = secServ.getJGroupsByJRole(curRealm, submiter, "addRole");
			for (int i = 0; i < jg.length ; i++) {
				uu.JgroupPrint(jg[i]);
			}
		} catch (NoSuchRoleException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		JRole jro;
		try {
			jro = secServ.getJRole(submiter, curRealm, "addRole");
			uu.JRolePrint(jro);
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchRoleException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		JRole[] gg1;
		try {
			gg1 = secServ.getJRolesByJGroup(curRealm, submiter, "addGroupIntosubRole");
			for (int i = 0; i < gg1.length ; i++) {
				uu.JRolePrint(gg1[i]);
			}
		} catch (NoSuchGroupException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		JRole[] gg2;
		try {
			gg2 = secServ.getParentJRolesByJUser(curRealm, submiter, "addUserIntoRole");
			for (int i = 0; i < gg2.length ; i++) {
				uu.JRolePrint(gg2[i]);
			}
		} catch (NoSuchUserException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		Vector vv1;
		try {
			vv1 = secServ.getPrivilegedRoles(curRealm, submiter, APIConst.PRIVILEGE_PUBLISH_REPORT);
			uu.printList("getPrivilegedRoles", vv1);
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		Vector vv2;
		try {
			vv2 = secServ.getRolePrivileges(curRealm, submiter, "addRole");
			uu.printList("getPrivilegedRoles", vv2);
		} catch (NoSuchRoleException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		JRole[] jj2;
		try {
			jj2 = secServ.getSubJRolesByJRole(curRealm, submiter, "addRole");
			for (int i = 0; i < jj2.length ; i++) {
				uu.JRolePrint(jj2[i]);
			}
		} catch (NoSuchRoleException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		
		try {
			JUser[] ju = secServ.getSubJUsersByJRole(curRealm, submiter, "addRole");
			for (int i = 0; i < ju.length ; i++) {
				uu.JUserPrint(ju[i]);
			}
			
		} catch (NoSuchRoleException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (NoSuchRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (BadRealmException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}catch (NullPointerException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			System.out.println("-------------- There may be no accessed information can be found, please don't care and keep on.");
		}
		
	}
}	

