<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<%@page contentType="text/html;charset=UTF-8" language="java" %>
<%@ page import="jet.cs.util.*, 
                 jet.server.util.nls.*,
                 jet.server.api.http.*,
                 jet.server.api.*,
                 java.io.*,
                 javax.xml.bind.DatatypeConverter,
                 java.util.*" %>
<!-- 
This jsp page is a dispatcher to one of the three pages that demonstrate
how Single Sign On can work.

This one reports the current users and provides a menu to run
one of the others.

This one also allows a logout operation, in order to clear
previous activity that logged someone in.

To demonstrate this, move this JSP page and the four other jsp 
pages to the folder "public_html/jinfonet".  

These four other jsp pages are:
customNoAuth.jsp
customParamAuth.jsp
customSessinAuth.jsp
customRunReport.jsp

Access this page from a browser by way of a bookmark.

   localhost:8888/jinfonet/customIndex.jsp

If this shows a user logged in and you want to see a demonstration
of what happens when a user is not logged in, press the "Logout" button.

Select one of the three demonstration JSP pages to run and click the 
link to run it.

Read the comments in each JSP page to understand what they do.

This page is simply a dispatcher to help demonstrates the Single Sign On framework in action.
-->
<%
    HttpRptServer httpRptServer = null;
    HttpUserSessionManager httpUserSessionManager = null;
    session = request.getSession(true);

    String JRuser = null;  
    String appUser = null;  
    boolean doLogout = false;
    String singleSignOnStatus = "";  

    // "action" may contain a long value of current time.
    // this is used so that the browser does not display the cached value of the page.
    // that long value is not used here.
    // supported action values:
    //   logout -> logout of the web session & logout of JReport Server
    String action = request.getParameter("action");  
    if ("logout".equals(action)) {
        doLogout = true;
    }

    // consider "logout" for applcation
    if (doLogout) {

        // logout activity needs to be in a separate JSP call
        // from code that accesses data from session.
    
        // emulation of login/logout in this demo is based on setting/removing this session variable
        if (session.getAttribute("authorized_user") != null) {
            session.removeAttribute("authorized_user");
        }

        // logout of JReport Server
        HttpUtil.logout(request);

        // return to this page without the logout action.
        // do this to avoid run time failures related to 
        // references to session data in code below
        // that does normal get-data activity.
       
        long time = new Date().getTime();
        String redirectURL="customIndex.jsp?action=" + String.valueOf(time);
        response.setStatus(HttpServletResponse.SC_MOVED_TEMPORARILY);
        response.setHeader("Location", redirectURL);
        response.setHeader("Content-Location", redirectURL);
        return;
    }

    // is the MyExternalAuthorized class on the class path.
    // If it is, then it can be used to set it as the one to use to turn on Single Sign On.
    // If not, then it can't be used.
    // packageIsFound will determine if the option is shown to Turn SSO On.
    boolean packageIsFound = false;
    try {
        Class.forName("com.example.MyExternalAuthorized");
        // here when class exists.
        packageIsFound = true;
    } 
    catch (ClassNotFoundException e) {
        // end up here when there is no class deployed.
        packageIsFound = false;
    }

    // establish context and handle for JReport API calls.
    httpRptServer = HttpUtil.getHttpRptServer(request);
    if (httpRptServer == null) {
        System.getProperties().put("jreport.context", application);
        HttpUtil.initEnv(System.getProperties());
        httpRptServer = HttpUtil.getHttpRptServer(request);
    }
    if (httpRptServer == null) {
        JRuser = "Unknown";
    } else {

        httpUserSessionManager = httpRptServer.getHttpUserSessionManager(); 

            // When there is no current user.  this getUser() returns an empty string.
        JRuser = (String)httpUserSessionManager.getUser(request);
        if (JRuser.equals("")) {
            JRuser = "No Current User";  // establish display value
        }

        HttpExternalAuthorized httpExternalAuthorized = 
                  (HttpExternalAuthorized)httpUserSessionManager.getHttpExternalAuthorized();
        if (httpExternalAuthorized == null) {
            singleSignOnStatus = "Single Sign On is OFF";
        } else {
            //  singleSignOnStatus will be displayed within enclosing bold tags.  Bold tags in extra text for this case work within that context.
            singleSignOnStatus = "Single Sign On is ON.</b>  &nbsp;&nbsp;&nbsp;&nbsp; ExternalAuthorized is by class <b>" + httpExternalAuthorized.getClass().getName();
        }
    }

    if (session.getAttribute("authorized_user") != null) {
        appUser = session.getAttribute("authorized_user").toString();
    } else {
        appUser = "No Current User";
    }

%>
<html>
<head>
<title>Dispatcher - Single Sign On Demonstration</title>
</head>
<body>
<b>Refreshing page in browser may be needed</b> 
<br>
<b>to see correct current user and SSO status.</b> 
<p>
Current application user in this session: <b><%=appUser %></b>
<br>
Current JReport Server user in this session: <b><%=JRuser %></b>
<br>
SSO Status: <b><%=singleSignOnStatus %></b>

<hr>
<table width="900" cellspacing="16" cellpadding="8" border="0">
<tr>
  <td width="30%" bgcolor="ffe7a8" >
  <form name="form-logout" action="customIndex.jsp">
    <fieldset >
    <legend>LOGOUT, clear user</legend>
      <input type="hidden" name="action" value="logout">
      <input type="submit" value="Log Out">
    </fieldset>
  </form>
  </td>
  <td width="35%" bgcolor="ffe7a8" >
  <form name="form-sso-off" action="customTurnOffSSO.jsp">
    <fieldset >
    <legend>TURN OFF Single Sign On</legend>
      <input type="submit" value="Turn Off SSO">
    </fieldset>
  </form>
  </td>
  <td bgcolor="ffe7a8" >
      <%
      if (packageIsFound) {
      %>
  <form name="form-sso-on" action="customTurnOnSSO.jsp">
    <fieldset >
    <legend>TURN On Single Sign On</legend>
      <input type="submit" value="Turn On SSO">
    </fieldset>
  </form>
      <%
      } else {
      %>
      Package not found in classpath: 
          <br>
          <b><i>com.example.MyExternalAuthorized</i></b>
          <br>
          Unable to turn on SSO
      <%
      }
      %>
  </td>
</tr>
</table>
<hr>

<p>

<h4>Select scenario to demonstrate <i>Single Sign On</i> behavior</h4> 
<ul>
<li>
<a href="customNoAuth.jsp">Run report when application does not have a user logged in.</a>
</li>
<li>
<a href="customSessionAuth.jsp">Run report when application user is logged in (User will become logged in by this choice).</a>
</li>
<li>
<a href="customParamAuth.jsp">Run report when application passes in app's User ID as a URL Query Parameter.</a>
</li>
</ul>

</body>
</html>
