import java.text.DateFormat;
import java.util.*;
import jet.server.api.admin.*;
import jet.server.api.admin.cfg.*;
import jet.cs.util.*;
import jet.server.api.*;
import jet.server.api.http.HttpUtil;

public class APIDemoSendEMail
{

    public static void main(String[] args)
	{
    	RptServer server = null;
		try {
			//set report home
			System.getProperties().put("reporthome", "c:\\JReport\\Server");
			
			//creates instance of RptServer
			HttpUtil.initEnv(System.getProperties());
			server = HttpUtil.getHttpRptServer();
			System.out.println("========server="+server);
			
			AdminService adminservice = server.getAdminService();
			ConfigService configservice = adminservice.getConfigService();
			ConfigurationMail configurationMail = configservice.getConfigurationMail();
			configurationMail.setMailServer("192.168.128.4"); // Your mail server
			configurationMail.setMailPort(25);                // mail service port
			configurationMail.setMailBox("Api@jinfonet.com");    // your mail address
			
			//set task properties
			Properties props = new Properties();
			props.put(APIConst.TAG_TASK_CLASS, APIConst.TASK_TO_MAIL);
			props.put(APIConst.TAG_CATALOG, "/SampleReports/SampleReports.cat");
			props.put(APIConst.TAG_REPORT, "CustomerAnalysis.cls");
			props.put(APIConst.TAG_TO_MAIL, "true");
			props.put(APIConst.TAG_REPORT_LANGUAGE, "en_US");
			String today = DateFormat.getDateInstance(DateFormat.LONG, new Locale("en", "US")).format(new Date());
			//set value of parameter "p_StartDate" & "p_EndDate".
			props.put(APIConst.TAG_PARAM_PREFIX + "p_StartDate", "January 1, 2006");
			props.put(APIConst.TAG_PARAM_PREFIX + "p_EndDate", today);
			//mail properties
			Properties mail = new Properties();

			//set the first mail properties
			mail.put(APIConst.TAG_MAIL_TO, "Api@jinfonet.com"); // sent to mail address
			mail.put(APIConst.TAG_MAIL_SUBJECT, "CustomerAnalysis");
			mail.put(APIConst.TAG_MAIL_COMMENT, "to user1.");
			

			//set APIConst.TAG_JRMAIL property field by properties of an E-Mail.
			props.put(APIConst.TAG_JRMAIL + "0", jet.server.api.http.HttpUtil.makeQuery(mail));

			mail.clear();
			//set the second mail properties
			mail.put(APIConst.TAG_MAIL_TO, "Api@jinfonet.com"); // sent to mail address
			mail.put(APIConst.TAG_MAIL_SUBJECT, "CustomerAnalysis");
			mail.put(APIConst.TAG_MAIL_COMMENT, "to user2.");

			//set APIConst.TAG_JRMAIL property field by properties of an E-Mail.
			props.put(APIConst.TAG_JRMAIL + "1", jet.server.api.http.HttpUtil.makeQuery(mail));
			
			System.out.println("========submitScheduledTask="+props);

			String taskID = server.submitScheduledTask("admin", props);
			System.out.println("========taskID="+taskID);

			//waiting the task completed
			Vector completeRecords = null;
			CompletedTaskTable completeTable = server.getCompletedTaskTable();
			while (true) {
				System.out.print(">");
				Thread.sleep(2000);
				completeRecords = completeTable.getCompletedTaskRecordsByTaskID(taskID);
				//check if the task completed
				if (completeRecords.size() > 0) {
					//completed
					break;
				}
			}
			
			System.out.println("\n========completeRecords=" + completeRecords);
			
			//get the completed record
			CompletedTaskRecord completeRecord = (CompletedTaskRecord)completeRecords.elementAt(0);
			System.out.println("========completeRecord=" + completeRecord);
			
			if (completeRecord.isSuccessful()) {
				System.out.println("========Successful!");
			} else {
				System.out.println("========Fail! Error message: \n" + completeRecord.getErrorMessage());
			}
			
		
		}catch (Throwable t){
			t.printStackTrace();
		}
		finally{
			// Make sure server is shutdown or there will be a 2 minute wait to start again
			server.shutdown();
			System.out.println("Server "+ server +" shutdown.");
		}
		System.exit(0);
    }
}


