package help;

import java.io.File;
import java.sql.ResultSet;

import jet.datasource.*;
import jet.ReportEnv;


/**
 * The interface is designed for new User data source.  
 * All UDSes that user wrote should implements the interface.  
 * So it can be used in JReport.
 */
public class AddressListUDS implements JRUserDataSource
{
	/** 
	 * The ResultSet need to be returned.
	 */
	AddressListResultSet rs;

    /**
     * The get the result set for user data source.
     */ 
    public ResultSet getResultSet(String param) throws JRUserDataSourceException
	{
		return new AddressListResultSet(ReportEnv.homePath + 
										"help" + 
										File.separator + 
										param);
	}

	/**
	 * Release the resources.
	 */
    public void releaseResultSet() throws JRUserDataSourceException
	{
		if (rs != null)
		{
			rs.close();
		}
	}
}