import jet.bean.*;
import java.awt.*;
import java.awt.event.*;

import jet.thinviewer.*;
import jet.connect.*;

/**
 * This class is used to test the Result Viewer Bean which is a GUI application.
 * It can not run a report, you first need to run a report, find the result name then update this program to use the name of the
 * JReport Result file (.rst) then you can use this to export to other formats.
 */

class TestResultBean extends Frame implements ActionListener, ClickActionListener
{
	JRResultViewer bean = null;
	
	TestResultBean()
	{
		setBackground(Color.lightGray);
		setBounds(0, 0, 500, 400);

		Menu m1 = new Menu("Menu");          //Create the first menu for test
		
		//Add menu items to menu m1
        MenuItem item = new MenuItem("start");
		item.addActionListener(this);
        m1.add(item);

        item = new MenuItem("print");
		item.addActionListener(this);
        m1.add(item);
		
        item = new MenuItem("export pdf");
		item.addActionListener(this);
        m1.add(item);
		
        item = new MenuItem("export text");
		item.addActionListener(this);
        m1.add(item);

	    item = new MenuItem("export html");
		item.addActionListener(this);
        m1.add(item);

		Menu m2 = new Menu("Go");
	
		//Add menu items to menu m2
        MenuItem item2 = new MenuItem("Previous Page");
		item2.addActionListener(this);
        m2.add(item2);
		
        item2 = new MenuItem("Next Page");
		item2.addActionListener(this);
        m2.add(item2);
		
        item2 = new MenuItem("First Page");
		item2.addActionListener(this);
        m2.add(item2);

		item2 = new MenuItem("Last Page");
		item2.addActionListener(this);
        m2.add(item2);

		item2 = new MenuItem("Total_Page_Number");
		item2.addActionListener(this);
        m2.add(item2);

		item2 = new MenuItem("GoToPage3");
		item2.addActionListener(this);
        m2.add(item2);

		Menu m3 = new Menu("View");
	
		//Add menu items to menu m3
        MenuItem item3 = new MenuItem("Zoom");
		item3.addActionListener(this);
        m3.add(item3);

		MenuBar mb = new MenuBar();           //Create a menuBar mb
		mb.add(m1);                           //Show two menus on the menubar 
		mb.add(m2);
		mb.add(m3);
		setMenuBar(mb);

		addWindowListener(new WindowAdapter()  //Listen to the action on the window
		{
			public void windowClosing(WindowEvent e) 
			{
				if ( bean != null )
					bean.exit();
				System.exit(0);
			}
		} );

		this.setVisible(true);
	}

	public void clickOnField(Record rec)
	{
		System.err.println("click on field:" + rec);
	}
	
	public void actionPerformed(ActionEvent e)
	{
		String label = e.getActionCommand();
		if ( label.equals("start") )
		{
			if (bean != null)
			{
				bean.exit();
				remove(bean);
			}
			bean = new JRResultViewer();
			bean.addClickActionListener(this);
			add("Center", bean);
			/**
			 * Set the name of the report which the JReport Result Viewer will run, here we input 
			 * the report customerlist.rst to viewer, 
			 */
			bean.setReportName("c:\\JReport\\Server\\temp\\customerlist.rst");
			/**
			 * Launch the result viewer to view the result report file
			 */
			bean.setLoadReport("yes");

			this.setVisible(true);

			System.out.println("**** status:" + bean.getStatus());
		}
        else if ( label.equals("print") )
		{
			try
			{
			if (bean != null)
			{
				bean.exit();
				remove(bean);
			}
			bean = new JRResultViewer();
			//bean.setShowInfoLevel(bean.vDebug | bean.vError);
			add("Center", bean);
			bean.setReportName("c:\\JReport\\Server\\temp\\customerlist.rst");
			bean.setLoadReport("yes");

			bean.printReport();
			System.out.println("**** status:" + bean.getPrintStatus());
			}
			catch (Exception ee)
			{
			ee.printStackTrace();
			}
		}
        else if ( label.equals("export pdf") )
		{
			if ( bean != null )
			{
				setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
				/**
				 * Export the result report customerlist.rst to a PDF file customerlist_0.pdf
				 * Note: 
				 * if you want export your own result report, you need to modify
				 * this test program, at least change the name of the result report file"
				 */
				bean.exportToPdf("c:\\JReport\\Server\\temp\\customerlist_0.pdf",new PDFParameter());
				setCursor( Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR) );
			}
		}
        else if ( label.equals("export text") )
		{
			if ( bean != null )
			{
				setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
				/**
				 * Export the result report customerlist.rst to a TEXT file customerlist_0.txt
				 * 
				 */
				TextParameter textParam=new TextParameter();
				textParam.setNormalTextFile(true);
				bean.exportToText("c:\\JReport\\Server\\temp\\customerlist_0.txt", textParam);
				setCursor( Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR) );
			}
		}
	    else if ( label.equals("export html") )
		{
			if ( bean != null )
			{
				setCursor(Cursor.getPredefinedCursor(Cursor.WAIT_CURSOR));
				/**
				 * Export the result report customerlist.rst to a HTML file customerlist_0.html"
				 */
				bean.exportToHtml("c:\\JReport\\Server\\temp\\customerlist_0.html",new HtmlParameter());
				setCursor( Cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR) );
			}
		}
		else if (label.equals("First Page") )
		{
			if (bean !=null)
			{
				//Go to the first page of the current result report
				bean.firstPage();
			}
		} 
		else if (label.equals("Previous Page"))
		{ 
			if (bean !=null)
			{
				//Go to the previous page 
				bean.prevPage();
			}
		}
		else if (label.equals("Next Page"))
		{
			if (bean !=null)
			{
				//Go to the next page
				bean.nextPage();
			}
		}
		else if (label.equals("Last Page"))
		{
			if (bean !=null)
			{
				//Go to the last page of the current result report
				bean.lastPage();
			}
		}
		else if (label.equals("Total_Page_Number"))
		{
			if (bean !=null)
			{
				//Get the total page numbers
				bean.getTotalPageNumber();
				if(bean.getTotalPageNumber()!= -1)
				System.out.println("total Number:"+bean.getTotalPageNumber());
			}
		}
	    else if (label.equals("GoToPage3"))
		{
			if (bean !=null)
			{
				//Go to the third page of the current result report
				//Note: here we just go to a certain page for test
				bean.gotoPage(3);
			}
		}
	    else if (label.equals("Zoom"))
		{
			if (bean !=null)
			{
				bean.zoom(200);
			}
		}
	}

	public static void main(String argv[])
	{
		new TestResultBean();
	}
}
