/*
 * Decompiled with CFR 0.152.
 */
package chart.data;

public class ChartTypeInfo {
    public static final int TYPE_MASK = 255;
    public static final int TYPE_BAR = 0;
    public static final int TYPE_BENCH = 1;
    public static final int TYPE_LINE = 2;
    public static final int TYPE_AREA = 3;
    public static final int TYPE_PIE = 4;
    public static final int TYPE_RADAR = 5;
    public static final int TYPE_GAUGE = 6;
    public static final int TYPE_SURFACE = 7;
    public static final int TYPE_SCATTER = 8;
    public static final int TYPE_BUBBLE = 9;
    public static final int TYPE_STOCK = 10;
    public static final int TYPE_BULLET = 11;
    public static final int TYPE_BULLSEYE = 12;
    public static final int TYPE_LED = 13;
    public static final int TYPE_ORG = 14;
    public static final int TYPE_SPARKLINE_BAR = 15;
    public static final int TYPE_SPARKLINE_LINE = 16;
    public static final int TYPE_SPARKLINE_PIE = 17;
    public static final int TYPE_SPARKLINE_BULLET = 18;
    public static final int TYPE_HEATMAP = 19;
    public static final int SUBTYPE_MASK = 3840;
    public static final int SUBTYPE_NORMAL = 0;
    public static final int SUBTYPE_STACK = 0;
    public static final int SUBTYPE_PERCENT = 256;
    public static final int SUBTYPE_SIDEBYSIDE = 512;
    public static final int SUBTYPE_ARRAY = 768;
    public static final int SUBTYPE_NO_LINE = 0;
    public static final int SUBTYPE_STRAIGHT_LINE = 256;
    public static final int SUBTYPE_CURVE_LINE = 512;
    public static final int SUBTYPE_OHLC = 0;
    public static final int SUBTYPE_HLC = 256;
    public static final int SUBTYPE_OC = 512;
    public static final int SUBTYPE_DAIL = 0;
    public static final int SUBTYPE_BAR = 256;
    public static final int SUBTYPE_BALL = 512;
    public static final int SUBTYPE_DONUT = 256;
    public static final int EFFECT_MASK = 61440;
    public static final int EFFECT_2D = 0;
    public static final int EFFECT_3D = 4096;
    public static final int SERIESTYPE_MASK = 0xFF0000;
    public static final int SERIESTYPE_1V = 0;
    public static final int SERIESTYPE_2V = 65536;
    public static final int SERIESTYPE_3V = 131072;
    public static final int SERIESTYPE_4V = 196608;
    public static final int[][] BUILTINTYPES = new int[][]{{512, 0, 256, 4608, 4096, 4352, 4864}, {513, 1, 257, 4609, 4097, 4353, 4865}, {770, 2, 258, 4866}, {771, 3, 259, 4867, 4099, 4355}, {4, 4100, 260, 4356}, {5}, {6, 262, 518}, {4871}, {65544, 65800, 66056}, {131081}, {66058, 131338, 196618}, {11}, {12}, {13}, {14}, {527, 15, 271}, {784, 16, 272}, {17, 4113, 273, 4369}, {18}, {19}};

    public static int getPrimType(int n) {
        int n2;
        int n3 = 0xFF & n;
        switch (n3) {
            case 15: {
                n2 = 0;
                break;
            }
            case 16: {
                n2 = 2;
                break;
            }
            case 17: {
                n2 = 4;
                break;
            }
            case 18: {
                n2 = 11;
                break;
            }
            default: {
                n2 = n3;
            }
        }
        return n2;
    }

    public static int getSubType(int n) {
        return 0xF00 & n;
    }

    public static int getEffect(int n) {
        return 0xF000 & n;
    }

    public static int getSeriesType(int n) {
        return 0xFF0000 & n;
    }

    public static int[] getIndexOfBuildInTypes(int n) {
        int[] nArray = new int[]{-1, -1};
        block0: for (int i = 0; i < BUILTINTYPES.length; ++i) {
            int[] nArray2 = BUILTINTYPES[i];
            for (int j = 0; j < nArray2.length; ++j) {
                if (n != nArray2[j]) continue;
                nArray[0] = i;
                nArray[1] = j;
                continue block0;
            }
        }
        return nArray;
    }

    public static boolean isSparkLineChart(int n) {
        boolean bl = false;
        int n2 = 0xFF & n;
        if (n2 == 15 || n2 == 16 || n2 == 17 || n2 == 18) {
            bl = true;
        }
        return bl;
    }

    public static int getRealPrimType(int n) {
        return 0xFF & n;
    }
}

