/*
 * Decompiled with CFR 0.152.
 */
package chart.util;

import chart.ChartComponent;
import chart.ChartCoordinatePaper;
import chart.ChartLabel;
import chart.ChartPlatform;
import chart.ChartPropertyValues;
import chart.axis.ChartAxis;
import chart.axis.ChartCategoryAxis;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.data.ChartDataFilter;
import chart.data.ChartDataSetModel;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartFillPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartShading;
import chart.graphics.ChartTextStyle;
import chart.graphics.ChartTexturePattern;
import chart.properties.ChartLineProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class ChartRenderTools {
    public static final int NORTH = 0;
    public static final int EAST = 1;
    public static final int SOUTH = 2;
    public static final int WEST = 3;
    public static final int NONE = 4;
    public static final int margine = 0;
    public static String platformKey = "CHARTPLATFORM";
    public static String paperKey = "CHARTCOORDINATEPAPER";
    public static String legendKey = "CHARTLEGEND";
    public static String labelKey = "CHARTLABEL";
    public static String CategoryKey = "CATEGORIES";
    public static String SeriesKey = "SERIES";
    public static String ValueKey = "VALUES";
    public static String lineNodeKey = "CHARTLINENODE";
    public static String conditionalKey = "CHARTCONDITIONAL";
    public static String conditionalShowValueInfoKey = "SHOWVALUEINFO";
    public static String conditionalFillByRangeKey = "CONDITIONALFILLBYRANGE";
    public static String conditionalFillByExpressionKey = "CONDITIONALFILLBYEXPRESSION";
    public static String conditionalExpressionIndexListKey = "CONDITIONALEXPRESSIONINDEXLIST";
    public static String conditionalLineByExpressionKey = "CONDITIONALLINEBYEXPRESSION";
    public static String conditionalLineExpressionIndexListKey = "CONDITIONALLINEEXPRESSIONINDEXLIST";
    public static String allCategoryNamesKey = "CATEGORYALLNAMES";
    public static String allSeriesNamesKey = "SERIESALLNAMES";
    public static final String DELIM = "\u0007";
    private static final String HighLightPattern = "" + (char)("\u0007".charAt(0) + '\u0001');

    public static Rectangle2D getStringBounds(String string, FontRenderContext fontRenderContext, Font font) {
        if (string == null || string.length() <= 0) {
            return new Rectangle2D.Float();
        }
        Rectangle2D rectangle2D = font.getStringBounds(string, fontRenderContext);
        LineMetrics lineMetrics = font.getLineMetrics(string, fontRenderContext);
        rectangle2D.setRect(rectangle2D.getX(), rectangle2D.getY(), Math.ceil(rectangle2D.getWidth()), lineMetrics.getHeight());
        return rectangle2D;
    }

    public static Rectangle2D getStringBounds(String string, Font font) {
        if (string == null || string.length() == 0) {
            return new Rectangle2D.Float();
        }
        FontRenderContext fontRenderContext = new FontRenderContext(font.getTransform(), false, true);
        return font.getStringBounds(string, fontRenderContext);
    }

    public static Rectangle cutRectangle(Rectangle rectangle, Rectangle rectangle2, int n) {
        Rectangle rectangle3 = new Rectangle();
        switch (n) {
            case 0: {
                rectangle3.x = rectangle.x + 0;
                rectangle3.y = rectangle.y + rectangle2.height + 0;
                rectangle3.width = rectangle.width - 0;
                rectangle3.height = rectangle.height - rectangle2.height - 0;
                break;
            }
            case 2: {
                rectangle3.x = rectangle.x + 0;
                rectangle3.y = rectangle.y + 0;
                rectangle3.width = rectangle.width - 0;
                rectangle3.height = rectangle.height - rectangle2.height - 0;
                break;
            }
            case 3: {
                rectangle3.x = rectangle2.x + rectangle2.width + 0;
                rectangle3.y = rectangle.y + 0;
                rectangle3.width = rectangle.width - 0 - rectangle2.width;
                rectangle3.height = rectangle.height - 0;
                break;
            }
            case 1: {
                rectangle3.x = rectangle.x + 0;
                rectangle3.y = rectangle.y + 0;
                rectangle3.width = rectangle.width - rectangle2.width - 0;
                rectangle3.height = rectangle.height - 0;
            }
        }
        return rectangle3;
    }

    public static Vector getCoordFromPath(GeneralPath generalPath) {
        Vector<Point> vector = new Vector<Point>();
        float[] fArray2 = new float[6];
        PathIterator pathIterator = generalPath.getPathIterator(new AffineTransform());
        while (!pathIterator.isDone()) {
            pathIterator.currentSegment(fArray2);
            int n = (int)fArray2[0];
            int n2 = (int)fArray2[1];
            Point point = new Point();
            point.setLocation(n, n2);
            vector.add(point);
            pathIterator.next();
        }
        return vector;
    }

    public static Rectangle calculateTitleAutoPos(Rectangle rectangle, ChartLabel chartLabel, int n) {
        String string = chartLabel.getText();
        if (string == null || string.length() == 0) {
            string = "Title";
        }
        Rectangle2D rectangle2D = ChartRenderTools.getStringBounds(string, chartLabel.getChartTextStyle().getFont());
        int n2 = (int)rectangle2D.getWidth();
        int n3 = (int)rectangle2D.getHeight();
        int n4 = 0;
        int n5 = 0;
        if (chartLabel.getIcon() != null && !chartLabel.getIcon().isNoIcon()) {
            n4 = chartLabel.getIconHeight();
            n5 = chartLabel.getIconWidth();
            int n6 = (int)chartLabel.getIconTextGap();
            switch (chartLabel.getIconAlignment()) {
                case 6: 
                case 7: {
                    n2 = n2 > n4 ? n2 : n4;
                    n3 += n6 + n5;
                    break;
                }
                case 0: 
                case 2: 
                case 3: 
                case 5: {
                    n2 += n6 + n4;
                    n3 += n5;
                    break;
                }
                case 1: 
                case 4: {
                    n3 = n3 > n5 ? n3 : n5;
                    n2 += n4;
                    break;
                }
            }
        }
        Rectangle rectangle2 = new Rectangle();
        switch (n) {
            case 4: {
                break;
            }
            case 3: {
                rectangle2.width = n3 + 6;
                rectangle2.height = n2 + 12;
                rectangle2.x = rectangle.x + 0;
                rectangle2.y = rectangle.y + (rectangle.height - rectangle2.width) / 2;
                break;
            }
            case 0: {
                rectangle2.width = n2 + 6;
                rectangle2.height = n3 + 6;
                rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
                rectangle2.y = rectangle.y + 0;
                break;
            }
            case 2: {
                rectangle2.width = n2 + 12;
                rectangle2.height = n3 + 6;
                rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
                rectangle2.y = rectangle.y + rectangle.height - rectangle2.height - 0;
                break;
            }
            case 1: {
                rectangle2.width = n3 + 6;
                rectangle2.height = n2 + 12;
                rectangle2.x = rectangle.x + rectangle.width - rectangle2.width - 0;
                rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
            }
        }
        return rectangle2;
    }

    public static ChartDataFilter mapChartDataFilter(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM);
        int n = stringTokenizer.countTokens();
        ChartDataFilter chartDataFilter = null;
        if (string != null && n > 0) {
            chartDataFilter = new ChartDataFilter();
            Vector<Object[]> vector = new Vector<Object[]>();
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                Object[] objectArray = new Object[]{new Integer(Integer.valueOf(string2.substring(0, 1))), string2.substring(1)};
                vector.add(objectArray);
            }
            chartDataFilter.setFilters(vector);
        }
        return chartDataFilter;
    }

    public static ChartDataFilter[] mapChartDataFilters(String string) {
        if (string == null) {
            return new ChartDataFilter[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, HighLightPattern);
        int n = stringTokenizer.countTokens();
        ChartDataFilter[] chartDataFilterArray = null;
        if (n > 0) {
            chartDataFilterArray = new ChartDataFilter[n];
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                chartDataFilterArray[i] = ChartRenderTools.mapChartDataFilter(string2);
            }
        }
        return chartDataFilterArray;
    }

    public static String mapFilterString(ChartDataFilter chartDataFilter) {
        String string = "";
        if (chartDataFilter != null) {
            for (int i = 0; i < chartDataFilter.getFilters().size(); ++i) {
                if (i != 0) {
                    string = string + DELIM;
                }
                Object[] objectArray = (Object[])chartDataFilter.getFilters().get(i);
                string = string + objectArray[0].toString() + objectArray[1].toString();
            }
        }
        return string;
    }

    public static String mapChartDataFilterList(ChartDataFilter[] chartDataFilterArray) {
        int n;
        String string = "";
        if (chartDataFilterArray != null && (n = 0) < chartDataFilterArray.length) {
            if (n != 0) {
                string = string + HighLightPattern;
            }
            return ChartRenderTools.mapFilterString(chartDataFilterArray[n]);
        }
        return string;
    }

    public static ChartFillPattern mapFillPattern(String string) {
        ChartFillPattern chartFillPattern = null;
        switch (string.charAt(0)) {
            case 'C': 
            case 'c': {
                String string2 = string.substring(1, 9);
                Color color = !string2.equals("No_Color") ? ChartRenderTools.mapStringToColor(string2) : null;
                chartFillPattern = new ChartColorPattern(color);
                String string3 = string.substring(9);
                float f = (float)Integer.valueOf(string3).intValue() / 100.0f;
                chartFillPattern.setAlpha(f);
                break;
            }
            case 'T': 
            case 't': {
                String string4 = string.charAt(1) != '0' ? string.substring(1, 3) : string.substring(1, 3);
                int n = Integer.valueOf(string4);
                String string5 = string.substring(3, 11);
                Color color = !string5.equals("No_Color") ? ChartRenderTools.mapStringToColor(string5) : null;
                String string6 = string.substring(11, 19);
                Color color2 = !string6.equals("No_Color") ? ChartRenderTools.mapStringToColor(string6) : null;
                chartFillPattern = new ChartTexturePattern(n, new ChartColorPattern(color), new ChartColorPattern(color2));
                String string7 = string.substring(19);
                float f = (float)Integer.valueOf(string7).intValue() / 100.0f;
                ((ChartTexturePattern)chartFillPattern).setAlpha(f);
                break;
            }
            case 'G': 
            case 'g': {
                String string8 = string.substring(1, 3);
                int n = Integer.valueOf(string8);
                String string9 = string.substring(3, 11);
                Color color = !string9.equals("No_Color") ? ChartRenderTools.mapStringToColor(string9) : null;
                String string10 = string.substring(11, 19);
                Color color3 = !string10.equals("No_Color") ? ChartRenderTools.mapStringToColor(string10) : null;
                String string11 = string.substring(19, 22);
                float f = (float)Integer.valueOf(string11).intValue() / 100.0f;
                String string12 = string.substring(22, 25);
                float f2 = 1.0f - (float)Integer.valueOf(string12).intValue() / 100.0f;
                String string13 = string.substring(25, 28);
                float f3 = (float)Integer.valueOf(string13).intValue() / 100.0f;
                String string14 = string.substring(28, 31);
                float f4 = 1.0f - (float)Integer.valueOf(string14).intValue() / 100.0f;
                String string15 = string.substring(31);
                chartFillPattern = new ChartGradientPattern(n);
                ((ChartGradientPattern)chartFillPattern).setStartColor(new ChartColorPattern(color));
                ((ChartGradientPattern)chartFillPattern).setEndColor(new ChartColorPattern(color3));
                ((ChartGradientPattern)chartFillPattern).setStartPoint(new Point2D.Float(f, f2));
                ((ChartGradientPattern)chartFillPattern).setEndPoint(new Point2D.Float(f3, f4));
                float f5 = (float)Integer.valueOf(string15).intValue() / 100.0f;
                ((ChartGradientPattern)chartFillPattern).setAlpha(f5);
                break;
            }
            case 'N': 
            case 'n': {
                chartFillPattern = null;
            }
        }
        return chartFillPattern;
    }

    public static ChartFillPattern[] mapPatterns(String string) {
        if (string == null) {
            return new ChartFillPattern[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM);
        int n = stringTokenizer.countTokens();
        ChartFillPattern[] chartFillPatternArray = null;
        if (n > 0) {
            chartFillPatternArray = new ChartFillPattern[n];
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                chartFillPatternArray[i] = ChartRenderTools.mapFillPattern(string2);
            }
        }
        return chartFillPatternArray;
    }

    public static String mapPatternString(ChartFillPattern chartFillPattern) {
        String string;
        Object object;
        String string2 = "";
        if (chartFillPattern == null) {
            string2 = string2 + "n";
        } else if (chartFillPattern instanceof ChartColorPattern) {
            string2 = string2 + "c";
            Color color = ((ChartColorPattern)chartFillPattern).getColor();
            string2 = color != null ? string2 + ChartRenderTools.mapColorToString(color) : string2 + "No_Color";
        } else if (chartFillPattern instanceof ChartTexturePattern) {
            string2 = string2 + "t";
            object = (ChartTexturePattern)chartFillPattern;
            int n = ((ChartTexturePattern)object).getPattern();
            string = "";
            if (n < 10) {
                string = "0";
            }
            string = string + String.valueOf(new Integer(n));
            Color color = ((ChartTexturePattern)object).getForeground().getColor();
            String string3 = color != null ? ChartRenderTools.mapColorToString(color) : "No_Color";
            Color color2 = ((ChartTexturePattern)object).getBackground().getColor();
            String string4 = color2 != null ? ChartRenderTools.mapColorToString(color2) : "No_Color";
            string2 = string2 + string + string3 + string4;
        } else if (chartFillPattern instanceof ChartGradientPattern) {
            string2 = string2 + "g";
            object = (ChartGradientPattern)chartFillPattern;
            int n = ((ChartGradientPattern)object).getPattern();
            string = "";
            if (n < 10) {
                string = "0";
            }
            string = string + String.valueOf(new Integer(n));
            Color color = ((ChartGradientPattern)object).getStartColor().getColor();
            String string5 = color != null ? ChartRenderTools.mapColorToString(color) : "No_Color";
            Color color3 = ((ChartGradientPattern)object).getEndColor().getColor();
            String string6 = color3 != null ? ChartRenderTools.mapColorToString(color3) : "No_Color";
            int n2 = (int)(((ChartGradientPattern)object).getStartPoint().getX() * 100.0);
            int n3 = (int)((1.0 - ((ChartGradientPattern)object).getStartPoint().getY()) * 100.0);
            int n4 = (int)(((ChartGradientPattern)object).getEndPoint().getX() * 100.0);
            int n5 = (int)((1.0 - ((ChartGradientPattern)object).getEndPoint().getY()) * 100.0);
            String string7 = "";
            if (n2 < 10) {
                string7 = "00";
            } else if (n2 < 100) {
                string7 = "0";
            }
            string7 = string7 + String.valueOf(new Integer(n2));
            String string8 = "";
            if (n4 < 10) {
                string8 = "00";
            } else if (n4 < 100) {
                string8 = "0";
            }
            string8 = string8 + String.valueOf(new Integer(n4));
            String string9 = "";
            if (n3 < 10) {
                string9 = "00";
            } else if (n3 < 100) {
                string9 = "0";
            }
            string9 = string9 + String.valueOf(new Integer(n3));
            String string10 = "";
            if (n5 < 10) {
                string10 = "00";
            } else if (n5 < 100) {
                string10 = "0";
            }
            string10 = string10 + String.valueOf(new Integer(n5));
            string2 = string2 + string + string5 + string6 + string7 + string9 + string8 + string10;
        }
        if (chartFillPattern != null) {
            object = "";
            int n = (int)(chartFillPattern.getAlpha() * 100.0f);
            if (n < 10) {
                object = "00";
            } else if (n < 100) {
                object = "0";
            }
            object = (String)object + String.valueOf(new Integer(n));
            string2 = string2 + (String)object;
        }
        return string2;
    }

    public static String mapPatternList(ChartFillPattern[] chartFillPatternArray) {
        String string = "";
        if (chartFillPatternArray != null) {
            for (int i = 0; i < chartFillPatternArray.length; ++i) {
                if (i != 0) {
                    string = string + DELIM;
                }
                ChartRenderTools.mapPatternString(chartFillPatternArray[i]);
            }
        }
        return string;
    }

    public static String mapColorToString(Color color) {
        String string;
        if (color == null) {
            string = "Transparent";
        } else {
            string = "0x";
            String string2 = Integer.toHexString(color.getRed());
            String string3 = Integer.toHexString(color.getGreen());
            String string4 = Integer.toHexString(color.getBlue());
            if (string2.length() < 2) {
                string2 = "0" + string2;
            }
            if (string3.length() < 2) {
                string3 = "0" + string3;
            }
            if (string4.length() < 2) {
                string4 = "0" + string4;
            }
            string = string + string2 + string3 + string4;
        }
        return string;
    }

    public static Color mapStringToColor(String string) {
        if (string != null) {
            if (string.length() > 2 && string.substring(0, 2).equals("0x")) {
                return new Color(Integer.parseInt(string.substring(2), 16));
            }
            if (string.equals("Transparent")) {
                return null;
            }
        }
        return null;
    }

    public static void setFontSpecialEffect1(ChartTextStyle chartTextStyle, int n) {
        switch (n) {
            case 1: {
                chartTextStyle.toggleEmbossed();
                break;
            }
            case 2: {
                chartTextStyle.toggleEngraved();
                break;
            }
            case 3: {
                chartTextStyle.toggleShadowed();
                break;
            }
            case 4: {
                chartTextStyle.toggleOutlined();
                break;
            }
            case 5: {
                chartTextStyle.toggleShadowed();
                chartTextStyle.toggleOutlined();
            }
        }
    }

    public static void setFontSpecialEffect2(ChartTextStyle chartTextStyle, int n) {
        switch (n) {
            case 1: {
                chartTextStyle.toggleSuperscript();
                break;
            }
            case 2: {
                chartTextStyle.toggleSubscript();
            }
        }
    }

    public static float[] mapRotationMatrix(String string) {
        if (string == null) {
            return new float[0];
        }
        float[] fArray2 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, DELIM);
        int n = stringTokenizer.countTokens();
        if (n > 0) {
            fArray2 = new float[n];
            for (int i = 0; i < n; ++i) {
                String string2 = stringTokenizer.nextToken();
                fArray2[i] = Float.parseFloat(string2);
            }
        }
        return fArray2;
    }

    public static float[][] formatMinorTickMark(float[][] fArray2, float[][] fArray3, float f) {
        float[][] fArray4;
        if (fArray2 == null || fArray3 == null) {
            return null;
        }
        int n = fArray2.length;
        boolean bl = false;
        boolean bl2 = false;
        if (!bl && !bl2) {
            fArray4 = new float[n - 1][2];
        } else if (bl && bl2) {
            fArray4 = new float[n + 1][2];
            fArray4[n - 1] = ChartRenderTools.CategoryKey(fArray2[0], fArray3[0], f);
            fArray4[n] = ChartRenderTools.CategoryKey(fArray2[n - 1], fArray3[1], f);
        } else {
            fArray4 = new float[n][2];
            fArray4[n - 1] = bl ? ChartRenderTools.CategoryKey(fArray2[0], fArray3[0], f) : ChartRenderTools.CategoryKey(fArray2[n - 1], fArray3[1], f);
        }
        for (int i = 0; i < n - 1; ++i) {
            fArray4[i][0] = (fArray2[i][0] + fArray2[i + 1][0]) / 2.0f;
            fArray4[i][1] = (fArray2[i][1] + fArray2[i + 1][1]) / 2.0f;
        }
        return fArray4;
    }

    private static float[] CategoryKey(float[] fArray2, float[] fArray3, float f) {
        float[] fArray4 = new float[2];
        float f2 = (float)Math.sqrt(Math.pow(fArray2[1] - fArray3[1], 2.0) + Math.pow(fArray2[0] - fArray3[0], 2.0));
        float f3 = (f2 - f) / f2;
        fArray4[0] = fArray2[0] + f3 * (fArray3[0] - fArray2[0]);
        fArray4[1] = fArray2[1] + f3 * (fArray3[1] - fArray2[1]);
        return fArray4;
    }

    public static ChartDataFilter constructPercentFilter(ChartDataFilter chartDataFilter, boolean bl) {
        if (chartDataFilter == null || chartDataFilter.getFilters().size() == 0) {
            chartDataFilter = new ChartDataFilter();
            if (bl) {
                ChartPropertyValues.addFilter(chartDataFilter, 1, "0.00%");
            } else {
                ChartPropertyValues.addFilter(chartDataFilter, 1, "0%");
            }
        } else {
            chartDataFilter = new ChartDataFilter((Vector)((Vector)chartDataFilter.getFilters()).clone());
            List list = chartDataFilter.getFilters();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = (Object[])list.get(i);
                if ((Integer)objectArray[0] != 1) continue;
                Object[] objectArray2 = new Object[]{new Integer(1), bl ? "0.00%" : "0%"};
                list.set(i, objectArray2);
            }
            chartDataFilter.init();
        }
        return chartDataFilter;
    }

    public static ChartColorPattern getSelectAreaFillColor() {
        ChartColorPattern chartColorPattern = new ChartColorPattern(new Color(255, 171, 63));
        chartColorPattern.setAlpha(0.7f);
        return chartColorPattern;
    }

    public static ChartPenStyle getSelectAreaPen() {
        ChartPenStyle chartPenStyle = new ChartPenStyle(new ChartColorPattern(new Color(255, 171, 63)));
        chartPenStyle.setPenWidth(1.0f);
        return chartPenStyle;
    }

    public static float[][][] divide(float[][] fArray2, float[] fArray3) {
        float[][][] fArray4 = null;
        if (fArray3 != null && fArray2 != null && fArray2.length == 4) {
            fArray4 = new float[fArray3.length][4][2];
            float f = fArray2[3][0] - fArray2[0][0];
            float f2 = fArray2[3][1] - fArray2[0][1];
            for (int i = 0; i < fArray3.length; ++i) {
                float[][] fArray5 = new float[4][2];
                if (i == 0) {
                    fArray5[0][0] = fArray2[0][0];
                    fArray5[0][1] = fArray2[0][1];
                    fArray5[1][0] = fArray2[1][0];
                    fArray5[1][1] = fArray2[1][1];
                    fArray5[2][0] = fArray5[1][0] + f * fArray3[i];
                    fArray5[2][1] = fArray5[1][1] + f2 * fArray3[i];
                    fArray5[3][0] = fArray5[0][0] + f * fArray3[i];
                    fArray5[3][1] = fArray5[0][1] + f2 * fArray3[i];
                    fArray4[i] = fArray5;
                    continue;
                }
                fArray5[0][0] = fArray4[i - 1][0][0];
                fArray5[0][1] = fArray4[i - 1][0][1];
                fArray5[1][0] = fArray4[i - 1][1][0];
                fArray5[1][0] = fArray4[i - 1][1][1];
                fArray5[2][0] = fArray5[1][0] + f * fArray3[i];
                fArray5[2][1] = fArray5[1][1] + f2 * fArray3[i];
                fArray5[3][0] = fArray5[0][0] + f * fArray3[i];
                fArray5[3][1] = fArray5[0][1] + f2 * fArray3[i];
                fArray4[i] = fArray5;
            }
        }
        return fArray4;
    }

    public static Shape[] getBarPath(float[][] fArray2, double d, float f, float f2, boolean bl, boolean bl2) {
        GeneralPath[] generalPathArray = null;
        if (fArray2 != null && fArray2.length == 4) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(fArray2[0][0], fArray2[0][1]);
            generalPath.lineTo(fArray2[1][0], fArray2[1][1]);
            generalPath.lineTo(fArray2[2][0], fArray2[2][1]);
            generalPath.lineTo(fArray2[3][0], fArray2[3][1]);
            generalPath.closePath();
            generalPathArray = new GeneralPath[6];
            generalPathArray[0] = generalPath;
        }
        return generalPathArray;
    }

    public static void fillCylindarFace(Graphics2D graphics2D, boolean bl, ChartFillPattern chartFillPattern, Shape shape) {
        if (chartFillPattern == null || shape == null) {
            return;
        }
        if (chartFillPattern instanceof ChartColorPattern) {
            if (!bl) {
                ChartGradientPattern chartGradientPattern = new ChartGradientPattern(1, true, (ChartColorPattern)ChartShading.HighLightPattern(chartFillPattern, 40), new Point2D.Float(0.28f, 0.5f), (ChartColorPattern)ChartShading.HighLightPattern(chartFillPattern, -25), new Point2D.Float(0.98f, 0.5f));
                chartGradientPattern.fill(graphics2D, shape);
            } else {
                ChartGradientPattern chartGradientPattern = new ChartGradientPattern(1, true, (ChartColorPattern)ChartShading.HighLightPattern(chartFillPattern, 50), new Point2D.Float(0.5f, 0.72f), (ChartColorPattern)ChartShading.HighLightPattern(chartFillPattern, -25), new Point2D.Float(0.5f, 0.02f));
                chartGradientPattern.fill(graphics2D, shape);
            }
        } else {
            chartFillPattern.fill(graphics2D, shape);
        }
    }

    public static Shape getNormalBarItemFace(float[][] fArray2) {
        GeneralPath generalPath = new GeneralPath();
        if (fArray2 != null && fArray2.length == 4) {
            generalPath.moveTo(fArray2[0][0], fArray2[0][1]);
            generalPath.lineTo(fArray2[1][0], fArray2[1][1]);
            generalPath.lineTo(fArray2[2][0], fArray2[2][1]);
            generalPath.lineTo(fArray2[3][0], fArray2[3][1]);
            generalPath.closePath();
            return generalPath;
        }
        return generalPath;
    }

    public static Shape getDepthBarFontFace(float[][] fArray2, float f, float f2, boolean bl) {
        GeneralPath generalPath = new GeneralPath();
        if (fArray2 != null && fArray2.length == 4) {
            float f3 = f;
            float f4 = -f2;
            generalPath.moveTo(fArray2[0][0] - f3, fArray2[0][1] - f4);
            generalPath.lineTo(fArray2[1][0] - f3, fArray2[1][1] - f4);
            generalPath.lineTo(fArray2[2][0] - f3, fArray2[2][1] - f4);
            generalPath.lineTo(fArray2[3][0] - f3, fArray2[3][1] - f4);
            generalPath.closePath();
        }
        return generalPath;
    }

    public static Shape getDepthBarTopFace(float[][] fArray2, float f, float f2, boolean bl, boolean bl2) {
        GeneralPath generalPath = new GeneralPath();
        if (fArray2 != null && fArray2.length == 4) {
            float f3;
            float f4;
            if (!bl) {
                f4 = f;
                f3 = -f2;
            } else {
                f3 = -f2;
                f4 = f;
            }
            if (!bl2) {
                generalPath.moveTo(fArray2[3][0], fArray2[3][1]);
                generalPath.lineTo(fArray2[2][0], fArray2[2][1]);
                generalPath.lineTo(fArray2[2][0] - f4, fArray2[2][1] - f3);
                generalPath.lineTo(fArray2[3][0] - f4, fArray2[3][1] - f3);
                generalPath.closePath();
            } else {
                generalPath.moveTo(fArray2[1][0], fArray2[1][1]);
                generalPath.lineTo(fArray2[0][0], fArray2[0][1]);
                generalPath.lineTo(fArray2[0][0] - f4, fArray2[0][1] - f3);
                generalPath.lineTo(fArray2[1][0] - f4, fArray2[1][1] - f3);
                generalPath.closePath();
            }
        }
        return generalPath;
    }

    public static Shape getDepthBarRightFace(float[][] fArray2, float f, float f2, boolean bl, boolean bl2) {
        GeneralPath generalPath = new GeneralPath();
        if (fArray2 != null && fArray2.length == 4) {
            float f3;
            float f4;
            if (!bl) {
                f4 = f;
                f3 = -f2;
            } else {
                f3 = -f2;
                f4 = f;
            }
            generalPath.moveTo(fArray2[1][0], fArray2[1][1]);
            generalPath.lineTo(fArray2[2][0], fArray2[2][1]);
            generalPath.lineTo(fArray2[2][0] - f4, fArray2[2][1] - f3);
            generalPath.lineTo(fArray2[1][0] - f4, fArray2[1][1] - f3);
            generalPath.closePath();
        }
        return generalPath;
    }

    static float[][] HighLightPattern(float[][] fArray2, double d, float f, float f2, boolean bl, boolean bl2) {
        float[][] fArray3 = null;
        if (fArray2 != null && fArray2.length == 4) {
            double d2 = -d;
            if (!bl) {
                double d3 = fArray2[3][1] - fArray2[0][1];
                double d4 = Math.abs(fArray2[0][0] - fArray2[1][0]);
                double d5 = d4 / 2.0;
                double d6 = f2 / 2.0f;
                double d7 = (float)Math.tan(d2);
                double d8 = Math.atan(d7 * d6 / d5);
                double d9 = (double)fArray2[0][0] + d5 - (double)(f / 2.0f);
                double d10 = (double)fArray2[0][1] + d6;
                int n = (int)((d5 + d6) * 2.0);
                n = n < 16 ? 16 : n;
                float[][] fArray4 = new float[n + 2][2];
                for (int i = 0; i < fArray4.length; ++i) {
                    double d11 = d8 + (double)(i * 2) * Math.PI / (double)fArray4.length;
                    fArray4[i][0] = (float)(d5 * Math.cos(d11));
                    fArray4[i][1] = (float)(d6 * Math.sin(d11));
                    float[] fArray5 = fArray4[i];
                    fArray5[0] = fArray5[0] + (float)((double)fArray4[i][1] * Math.tan(d2));
                    float[] fArray6 = fArray4[i];
                    fArray6[0] = (float)((double)fArray6[0] + d9);
                    float[] fArray7 = fArray4[i];
                    fArray7[1] = (float)((double)fArray7[1] + d10);
                    if (!bl2) continue;
                    float[] fArray8 = fArray4[i];
                    fArray8[1] = (float)((double)fArray8[1] + d3);
                }
                fArray3 = fArray4;
            } else {
                d2 = 1.5707963267948966 - d;
                double d12 = fArray2[3][0] - fArray2[0][0];
                double d13 = Math.abs(fArray2[0][1] - fArray2[1][1]);
                double d14 = d13 / 2.0;
                double d15 = f / 2.0f;
                double d16 = 1.0f / (float)Math.tan(d2);
                double d17 = Math.atan(-d16 * d14 / d15);
                double d18 = (double)fArray2[0][0] - d15;
                float f3 = fArray2[0][1] > fArray2[1][1] ? fArray2[0][1] : fArray2[1][1];
                double d19 = (double)(f3 + f2 / 2.0f) - d14;
                int n = (int)((d14 + d15) * 2.0);
                n = n < 16 ? 16 : n;
                float[][] fArray9 = new float[n + 2][2];
                for (int i = 0; i < fArray9.length; ++i) {
                    double d20 = d17 + (double)(i * 2) * Math.PI / (double)fArray9.length;
                    fArray9[i][0] = (float)(d15 * Math.cos(d20));
                    fArray9[i][1] = (float)(d14 * Math.sin(d20));
                    float[] fArray10 = fArray9[i];
                    fArray10[1] = fArray10[1] - (float)((double)fArray9[i][0] * Math.tan(d2));
                    float[] fArray11 = fArray9[i];
                    fArray11[0] = (float)((double)fArray11[0] + d18);
                    float[] fArray12 = fArray9[i];
                    fArray12[1] = (float)((double)fArray12[1] + d19);
                    if (!bl2) continue;
                    float[] fArray13 = fArray9[i];
                    fArray13[0] = (float)((double)fArray13[0] + d12);
                }
                fArray3 = fArray9;
            }
        }
        return fArray3;
    }

    public static Shape[] getCylindarFaces(float[][] fArray2, double d, float f, float f2, boolean bl, boolean bl2) {
        GeneralPath[] generalPathArray = null;
        float[][] fArray3 = ChartRenderTools.HighLightPattern(fArray2, d, f, f2, bl, bl2);
        if (fArray3 != null) {
            GeneralPath generalPath = new GeneralPath();
            GeneralPath generalPath2 = new GeneralPath();
            GeneralPath generalPath3 = new GeneralPath();
            float f3 = 0.0f;
            f3 = !bl ? fArray2[3][1] - fArray2[0][1] : fArray2[3][0] - fArray2[0][0];
            if (bl2) {
                f3 = -f3;
            }
            int n = fArray3.length / 2;
            int n2 = fArray3.length;
            generalPath2.moveTo(fArray3[0][0], fArray3[0][1]);
            generalPath.moveTo(fArray3[0][0], fArray3[0][1]);
            if (bl) {
                generalPath.moveTo(fArray3[n][0], fArray3[n][1]);
            }
            if (!bl) {
                generalPath3.moveTo(fArray3[0][0], fArray3[0][1] + f3);
            } else {
                generalPath3.moveTo(fArray3[0][0] + f3, fArray3[0][1]);
            }
            for (int i = 0; i < fArray3.length; ++i) {
                generalPath2.lineTo(fArray3[i][0], fArray3[i][1]);
                if (!bl) {
                    generalPath3.lineTo(fArray3[i][0], fArray3[i][1] + f3);
                } else {
                    generalPath3.lineTo(fArray3[i][0] + f3, fArray3[i][1]);
                }
                if (i <= n) {
                    if (!bl) {
                        generalPath.lineTo(fArray3[i][0], fArray3[i][1]);
                    } else {
                        generalPath.lineTo(fArray3[i + n - 1][0], fArray3[i + n - 1][1]);
                    }
                    if (i != n) continue;
                    if (!bl) {
                        generalPath.lineTo(fArray3[i][0], fArray3[i][1] + f3);
                        continue;
                    }
                    generalPath.lineTo(fArray3[0][0] + f3, fArray3[0][1]);
                    continue;
                }
                if (!bl) {
                    generalPath.lineTo(fArray3[n2 - i][0], fArray3[n2 - i][1] + f3);
                    continue;
                }
                generalPath.lineTo(fArray3[i - n][0] + f3, fArray3[i - n][1]);
            }
            if (bl) {
                generalPath.lineTo(fArray3[n][0], fArray3[n][1]);
            }
            generalPath.closePath();
            generalPath3.closePath();
            generalPath2.closePath();
            generalPathArray = new GeneralPath[]{generalPath, generalPath3, generalPath2};
        } else {
            boolean bl3 = false;
        }
        return generalPathArray;
    }

    public static Shape getCylindarDrawShape(float[][] fArray2, double d, float f, float f2, boolean bl, boolean bl2) {
        float[][] fArray3 = ChartRenderTools.HighLightPattern(fArray2, d, f, f2, bl, bl2);
        GeneralPath generalPath = new GeneralPath();
        if (fArray3 != null) {
            GeneralPath generalPath2 = new GeneralPath();
            GeneralPath generalPath3 = new GeneralPath();
            GeneralPath generalPath4 = new GeneralPath();
            float f3 = 0.0f;
            f3 = !bl ? fArray2[3][1] - fArray2[0][1] : fArray2[3][0] - fArray2[0][0];
            if (bl2) {
                f3 = -f3;
            }
            int n = fArray3.length / 2;
            int n2 = fArray3.length;
            if (!bl) {
                generalPath2.moveTo(fArray3[0][0], fArray3[0][1]);
                generalPath3.moveTo(fArray3[0][0], fArray3[0][1] + f3);
                generalPath4.moveTo(fArray3[0][0], fArray3[0][1]);
                generalPath4.lineTo(fArray3[0][0], fArray3[0][1] + f3);
                generalPath4.moveTo(fArray3[n][0], fArray3[n][1]);
                generalPath4.lineTo(fArray3[n][0], fArray3[n][1] + f3);
            } else {
                generalPath2.moveTo(fArray3[n][0], fArray3[n][1]);
                generalPath3.moveTo(fArray3[0][0] + f3, fArray3[0][1]);
                generalPath4.moveTo(fArray3[0][0] + f3, fArray3[0][1]);
                generalPath4.lineTo(fArray3[0][0], fArray3[0][1]);
                generalPath4.moveTo(fArray3[n][0], fArray3[n][1]);
                generalPath4.lineTo(fArray3[n][0] + f3, fArray3[n][1]);
            }
            for (int i = 0; i < fArray3.length; ++i) {
                if (!bl) {
                    generalPath3.lineTo(fArray3[i][0], fArray3[i][1] + f3);
                    if (i > n) continue;
                    generalPath2.lineTo(fArray3[i][0], fArray3[i][1]);
                    continue;
                }
                generalPath3.lineTo(fArray3[i][0] + f3, fArray3[i][1]);
                if (i <= n) continue;
                generalPath2.lineTo(fArray3[i][0], fArray3[i][1]);
            }
            generalPath3.closePath();
            generalPath.append(generalPath3, false);
            generalPath.append(generalPath2, false);
            generalPath.append(generalPath4, false);
        }
        return generalPath;
    }

    public static Shape getCylindarDesignFace(float[][] fArray2, double d, float f, float f2, boolean bl, boolean bl2) {
        GeneralPath generalPath = new GeneralPath();
        float[][] fArray3 = ChartRenderTools.HighLightPattern(fArray2, d, f, f2, bl, bl2);
        if (fArray3 != null) {
            float f3 = 0.0f;
            f3 = !bl ? fArray2[3][1] - fArray2[0][1] : fArray2[3][0] - fArray2[0][0];
            if (bl2) {
                f3 = -f3;
            }
            int n = fArray3.length / 2;
            generalPath.moveTo(fArray3[0][0], fArray3[0][1]);
            if (!bl) {
                generalPath.lineTo(fArray3[n / 2][0], fArray3[n / 2][1]);
                generalPath.lineTo(fArray3[n][0], fArray3[n][1]);
                generalPath.lineTo(fArray3[n][0], fArray3[n][1] + f3);
                generalPath.lineTo(fArray3[n / 2][0], fArray3[n / 2][1] + f3);
                generalPath.lineTo(fArray3[0][0], fArray3[0][1] + f3);
            } else {
                generalPath.lineTo(fArray3[n / 2][0], fArray3[n / 2][1]);
                generalPath.lineTo(fArray3[n][0], fArray3[n][1]);
                generalPath.lineTo(fArray3[n][0] + f3, fArray3[n][1]);
                generalPath.lineTo(fArray3[n / 2][0] + f3, fArray3[n / 2][1]);
                generalPath.lineTo(fArray3[0][0] + f3, fArray3[0][1]);
            }
            generalPath.closePath();
        }
        return generalPath;
    }

    public static Shape getCylindarItemFaces(float[][] fArray2, double d, float f, float f2, boolean bl, boolean bl2) {
        GeneralPath generalPath = new GeneralPath();
        float[][] fArray3 = ChartRenderTools.HighLightPattern(fArray2, d, f, f2, bl, bl2);
        if (fArray3 != null) {
            float f3 = 0.0f;
            f3 = !bl ? fArray2[3][1] - fArray2[0][1] : fArray2[3][0] - fArray2[0][0];
            int n = fArray3.length / 2;
            int n2 = fArray3.length;
            generalPath.moveTo(fArray3[0][0], fArray3[0][1]);
            if (bl) {
                generalPath.moveTo(fArray3[n][0], fArray3[n][1]);
            }
            for (int i = 0; i < fArray3.length; ++i) {
                if (i <= n) {
                    if (!bl) {
                        generalPath.lineTo(fArray3[i][0], fArray3[i][1]);
                    } else {
                        generalPath.lineTo(fArray3[i + n - 1][0], fArray3[i + n - 1][1]);
                    }
                    if (i != n) continue;
                    if (!bl) {
                        generalPath.lineTo(fArray3[i][0], fArray3[i][1] + f3);
                        continue;
                    }
                    generalPath.lineTo(fArray3[0][0] + f3, fArray3[0][1]);
                    continue;
                }
                if (!bl) {
                    generalPath.lineTo(fArray3[n2 - i][0], fArray3[n2 - i][1] + f3);
                    continue;
                }
                generalPath.lineTo(fArray3[n2 - (i - n)][0] + f3, fArray3[n2 - (i - n)][1]);
            }
            generalPath.closePath();
        }
        return generalPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void paintDropDownList(Graphics2D graphics2D, int n, int n2, int n3, int n4, Color color, Color color2, Font font, String string) {
        Component component;
        if (n < 0 || n2 < 0) {
            return;
        }
        JComboBox<String> jComboBox = new JComboBox<String>();
        if (string != null) {
            jComboBox.addItem("1234");
        }
        jComboBox.setBackground(color);
        jComboBox.setForeground(color);
        jComboBox.setFont(font);
        jComboBox.setAlignmentX(0.0f);
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(n, n2, n3, n4);
        jComboBox.setBounds(n, n2, n3, n4);
        JLabel jLabel = new JLabel(string);
        jLabel.setBounds(n, n2, n3, n4);
        jLabel.setAlignmentX(0.0f);
        jLabel.setForeground(color2);
        jLabel.setFont(font);
        try {
            jComboBox.paint(graphics2D2);
            jLabel.paint(graphics2D2);
        }
        finally {
            graphics2D2.dispose();
        }
        int n5 = 0;
        while ((component = jComboBox.getComponent(n5)) != null && !(component instanceof AbstractButton)) {
            ++n5;
        }
        if (component != null) {
            n5 = n + n3 - n4 - 1;
            int n6 = n2 + 1;
            int n7 = n5 < n ? 0 : n4;
            int n8 = n4 - 2 < n2 ? 0 : n4 - 2;
            component.setBounds(n5, n6, n7, n8);
            graphics2D2 = (Graphics2D)graphics2D.create(n5, n6, n7, n8);
            try {
                component.paint(graphics2D2);
            }
            finally {
                graphics2D2.dispose();
            }
        }
    }

    public static ChartFillPattern highLight(ChartFillPattern chartFillPattern, int n) {
        ChartFillPattern chartFillPattern2 = null;
        if (chartFillPattern != null) {
            Color color = null;
            Color color2 = null;
            if (chartFillPattern instanceof ChartColorPattern) {
                color = ((ChartColorPattern)chartFillPattern).getColor();
                chartFillPattern2 = (ChartColorPattern)chartFillPattern.clone();
                ((ChartColorPattern)chartFillPattern2).setColor(ChartRenderTools.KEY_ANTIALIASING(color, n));
            } else if (chartFillPattern instanceof ChartGradientPattern) {
                chartFillPattern2 = (ChartGradientPattern)chartFillPattern.clone();
                color = ((ChartGradientPattern)chartFillPattern).getStartColor() == null ? null : ((ChartGradientPattern)chartFillPattern).getStartColor().getColor();
                Color color3 = color2 = ((ChartGradientPattern)chartFillPattern).getEndColor() == null ? null : ((ChartGradientPattern)chartFillPattern).getEndColor().getColor();
                if (((ChartGradientPattern)chartFillPattern2).getStartColor() != null) {
                    ((ChartGradientPattern)chartFillPattern2).getStartColor().setColor(ChartRenderTools.KEY_ANTIALIASING(color, n));
                }
                if (((ChartGradientPattern)chartFillPattern2).getEndColor() != null) {
                    ((ChartGradientPattern)chartFillPattern2).getEndColor().setColor(ChartRenderTools.KEY_ANTIALIASING(color2, n));
                }
            } else if (chartFillPattern instanceof ChartTexturePattern) {
                chartFillPattern2 = (ChartTexturePattern)chartFillPattern.clone();
                color = ((ChartTexturePattern)chartFillPattern).getForeground() == null ? null : ((ChartTexturePattern)chartFillPattern).getForeground().getColor();
                Color color4 = color2 = ((ChartTexturePattern)chartFillPattern).getBackground() == null ? null : ((ChartTexturePattern)chartFillPattern).getBackground().getColor();
                if ((ChartTexturePattern)chartFillPattern2 != null) {
                    ((ChartTexturePattern)chartFillPattern2).getForeground().setColor(ChartRenderTools.KEY_ANTIALIASING(color, n));
                }
                if (((ChartTexturePattern)chartFillPattern2).getBackground() != null) {
                    ((ChartTexturePattern)chartFillPattern2).getBackground().setColor(ChartRenderTools.KEY_ANTIALIASING(color2, n));
                }
            }
        }
        return chartFillPattern2;
    }

    static Color KEY_ANTIALIASING(Color color, int n) {
        if (color != null) {
            int n2 = color.getRGB();
            int n3 = color.getAlpha();
            int n4 = n2 >> 16 & 0xFF;
            int n5 = n2 >> 8 & 0xFF;
            int n6 = n2 & 0xFF;
            int n7 = n >= 0 ? 1 : 0;
            n = Math.abs(n);
            n4 = (n4 * (100 - n) + n7 * 255 * n) / 100;
            n5 = (n5 * (100 - n) + n7 * 255 * n) / 100;
            n6 = (n6 * (100 - n) + n7 * 255 * n) / 100;
            return new Color(n4, n5, n6, n3);
        }
        return null;
    }

    public static void drawZomBut(Graphics2D graphics2D, Rectangle rectangle, boolean bl, boolean bl2) {
        if (graphics2D == null || rectangle == null) {
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ChartGradientPattern chartGradientPattern = null;
        ChartGradientPattern chartGradientPattern2 = null;
        ChartColorPattern chartColorPattern = null;
        ChartPenStyle chartPenStyle = new ChartPenStyle();
        chartPenStyle.setPenWidth(2.0f);
        GeneralPath generalPath = null;
        chartGradientPattern = new ChartGradientPattern(0, false, new ChartColorPattern(new Color(244, 244, 244)), new Point2D.Float(0.0f, 0.03f), new ChartColorPattern(new Color(212, 212, 216)), new Point2D.Float(0.0f, 1.0f));
        chartGradientPattern2 = new ChartGradientPattern(0, false, new ChartColorPattern(new Color(212, 212, 216)), new Point2D.Float(0.0f, 0.0f), new ChartColorPattern(new Color(207, 207, 209)), new Point2D.Float(0.0f, 0.97f));
        chartGradientPattern.fill(graphics2D2, new Rectangle(0, 0, rectangle.width, rectangle.height / 2));
        chartGradientPattern2.fill(graphics2D2, new Rectangle(0, rectangle.height / 2, rectangle.width, rectangle.height / 2));
        ChartPenStyle chartPenStyle2 = new ChartPenStyle(new ChartColorPattern(new Color(155, 155, 155)));
        chartPenStyle2.setPenWidth(3.0f);
        chartPenStyle2.draw(graphics2D2, new Rectangle(0, 0, rectangle.width, rectangle.height));
        if (bl && bl2) {
            chartColorPattern = new ChartColorPattern(new Color(94, 94, 94));
            chartPenStyle.setPenColor(chartColorPattern);
            chartPenStyle.setPenWidth(3.0f);
            generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(rectangle.width, 0.0f);
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(0.0f, rectangle.height);
            chartPenStyle.draw(graphics2D2, generalPath);
        }
        chartPenStyle.setPenColor(new ChartColorPattern(new Color(96, 96, 96)));
        float f = rectangle.width > rectangle.height ? (float)(rectangle.height / 4) : (float)(rectangle.width / 4);
        int n = rectangle.width / 6;
        int n2 = rectangle.width / 3 + n;
        int n3 = 3;
        Area area = new Area();
        Arc2D.Float float_ = new Arc2D.Float((float)(rectangle.width / 2) - f + (float)n, (float)(rectangle.height / 2) - f, 2.0f * f, 2.0f * f, -90.0f, 180.0f, 2);
        Arc2D.Float float_2 = new Arc2D.Float((float)(rectangle.width / 2) - f + (float)n3 + (float)n, (float)(rectangle.height / 2) - f + (float)n3, 2.0f * f - (float)(2 * n3), 2.0f * f - (float)(2 * n3), -90.0f, 180.0f, 2);
        Rectangle2D.Float float_3 = new Rectangle2D.Float(rectangle.width / 2 - n2 + n, (float)(rectangle.height / 2) - f, n2, 2.0f * f);
        Rectangle2D.Float float_4 = new Rectangle2D.Float(rectangle.width / 2 - n2 + n, (float)(rectangle.height / 2) - f + (float)n3, n2, 2.0f * f - (float)(2 * n3));
        area.add(new Area(float_3));
        area.add(new Area(float_));
        area.subtract(new Area(float_4));
        area.subtract(new Area(float_2));
        chartGradientPattern = new ChartGradientPattern(0, false, new ChartColorPattern(new Color(155, 155, 155)), new Point2D.Float(0.0f, 0.03f), new ChartColorPattern(new Color(121, 121, 121)), new Point2D.Float(0.0f, 0.95f));
        chartGradientPattern.fill(graphics2D2, area);
        generalPath = new GeneralPath();
        generalPath.moveTo((float)(rectangle.width / 2) - f + (float)n, (float)(rectangle.height / 2) - f + (float)(n3 / 2));
        generalPath.lineTo((float)(rectangle.width / 2) - f + (float)n, (float)(rectangle.height / 2) - f + (float)(n3 / 2) - 5.0f);
        generalPath.lineTo((float)(rectangle.width / 2) - f + (float)n - 8.0f, (float)(rectangle.height / 2) - f + (float)(n3 / 2));
        generalPath.lineTo((float)(rectangle.width / 2) - f + (float)n, (float)(rectangle.height / 2) - f + (float)(n3 / 2) + 5.0f);
        generalPath.closePath();
        chartGradientPattern.fill(graphics2D2, generalPath);
    }

    public static ChartPenStyle getZomOutButPen() {
        ChartColorPattern chartColorPattern = new ChartColorPattern(new Color(76, 76, 76));
        ChartPenStyle chartPenStyle = new ChartPenStyle();
        chartPenStyle.setPenColor(chartColorPattern);
        chartPenStyle.setPenWidth(3.0f);
        return chartPenStyle;
    }

    public static void drawLegendScrButton(Graphics2D graphics2D, Rectangle rectangle, float f, float f2) {
        if (rectangle == null) {
            return;
        }
        if (f2 >= 1.0f) {
            return;
        }
        if (rectangle.width < 1 || rectangle.height < 1) {
            return;
        }
        try {
            Rectangle rectangle2 = (Rectangle)rectangle.clone();
            Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
            int n = rectangle2.height / 2;
            n = n > 16 ? 16 : n;
            Rectangle rectangle3 = new Rectangle(0, 0, rectangle2.width, rectangle2.height);
            Rectangle rectangle4 = new Rectangle(0, 0, rectangle2.width, n);
            Rectangle rectangle5 = new Rectangle(0, 0 + rectangle2.height - n, rectangle2.width, n);
            GeneralPath generalPath = new GeneralPath();
            if (rectangle4.width >= 6 && rectangle4.height >= 6) {
                generalPath.moveTo((float)rectangle4.x + (float)rectangle4.width / 2.0f, (float)rectangle4.y + (float)rectangle4.height / 2.0f - 2.0f);
                generalPath.lineTo((float)rectangle4.x + (float)rectangle4.width / 2.0f - 4.0f, (float)rectangle4.y + (float)rectangle4.height / 2.0f + 2.0f);
                generalPath.lineTo((float)rectangle4.x + (float)rectangle4.width / 2.0f + 4.0f, (float)rectangle4.y + (float)rectangle4.height / 2.0f + 2.0f);
                generalPath.closePath();
            }
            GeneralPath generalPath2 = new GeneralPath();
            if (rectangle5.width >= 6 && rectangle5.height >= 6) {
                generalPath2.moveTo((float)rectangle5.x + (float)rectangle5.width / 2.0f, (float)rectangle5.y + (float)rectangle4.height / 2.0f + 2.0f);
                generalPath2.lineTo((float)rectangle5.x + (float)rectangle5.width / 2.0f - 4.0f, (float)rectangle5.y + (float)rectangle5.height / 2.0f - 2.0f);
                generalPath2.lineTo((float)rectangle5.x + (float)rectangle5.width / 2.0f + 4.0f, (float)rectangle5.y + (float)rectangle5.height / 2.0f - 2.0f);
                generalPath2.closePath();
            }
            RoundRectangle2D.Float float_ = null;
            if (rectangle3.height - n * 2 > 4) {
                float f3 = rectangle3.height - 2 * n;
                float_ = new RoundRectangle2D.Float(rectangle3.x, (float)(rectangle3.y + n) + f3 * f, rectangle3.width - 1, f3 * f2, 2.0f, 2.0f);
            }
            ChartColorPattern chartColorPattern = new ChartColorPattern(new Color(241, 241, 241));
            ChartGradientPattern chartGradientPattern = new ChartGradientPattern(1, true, new ChartColorPattern(new Color(242, 242, 242)), new Point2D.Float(0.05f, 0.5f), new ChartColorPattern(new Color(180, 180, 180)), new Point2D.Float(0.96f, 0.5f));
            ChartGradientPattern chartGradientPattern2 = new ChartGradientPattern(1, true, new ChartColorPattern(new Color(56, 56, 56)), new Point2D.Float(0.2f, 0.3f), new ChartColorPattern(new Color(200, 200, 200)), new Point2D.Float(1.0f, 1.0f));
            chartColorPattern.fill(graphics2D2, rectangle3);
            chartGradientPattern.fill(graphics2D2, rectangle4);
            chartGradientPattern.fill(graphics2D2, rectangle5);
            chartGradientPattern2.fill(graphics2D2, generalPath);
            chartGradientPattern2.fill(graphics2D2, generalPath2);
            if (float_ != null) {
                chartGradientPattern.fill(graphics2D2, float_);
                ChartPenStyle chartPenStyle = new ChartPenStyle(new ChartColorPattern(new Color(166, 166, 166)));
                chartPenStyle.setPenWidth(1.0f);
                chartPenStyle.draw(graphics2D2, float_);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static int[] getPieTable(float f, float f2, float f3, int n) {
        int n2 = 0;
        int n3 = 0;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        for (int i = n; i >= 1; --i) {
            for (int j = n; j >= 1; --j) {
                if (i * j < n) continue;
                f5 = n;
                f5 /= (float)(i * j);
                f7 = f2 / (float)i;
                f6 = f / (float)j;
                if (f7 * f7 * (1.0f / f3) / (f6 * f7) < 1.0f) {
                    f5 *= f7 * f7 * (1.0f / f3) / (f6 * f7);
                } else if (f6 * f6 * f3 / (f6 * f7) < 1.0f) {
                    f5 *= f6 * f6 * f3 / (f6 * f7);
                }
                if (!(f5 > f4)) continue;
                f4 = f5;
                n2 = i;
                n3 = j;
            }
        }
        int[] nArray = new int[]{n2, n3};
        return nArray;
    }

    public static void drawChartLine(ChartLineProperties chartLineProperties, Graphics2D graphics2D, Shape shape) {
        if (shape == null || graphics2D == null || chartLineProperties == null) {
            return;
        }
        int n = -1;
        switch (chartLineProperties.getLineStyle()) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 1;
                break;
            }
            case 4: {
                n = 4;
            }
        }
        ChartPenStyle chartPenStyle = new ChartPenStyle(n, new ChartColorPattern(chartLineProperties.getLineColor()));
        chartPenStyle.setPenWidth(chartLineProperties.getThickness());
        chartPenStyle.draw(graphics2D, shape);
    }

    public static int convertPixelToUnit(int n, int n2) {
        return (int)Math.round((double)n * 5760.0 / (double)n2);
    }

    public static int convertUnitToPixel(int n, int n2) {
        return (int)Math.round((double)n * (double)n2 / 5760.0);
    }

    public static void drawChartLine(ChartLineProperties chartLineProperties, Graphics2D graphics2D, List list, int n) {
        if (list == null || graphics2D == null || chartLineProperties == null) {
            return;
        }
        int n2 = -1;
        switch (chartLineProperties.getLineStyle()) {
            case 1: {
                n2 = 0;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 4;
            }
        }
        ChartPenStyle chartPenStyle = new ChartPenStyle(n2, new ChartColorPattern(chartLineProperties.getLineColor()));
        chartPenStyle.setPenWidth(chartLineProperties.getThickness());
        for (int i = 0; i < list.size(); i += 2) {
            Point point = (Point)list.get(i);
            Point point2 = (Point)list.get(i + 1);
            Line2D.Float float_ = new Line2D.Float(ChartRenderTools.convertUnitToPixel(point.x, n), ChartRenderTools.convertUnitToPixel(point.y, n), ChartRenderTools.convertUnitToPixel(point2.x, n), ChartRenderTools.convertUnitToPixel(point2.y, n));
            chartPenStyle.draw(graphics2D, float_);
        }
    }

    public static void drawLegendExtButton(Graphics2D graphics2D, Rectangle rectangle, boolean bl) {
        if (rectangle == null) {
            return;
        }
        Graphics2D graphics2D2 = (Graphics2D)graphics2D.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath generalPath = new GeneralPath();
        if (bl) {
            generalPath.moveTo(3.0f, 3.0f);
            generalPath.lineTo(15.0f, 9.0f);
            generalPath.lineTo(3.0f, 15.0f);
            generalPath.closePath();
        } else {
            generalPath.moveTo(15.0f, 3.0f);
            generalPath.lineTo(3.0f, 9.0f);
            generalPath.lineTo(15.0f, 15.0f);
            generalPath.closePath();
        }
        ChartColorPattern chartColorPattern = new ChartColorPattern(new Color(127, 127, 127));
        chartColorPattern.fill(graphics2D2, generalPath);
    }

    public static float[] getScrollInfo(ChartCoordinatePaper chartCoordinatePaper, Rectangle rectangle) {
        if (rectangle == null || chartCoordinatePaper == null) {
            return new float[]{0.0f, 1.0f};
        }
        if (!(chartCoordinatePaper instanceof Chart2DPaper)) {
            return new float[]{0.0f, 1.0f};
        }
        Chart2DPaper chart2DPaper = (Chart2DPaper)chartCoordinatePaper;
        float[] fArray2 = new float[]{0.0f, 1.0f};
        Vector vector = chart2DPaper.getCharts();
        for (int i = 0; i < vector.size(); ++i) {
            if (vector.get(i) == null) continue;
            int n = -1;
            int n2 = -1;
            Shape[][] shapeArray = chart2DPaper.getItemShapes(i);
            if (shapeArray == null || shapeArray.length <= 0) continue;
            for (int j = 0; j < shapeArray.length; ++j) {
                if (shapeArray[j] == null) continue;
                int n3 = 0;
                while (n3 < shapeArray[j].length) {
                    if (shapeArray[j][n3] == null) {
                        // empty if block
                    }
                    ++j;
                }
            }
        }
        return fArray2;
    }

    public static Rectangle getGraphArea(Rectangle rectangle, ChartCoordinatePaper chartCoordinatePaper) {
        if (chartCoordinatePaper == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Rectangle rectangle2 = (Rectangle)rectangle.clone();
        Rectangle rectangle3 = chartCoordinatePaper.getBounds();
        if (chartCoordinatePaper instanceof Chart2DPaper && chartCoordinatePaper.getProperties() != null) {
            float f = chartCoordinatePaper.getProperties().getScaleX();
            float f2 = chartCoordinatePaper.getProperties().getScaleY();
            float f3 = rectangle2.x + rectangle2.width / 2;
            float f4 = rectangle2.y + rectangle2.height / 2;
            rectangle2.x = (int)(f3 -= (float)rectangle2.width * f / 2.0f);
            rectangle2.y = (int)(f4 -= (float)rectangle2.height * f2 / 2.0f);
            rectangle2.x += rectangle3.x;
            rectangle2.y += rectangle3.y;
            rectangle2.width = (int)((float)rectangle2.width * f);
            rectangle2.height = (int)((float)rectangle2.height * f2);
            if (chartCoordinatePaper.getProperties().getGraphProperties().isUseDepth()) {
                double d = Math.sin(Math.PI / 180 * (double)chartCoordinatePaper.getProperties().getGraphProperties().getDepthDirection());
                double d2 = chartCoordinatePaper.getProperties().getGraphProperties().getDepth();
                rectangle2.height = (int)((double)rectangle2.height + d * d2);
            }
            return rectangle2;
        }
        rectangle2.x += rectangle3.x;
        rectangle2.y += rectangle3.y;
        return rectangle2;
    }

    public static float[] getScrollInfo(Rectangle rectangle, ChartCoordinatePaper chartCoordinatePaper, ChartDataSetModel chartDataSetModel) {
        float[] fArray2 = null;
        if (rectangle != null && chartCoordinatePaper != null && chartCoordinatePaper instanceof Chart2DPaper && chartDataSetModel != null && chartDataSetModel.getCategoryCount() > 0) {
            try {
                if (chartDataSetModel.getChartDataSets() != null && chartDataSetModel.getChartDataSets().size() >= 1) {
                    Chart2DObject chart2DObject = (Chart2DObject)((Chart2DPaper)chartCoordinatePaper).getCharts().get(0);
                    Shape[][] shapeArray = ((Chart2DPaper)chartCoordinatePaper).getItemShapes(0);
                    Rectangle rectangle2 = chartCoordinatePaper.getBounds();
                    Rectangle rectangle3 = (Rectangle)rectangle.clone();
                    rectangle3.x -= rectangle2.x;
                    rectangle3.y -= rectangle2.y;
                    int n = chart2DObject.getScrollLabelCount();
                    int n2 = -1;
                    int n3 = -1;
                    if (n <= 0) {
                        return fArray2;
                    }
                    if (shapeArray == null) {
                        return fArray2;
                    }
                    if (shapeArray.length <= 0) {
                        return fArray2;
                    }
                    for (int i = 0; i < shapeArray.length; ++i) {
                        Shape[] shapeArray2 = shapeArray[i];
                        if (shapeArray2 == null) continue;
                        for (int j = 0; j < shapeArray2.length; ++j) {
                            if (shapeArray2[j] == null || !rectangle3.intersects(shapeArray2[j].getBounds2D())) continue;
                            n2 = n2 == -1 ? j : n2;
                            n3 = n3 < j ? j : n3;
                        }
                    }
                    if (n2 != -1 && n3 != -1) {
                        float f = n2;
                        float f2 = n3 + 1;
                        float[] fArray3 = new float[]{f / (float)n, f2 / (float)n};
                        return fArray3;
                    }
                }
            }
            catch (Exception exception) {
                return new float[]{0.0f, 0.0f};
            }
        }
        return fArray2;
    }

    public static Rectangle getLegendArrowLoc(Rectangle rectangle, Rectangle rectangle2) {
        if (rectangle == null || rectangle2 == null) {
            return null;
        }
        int n = rectangle.width;
        int n2 = rectangle.height;
        int n3 = rectangle2.x;
        int n4 = rectangle2.y;
        int n5 = rectangle2.width;
        int n6 = rectangle2.height;
        Rectangle rectangle3 = new Rectangle();
        rectangle3.width = 22;
        rectangle3.height = 22;
        if (n3 >= 22 && n4 >= 22) {
            rectangle3.x = n3 - 22;
            rectangle3.y = n4 - 22;
        } else if (n3 >= 22) {
            rectangle3.x = n3 - 22;
            rectangle3.y = n4;
        } else if (n4 + n6 + 22 < n2) {
            rectangle3.x = n3;
            rectangle3.y = n4 + n6;
        } else {
            rectangle3.x = n3;
            rectangle3.y = n4;
        }
        return rectangle3;
    }

    public static Rectangle getComponetInnerBounds(ChartComponent chartComponent) {
        Rectangle rectangle = new Rectangle();
        if (chartComponent != null && chartComponent.getBackground() != null) {
            Rectangle rectangle2 = chartComponent.getBounds();
            ChartPenStyle chartPenStyle = chartComponent.getBackground().getPen();
            if (chartPenStyle != null) {
                int n = (int)chartPenStyle.getPenWidth();
                rectangle2.x += n;
                rectangle2.y += n;
                rectangle2.width -= 2 * n;
                rectangle2.height -= 2 * n;
            }
            rectangle.x = rectangle2.x;
            rectangle.y = rectangle2.y;
            rectangle.width = rectangle2.width;
            rectangle.height = rectangle2.height;
        } else if (chartComponent != null) {
            Rectangle rectangle3 = chartComponent != null ? chartComponent.getBounds() : new Rectangle();
            rectangle.x = rectangle3.x;
            rectangle.y = rectangle3.y;
            rectangle.width = rectangle3.width;
            rectangle.height = rectangle3.height;
        }
        return rectangle;
    }

    public static ChartColorPattern getColor(String string) {
        if (string == null) {
            ChartColorPattern chartColorPattern = new ChartColorPattern();
            chartColorPattern.setNoFill(true);
            return chartColorPattern;
        }
        try {
            Color color = null;
            String string2 = string.substring(2);
            int n = Integer.parseInt(string2, 16);
            color = new Color(n);
            return new ChartColorPattern(color);
        }
        catch (Exception exception) {
            ChartColorPattern chartColorPattern = new ChartColorPattern();
            chartColorPattern.setNoFill(true);
            return chartColorPattern;
        }
    }

    public static float[] getScrollInfo(ChartPlatform chartPlatform, float[] fArray2) {
        float[] fArray3 = null;
        ChartCoordinatePaper chartCoordinatePaper = chartPlatform.getChartCoordinatePaper();
        ChartDataSetModel chartDataSetModel = chartPlatform.getDataSetModel();
        ChartAxis chartAxis = chartCoordinatePaper.getAxisX1();
        if (chartAxis != null && chartAxis instanceof ChartCategoryAxis && ((ChartCategoryAxis)chartAxis).custommerConstant()) {
            return fArray2;
        }
        if (chartDataSetModel != null) {
            fArray3 = new float[2];
            int n = chartDataSetModel.getCategoryCount();
            if (n > 1) {
                float f = 1.0f;
                f /= (float)n;
                float f2 = fArray2[0];
                float f3 = fArray2[1];
                if (f3 % f > 0.0f) {
                    f3 += f - f3 % f;
                }
                fArray3[0] = f2;
                fArray3[1] = f3;
                return fArray3;
            }
        }
        return fArray2;
    }
}

