/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbDouble;
import jet.connect.DbValue;

public class DbDoubleColumnBuffer
extends DbColumnBuffer {
    double[] SEDU;
    boolean clearMem = false;

    public double[] getBuffer() {
        return this.SEDU;
    }

    public DbDoubleColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.SEDU = new double[n];
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        this.SEDU[n] = ((DbDouble)dbValue).get();
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbDouble)dbValue).set(this.SEDU[n]);
    }

    @Override
    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        for (int i = 0; i < this.SEDU.length; ++i) {
            dataOutput.writeDouble(this.SEDU[i]);
        }
    }

    @Override
    protected void readValueFromFile(DataInput dataInput) throws IOException {
        for (int i = 0; i < this.SEDU.length; ++i) {
            this.SEDU[i] = dataInput.readDouble();
        }
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.SEDU = null;
    }
}

