/*
 * Decompiled with CFR 0.152.
 */
package jet.connect;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import jet.connect.DbChar;
import jet.connect.DbColDesc;
import jet.connect.DbColumnBuffer;
import jet.connect.DbValue;

public class DbStringColumnBuffer
extends DbColumnBuffer {
    String[] SEDU;
    private final int clearMem;
    boolean equals = false;

    public String[] getBuffer() {
        return this.SEDU;
    }

    public DbStringColumnBuffer(DbColDesc dbColDesc, int n) {
        super(dbColDesc, n);
        this.SEDU = new String[n];
        if (dbColDesc.getEncodingName().equals("UTF8")) {
            this.equals = true;
        }
        this.clearMem = dbColDesc.getPrecision();
    }

    @Override
    public void updateCell(int n, DbValue dbValue) {
        this.SEDU[n] = ((DbChar)dbValue).get();
        if (this.SEDU[n] != null && this.SEDU[n].length() > this.clearMem) {
            this.SEDU[n] = this.SEDU[n].substring(0, this.clearMem);
        }
    }

    @Override
    public void refreshFromCell(int n, DbValue dbValue) {
        ((DbChar)dbValue).set(this.SEDU[n]);
    }

    @Override
    protected void writeValueToFile(DataOutput dataOutput) throws IOException {
        int n = this.C.getPrecision();
        for (int i = 0; i < this.SEDU.length; ++i) {
            byte[] byArray;
            if (this.isNull(i)) {
                dataOutput.writeInt(0);
                for (int j = 0; j < this.clearMem; ++j) {
                    dataOutput.write(0);
                }
                continue;
            }
            if (this.SEDU[i] == null) {
                this.SEDU[i] = "";
            }
            try {
                byArray = this.equals ? this.SEDU[i].getBytes("UTF8") : this.SEDU[i].getBytes();
            }
            catch (Exception exception) {
                byArray = new byte[]{};
            }
            if (byArray.length < n) {
                dataOutput.writeInt(byArray.length);
                dataOutput.write(byArray);
                int n2 = n - byArray.length;
                for (int j = 0; j < n2; ++j) {
                    dataOutput.write(0);
                }
                continue;
            }
            dataOutput.writeInt(n);
            dataOutput.write(byArray, 0, n);
        }
    }

    @Override
    protected void readValueFromFile(DataInput dataInput) throws IOException {
        int n = this.C.getPrecision();
        int n2 = 0;
        byte[] byArray = new byte[n];
        for (int i = 0; i < this.SEDU.length; ++i) {
            n2 = dataInput.readInt();
            dataInput.readFully(byArray);
            if (!this.isNull(i) && n2 != 0) {
                if (this.equals) {
                    this.SEDU[i] = new String(byArray, 0, n2, "UTF8");
                    continue;
                }
                this.SEDU[i] = new String(byArray, 0, n2);
                continue;
            }
            this.SEDU[i] = "";
        }
    }

    @Override
    public void clearMem() {
        super.clearMem();
        this.SEDU = null;
    }
}

