/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import guitools.toolkit.Unit;
import java.awt.Font;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbValue;
import jet.datastream.DSDataStreamable;
import jet.datastream.JRVisiableResult;
import jet.datastream.ParagraphTools;
import jet.util.FontSets;
import jet.util.VersionControlable;

public class DSParagraphText
extends JRVisiableResult {
    private String SEDU;
    private Font UTFLength = null;
    private Font add = null;
    private int addElement = 0;
    private int append = 0;
    private int[] clone;
    private boolean convertPixelToUnit = false;
    private boolean convertUnitToPixel = false;
    private boolean dup = false;
    private DbValue elementAt = null;
    private int getAfterWordWNum = 0;
    private int getBeforeWordWNum = 0;
    private int getErrorWidth = 0;
    private boolean getFont = false;
    private boolean getLeading = false;
    private Vector getText = new Vector();
    private int[] getTextBaseLineY;
    private int getVersion = -1;
    private int getWhiteSpaceNum = -1;
    private boolean getWidth = true;
    private int getWidthBeforeFirstDecimalUsePrecision = -1;
    private boolean getWrapPostionUsePrecision = false;
    private int lastBreakPos = 0;
    private boolean length = false;

    public DSParagraphText() {
    }

    public DSParagraphText(String string, Font font) {
        this.SEDU = string;
        this.UTFLength = font;
    }

    public DSParagraphText(String string, int n) {
        this.SEDU = string;
        this.UTFLength = this.SEDU(n);
    }

    public void setText(String string) {
        this.SEDU = string;
    }

    public String getText() {
        String string = this.append == 0 ? this.SEDU.substring(this.addElement) : this.SEDU.substring(this.addElement, this.append + this.addElement);
        if (this.getWrapPostionUsePrecision) {
            string = this.lastBreakPos > 2 && !this.length && string.length() > this.lastBreakPos - 2 ? string.substring(0, this.lastBreakPos - 2) + "..." : (this.lastBreakPos == 2 && !this.length ? string.substring(0, this.lastBreakPos - 1) + "..." : "");
        }
        return string;
    }

    public String getAllText() {
        return this.SEDU;
    }

    public void setFont(Font font) {
        this.UTFLength = font;
    }

    public void setFontWhenScript(Font font) {
        this.add = font;
    }

    public void setStartCharNum(int n) {
        this.addElement = n;
    }

    public int getStartCharNum() {
        return this.addElement;
    }

    public void setSplitWidth(int n) {
        this.append = n;
    }

    public int getSplitWidth() {
        return this.append;
    }

    public String getSplitText() {
        if (this.append == 0) {
            return this.SEDU.substring(this.addElement);
        }
        return this.SEDU.substring(this.addElement, this.append + this.addElement);
    }

    public int getTextWidth() {
        if (this.convertUnitToPixel) {
            return this.getWidth();
        }
        if (this.add == null) {
            return Unit.convertPixelToUnit(ParagraphTools.textWidthUsePrecision(this.getText(), this.UTFLength, this.getWidth));
        }
        return Unit.convertPixelToUnit(ParagraphTools.textWidthUsePrecision(this.getText(), this.add, this.getWidth));
    }

    public int getScriptTextH() {
        return Math.round(Unit.convertPixelToUnit(ParagraphTools.textHeightUsePrecision(this.getText(), this.add, this.getWidth)));
    }

    public int getTextHeight() {
        if (this.getVersion == -1 && this.UTFLength != null) {
            this.getVersion = Math.round(Unit.convertPixelToUnit(ParagraphTools.textHeightUsePrecision(this.getText(), this.UTFLength, this.getWidth)));
        }
        return this.getVersion;
    }

    public int getTextHeightWhenScript() {
        return Math.round(Unit.convertPixelToUnit(ParagraphTools.textHeightUsePrecision(this.getText(), this.UTFLength, this.getWidth)));
    }

    public int getBeforeDecimalWidth() {
        if (this.add == null) {
            return Unit.convertPixelToUnit(ParagraphTools.getWidthBeforeFirstDecimalUsePrecision(this.getText(), this.UTFLength, this.getWidth));
        }
        return Unit.convertPixelToUnit(ParagraphTools.getWidthBeforeFirstDecimalUsePrecision(this.getText(), this.add, this.getWidth));
    }

    public int[] getWrapPostion(int n) {
        if (this.add == null) {
            return ParagraphTools.getWrapPostionUsePrecision(this.getText(), this.UTFLength, Unit.convertUnitToPixel(n), this.getWidth);
        }
        return ParagraphTools.getWrapPostionUsePrecision(this.getText(), this.add, Unit.convertUnitToPixel(n), this.getWidth);
    }

    public int getWrapPostion() {
        return ParagraphTools.lastBreakPos(0, this.getText().length(), this.getText());
    }

    private Font SEDU(int n) {
        Font font = FontSets.getFont("Arial", 1, n);
        return font;
    }

    public Font getTextFont() {
        return this.UTFLength;
    }

    public Font getScriptFont() {
        return this.add;
    }

    public int getBeforeWordWNum() {
        return ParagraphTools.getBeforeWordWNum(this.getText());
    }

    public int getAfterWordWNum() {
        return ParagraphTools.getAfterWordWNum(this.getText());
    }

    public int getWhiteSpaceNum() {
        return ParagraphTools.getWhiteSpaceNum(this.getText());
    }

    public int[] getWhiteSpaceWidth() {
        return this.clone;
    }

    public void setWhitSpaceWidth(int[] nArray) {
        this.clone = new int[nArray.length];
        this.clone = nArray;
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        int n;
        int n2;
        super.readProperties(dataInput, dSDataStreamable);
        this.SEDU = dataInput.readUTF();
        this.addElement = dataInput.readInt();
        this.append = dataInput.readInt();
        this.convertUnitToPixel = dataInput.readBoolean();
        this.getAfterWordWNum = dataInput.readInt();
        this.getBeforeWordWNum = dataInput.readInt();
        this.getErrorWidth = dataInput.readInt();
        this.getFont = dataInput.readBoolean();
        this.getLeading = dataInput.readBoolean();
        if (dataInput.readBoolean() && (n2 = dataInput.readInt()) > 0) {
            this.clone = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.clone[n] = dataInput.readInt();
            }
        }
        if ((n2 = dataInput.readInt()) > 0) {
            this.getTextBaseLineY = new int[n2];
            for (n = 0; n < n2; ++n) {
                this.getText.add(dataInput.readUTF());
            }
            for (n = 0; n < n2; ++n) {
                this.getTextBaseLineY[n] = dataInput.readInt();
            }
        }
        this.getVersion = dataInput.readInt();
        n = ((VersionControlable)((Object)dataInput)).getVersion();
        if (n >= 263680 || n == 0) {
            this.getWrapPostionUsePrecision = dataInput.readBoolean();
            this.lastBreakPos = dataInput.readInt();
            this.length = dataInput.readBoolean();
        }
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        int n;
        super.writeProperties(dataOutput);
        dataOutput.writeUTF(this.SEDU);
        dataOutput.writeInt(this.addElement);
        dataOutput.writeInt(this.append);
        dataOutput.writeBoolean(this.convertUnitToPixel);
        dataOutput.writeInt(this.getAfterWordWNum);
        dataOutput.writeInt(this.getBeforeWordWNum);
        dataOutput.writeInt(this.getErrorWidth);
        dataOutput.writeBoolean(this.getFont);
        dataOutput.writeBoolean(this.getLeading);
        if (this.clone != null) {
            dataOutput.writeBoolean(true);
            dataOutput.writeInt(this.clone.length);
            for (n = 0; n < this.clone.length; ++n) {
                dataOutput.writeInt(this.clone[n]);
            }
        } else {
            dataOutput.writeBoolean(false);
        }
        n = this.getText.size();
        dataOutput.writeInt(n);
        if (n > 0) {
            int n2;
            for (n2 = 0; n2 < n; ++n2) {
                dataOutput.writeUTF((String)this.getText.elementAt(n2));
            }
            for (n2 = 0; n2 < n; ++n2) {
                dataOutput.writeInt(this.getTextBaseLineY[n2]);
            }
        }
        dataOutput.writeInt(this.getVersion);
        dataOutput.writeBoolean(this.getWrapPostionUsePrecision);
        dataOutput.writeInt(this.lastBreakPos);
        dataOutput.writeBoolean(this.length);
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        n += 2 + DSParagraphText.UTFLength(this.SEDU);
        n += 8;
        ++n;
        n += 4;
        n += 8;
        n += 2;
        if (this.clone != null) {
            ++n;
            n += (this.clone.length + 1) * 4;
        } else {
            ++n;
        }
        int n2 = this.getText.size();
        n += 4;
        if (n2 > 0) {
            int n3;
            for (n3 = 0; n3 < n2; ++n3) {
                n += 2 + DSParagraphText.UTFLength((String)this.getText.elementAt(n3));
            }
            for (n3 = 0; n3 < n2; ++n3) {
                n += 4;
            }
        }
        n += 4;
        ++n;
        n += 4;
        return ++n;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSParagraphText());
    }

    public DSParagraphText dup(DSParagraphText dSParagraphText) {
        super.dup(dSParagraphText);
        dSParagraphText.SEDU = this.SEDU;
        dSParagraphText.addElement = this.addElement;
        dSParagraphText.append = this.append;
        dSParagraphText.convertUnitToPixel = this.convertUnitToPixel;
        dSParagraphText.getAfterWordWNum = this.getAfterWordWNum;
        dSParagraphText.getBeforeWordWNum = this.getBeforeWordWNum;
        dSParagraphText.getErrorWidth = this.getErrorWidth;
        dSParagraphText.getLeading = this.getLeading;
        dSParagraphText.getFont = this.getFont;
        dSParagraphText.clone = this.clone == null ? null : (int[])this.clone.clone();
        dSParagraphText.getText = this.getText == null ? null : (Vector)this.getText.clone();
        dSParagraphText.getTextBaseLineY = this.getTextBaseLineY == null ? null : (int[])this.getTextBaseLineY.clone();
        dSParagraphText.getVersion = this.getVersion;
        dSParagraphText.UTFLength = this.UTFLength;
        dSParagraphText.add = this.add;
        dSParagraphText.getWrapPostionUsePrecision = this.getWrapPostionUsePrecision;
        dSParagraphText.lastBreakPos = this.lastBreakPos;
        dSParagraphText.length = this.length;
        return dSParagraphText;
    }

    public String getFormatText() {
        return this.getText();
    }

    public void setIsField(boolean bl) {
        this.convertPixelToUnit = bl;
    }

    public boolean getIsField() {
        return this.convertPixelToUnit;
    }

    public void setIsTab(boolean bl) {
        this.convertUnitToPixel = bl;
    }

    public boolean getIsTab() {
        return this.convertUnitToPixel;
    }

    public void setIsEnd(boolean bl) {
        this.dup = bl;
    }

    public boolean getIsEnd() {
        return this.dup;
    }

    public DbValue getDbValue() {
        return this.elementAt;
    }

    public void setDbValue(DbValue dbValue) {
        this.elementAt = dbValue;
    }

    public void setLineSpacing(int n) {
        this.getAfterWordWNum = n;
    }

    public int getLineSpacing() {
        return this.getAfterWordWNum;
    }

    public int getTextX() {
        return this.getBeforeWordWNum;
    }

    public int getTextY() {
        return this.getErrorWidth;
    }

    public int getTextBaseLineY() {
        if (this.getWhiteSpaceNum == -1) {
            this.getWhiteSpaceNum = (int)Unit.convertPixelToUnit(ParagraphTools.getTextBaseLineY(this.getText(), this.UTFLength));
        }
        return this.getWhiteSpaceNum;
    }

    public int getScriptBaseLineY() {
        return (int)Unit.convertPixelToUnit(ParagraphTools.getTextBaseLineY(this.getText(), this.add));
    }

    public int getTextLeading() {
        return (int)Unit.convertPixelToUnit(ParagraphTools.getLeading(this.getText(), this.UTFLength));
    }

    public int getScriptLeading() {
        return (int)Unit.convertPixelToUnit(ParagraphTools.getLeading(this.getText(), this.add));
    }

    public void setTextXY(int n, int n2) {
        this.getBeforeWordWNum = n;
        this.getErrorWidth = n2;
    }

    public void setScript(boolean bl, boolean bl2) {
        this.getFont = bl;
        this.getLeading = bl2;
    }

    public boolean getSuperscript() {
        return this.getFont;
    }

    public boolean getSubscript() {
        return this.getLeading;
    }

    public Vector getWords() {
        return this.getText;
    }

    public int[] getWordsPosition() {
        return this.getTextBaseLineY;
    }

    public void calculateJustifyWords() {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = true;
        int n3 = this.getText().length();
        Vector<String> vector = new Vector<String>();
        if (this.clone == null || this.clone.length == 0) {
            this.getText.add(this.getText());
            this.getTextBaseLineY = new int[1];
            this.getTextBaseLineY[0] = 0;
        } else {
            int n4;
            int n5;
            int n6;
            char[] cArray = this.getText().toCharArray();
            int n7 = 0;
            while (n7 < n3) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(cArray[n7]);
                int n8 = n7;
                if (cArray[n7] == ' ') {
                    ++n7;
                    for (n6 = n8 + 1; n6 < n3; ++n6) {
                        if (cArray[n6] == ' ') {
                            if (!bl2) break;
                            stringBuffer.append(cArray[n6]);
                            continue;
                        }
                        stringBuffer.append(cArray[n6]);
                        n7 = n6 + 1;
                        bl2 = false;
                    }
                    vector.add(stringBuffer.toString());
                    continue;
                }
                bl2 = false;
                for (n6 = n8 + 1; n6 < n3; ++n6) {
                    if (cArray[n6] == ' ') {
                        if (bl2) continue;
                        n7 = n6;
                        break;
                    }
                    stringBuffer.append(cArray[n6]);
                    n7 = n6 + 1;
                    bl2 = false;
                }
                vector.add(stringBuffer.toString());
            }
            n7 = vector.size();
            int n9 = ParagraphTools.getErrorWidth(this.getText(), vector, this.add != null ? this.add : this.UTFLength);
            int[] nArray = new int[n7];
            for (n6 = 0; n6 < n7; ++n6) {
                n5 = ParagraphTools.getWhiteSpaceNum((String)vector.elementAt(n6));
                for (n4 = 0; n4 < n5; ++n4) {
                    if (n2 + 1 <= this.clone.length) {
                        n += this.clone[n2];
                    }
                    ++n2;
                }
                nArray[n6] = n;
                n = n + this.add((String)vector.elementAt(n6)) - n9;
            }
            Vector<String> vector2 = new Vector<String>();
            n2 = 0;
            for (n5 = 0; n5 < n7; ++n5) {
                int n10;
                n4 = 0;
                int n11 = 0;
                StringBuffer stringBuffer = new StringBuffer();
                int n12 = ParagraphTools.getWhiteSpaceNum((String)vector.elementAt(n5));
                if (n5 == 0 && n12 > 0) {
                    for (n10 = 0; n10 < n12; ++n10) {
                        if (n2 + 1 <= this.clone.length) {
                            n4 += this.clone[n2];
                        }
                        ++n2;
                    }
                    n11 = Math.round(n4 / this.add(" "));
                    for (n10 = 0; n10 < n11; ++n10) {
                        stringBuffer.append(' ');
                    }
                    vector2.addElement(stringBuffer.toString());
                    if (n7 == 1) {
                        vector2.addElement((String)vector.elementAt(n5));
                        continue;
                    }
                    stringBuffer = new StringBuffer();
                    stringBuffer.append((String)vector.elementAt(n5));
                    n12 = ParagraphTools.getWhiteSpaceNum((String)vector.elementAt(n5 + 1));
                    for (n10 = 0; n10 < n12; ++n10) {
                        if (n2 + 1 <= this.clone.length) {
                            n4 += this.clone[n2];
                        }
                        ++n2;
                    }
                    n11 = Math.round(n4 / this.add(" ")) + 1;
                    for (n10 = 0; n10 < n11; ++n10) {
                        stringBuffer.append(' ');
                    }
                    vector2.addElement(stringBuffer.toString());
                    continue;
                }
                n4 = 0;
                stringBuffer = new StringBuffer();
                stringBuffer.append((String)vector.elementAt(n5));
                if (n5 == n7 - 1) {
                    vector2.addElement(stringBuffer.toString());
                    break;
                }
                n12 = ParagraphTools.getWhiteSpaceNum((String)vector.elementAt(n5 + 1));
                for (n10 = 0; n10 < n12; ++n10) {
                    if (n2 + 1 <= this.clone.length) {
                        n4 += this.clone[n2];
                    }
                    ++n2;
                }
                n11 = Math.round(n4 / this.add(" ")) + 1;
                for (n10 = 0; n10 < n11; ++n10) {
                    stringBuffer.append(' ');
                }
                vector2.addElement(stringBuffer.toString());
            }
            if (vector2.size() > vector.size()) {
                this.getTextBaseLineY = new int[vector2.size()];
                this.getTextBaseLineY[0] = 0;
                for (n5 = 0; n5 < nArray.length; ++n5) {
                    this.getTextBaseLineY[n5 + 1] = nArray[n5];
                }
                this.getText = (Vector)vector2.clone();
            } else {
                this.getTextBaseLineY = (int[])nArray.clone();
                this.getText = (Vector)vector2.clone();
            }
        }
    }

    private int add(String string) {
        if (this.add == null) {
            return Unit.convertPixelToUnit(ParagraphTools.textWidthUsePrecision(string, this.UTFLength, this.getWidth));
        }
        return Unit.convertPixelToUnit(ParagraphTools.textWidthUsePrecision(string, this.add, this.getWidth));
    }

    public void isHighPrecision(boolean bl) {
        this.getWidth = bl;
    }

    public boolean getPrecision() {
        return this.getWidth;
    }

    public int getQueryID() {
        return this.getWidthBeforeFirstDecimalUsePrecision;
    }

    public void setQueryID(int n) {
        this.getWidthBeforeFirstDecimalUsePrecision = n;
    }

    public void setNeedEllipsis(boolean bl) {
        this.getWrapPostionUsePrecision = bl;
    }

    public void setEllipsisIndex(int n) {
        this.lastBreakPos = n;
    }

    public void setIsNumber(boolean bl) {
        this.length = bl;
    }

    public boolean isNumber() {
        return this.length;
    }
}

