/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import guitools.Painter;
import guitools.PainterConstants;
import guitools.toolkit.Unit;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.FilterInputStream;
import java.io.IOException;
import jet.JRStopEngineException;
import jet.connect.DbBinary;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSTextObj;
import jet.datastream.JRVisiableResult;
import jet.util.BitmapReader;
import jet.util.Containable;
import jet.util.HashVector;
import jet.util.PictureFileFormatDetector;
import jet.util.Propertiable;
import jet.util.VersionControlable;

public class DSPicture
extends JRVisiableResult {
    private int DEFAULT_SHADOW_WIDTH = 0;
    private int SEDU;
    private int addImage;
    private int booleanValue = -1;

    public void setStretchHeight(int n) {
        this.DEFAULT_SHADOW_WIDTH = n;
    }

    public int getStretchHeight() {
        return this.DEFAULT_SHADOW_WIDTH;
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        this.DEFAULT_SHADOW_WIDTH = dataInput.readInt();
        if (dataInput instanceof VersionControlable) {
            int n;
            this.SEDU = n = ((VersionControlable)((Object)dataInput)).getVersion();
            if (n < 5 && n != 0) {
                this.DEFAULT_SHADOW_WIDTH = Unit.convertPixelToUnit(this.DEFAULT_SHADOW_WIDTH);
            }
            if (n >= 131098 || n == 0) {
                this.booleanValue = dataInput.readInt();
            }
        }
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        dataOutput.writeInt(this.DEFAULT_SHADOW_WIDTH);
        dataOutput.writeInt(this.booleanValue);
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        n += 4;
        return n += 4;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSPicture());
    }

    public DSPicture dup(DSPicture dSPicture) {
        super.dup(dSPicture);
        dSPicture.DEFAULT_SHADOW_WIDTH = this.DEFAULT_SHADOW_WIDTH;
        dSPicture.booleanValue = this.booleanValue;
        return dSPicture;
    }

    @Override
    public void paint(Graphics graphics) {
        Image image = null;
        if (this.getObjectType() == 128) {
            image = this.getImgResourceByPropertyName("PictureName").getImage();
            if (image != null) {
                graphics.drawImage(image, 0, 0, this.getBounds().width, this.getBounds().height, null);
            }
        } else {
            Propertiable propertiable = this.getPropertyByName("Background");
            Color color = propertiable == null ? null : (Color)propertiable.getObject();
            Color color2 = (Color)this.getPropertyByName("BorderColor").getObject();
            int n = (Integer)this.getPropertyByName("BorderWidth").getObject();
            int n2 = (Integer)this.getPropertyByName("TopLine").getObject();
            int n3 = (Integer)this.getPropertyByName("BottomLine").getObject();
            int n4 = (Integer)this.getPropertyByName("LeftLine").getObject();
            int n5 = (Integer)this.getPropertyByName("RightLine").getObject();
            boolean bl = (Boolean)this.getPropertyByName("Shadow").getObject();
            Color color3 = (Color)this.getPropertyByName("ShadowColor").getObject();
            String string = this.SEDU >= 262145 || this.SEDU == 0 ? (String)this.getPropertyByName("RuntimeColumnName").getObject() : (String)this.getPropertyByName("ColumnName").getObject();
            int n6 = this.getResolution();
            n = Unit.convertUnitToPixel(n, n6);
            int n7 = Unit.convertUnitToPixel(PainterConstants.DEFAULT_SHADOW_WIDTH, n6);
            Rectangle rectangle = this.getBounds();
            Painter.drawBorder(graphics, new Dimension(rectangle.width, rectangle.height), color, color2, n, n2, n3, n4, n5, bl, color3, n7);
            JRecord jRecord = this.getRecord();
            DbBinary dbBinary = (DbBinary)jRecord.getCell(string);
            if (!dbBinary.isNull()) {
                byte[] byArray = dbBinary.get();
                int n8 = (Integer)this.getPropertyByName("MediaType").getObject();
                if (byArray != null && byArray.length > 0) {
                    Object object;
                    MediaTracker mediaTracker;
                    block23: {
                        if (n8 == 2) {
                            n8 = PictureFileFormatDetector.getPictureFileType(byArray);
                        }
                        mediaTracker = new MediaTracker(new Container());
                        if (n8 == 4) {
                            image = Toolkit.getDefaultToolkit().createImage(byArray);
                        } else if (n8 == 0) {
                            image = Toolkit.getDefaultToolkit().createImage(byArray);
                        } else if (n8 == 3) {
                            image = Toolkit.getDefaultToolkit().createImage(byArray);
                        } else if (n8 == 1) {
                            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                            object = new DataInputStream(byteArrayInputStream);
                            BitmapReader bitmapReader = BitmapReader.loadFromBMP((DataInput)object);
                            if (bitmapReader != null) {
                                image = Toolkit.getDefaultToolkit().createImage(bitmapReader.getMemImgSrc());
                            }
                            try {
                                byteArrayInputStream.close();
                                ((FilterInputStream)object).close();
                            }
                            catch (IOException iOException) {
                                if (!JRLog.isError(2)) break block23;
                                JRLog.error(2, iOException);
                            }
                        }
                    }
                    if (image != null) {
                        block24: {
                            mediaTracker.addImage(image, 0);
                            try {
                                mediaTracker.waitForID(0);
                            }
                            catch (InterruptedException interruptedException) {
                                if (!JRLog.isError(2)) break block24;
                                JRLog.error(2, interruptedException);
                            }
                        }
                        int n9 = Unit.convertUnitToPixel(this.getStartYPos(), n6);
                        object = new Rectangle(0, -n9, rectangle.width, rectangle.height);
                        if (n4 != 0) {
                            int n10 = (n4 == 5 ? 3 : 1) * n;
                            ((Rectangle)object).x += n10;
                            ((Rectangle)object).width -= n10;
                        }
                        if (n2 != 0) {
                            int n11 = (n2 == 5 ? 3 : 1) * n;
                            ((Rectangle)object).y += n11;
                            ((Rectangle)object).height -= n11;
                        }
                        if (n5 != 0) {
                            ((Rectangle)object).width = ((Rectangle)object).width - (n5 == 5 ? 3 : 1) * n;
                        }
                        if (n3 != 0) {
                            ((Rectangle)object).height = ((Rectangle)object).height - (n3 == 5 ? 3 : 1) * n;
                        }
                        ((Rectangle)object).width = ((Rectangle)object).width - (bl ? n7 : 0);
                        ((Rectangle)object).height = ((Rectangle)object).height - (bl ? n7 : 0);
                        graphics.drawImage(image, ((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height, null);
                    }
                }
            }
        }
    }

    public int getTextObjParaFmtNO() {
        return this.booleanValue;
    }

    public void setTextObjParaFmtNO(int n) {
        this.booleanValue = n;
    }

    public HashVector getTextObjParaFmts() {
        Containable containable = this.getParent();
        if (this.booleanValue < 0 || containable == null || !(containable instanceof DSTextObj)) {
            return null;
        }
        return ((DSTextObj)containable).getParaFormat(this.booleanValue);
    }

    public int getImageTpye() {
        return this.addImage;
    }

    public void setImageTpye(int n) {
        this.addImage = n;
    }
}

