/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import com.jinfonet.util.JRLog;
import guitools.toolkit.Unit;
import java.awt.Font;
import java.awt.Graphics;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.connect.DbValue;
import jet.dataengine.api.DSException;
import jet.dataengine.api.dbbuffer.JDbBufferCursor;
import jet.dataengine.api.dbbuffer.JDbBufferData;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.DSBody;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSSubReport;
import jet.datastream.JRVisiableResult;
import jet.datastream.render.Render;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.RenderSlider;
import jet.datastream.render.RenderUtil;
import jet.datastream.util.SliderValueCollector;
import jet.util.DbValueFormat;
import jet.util.FontSets;
import jet.util.JRInterruptedException;
import jet.util.Propertiable;
import jet.util.ReportFormat;
import toolkit.db.gui.MappingSQLType;

public class DSSlider
extends JRVisiableResult {
    private Font SEDU = null;
    private List add = null;
    private List booleanValue = null;
    private SliderValueCollector calRangeThumbPosScale = new SliderValueCollector();
    private int cleanupSelectedValues = -1;

    @Override
    public void paint(Graphics graphics) {
        Render render = this.SEDU();
        render.paintFieldBackground(graphics);
        render.paint(graphics);
        render.setPaintCalledByField(false);
    }

    public Render getRender() {
        Render render = this.SEDU();
        return render;
    }

    public void setSpecfunIntervalUnit(int n) {
        this.cleanupSelectedValues = n;
    }

    private Render SEDU() {
        this.calRangeThumbPosScale.setTemplate(this.template);
        this.calRangeThumbPosScale.setLocale(this.getCommunicator().getLocale());
        RenderSlider renderSlider = new RenderSlider(this);
        this.add(renderSlider, this);
        return renderSlider;
    }

    private void add(RenderSlider renderSlider, DSSlider dSSlider) {
        int n = dSSlider.getResolution();
        renderSlider.setResolution(n);
        String string = RenderUtil.getPropertyByName(dSSlider, "FontFace").toString();
        int n2 = 0;
        if (!string.startsWith("*")) {
            if (((Boolean)RenderUtil.getPropertyByName(dSSlider, "Bold")).booleanValue()) {
                n2 |= 1;
            }
            if (((Boolean)RenderUtil.getPropertyByName(dSSlider, "Italic")).booleanValue()) {
                n2 |= 2;
            }
        }
        float f = ((Number)RenderUtil.getPropertyByName(dSSlider, "FontSize")).intValue();
        float f2 = Unit.convertUnitToPixel(f, n);
        if (n == 60) {
            if (f2 > (float)((int)f2)) {
                f2 += 1.0f;
            }
            renderSlider.setFont(RenderGraphicsToolkit.getFont(string, n2, (int)f2));
        } else {
            renderSlider.setFont(RenderGraphicsToolkit.getFont(string, n2, f2));
        }
        renderSlider.locate();
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        this.cleanupSelectedValues = dataInput.readInt();
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        dataOutput.writeInt(this.cleanupSelectedValues);
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        return n += 4;
    }

    public int getSliderType() {
        return (Integer)this.getPropertyByName("SliderType").getObject();
    }

    public String formatValue(DbValue dbValue) {
        String string;
        DbValueFormat dbValueFormat = null;
        String string2 = (String)this.getPropertyByName("Format").getObject();
        if (string2.equals("")) {
            string = dbValue.toString();
        } else {
            try {
                dbValueFormat = ReportFormat.getOneFormat(dbValue.getSqlType(), string2);
            }
            catch (JRInterruptedException jRInterruptedException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, "get JRInterruptedException ", (Throwable)jRInterruptedException);
                }
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                dbValueFormat = null;
            }
            string = dbValueFormat != null ? dbValueFormat.format(dbValue) : dbValue.toString();
        }
        return string;
    }

    public Font getLabelFont() {
        if (this.SEDU != null) {
            return this.SEDU;
        }
        Font font = null;
        int n = 0;
        if (((Boolean)this.getPropertyByName("Bold").getObject()).booleanValue()) {
            n |= 1;
        }
        if (((Boolean)this.getPropertyByName("Italic").getObject()).booleanValue()) {
            n |= 2;
        }
        int n2 = (Integer)this.getPropertyByName("FontSize").getObject();
        int n3 = Unit.convertUnitToPixel(n2, this.getResolution());
        this.SEDU = font = FontSets.getFont((String)this.getPropertyByName("FontFace").getObject(), n, n3);
        return font;
    }

    public List getAllTicksValues() throws DSException {
        if (this.add != null) {
            return this.add;
        }
        this.add = new ArrayList();
        List list = new ArrayList();
        List list2 = this.booleanValue();
        if (!list2.isEmpty()) {
            if (list2.size() == 1) {
                list.add(list2.get(0));
            } else if ((Integer)this.getPropertyByName("SliderType").getObject() == 0) {
                list = list2;
            } else {
                DbValue dbValue = (DbValue)list2.get(0);
                switch (dbValue.getSqlType()) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 2005: {
                        list = list2;
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: {
                        list = this.calRangeThumbPosScale.extractNumberRangeValues(list2);
                        break;
                    }
                    default: {
                        list.add(list2.get(0));
                        list.add(list2.get(list2.size() - 1));
                    }
                }
            }
        }
        this.add = list;
        return list;
    }

    public List getSelectedTicksValues() throws DSException {
        if (this.booleanValue == null) {
            this.booleanValue = new ArrayList();
            List list = this.getCommunicator().getListRunTimeInfo(this.cleanupSelectedValues(), this.template.getInstName());
            if (list != null && !list.isEmpty()) {
                Object object;
                Object object2 = new ArrayList();
                for (String[] stringArray : list) {
                    object = stringArray;
                    int n = ((String[])object).length;
                    for (int i = 0; i < n; ++i) {
                        String string = object[i];
                        object2.add(string);
                    }
                }
                String string = (String)this.getPropertyByName("ArtificialDataType").getObject();
                int n = MappingSQLType.mergeParamTypeToSQLType(string);
                if (n == 91 || n == 92 || n == 93) {
                    object = new ArrayList();
                    for (String string2 : object2) {
                        object.add(String.valueOf(this.calRangeThumbPosScale.parseDateTime(string2, n)));
                    }
                    object2 = object;
                }
                if (!(object = this.calRangeThumbPosScale.convertStrToDbValue((List)object2, string)).isEmpty()) {
                    if (this.add == null) {
                        this.getAllTicksValues();
                    }
                    this.booleanValue = this.calRangeThumbPosScale.cleanupSelectedValues((List)object, this.add);
                }
            }
        }
        return this.booleanValue;
    }

    private List booleanValue() throws DSException {
        List list = null;
        boolean bl = (Boolean)this.getPropertyByName("UseCustomValue").getObject();
        if (bl) {
            List list2 = (List)this.getPropertyByName("CustomValueList").getObject();
            String string = (String)this.getPropertyByName("ArtificialDataType").getObject();
            list = this.calRangeThumbPosScale.convertStrToDbValue(list2, string);
        } else {
            list = this.calRangeThumbPosScale();
        }
        return list;
    }

    private List calRangeThumbPosScale() throws DSException {
        ArrayList<DbValue> arrayList = new ArrayList<DbValue>();
        String string = null;
        Propertiable propertiable = this.getTemplate().getPropertyByName("RuntimeColumnName");
        if (propertiable == null || ((Vector)propertiable.getObject()).isEmpty()) {
            if (JRLog.isError(2)) {
                JRLog.error(2, "can not find corresponding column name");
            }
            return arrayList;
        }
        string = (String)((Vector)propertiable.getObject()).get(0);
        JDbBufferData[] jDbBufferDataArray = this.getCommunicator().getFilterControlValueList(this.getTemplate(), string, this.cleanupSelectedValues());
        if (jDbBufferDataArray != null) {
            if (jDbBufferDataArray.length == 0) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, "slider can not get buffer data");
                }
                return arrayList;
            }
            JDbBufferCursor jDbBufferCursor = jDbBufferDataArray[0].createCursor();
            int n = 2;
            try {
                n = jDbBufferCursor.isNoRecord();
            }
            catch (SQLException sQLException) {
                JRLog.error(2, "slider bufferData cursor.isNoRecord() get exception: ", (Throwable)sQLException);
            }
            if (n != 2) {
                JRecord jRecord = jDbBufferCursor.createRecord();
                DbValue dbValue = null;
                while (jDbBufferCursor.next()) {
                    int n2 = jDbBufferCursor.getPosition();
                    jRecord.setPosition(n2);
                    jRecord.refresh();
                    dbValue = (DbValue)jRecord.getCell(string).clone();
                    arrayList.add(dbValue);
                }
            }
        }
        return arrayList;
    }

    private int cleanupSelectedValues() {
        int n = 0;
        DSBody dSBody = (DSBody)this.findBody(this);
        if (dSBody.getObjectType() == 262182) {
            n = ((DSSubReport)dSBody.getParent()).getSubIdx();
        }
        return n;
    }

    public double getRangeThumbPosScale(int n) {
        return this.calRangeThumbPosScale.calRangeThumbPosScale((DbValue)this.booleanValue.get(n), this.add, this.cleanupSelectedValues);
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSSlider());
    }

    public DSSlider dup(DSSlider dSSlider) {
        super.dup(dSSlider);
        dSSlider.cleanupSelectedValues = this.cleanupSelectedValues;
        return dSSlider;
    }
}

