/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import jet.JRStopEngineException;
import jet.dataengine.api.dbbuffer.JRecord;
import jet.datastream.Communicator;
import jet.datastream.DSContainer;
import jet.datastream.DSDataStreamable;
import jet.datastream.DSTableCell;
import jet.datastream.DSTableRow;
import jet.datastream.JRObjectResult;
import jet.util.VersionControlable;

public class DSTableObject
extends DSContainer {
    public static final int NoPara = -1;
    DSDataStreamable SEDU;
    private int add;
    private int containsKey;
    private boolean dup;
    private boolean get;
    private int getCalculateRecord;
    private int getChildren;
    private int getColSpan;
    private boolean getCommunicator;
    private int getDataStream;
    private boolean getGridX;
    private int getGridY;

    public JRecord getRecord(DSTableRow dSTableRow) {
        int n = dSTableRow.getRecordIndex();
        return this.SEDU.getRecord(n);
    }

    public JRecord getRecord(int n) {
        return this.SEDU.getRecord(n);
    }

    public JRecord getSynRecord(int n) {
        return this.SEDU.getSynRecord(n);
    }

    public JRecord getSynRecord2(int n) {
        return this.SEDU.getSynRecord2(n);
    }

    public int getSubIdx() {
        if (this.SEDU == null) {
            return -1;
        }
        return this.SEDU.getSubIndex();
    }

    public List getCells_old() {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.containsKey; ++i) {
            arrayList.add(new ArrayList());
        }
        Vector vector = this.getChildren();
        int n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            if ((((JRObjectResult)vector.get(i)).getObjectType() & 0x1000000) != 0x1000000) {
                ++n;
                continue;
            }
            DSTableRow dSTableRow = (DSTableRow)vector.get(i);
            Vector vector2 = dSTableRow.getChildren();
            int n2 = 0;
            for (int j = 0; j < vector2.size(); ++j) {
                DSTableCell dSTableCell = (DSTableCell)vector2.get(j);
                if (this.get) {
                    ((ArrayList)arrayList.get(n2)).add(dSTableCell);
                    int n3 = dSTableCell.getColSpan();
                    n2 += n3 - 1;
                } else {
                    ((ArrayList)arrayList.get(i - n)).add(dSTableCell);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public List getCells() {
        Vector vector = this.getChildren();
        TreeMap treeMap = new TreeMap();
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            if ((((JRObjectResult)vector.get(i)).getObjectType() & 0x1000000) != 0x1000000) continue;
            DSTableRow dSTableRow = (DSTableRow)vector.get(i);
            n = dSTableRow.getY();
            Vector vector2 = dSTableRow.getChildren();
            for (int j = 0; j < vector2.size(); ++j) {
                DSTableCell dSTableCell = (DSTableCell)vector2.get(j);
                n2 = this.isHorizontal() ? dSTableCell.getGridX() : dSTableCell.getGridY();
                if (treeMap.containsKey(n2)) {
                    ((List)treeMap.get(n2)).add(dSTableCell);
                    continue;
                }
                ArrayList<DSTableCell> arrayList = new ArrayList<DSTableCell>();
                arrayList.add(dSTableCell);
                treeMap.put(n2, arrayList);
            }
        }
        ArrayList arrayList = new ArrayList(treeMap.values());
        return arrayList;
    }

    @Override
    protected void readProperties(DataInput dataInput, DSDataStreamable dSDataStreamable) throws IOException, JRStopEngineException {
        super.readProperties(dataInput, dSDataStreamable);
        Communicator communicator = dSDataStreamable.getCommunicator();
        int n = communicator.getSubIdx(this.getTemplate());
        this.SEDU = n > -1 ? communicator.getDataStream(n) : communicator.getDataStream(0);
        this.add = dataInput.readInt();
        this.containsKey = dataInput.readInt();
        this.get = dataInput.readBoolean();
        this.getCalculateRecord = dataInput.readInt();
        this.getChildren = dataInput.readInt();
        int n2 = ((VersionControlable)((Object)dataInput)).getVersion();
        VersionControlable cfr_ignored_0 = (VersionControlable)((Object)dataInput);
        if (n2 >= 262176 || n2 == 0) {
            this.getColSpan = dataInput.readBoolean() ? dataInput.readInt() : -1;
        }
        VersionControlable cfr_ignored_1 = (VersionControlable)((Object)dataInput);
        if (n2 >= 262400 || n2 == 0) {
            this.getCommunicator = dataInput.readBoolean();
            this.getDataStream = dataInput.readInt();
        }
        VersionControlable cfr_ignored_2 = (VersionControlable)((Object)dataInput);
        if (n2 >= 262656 || n2 == 0) {
            this.getGridX = dataInput.readBoolean();
        }
        if (n2 >= 263168 || n2 == 0) {
            this.getGridY = dataInput.readInt();
        }
    }

    @Override
    protected void writeProperties(DataOutput dataOutput) throws IOException {
        super.writeProperties(dataOutput);
        dataOutput.writeInt(this.add);
        dataOutput.writeInt(this.containsKey);
        dataOutput.writeBoolean(this.get);
        dataOutput.writeInt(this.getCalculateRecord);
        dataOutput.writeInt(this.getChildren);
        dataOutput.writeBoolean(this.dup);
        if (this.dup) {
            dataOutput.writeInt(this.getColSpan);
        }
        dataOutput.writeBoolean(this.getCommunicator);
        dataOutput.writeInt(this.getDataStream);
        dataOutput.writeBoolean(this.getGridX);
        dataOutput.writeInt(this.getGridY);
    }

    @Override
    protected int propLength() {
        int n = super.propLength();
        n += 24;
        n += 4;
        if (this.dup) {
            n += 4;
        }
        return n;
    }

    public int getColCnt() {
        return this.add;
    }

    public void setColCnt(int n) {
        this.add = n;
    }

    public int getRowCnt() {
        return this.containsKey;
    }

    public void setRowCnt(int n) {
        this.containsKey = n;
    }

    public void setGroupTreeIDX(int n) {
        this.getChildren = n;
    }

    public int getGroupTreeIDX() {
        return this.getChildren;
    }

    public boolean isHorizontal() {
        return this.get;
    }

    public void setHorizontal(boolean bl) {
        this.get = bl;
    }

    public DSDataStreamable getStream() {
        return this.SEDU;
    }

    public void setStream(DSDataStreamable dSDataStreamable) {
        this.SEDU = dSDataStreamable;
    }

    public int getTotalBlockNum() {
        return this.getCalculateRecord;
    }

    public void setTotalBlockNum(int n) {
        this.getCalculateRecord = n;
    }

    @Override
    public Object copyObject() {
        return this.dup(new DSTableObject());
    }

    public DSTableObject dup(DSTableObject dSTableObject) {
        super.dup(dSTableObject);
        dSTableObject.setStream(this.SEDU);
        dSTableObject.setColCnt(this.add);
        dSTableObject.setRowCnt(this.containsKey);
        dSTableObject.setHorizontal(this.get);
        dSTableObject.setGroupTreeIDX(this.getChildren);
        dSTableObject.setTotalBlockNum(this.getCalculateRecord);
        dSTableObject.dup = this.dup;
        dSTableObject.setParameterKey(this.getColSpan);
        dSTableObject.setInlinePanel(this.getCommunicator);
        dSTableObject.setBeginRecIdx(this.getDataStream);
        dSTableObject.setIsFirstTable(this.getGridX);
        dSTableObject.setRoundingMode(this.getGridY);
        return dSTableObject;
    }

    public void setParameterKey(int n) {
        this.dup = n != -1;
        this.getColSpan = n;
    }

    public int getParameterKey() {
        return this.getColSpan;
    }

    public JRecord getCalculateRecord(DSTableRow dSTableRow) {
        int n = dSTableRow.getRecordIndex();
        return this.SEDU.getCalculateRecord(n);
    }

    public void setInlinePanel(boolean bl) {
        this.getCommunicator = bl;
    }

    public boolean hasInlinePanel() {
        return this.getCommunicator;
    }

    public int getBeginRecIdx() {
        return this.getDataStream;
    }

    public void setBeginRecIdx(int n) {
        this.getDataStream = n;
    }

    public boolean getIsFirstTable() {
        return this.getGridX;
    }

    public void setIsFirstTable(boolean bl) {
        this.getGridX = bl;
    }

    @Override
    public int getRoundingMode() {
        return this.getGridY;
    }

    @Override
    public void setRoundingMode(int n) {
        this.getGridY = n;
    }
}

