/*
 * Decompiled with CFR 0.152.
 */
package jet.datastream.render.barcode.linearBarcode;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import jet.datastream.render.RenderGraphicsToolkit;
import jet.datastream.render.barcode.BarcodeTable;
import jet.datastream.render.barcode.BarcodeUtil;
import jet.datastream.render.barcode.linearBarcode.BarcodeConstraints;
import jet.datastream.render.barcode.linearBarcode.LinearBarcode;

public class BarcodeUPCE
extends LinearBarcode {
    public int centreX;
    public int centreY;
    String EAN13;
    boolean EAN13Translate = false;

    public BarcodeUPCE(BarcodeConstraints barcodeConstraints) {
        this.paper = barcodeConstraints;
    }

    @Override
    public void init() {
        this.EAN13 = this.paper.getBarMessage();
        this.centreX = this.paper.getCenterX();
        this.centreY = this.paper.getCenterY();
        this.foreColor = this.paper.getForeground();
        this.barHeight = this.paper.getBarHeight();
        this.narrowWidth = this.paper.getBarNarrowWidth();
        this.scaleMode = this.paper.getBarScaleMode();
        this.bottomLabelFont = this.paper.getBarHRFont();
        this.supplementText = this.paper.getBarSupplement();
        this.startingQuietZone = this.paper.getBarQuietZone();
        this.unit = this.paper.getUnit();
        if (this.supplementText != null && (this.supplementText.length() == 2 || this.supplementText.length() == 5)) {
            this.EAN13Translate = true;
        }
        this.backColor = this.paper.getBackground();
        this.isExPDF = this.paper.getIsExportToPDF();
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        this.printUPCE(graphics2D, this.EAN13);
    }

    @Override
    public void calculateWidth() {
        this.EAN13(this.EAN13);
    }

    private void EAN13(String string) {
        int n;
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 20.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f5 *= this.unit;
        f6 *= this.unit;
        f4 = (float)this.centreY - (f3 *= this.unit) / 2.0f;
        float f7 = f3 / 10.0f;
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) >= '0' && string.charAt(i) <= '9') continue;
            return;
        }
        if (this.EAN13Translate && this.supplementText.length() == 2) {
            stringBuffer2 = BarcodeUtil.supplement2Tran(this.supplementText);
        } else if (this.EAN13Translate && this.supplementText.length() == 5) {
            stringBuffer2 = BarcodeUtil.supplement5Tran(this.supplementText);
        }
        if (string.length() == 7) {
            n = BarcodeUtil.checkCode(string);
            stringBuffer = BarcodeUPCE.UPCETran(string + String.valueOf(n));
        } else if (string.length() == 8) {
            n = BarcodeUtil.checkCode(string.substring(0, 7));
            if (!String.valueOf(n).equals(String.valueOf(string.charAt(7)))) {
                // empty if block
            }
            stringBuffer = BarcodeUPCE.UPCETran(string);
        } else {
            return;
        }
        Rectangle2D rectangle2D = RenderGraphicsToolkit.getBounds("" + string.charAt(0), this.bottomLabelFont);
        int n2 = (int)rectangle2D.getWidth();
        int n3 = (int)rectangle2D.getHeight();
        f = this.EAN13Translate ? (f2 = (float)this.centreX - ((float)(stringBuffer.length() + stringBuffer2.length() + 1) * f5 / 2.0f + (float)(n2 / 2))) : (f2 = (float)this.centreX - (float)stringBuffer.length() * f5 / 2.0f);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            f += f5;
        }
        if (this.EAN13Translate) {
            float f8 = f = f + (float)n2 + f5;
            for (int i = 0; i < stringBuffer2.length(); ++i) {
                f += f5;
            }
        }
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n2 * 2)), (int)(f3 + (float)(n3 * 2)));
        this.paper.setBarDimension(this.barD);
    }

    public static StringBuffer UPCETran(String string) {
        int n;
        String string2 = new String();
        StringBuffer stringBuffer = new StringBuffer();
        if (string.charAt(0) == '0') {
            for (n = 0; n <= 9; ++n) {
                if (string.charAt(7) != BarcodeTable.EAN13[n]) continue;
                string2 = BarcodeTable.UPCEMTable[0][n];
            }
        } else {
            for (n = 0; n <= 9; ++n) {
                if (string.charAt(7) != BarcodeTable.EAN13[n]) continue;
                string2 = BarcodeTable.UPCEMTable[1][n];
            }
        }
        stringBuffer.append("101");
        for (n = 1; n <= 6; ++n) {
            int n2;
            if (string2.charAt(n - 1) == '0') {
                for (n2 = 0; n2 <= 9; ++n2) {
                    if (string.charAt(n) != BarcodeTable.EAN13[n2]) continue;
                    stringBuffer.append(BarcodeTable.EAN13Translate[0][n2]);
                }
                continue;
            }
            for (n2 = 0; n2 <= 9; ++n2) {
                if (string.charAt(n) != BarcodeTable.EAN13[n2]) continue;
                stringBuffer.append(BarcodeTable.EAN13Translate[1][n2]);
            }
        }
        stringBuffer.append("010101");
        return stringBuffer;
    }

    public void printUPCE(Graphics2D graphics2D, String string) {
        int n;
        float f = 50.0f;
        float f2 = 50.0f;
        float f3 = 50.0f;
        float f4 = 20.0f;
        float f5 = BarcodeUtil.getUserDimFromMils(this.narrowWidth, this.scaleMode);
        float f6 = BarcodeUtil.getUserDimFromMils(this.startingQuietZone, this.scaleMode);
        f3 = BarcodeUtil.getUserDimFromMils(this.barHeight, this.scaleMode);
        f5 *= this.unit;
        f6 *= this.unit;
        f4 = (float)this.centreY - (f3 *= this.unit) / 2.0f;
        float f7 = f3 / 10.0f;
        StringBuffer stringBuffer = new StringBuffer();
        graphics2D.setFont(this.bottomLabelFont);
        StringBuffer stringBuffer2 = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) >= '0' && string.charAt(i) <= '9') continue;
            return;
        }
        if (this.EAN13Translate && this.supplementText.length() == 2) {
            stringBuffer2 = BarcodeUtil.supplement2Tran(this.supplementText);
        } else if (this.EAN13Translate && this.supplementText.length() == 5) {
            stringBuffer2 = BarcodeUtil.supplement5Tran(this.supplementText);
        }
        if (string.length() == 7) {
            n = BarcodeUtil.checkCode(string);
            stringBuffer = BarcodeUPCE.UPCETran(string + String.valueOf(n));
        } else if (string.length() == 8) {
            n = BarcodeUtil.checkCode(string.substring(0, 7));
            if (!String.valueOf(n).equals(String.valueOf(string.charAt(7)))) {
                // empty if block
            }
            stringBuffer = BarcodeUPCE.UPCETran(string);
        } else {
            return;
        }
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        int n2 = fontMetrics.stringWidth("" + string.charAt(0));
        int n3 = (int)fontMetrics.getStringBounds("" + string.charAt(0), graphics2D).getHeight();
        f = this.EAN13Translate ? (f2 = (float)this.centreX - ((float)(stringBuffer.length() + stringBuffer2.length() + 1) * f5 / 2.0f + (float)(n2 / 2))) : (f2 = (float)this.centreX - (float)stringBuffer.length() * f5 / 2.0f);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (stringBuffer.charAt(i) == '1') {
                graphics2D.setColor(this.foreColor);
                if (i < 4 || i >= stringBuffer.length() - 6) {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                } else {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3);
                }
            } else if (this.isExPDF) {
                if (this.backColor != null) {
                    graphics2D.setColor(this.backColor);
                } else {
                    graphics2D.setColor(Color.white);
                }
                if (i < 4 || i >= stringBuffer.length() - 6) {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                } else {
                    BarcodeUtil.drawbar(graphics2D, f, f4, f5, f3 + f7);
                }
            }
            f += f5;
        }
        graphics2D.setColor(this.foreColor);
        graphics2D.setFont(this.bottomLabelFont);
        BarcodeUtil.printBarcodeDataB(String.valueOf(string.charAt(0)), graphics2D, (int)f2, (int)(f3 + f4));
        if (string.length() == 7) {
            BarcodeUtil.printBarcodeDataM(string.substring(1), graphics2D, (int)((f - 6.0f * f5) / 2.0f + (f2 + 3.0f * f5) / 2.0f), (int)(f3 + f4), (int)(f - 9.0f * f5 - f2));
            BarcodeUtil.printBarcodeDataA(String.valueOf(n), graphics2D, (int)f, (int)(f3 + f4));
        } else {
            BarcodeUtil.printBarcodeDataM(string.substring(1, 7), graphics2D, (int)((f - 6.0f * f5) / 2.0f + (f2 + 3.0f * f5) / 2.0f), (int)(f3 + f4), (int)(f - 9.0f * f5 - f2));
            BarcodeUtil.printBarcodeDataA(String.valueOf(string.charAt(7)), graphics2D, (int)f, (int)(f3 + f4));
        }
        if (this.EAN13Translate) {
            float f8 = f = f + (float)n2 + f5;
            for (int i = 0; i < stringBuffer2.length(); ++i) {
                if (stringBuffer2.charAt(i) == '1') {
                    graphics2D.setColor(this.foreColor);
                    BarcodeUtil.drawbar(graphics2D, f, f4 + f7, f5, f3 - f7);
                } else if (this.isExPDF) {
                    if (this.backColor != null) {
                        graphics2D.setColor(this.backColor);
                    } else {
                        graphics2D.setColor(Color.white);
                    }
                    BarcodeUtil.drawbar(graphics2D, f, f4 + f7, f5, f3 - f7);
                }
                f += f5;
            }
            graphics2D.setColor(this.foreColor);
            BarcodeUtil.printBarcodeDataU(this.supplementText, graphics2D, (int)((f8 + f) / 2.0f), (int)(f4 + f7), (int)(f - f8));
        }
        this.barD.setSize((int)(f6 * 2.0f + f - f2 + (float)(n2 * 2)), (int)(f3 + (float)(n3 * 2)));
        this.paper.setBarDimension(this.barD);
    }
}

