/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel;

import com.jinfonet.util.JRLog;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.datastream.CTGridInfo;
import jet.datastream.DSBody;
import jet.datastream.DSCTField;
import jet.datastream.DSContainer;
import jet.datastream.DSCrossTab;
import jet.datastream.DSField;
import jet.datastream.DSSection;
import jet.datastream.DSShape;
import jet.datastream.DSSubReport;
import jet.datastream.DSTableRow;
import jet.datastream.DSTemplatible;
import jet.datastream.JRObjectResult;
import jet.datastream.JRVisiableResult;
import jet.export.ExportAuxInfo;
import jet.export.excel.ColorInfo;
import jet.export.excel.ExcelFontInfo;
import jet.export.excel.FldBorderInfo;
import jet.export.excel.v7x.PageRowColInfo;
import jet.export.util.CCUtil;
import jet.export.util.ExportCache;
import jet.util.Containable;
import jet.util.FontSets;
import jet.util.Propertiable;

public abstract class ExcelBaseCache
extends ExportCache {
    public static final int FORECOLORINDEX = 0;
    public static final int BACKCOLORINDEX = 1;
    public static final int BORDERCOLORINDEX = 2;
    public static final String[] BORDERLINENAME = new String[]{"TopLine", "LeftLine", "BottomLine", "RightLine"};
    public static final byte TOP = 0;
    public static final byte LEFT = 1;
    public static final byte BOTTOM = 2;
    public static final byte RIGHT = 3;
    private boolean ENGLISH;
    private boolean FALSE;
    protected boolean notOrginalWordWrap = true;
    protected boolean isWordWrap = false;
    private boolean SEDU = true;
    protected Hashtable fldColorTable;
    protected Hashtable fldFgColorTable;
    protected ArrayList fldFgCannotCache;
    protected Hashtable fldBgColorTable;
    protected ArrayList fldBgCannotCache;
    protected Hashtable fldBdColorTable;
    protected ArrayList fldBdCannotCache;
    private Hashtable TRUE = new Hashtable();
    private Hashtable add;
    protected Hashtable wordWrapTable;
    protected Hashtable canNotCacheWordWrap;
    protected Hashtable borderStyles;
    protected Hashtable invisibleCanCacheTable;
    protected Hashtable toXlsCanCacheTable;
    protected Hashtable invisibleTable;
    protected Hashtable toExcelTable;
    protected Hashtable canBeExportToTable;

    public ExcelBaseCache(ExportAuxInfo exportAuxInfo, String string) {
        super(exportAuxInfo, string);
        this.FALSE = JRLog.isError(3);
        this.ENGLISH = JRLog.isError(2);
    }

    public void setWordWrap(int n) {
        if (n == 0) {
            this.notOrginalWordWrap = false;
        } else if (n == 2) {
            this.isWordWrap = true;
        }
    }

    public String getFieldValue(DSField dSField) {
        Object object = dSField.toString();
        if (object == null || ((String)object).length() == 0) {
            return object;
        }
        int n = dSField.getRenderType();
        if (n == 4) {
            int n2;
            Object object2;
            Propertiable propertiable = dSField.getPropertyByName("WebValue");
            if (propertiable != null && (object2 = (String)propertiable.getObject()) != null && ((String)object2).length() > 0) {
                object = object2;
            }
            if ((object2 = dSField.getPropertyByName("TextFieldType")) != null && (n2 = ((Number)object2.getObject()).intValue()) == 1) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < ((String)object).length(); ++i) {
                    stringBuffer.append("*");
                }
                object = stringBuffer.toString();
            }
        }
        return object;
    }

    protected void initial() {
        this.add = new Hashtable();
        this.add.put("Default", "Arial");
        this.add.put("Dialog", "Arial");
        this.add.put("SansSerif", "Arial");
        this.add.put("Serif", "Times New Roman");
        this.add.put("Monospaced", "Courier New");
        this.add.put("Helvetica", "sansserif");
        this.add.put("TimesRoman", "serif");
        this.add.put("Courier", "Courier New");
        this.add.put("DialogInput", "Courier New");
        this.add.put("ZapfDingbats", "WingDings");
    }

    public void setPJFVersion(int n) {
        if (n != 0 && n < 262416) {
            this.SEDU = false;
        }
    }

    @Override
    public void clear() {
        super.clear();
        this.fldColorTable = null;
        this.fldFgColorTable = null;
        this.fldFgCannotCache = null;
        this.fldBgColorTable = null;
        this.fldBgCannotCache = null;
        this.fldBdColorTable = null;
        this.fldBdCannotCache = null;
        this.wordWrapTable = null;
        this.canNotCacheWordWrap = null;
        if (this.TRUE != null) {
            this.TRUE.clear();
            this.TRUE = null;
        }
        if (this.add != null) {
            this.add.clear();
            this.add = null;
        }
        this.borderStyles = null;
        this.invisibleCanCacheTable = null;
        this.toXlsCanCacheTable = null;
        this.invisibleTable = null;
        this.toExcelTable = null;
        this.canBeExportToTable = null;
    }

    public ExcelFontInfo getExcelFontInfo(String string, boolean bl, boolean bl2) {
        String string2 = string + bl + bl2;
        ExcelFontInfoImp excelFontInfoImp = (ExcelFontInfoImp)this.TRUE.get(string2);
        if (excelFontInfoImp == null) {
            String string3;
            String string4;
            int n = 0;
            if (bl) {
                n |= 1;
            }
            if (bl2) {
                n |= 2;
            }
            if ((string4 = (String)this.add.get(string3 = FontSets.getFont(string, n, 16).getFamily(Locale.ENGLISH))) == null) {
                this.add.put(string3, string3);
                string4 = string3;
            }
            excelFontInfoImp = new ExcelFontInfoImp(string4);
            excelFontInfoImp.setIsBold(((n = FontSets.getTrueFontStyleForUser(string, n)) & 1) == 1);
            excelFontInfoImp.setIsItalic((n & 2) == 2);
            this.TRUE.put(string2, excelFontInfoImp);
        }
        return excelFontInfoImp;
    }

    public boolean getWordWrap(DSField dSField) {
        if (this.notOrginalWordWrap) {
            return this.isWordWrap;
        }
        this.canCacheWordWrap(dSField);
        DSTemplatible dSTemplatible = dSField.getTemplate();
        Boolean bl = (Boolean)this.wordWrapTable.get(dSTemplatible);
        if (bl != null) {
            return bl;
        }
        return CCUtil.getBooleanPropertyByName(dSField, "WordWrap");
    }

    protected boolean canCacheWordWrap(DSField dSField) {
        if (this.notOrginalWordWrap) {
            return true;
        }
        DSTemplatible dSTemplatible = dSField.getTemplate();
        if (this.canNotCacheWordWrap.contains(dSTemplatible)) {
            return false;
        }
        if (this.wordWrapTable.containsKey(dSTemplatible)) {
            return true;
        }
        boolean bl = CCUtil.getBooleanPropertyByName(dSField, "WordWrap");
        boolean bl2 = this.isChangeBy(dSField, "WordWrap");
        if (bl2) {
            this.canNotCacheWordWrap.put(dSTemplatible, Boolean.TRUE);
        } else if (bl) {
            this.wordWrapTable.put(dSTemplatible, Boolean.TRUE);
        } else {
            this.wordWrapTable.put(dSTemplatible, Boolean.FALSE);
        }
        return !bl2;
    }

    public Color[] getFieldColor(DSField dSField) {
        DSTemplatible dSTemplatible = dSField.getTemplate();
        Color[] colorArray = (Color[])this.fldColorTable.get(dSTemplatible);
        if (colorArray == null) {
            colorArray = new Color[3];
            boolean bl = true;
            Color color = (Color)this.fldFgColorTable.get(dSTemplatible);
            if (color == null) {
                color = this.getColorPropertyByName(dSField, "Foreground");
                if (!this.fldFgCannotCache.contains(dSTemplatible)) {
                    if (this.isChangeBy(dSField, "Foreground")) {
                        this.fldFgCannotCache.add(dSTemplatible);
                        bl = false;
                    } else {
                        this.fldFgColorTable.put(dSTemplatible, color);
                    }
                } else {
                    bl = false;
                }
            }
            colorArray[0] = color;
            ColorInfo colorInfo = (ColorInfo)this.fldBgColorTable.get(dSTemplatible);
            if (colorInfo == null) {
                Color color2 = this.getColorPropertyByName(dSField, "Background");
                boolean bl2 = false;
                if (color2 == null) {
                    if (((JRObjectResult)((Object)dSField.getParent())).getObjectType() == 34) {
                        CTGridInfo cTGridInfo = ((DSCTField)dSField).getParentGridInfo();
                        color2 = cTGridInfo.fillColor;
                        bl2 = true;
                        if (color2 == null) {
                            color2 = this.getParentColor(dSField);
                        }
                    } else {
                        color2 = this.getParentColor(dSField);
                        bl2 = true;
                    }
                }
                colorInfo = new ColorInfo(color2);
                if (!this.fldBgCannotCache.contains(dSTemplatible)) {
                    if (bl2 || this.isChangeBy(dSField, "Background")) {
                        this.fldBgCannotCache.add(dSTemplatible);
                        bl = false;
                    } else {
                        this.fldBgColorTable.put(dSTemplatible, colorInfo);
                    }
                } else {
                    bl = false;
                }
            }
            colorArray[1] = colorInfo.getColor();
            Color color3 = (Color)this.fldBdColorTable.get(dSTemplatible);
            if (color3 == null) {
                color3 = this.getColorPropertyByName(dSField, "BorderColor");
                if (!this.fldBdCannotCache.contains(dSTemplatible)) {
                    if (this.isChangeBy(dSField, "BorderColor")) {
                        this.fldBdCannotCache.add(dSTemplatible);
                        bl = false;
                    } else {
                        this.fldBdColorTable.put(dSTemplatible, color3);
                    }
                } else {
                    bl = false;
                }
            }
            colorArray[2] = color3;
            if (bl) {
                this.fldColorTable.put(dSTemplatible, colorArray);
            }
        }
        return colorArray;
    }

    protected Color getParentColor(JRVisiableResult jRVisiableResult) {
        Containable containable;
        Color color = null;
        if (jRVisiableResult.getParent() != null && (containable = jRVisiableResult.getParent()) instanceof DSContainer) {
            DSContainer dSContainer = (DSContainer)containable;
            if (dSContainer.getObjectType() == 262178) {
                color = this.getParentColor(dSContainer);
            } else {
                Containable containable2;
                int n;
                if ((dSContainer instanceof DSSection || dSContainer instanceof DSTableRow || dSContainer instanceof DSBody) && (n = CCUtil.getIntPropertyByName(dSContainer, "BackgroundType")) != 0) {
                    return color;
                }
                color = this.getColorPropertyByName(dSContainer, "Background");
                if (color == null && dSContainer.getParent() != null && (containable2 = dSContainer.getParent()) instanceof DSContainer) {
                    int n2;
                    if ((containable2 instanceof DSSection || containable2 instanceof DSTableRow || containable2 instanceof DSBody) && (n2 = CCUtil.getIntPropertyByName((JRObjectResult)((Object)containable2), "BackgroundType")) != 0) {
                        return color;
                    }
                    color = this.getColorPropertyByName((JRObjectResult)((Object)containable2), "Background");
                }
            }
        }
        return color;
    }

    public FldBorderInfo getExcelBorderStyle(DSField dSField) throws IOException {
        DSTemplatible dSTemplatible = dSField.getTemplate();
        FldBorderInfo fldBorderInfo = (FldBorderInfo)this.borderStyles.get(dSTemplatible);
        if (fldBorderInfo == null) {
            int n;
            Object object;
            fldBorderInfo = new FldBorderInfo();
            if (((JRObjectResult)((Object)dSField.getParent())).getObjectType() == 34) {
                boolean bl;
                DSCrossTab dSCrossTab = (DSCrossTab)dSField.getParent();
                Boolean bl2 = (Boolean)this.borderStyles.get(dSCrossTab.getTemplate());
                Color color = (Color)this.borderStyles.get(dSCrossTab.getTemplate() + "borderColor");
                if (bl2 == null) {
                    bl = this.getBooleanPropertyByName(dSCrossTab, "Hasborder");
                    bl2 = bl;
                    this.borderStyles.put(dSCrossTab.getTemplate(), bl2);
                    color = this.getColorPropertyByName(dSCrossTab, "BorderColor");
                    this.borderStyles.put(dSCrossTab.getTemplate() + "borderColor", color);
                }
                if (bl = bl2.booleanValue()) {
                    object = (DSCTField)dSField;
                    CTGridInfo cTGridInfo = ((DSCTField)object).getParentGridInfo();
                    Vector vector = cTGridInfo.getChildren();
                    if (vector.size() == 1) {
                        fldBorderInfo.I(color);
                        fldBorderInfo.Z(color);
                        fldBorderInfo.C(color);
                        fldBorderInfo.B(color);
                        fldBorderInfo.I((short)1);
                        fldBorderInfo.Z((short)1);
                        fldBorderInfo.C((short)1);
                        fldBorderInfo.B((short)1);
                    } else {
                        int n2;
                        PageRowColInfo pageRowColInfo = new PageRowColInfo(1152, false);
                        PageRowColInfo pageRowColInfo2 = new PageRowColInfo(1152, false);
                        for (n2 = 0; n2 < vector.size(); ++n2) {
                            DSCTField dSCTField = (DSCTField)vector.get(n2);
                            pageRowColInfo2.addSimpleObj(dSCTField.getX(), dSCTField.getWidth());
                            pageRowColInfo.addSimpleObj(dSCTField.getY(), dSCTField.getHeight());
                        }
                        n2 = pageRowColInfo.getRowNum();
                        if (n2 == 1) {
                            fldBorderInfo.Z(color);
                            fldBorderInfo.B(color);
                            fldBorderInfo.Z((short)1);
                            fldBorderInfo.B((short)1);
                        } else {
                            int n3 = pageRowColInfo.getSimpleObjRowIndx(((JRVisiableResult)object).getY(), ((JRVisiableResult)object).getHeight());
                            if (n3 == 0) {
                                fldBorderInfo.Z(color);
                                fldBorderInfo.Z((short)1);
                            } else if (n3 == n2 - 1) {
                                fldBorderInfo.B(color);
                                fldBorderInfo.B((short)1);
                            }
                        }
                        int n4 = pageRowColInfo2.getColNum();
                        if (n4 == 1) {
                            fldBorderInfo.I(color);
                            fldBorderInfo.C(color);
                            fldBorderInfo.I((short)1);
                            fldBorderInfo.C((short)1);
                        } else {
                            int n5 = pageRowColInfo2.getSimpleObjColIndx(((JRVisiableResult)object).getX(), ((JRVisiableResult)object).getWidth());
                            if (n5 == 0) {
                                fldBorderInfo.I(color);
                                fldBorderInfo.I((short)1);
                            } else if (n5 == n4 - 1) {
                                fldBorderInfo.C(color);
                                fldBorderInfo.C((short)1);
                            }
                        }
                    }
                }
            }
            if ((n = CCUtil.getIntPropertyByName(dSField, "BorderWidth")) > 0) {
                short s;
                n /= 4;
                int[] nArray = new int[BORDERLINENAME.length];
                for (int i = 0; i < BORDERLINENAME.length; ++i) {
                    nArray[i] = CCUtil.getIntPropertyByName(dSField, BORDERLINENAME[i]);
                }
                short[] sArray = new short[4];
                for (s = 0; s < BORDERLINENAME.length; ++s) {
                    short s2;
                    sArray[s] = s2 = this.getExcelBorderStyle(n, nArray[s]);
                }
                s = sArray[1];
                object = CCUtil.getColorPropertyByName(dSField, "BorderColor");
                if (s != 0) {
                    fldBorderInfo.I(s);
                    fldBorderInfo.I((Color)object);
                }
                if ((s = sArray[0]) != 0) {
                    fldBorderInfo.Z(s);
                    fldBorderInfo.Z((Color)object);
                }
                if ((s = sArray[3]) != 0) {
                    fldBorderInfo.C(s);
                    fldBorderInfo.C((Color)object);
                }
                if ((s = sArray[2]) != 0) {
                    fldBorderInfo.B(s);
                    fldBorderInfo.B((Color)object);
                }
            }
            this.borderStyles.put(dSTemplatible, fldBorderInfo);
        }
        return fldBorderInfo;
    }

    public short getExcelBorderStyle(int n, int n2) {
        if (n <= 0) {
            return 0;
        }
        switch (n2) {
            case 0: {
                return 0;
            }
            case 1: {
                if (n < 20) {
                    return 1;
                }
                if (n > 35) {
                    return 5;
                }
                return 2;
            }
            case 2: {
                if (n < 20) {
                    return 3;
                }
                return 8;
            }
            case 3: {
                if (n < 20) {
                    return 11;
                }
                return 12;
            }
            case 4: {
                if (n < 20) {
                    return 9;
                }
                return 10;
            }
        }
        return 6;
    }

    @Override
    public boolean isExport(JRObjectResult jRObjectResult) {
        boolean bl;
        if (this.SEDU && jRObjectResult.getObjectType() == 44) {
            return false;
        }
        int n = jRObjectResult.getObjectType();
        if (n == 8192) {
            return false;
        }
        DSTemplatible dSTemplatible = jRObjectResult.getTemplate();
        Object v = this.canBeExportToTable.get(dSTemplatible);
        if (v != null) {
            bl = (Boolean)v;
        } else {
            bl = jRObjectResult instanceof JRVisiableResult;
            boolean bl2 = true;
            boolean bl3 = false;
            if (this.isExportToShape() && (bl3 = jRObjectResult instanceof DSShape)) {
                bl = true;
            }
            if (bl) {
                boolean bl4;
                boolean bl5;
                if (!bl3) {
                    switch (n) {
                        case 16386: 
                        case 65539: 
                        case 0x100002: {
                            return false;
                        }
                        case 33: 
                        case 37: 
                        case 45: {
                            if (!((DSSubReport)jRObjectResult).isError()) break;
                            if (this.ENGLISH) {
                                JRLog.error(2, 2402206);
                            }
                            return false;
                        }
                    }
                }
                if ((v = this.invisibleTable.get(dSTemplatible)) != null) {
                    bl5 = (Boolean)v;
                } else {
                    bl5 = this.BORDERLINENAME(jRObjectResult);
                    v = this.invisibleCanCacheTable.get(dSTemplatible);
                    if (v != null) {
                        bl2 = (Boolean)v;
                    } else {
                        boolean bl6 = bl2 = !this.isChangeBy(jRObjectResult, "Invisible");
                        if (bl2) {
                            this.invisibleCanCacheTable.put(dSTemplatible, Boolean.TRUE);
                            this.invisibleTable.put(dSTemplatible, bl5);
                        } else {
                            this.invisibleCanCacheTable.put(dSTemplatible, Boolean.FALSE);
                        }
                    }
                }
                v = this.toExcelTable.get(dSTemplatible);
                if (v != null) {
                    bl4 = (Boolean)v;
                } else {
                    bl4 = CCUtil.getBooleanPropertyByName(jRObjectResult, "ExportToXLS");
                    v = this.toXlsCanCacheTable.get(dSTemplatible);
                    if (v != null) {
                        boolean bl7 = (Boolean)v;
                        if (!bl7) {
                            bl2 = false;
                        }
                    } else {
                        boolean bl8 = CCUtil.canCacheToXls(jRObjectResult);
                        if (bl8) {
                            this.toXlsCanCacheTable.put(dSTemplatible, Boolean.TRUE);
                            this.toExcelTable.put(dSTemplatible, bl4);
                        } else {
                            this.toXlsCanCacheTable.put(dSTemplatible, Boolean.FALSE);
                            bl2 = false;
                        }
                    }
                }
                boolean bl9 = bl = !bl5 && bl4;
            }
            if (bl2) {
                if (bl) {
                    this.canBeExportToTable.put(dSTemplatible, Boolean.TRUE);
                } else {
                    this.canBeExportToTable.put(dSTemplatible, Boolean.FALSE);
                }
            }
        }
        if (bl && !(jRObjectResult instanceof DSShape)) {
            boolean bl10 = bl = ((JRVisiableResult)jRObjectResult).getWidth() > 0 && ((JRVisiableResult)jRObjectResult).getHeight() > 0;
            if (!bl) {
                if (n == 262178) {
                    bl = true;
                }
                if (!bl && this.FALSE) {
                    JRLog.trace(3, 2402204, String.valueOf(((JRVisiableResult)jRObjectResult).getObjectType()));
                    JRLog.trace(3, 2402205, ((JRVisiableResult)jRObjectResult).getWidth() + "*" + ((JRVisiableResult)jRObjectResult).getHeight());
                }
            }
        }
        return bl;
    }

    public String getSheetName(String string, int n) {
        if (string == null || string.length() == 0) {
            return "Sheet" + n;
        }
        if (string.startsWith("'")) {
            string = "_" + string.substring(1);
        }
        if (string.endsWith("'")) {
            string = string.substring(0, string.length() - 1);
            string = string + "_";
        }
        int n2 = n == 1 ? 31 : (n < 11 ? 30 : (n < 101 ? 29 : (n < 1001 ? 28 : (n < 10001 ? 27 : 20))));
        String string2 = string;
        if (string2.length() > n2) {
            string2 = string2.substring(0, n2);
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ":/\\?*][", true);
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if ("/".equals(string3) || "\\".equals(string3) || "?".equals(string3) || "*".equals(string3) || "[".equals(string3) || "]".equals(string3) || ":".equals(string3)) {
                stringBuffer.append("_");
                continue;
            }
            stringBuffer.append(string3);
        }
        if (n != 1) {
            stringBuffer.append(n - 1);
        }
        return stringBuffer.toString();
    }

    public abstract boolean isExportToShape();

    protected Color getColorPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getColorPropertyByName(jRObjectResult, string);
    }

    protected boolean getBooleanPropertyByName(JRObjectResult jRObjectResult, String string) {
        return CCUtil.getBooleanPropertyByName(jRObjectResult, string);
    }

    private boolean BORDERLINENAME(JRObjectResult jRObjectResult) {
        return CCUtil.getBooleanPropertyByName(jRObjectResult, "Invisible");
    }

    protected boolean isChangeBy(JRObjectResult jRObjectResult, String string) {
        Propertiable propertiable = jRObjectResult.getTemplate().getPropertyByName(string);
        return this.isChangeBy(propertiable);
    }

    protected boolean isChangeBy(Propertiable propertiable) {
        if (propertiable == null) {
            return false;
        }
        return propertiable.isChangeByOther() || propertiable.isChagneByFmtt() || propertiable.isChangeByBL();
    }

    class ExcelFontInfoImp
    implements ExcelFontInfo {
        private String SEDU;
        private boolean I;
        private boolean Z;

        public ExcelFontInfoImp(String string) {
            this.SEDU = string;
        }

        @Override
        public String getFontFamily() {
            return this.SEDU;
        }

        @Override
        public boolean isBold() {
            return this.I;
        }

        public void setIsBold(boolean bl) {
            this.I = bl;
        }

        @Override
        public boolean isItalic() {
            return this.Z;
        }

        public void setIsItalic(boolean bl) {
            this.Z = bl;
        }
    }
}

