/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.imp.xlsx;

import com.jinfonet.util.JRLog;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import jet.export.excel.imp.xlsx.DumpableContainer;
import jet.export.excel.imp.xlsx.TempFile;
import jet.export.excel.imp.xlsx.util.Util;

class Merges
extends DumpableContainer {
    public Merges(TempFile tempFile, int n) {
        super(tempFile, n);
        if (JRLog.isTrace(6)) {
            JRLog.trace(6, "Xlsx API: The maximum count of merges of every worksheet in memory is " + n);
        }
    }

    @Override
    protected void dump(DataOutputStream dataOutputStream, Object object) throws IOException {
        Object[] objectArray = (Object[])object;
        int[] nArray = (int[])objectArray[0];
        short[] sArray = (short[])objectArray[1];
        dataOutputStream.writeInt(nArray[0]);
        dataOutputStream.writeInt(nArray[1]);
        dataOutputStream.writeShort(sArray[0]);
        dataOutputStream.writeShort(sArray[1]);
    }

    @Override
    protected Object load(DataInputStream dataInputStream) throws IOException {
        return new Object[]{new int[]{dataInputStream.readInt(), dataInputStream.readInt()}, new short[]{dataInputStream.readShort(), dataInputStream.readShort()}};
    }

    @Override
    protected void write(XMLStreamWriter xMLStreamWriter, Object object) throws XMLStreamException, IOException {
        Object[] objectArray = (Object[])object;
        int[] nArray = (int[])objectArray[0];
        short[] sArray = (short[])objectArray[1];
        xMLStreamWriter.writeEmptyElement("mergeCell");
        xMLStreamWriter.writeAttribute("ref", Util.colNumToStr(sArray[0]) + (nArray[0] + 1) + ":" + Util.colNumToStr(sArray[1]) + (nArray[1] + 1));
    }

    @Override
    protected void writeHead(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeStartElement("mergeCells");
        xMLStreamWriter.writeAttribute("count", String.valueOf((long)this.mem.size() + this.dumpedCount));
    }

    @Override
    protected void writeTail(XMLStreamWriter xMLStreamWriter) throws XMLStreamException {
        xMLStreamWriter.writeEndElement();
    }
}

