/*
 * Decompiled with CFR 0.152.
 */
package jet.export.excel.v7x;

import guitools.toolkit.Unit;
import java.awt.Color;
import java.util.Hashtable;
import jet.datastream.DSField;
import jet.datastream.DSParagraphText;
import jet.datastream.DSTemplatible;
import jet.datastream.JRVisiableResult;
import jet.export.ExportAuxInfo;
import jet.export.excel.ExcelCache;
import jet.export.excel.ExcelFontInfo;
import jet.export.excel.api.ExcelFactory;
import jet.export.excel.api.ExcelFont;
import jet.export.util.CCUtil;
import jet.export.util.FontInfo;

public class ColumnFormatCache
extends ExcelCache {
    private boolean SEDU = false;
    private int TRUE = 1;
    private int append = 0;
    private Hashtable containsKey = new Hashtable();
    private Hashtable convertUnitToInch = new Hashtable();
    private ExcelFactory createFont;
    private Hashtable get;
    private Hashtable getBooleanPropertyByName;

    public ColumnFormatCache(boolean bl, ExportAuxInfo exportAuxInfo, boolean bl2) {
        super(bl, exportAuxInfo, "ColumnFormat", bl2);
    }

    public void setIsColumned(boolean bl) {
        this.SEDU = bl;
    }

    @Override
    protected Color getParentColor(JRVisiableResult jRVisiableResult) {
        if (this.SEDU) {
            return null;
        }
        return super.getParentColor(jRVisiableResult);
    }

    @Override
    public void reInitial() {
        this.get = new Hashtable();
        this.getBooleanPropertyByName = new Hashtable();
        super.reInitial();
    }

    @Override
    public void clear() {
        this.get = null;
        this.getBooleanPropertyByName = null;
    }

    void I(String string) {
        if (string == null) {
            ++this.TRUE;
        } else {
            Integer n = (Integer)this.containsKey.get(string);
            if (n == null) {
                n = 2;
            } else {
                int n2 = n + 1;
                n = n2;
            }
            this.containsKey.put(string, n);
        }
        ++this.append;
    }

    int Z(String string) {
        if (string == null) {
            return this.TRUE;
        }
        Integer n = (Integer)this.containsKey.get(string);
        if (n == null) {
            return 1;
        }
        return n;
    }

    int I() {
        return this.append;
    }

    void I(int n, String string) {
        this.convertUnitToInch.put(n, string);
    }

    String I(int n) {
        String string = (String)this.convertUnitToInch.get(n);
        if (string == null) {
            throw new NullPointerException("The sheet name is not stored by the sheet index(" + n + ")");
        }
        return string;
    }

    public void setExcelFactory(ExcelFactory excelFactory) {
        this.createFont = excelFactory;
    }

    public ExcelFont getExcelFont(DSParagraphText dSParagraphText) {
        Color color;
        FontInfo fontInfo = this.getFontInfo(dSParagraphText);
        String string = fontInfo.getFontName();
        boolean bl = this.getBooleanPropertyByName(dSParagraphText, "Bold");
        boolean bl2 = this.getBooleanPropertyByName(dSParagraphText, "Italic");
        ExcelFontInfo excelFontInfo = this.getExcelFontInfo(string, bl, bl2);
        double d = this.SEDU(fontInfo.getFontSize());
        ExcelFont excelFont = this.createFont.createFont(string, d);
        excelFont.setIsBold(excelFontInfo.isBold());
        excelFont.setIsItalic(excelFontInfo.isItalic());
        boolean bl3 = this.getBooleanPropertyByName(dSParagraphText, "StrikeOut");
        boolean bl4 = this.getBooleanPropertyByName(dSParagraphText, "Underline");
        excelFont.setIsStruckout(bl3);
        if (bl4) {
            excelFont.setUnderline((byte)1);
        }
        if ((color = this.getColorPropertyByName(dSParagraphText, "Foreground")) != null) {
            excelFont.setFontColor(color);
        }
        String string2 = dSParagraphText.getText();
        int n = (Integer)dSParagraphText.getPropertyByName("SupersubScript").getObject();
        switch (n) {
            case 1: {
                excelFont.setSuperSubScript((short)1);
                break;
            }
            case 2: {
                excelFont.setSuperSubScript((short)2);
                break;
            }
        }
        return excelFont;
    }

    public ExcelFont getExcelFont(DSField dSField) {
        DSTemplatible dSTemplatible = dSField.getTemplate();
        ExcelFont excelFont = (ExcelFont)this.get.get(dSTemplatible);
        if (excelFont == null) {
            boolean bl = true;
            if (this.getBooleanPropertyByName.containsKey(dSTemplatible)) {
                bl = false;
            }
            FontInfo fontInfo = this.getFontInfo(dSField);
            String string = fontInfo.getFontName();
            boolean bl2 = this.getBooleanPropertyByName(dSField, "Bold");
            boolean bl3 = this.getBooleanPropertyByName(dSField, "Italic");
            if (bl) {
                bl = fontInfo.isCanBeCache();
            }
            if (bl) {
                boolean bl4 = bl = !CCUtil.isChangeByFormularProperty(dSField, "Bold");
                if (bl) {
                    bl = !CCUtil.isChangeByFormularProperty(dSField, "Italic");
                }
            }
            ExcelFontInfo excelFontInfo = this.getExcelFontInfo(string, bl2, bl3);
            double d = this.SEDU(fontInfo.getFontSize());
            excelFont = this.createFont.createFont(excelFontInfo.getFontFamily(), d);
            excelFont.setIsBold(excelFontInfo.isBold());
            excelFont.setIsItalic(excelFontInfo.isItalic());
            boolean bl5 = this.getBooleanPropertyByName(dSField, "StrikeOut");
            if (bl) {
                bl = !CCUtil.isChangeByFormularProperty(dSField, "StrikeOut");
            }
            boolean bl6 = this.getBooleanPropertyByName(dSField, "Underline");
            if (bl) {
                bl = !CCUtil.isChangeByFormularProperty(dSField, "Underline");
            }
            boolean bl7 = this.getBooleanPropertyByName(dSField, "Shadow");
            if (bl) {
                bl = !CCUtil.isChangeByFormularProperty(dSField, "Shadow");
            }
            excelFont.setIsStruckout(bl5);
            if (bl6) {
                excelFont.setUnderline((byte)1);
            }
            Color color = CCUtil.getColorPropertyByName(dSField, "Foreground");
            if (bl) {
                bl = !CCUtil.isChangeByFormularProperty(dSField, "Foreground");
            }
            excelFont.setFontColor(color);
            if (!bl) {
                this.getBooleanPropertyByName.put(dSTemplatible, Boolean.TRUE);
            } else {
                this.get.put(dSTemplatible, excelFont);
            }
        }
        return excelFont;
    }

    private double SEDU(int n) {
        return Unit.convertUnitToInch(n) * 72.0;
    }
}

