/*
 * Decompiled with CFR 0.152.
 */
package jet.export.pdf;

import com.jinfonet.resstore.OutOfSpaceException;
import com.jinfonet.util.JRLog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jet.bean.PDFParameter;
import jet.export.ExpException;
import jet.export.ExportAuxInfo;
import jet.export.pdf.ExportToPDF;
import jet.export.pdf.PDFImporter;

public class PDFSpliter {
    PDFParameter SEDU;
    private long add;
    private int append;
    private int clear;
    private String closeSourcePDFFile;
    private List delete;
    private PDFImporter error;
    private int fileUpdated;
    private ExportAuxInfo get;
    private String getDiskStore;

    public PDFSpliter(List list, PDFParameter pDFParameter, ExportAuxInfo exportAuxInfo) {
        this.SEDU = pDFParameter;
        this.delete = list;
        this.get = exportAuxInfo;
    }

    void SEDU() throws ExpException {
        this.error = null;
        this.closeSourcePDFFile = (String)this.delete.get(0);
        long l = PDFSpliter.getMaxSizeOfOneFile(this.closeSourcePDFFile);
        if (l > 0L) {
            this.add = PDFSpliter.append(this.SEDU.getMaxSizeOfOneFile());
            this.append = this.SEDU.getMaxPageOfOneFile();
            this.error = new PDFImporter(this.SEDU, this.get);
            this.error.openSourcePDFFile(this.closeSourcePDFFile);
            this.fileUpdated = this.error.getTotalPagesNumberOfSourcePDF();
            this.add(l);
        }
    }

    void add(long l) {
        this.clear = (int)(this.add / (l / (long)this.fileUpdated));
        if (this.clear == 0) {
            this.clear = 1;
        }
    }

    protected boolean splitBySize() throws ExpException {
        boolean bl = false;
        this.SEDU();
        String string = null;
        int n = 1;
        long l = 0L;
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            int n3 = this.delete(n);
            string = this.getDiskStore(++n2);
            PDFSpliter.getTotalPagesNumberOfSourcePDF(string, this.get);
            this.error.importPDFFile(string, n, n3);
            l = PDFSpliter.getMaxSizeOfOneFile(string);
            if (l > this.add) {
                n3 = this.clear(string, n, n3);
            } else if (l < this.add) {
                n3 = this.closeSourcePDFFile(string, n, n3);
            }
            if (n3 == this.fileUpdated) {
                arrayList.add(string);
                bl = true;
                break;
            }
            if (n3 == -1) {
                bl = false;
                break;
            }
            n = n3 + 1;
            arrayList.add(string);
        }
        this.error.closeSourcePDFFile();
        if (bl) {
            PDFSpliter.getMaxPageOfOneFile(this.delete, arrayList, this.get);
            PDFSpliter.getTotalPagesNumberOfSourcePDF(this.closeSourcePDFFile, this.get);
            arrayList = null;
        }
        return bl;
    }

    protected boolean splitByPage() throws ExpException {
        boolean bl = false;
        this.SEDU();
        String string = null;
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (true) {
            n2 = (n2 += this.append) > this.fileUpdated ? this.fileUpdated : n2;
            string = this.getDiskStore(++n3);
            PDFSpliter.getTotalPagesNumberOfSourcePDF(string, this.get);
            this.error.importPDFFile(string, n, n2);
            if (n2 >= this.fileUpdated) {
                arrayList.add(string);
                bl = true;
                break;
            }
            if (n2 == -1) {
                bl = false;
                break;
            }
            n = n2 + 1;
            arrayList.add(string);
        }
        this.error.closeSourcePDFFile();
        if (bl) {
            PDFSpliter.getMaxPageOfOneFile(this.delete, arrayList, this.get);
            PDFSpliter.getTotalPagesNumberOfSourcePDF(this.closeSourcePDFFile, this.get);
            arrayList = null;
        }
        return bl;
    }

    static int append(int n) {
        int n2 = 0;
        if (n != -1) {
            n2 = n * 1000 * 1;
        }
        return n2;
    }

    int clear(String string, int n, int n2) throws ExpException {
        long l = 0L;
        while (n != n2) {
            PDFSpliter.getTotalPagesNumberOfSourcePDF(string, this.get);
            this.error.importPDFFile(string, n, --n2);
            l = PDFSpliter.getMaxSizeOfOneFile(string);
            if (l > this.add) continue;
            break;
        }
        return n2;
    }

    int closeSourcePDFFile(String string, int n, int n2) throws ExpException {
        long l = 0L;
        while (n2 != this.fileUpdated) {
            this.error(string);
            if (n == n2) {
                this.get(string);
                break;
            }
            this.error.importPDFFile(string, n, ++n2);
            l = PDFSpliter.getMaxSizeOfOneFile(string);
            if (l <= this.add) continue;
            this.get(string);
            --n2;
            break;
        }
        this.fileUpdated();
        return n2;
    }

    int delete(int n) {
        int n2 = n + this.clear;
        if (n2 > this.fileUpdated) {
            n2 = this.fileUpdated;
        }
        return n2;
    }

    void error(String string) throws ExpException {
        if (this.getDiskStore != null) {
            PDFSpliter.getTotalPagesNumberOfSourcePDF(this.getDiskStore, this.get);
        }
        this.getDiskStore = string + ".temp";
        PDFSpliter.importPDFFile(string, this.getDiskStore, this.get);
    }

    void fileUpdated() {
        if (this.getDiskStore != null) {
            PDFSpliter.getTotalPagesNumberOfSourcePDF(this.getDiskStore, this.get);
        }
    }

    void get(String string) throws ExpException {
        if (this.getDiskStore != null) {
            PDFSpliter.getTotalPagesNumberOfSourcePDF(string, this.get);
            PDFSpliter.importPDFFile(this.getDiskStore, string, this.get);
            this.getDiskStore = null;
        }
    }

    String getDiskStore(int n) {
        String string = ExportToPDF.I(this.closeSourcePDFFile, "_" + n);
        return string;
    }

    static void getMaxPageOfOneFile(List list, List list2, ExportAuxInfo exportAuxInfo) throws ExpException {
        int n = list2.size();
        list.remove(0);
        for (int i = 0; i < n; ++i) {
            String string = (String)list2.get(i);
            String string2 = ExportToPDF.I(string, "of" + String.valueOf(n));
            PDFSpliter.importPDFFile(string, string2, exportAuxInfo);
            list.add(string2);
        }
        list2.clear();
    }

    static long getMaxSizeOfOneFile(String string) {
        File file = new File(string);
        long l = 0L;
        if (file.isFile()) {
            l = file.length();
        }
        file = null;
        return l;
    }

    static boolean getTotalPagesNumberOfSourcePDF(String string, ExportAuxInfo exportAuxInfo) {
        boolean bl = false;
        File file = new File(string);
        if (file.isFile()) {
            bl = file.delete();
            exportAuxInfo.getDiskStore().delete(file);
        }
        file = null;
        return bl;
    }

    static boolean importPDFFile(String string, String string2, ExportAuxInfo exportAuxInfo) throws ExpException {
        boolean bl = false;
        File file = new File(string);
        File file2 = new File(string2);
        if (file != null && file2 != null && file.isFile()) {
            bl = file.renameTo(file2);
            try {
                exportAuxInfo.getDiskStore().fileUpdated(new File(string));
                exportAuxInfo.getDiskStore().fileUpdated(file2);
            }
            catch (OutOfSpaceException outOfSpaceException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, outOfSpaceException);
                }
                throw new ExpException(outOfSpaceException);
            }
            catch (IOException iOException) {
                if (JRLog.isError(2)) {
                    JRLog.error(2, iOException);
                }
                throw new ExpException(iOException);
            }
        }
        file = null;
        file2 = null;
        return bl;
    }
}

