/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.StringTokenizer;
import java.util.Vector;
import jet.Env;
import jet.connect.DbArray;
import jet.connect.DbBigInt;
import jet.connect.DbDecimal;
import jet.connect.DbDouble;
import jet.connect.DbInteger;
import jet.connect.DbNumber;
import jet.connect.DbReal;
import jet.connect.DbSmallInt;
import jet.connect.DbTinyInt;
import jet.connect.DbValue;
import jet.datasource.hds.ArrayImpl;
import jet.util.DbValueFormat;

public class AllNumberFormat
extends DecimalFormat
implements DbValueFormat {
    String SEDU = "JRD";

    public AllNumberFormat() {
    }

    public AllNumberFormat(String string) {
        super(string);
    }

    public AllNumberFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        super(string, decimalFormatSymbols);
    }

    @Override
    public synchronized String format(DbValue dbValue) {
        int n = dbValue.getSqlType();
        boolean bl = this.getPattern().startsWith(this.SEDU) || dbValue.isCurrency();
        boolean bl2 = false;
        String string = this.getPattern();
        if (bl && dbValue instanceof DbDecimal) {
            BigDecimal bigDecimal = ((DbDecimal)dbValue).get();
            return this.formatBig(bigDecimal);
        }
        switch (n) {
            case -6: 
            case -5: 
            case 4: 
            case 5: {
                long l = ((DbNumber)dbValue).longValue();
                return this.format(l);
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: {
                double d = ((DbNumber)dbValue).doubleValue();
                if (Double.isNaN(d)) {
                    return "NaN";
                }
                return this.format(d);
            }
        }
        return null;
    }

    @Override
    public synchronized String format(DbValue dbValue, String string) {
        int n = dbValue.getSqlType();
        String string2 = null;
        switch (n) {
            case -6: {
                byte[] byArray = (byte[])((DbArray)dbValue).getValue();
                for (int i = 0; i < byArray.length; ++i) {
                    string2 = i == 0 ? this.format(byArray[i]) : string2 + string + this.format(byArray[i]);
                }
                break;
            }
            case 5: {
                short[] sArray = (short[])((DbArray)dbValue).getValue();
                for (int i = 0; i < sArray.length; ++i) {
                    string2 = i == 0 ? this.format(sArray[i]) : string2 + string + this.format(sArray[i]);
                }
                break;
            }
            case 4: {
                int[] nArray = (int[])((DbArray)dbValue).getValue();
                for (int i = 0; i < nArray.length; ++i) {
                    string2 = i == 0 ? this.format(nArray[i]) : string2 + string + this.format(nArray[i]);
                }
                break;
            }
            case -5: {
                long[] lArray = (long[])((DbArray)dbValue).getValue();
                for (int i = 0; i < lArray.length; ++i) {
                    string2 = i == 0 ? this.format(lArray[i]) : string2 + string + this.format(lArray[i]);
                }
                break;
            }
            case 7: {
                float[] fArray2 = (float[])((DbArray)dbValue).getValue();
                for (int i = 0; i < fArray2.length; ++i) {
                    string2 = i == 0 ? this.format(fArray2[i]) : string2 + string + this.format(fArray2[i]);
                }
                break;
            }
            case 6: 
            case 8: {
                double[] dArray = (double[])((DbArray)dbValue).getValue();
                for (int i = 0; i < dArray.length; ++i) {
                    string2 = i == 0 ? this.format(dArray[i]) : string2 + string + this.format(dArray[i]);
                }
                break;
            }
            case 2: 
            case 3: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])((DbArray)dbValue).getValue();
                for (int i = 0; i < bigDecimalArray.length; ++i) {
                    string2 = i == 0 ? this.formatBig(bigDecimalArray[i]) : string2 + string + this.formatBig(bigDecimalArray[i]);
                }
                break;
            }
        }
        return string2;
    }

    @Override
    public String getPattern() {
        return this.toPattern();
    }

    @Override
    public String getLocalizedPattern() {
        return this.toLocalizedPattern();
    }

    @Override
    public void applyPattern(String string) {
        super.applyPattern(string);
    }

    @Override
    public void applyLocalizedPattern(String string) {
        super.applyLocalizedPattern(string);
    }

    private String SEDU(String string, String string2) {
        int n = string.indexOf(string2);
        if (n != -1) {
            string = string.substring(0, n) + string.substring(n + string2.length());
        }
        return string;
    }

    public String formatBig(BigDecimal bigDecimal) {
        if (Env.ifHighJVM5) {
            return this.SEDU(this.format(bigDecimal), this.SEDU);
        }
        return this.jrFormatBig(bigDecimal);
    }

    public String jrFormatBig(BigDecimal bigDecimal) {
        StringBuffer stringBuffer = new StringBuffer("");
        String string = this.getLocalizedPattern();
        this.applyLocalizedPattern(string);
        DecimalFormatSymbols decimalFormatSymbols = this.getDecimalFormatSymbols();
        boolean bl = bigDecimal != null ? bigDecimal.doubleValue() < 0.0 : false;
        int n = this.getGroupingSize();
        char c = decimalFormatSymbols.getGroupingSeparator();
        String string2 = this.getNegativeSuffix();
        String string3 = this.getNegativePrefix();
        String string4 = this.getPositivePrefix();
        String string5 = this.getPositiveSuffix();
        int n2 = this.getMaximumFractionDigits();
        char c2 = decimalFormatSymbols.getDecimalSeparator();
        char[] cArray = new char[50];
        cArray[0] = 46;
        for (int i = 1; i < 50; ++i) {
            cArray[i] = 48;
        }
        if (bigDecimal != null) {
            bigDecimal = bigDecimal.abs().setScale(n2, 4);
        }
        String string6 = bigDecimal != null ? bigDecimal.toString() : "";
        StringBuffer stringBuffer2 = new StringBuffer(string6);
        int n3 = string6.indexOf(46);
        int n4 = n2 - (string6.length() - n3 - 1);
        if (n3 >= 0 || n2 > 0) {
            if (n3 < 0 && n2 > 0) {
                this.append(stringBuffer2, cArray, 0, n2 + 1);
            } else if (n4 > 0) {
                this.append(stringBuffer2, cArray, 1, n4);
            } else if (n4 < 0) {
                stringBuffer2.setLength(stringBuffer2.length() - n4 * -1);
            }
        }
        string6 = stringBuffer2.toString();
        int n5 = string6.length();
        stringBuffer.append(bl ? string2 : string5);
        if (n2 > 0) {
            string6.getChars(n5 - n2, n5, cArray, 0);
            this.insert(stringBuffer, 0, cArray, 0, n2);
            stringBuffer.insert(0, c2);
            n5 = n5 - n2 - 1;
        }
        if (n > 0) {
            while (n5 > n) {
                string6.getChars(n5 - n, n5, cArray, 0);
                this.insert(stringBuffer, 0, cArray, 0, n);
                stringBuffer.insert(0, c);
                n5 -= n;
            }
        }
        string6.getChars(0, n5, cArray, 0);
        this.insert(stringBuffer, 0, cArray, 0, n5);
        stringBuffer.insert(0, bl ? string3 : string4);
        String string7 = stringBuffer.toString();
        int n6 = string7.indexOf(this.SEDU);
        if (n6 != -1) {
            string7 = string7.substring(0, n6) + string7.substring(n6 + this.SEDU.length());
        }
        return string7;
    }

    public void insert(StringBuffer stringBuffer, int n, char[] cArray, int n2, int n3) {
        for (int i = 0; i < n3; ++i) {
            stringBuffer.insert(n + i, cArray[i + n2]);
        }
    }

    public void append(StringBuffer stringBuffer, char[] cArray, int n, int n2) {
        for (int i = 0; i < n2; ++i) {
            stringBuffer.append(cArray[i + n]);
        }
    }

    @Override
    public void parse(DbValue dbValue, String string) throws ParseException {
        Number number = (Number)this.parseObject(string);
        switch (dbValue.getSqlType()) {
            case -5: {
                ((DbBigInt)dbValue).set(number.longValue());
                break;
            }
            case 5: {
                ((DbSmallInt)dbValue).set(number.shortValue());
                break;
            }
            case -6: {
                ((DbTinyInt)dbValue).set(number.byteValue());
                break;
            }
            case 4: {
                ((DbInteger)dbValue).set(number.intValue());
                break;
            }
            case 7: {
                ((DbReal)dbValue).set(number.floatValue());
                break;
            }
            case 6: 
            case 8: {
                ((DbDouble)dbValue).set(number.doubleValue());
                break;
            }
            case 2: 
            case 3: {
                ((DbDecimal)dbValue).set(new BigDecimal(number.doubleValue()));
            }
        }
    }

    @Override
    public void parse(DbValue dbValue, String string, String string2) throws ParseException, SQLException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        ArrayImpl arrayImpl = new ArrayImpl(dbValue.getSqlType(), this);
        arrayImpl.setValue(vector);
        ((DbArray)dbValue).set(arrayImpl);
    }

    @Override
    public String[] formatArray(DbArray dbArray) {
        String[] stringArray = null;
        int n = dbArray.getSqlType();
        switch (n) {
            case -6: {
                byte[] byArray = (byte[])dbArray.getValue();
                stringArray = new String[byArray.length];
                for (int i = 0; i < byArray.length; ++i) {
                    stringArray[i] = this.format(byArray[i]);
                }
                break;
            }
            case 5: {
                short[] sArray = (short[])dbArray.getValue();
                stringArray = new String[sArray.length];
                for (int i = 0; i < sArray.length; ++i) {
                    stringArray[i] = this.format(sArray[i]);
                }
                break;
            }
            case 4: {
                int[] nArray = (int[])dbArray.getValue();
                stringArray = new String[nArray.length];
                for (int i = 0; i < nArray.length; ++i) {
                    stringArray[i] = this.format(nArray[i]);
                }
                break;
            }
            case -5: {
                long[] lArray = (long[])dbArray.getValue();
                stringArray = new String[lArray.length];
                for (int i = 0; i < lArray.length; ++i) {
                    stringArray[i] = this.format(lArray[i]);
                }
                break;
            }
            case 7: {
                float[] fArray2 = (float[])dbArray.getValue();
                stringArray = new String[fArray2.length];
                for (int i = 0; i < fArray2.length; ++i) {
                    stringArray[i] = this.format(fArray2[i]);
                }
                break;
            }
            case 6: 
            case 8: {
                double[] dArray = (double[])dbArray.getValue();
                stringArray = new String[dArray.length];
                for (int i = 0; i < dArray.length; ++i) {
                    stringArray[i] = this.format(dArray[i]);
                }
                break;
            }
            case 2: 
            case 3: {
                BigDecimal[] bigDecimalArray = (BigDecimal[])dbArray.getValue();
                stringArray = new String[bigDecimalArray.length];
                for (int i = 0; i < bigDecimalArray.length; ++i) {
                    stringArray[i] = this.formatBig(bigDecimalArray[i]);
                }
                break;
            }
        }
        return stringArray;
    }
}

