/*
 * Decompiled with CFR 0.152.
 */
package jet.util;

class DCT {
    public int N = 8;
    public int QUALITY = 80;
    public Object[] quantum = new Object[2];
    public Object[] Divisors = new Object[2];
    public int[] quantum_luminance = new int[this.N * this.N];
    public double[] DivisorsLuminance = new double[this.N * this.N];
    public int[] quantum_chrominance = new int[this.N * this.N];
    public double[] DivisorsChrominance = new double[this.N * this.N];

    public DCT(int n) {
        this.Divisors(n);
    }

    private void Divisors(int n) {
        int n2;
        int n3;
        int n4;
        double[] dArray = new double[]{1.0, 1.387039845, 1.306562965, 1.175875602, 1.0, 0.785694958, 0.5411961, 0.275899379};
        int n5 = n;
        if (n5 <= 0) {
            n5 = 1;
        }
        if (n5 > 100) {
            n5 = 100;
        }
        n5 = n5 < 50 ? 5000 / n5 : 200 - n5 * 2;
        this.quantum_luminance[0] = 16;
        this.quantum_luminance[1] = 11;
        this.quantum_luminance[2] = 10;
        this.quantum_luminance[3] = 16;
        this.quantum_luminance[4] = 24;
        this.quantum_luminance[5] = 40;
        this.quantum_luminance[6] = 51;
        this.quantum_luminance[7] = 61;
        this.quantum_luminance[8] = 12;
        this.quantum_luminance[9] = 12;
        this.quantum_luminance[10] = 14;
        this.quantum_luminance[11] = 19;
        this.quantum_luminance[12] = 26;
        this.quantum_luminance[13] = 58;
        this.quantum_luminance[14] = 60;
        this.quantum_luminance[15] = 55;
        this.quantum_luminance[16] = 14;
        this.quantum_luminance[17] = 13;
        this.quantum_luminance[18] = 16;
        this.quantum_luminance[19] = 24;
        this.quantum_luminance[20] = 40;
        this.quantum_luminance[21] = 57;
        this.quantum_luminance[22] = 69;
        this.quantum_luminance[23] = 56;
        this.quantum_luminance[24] = 14;
        this.quantum_luminance[25] = 17;
        this.quantum_luminance[26] = 22;
        this.quantum_luminance[27] = 29;
        this.quantum_luminance[28] = 51;
        this.quantum_luminance[29] = 87;
        this.quantum_luminance[30] = 80;
        this.quantum_luminance[31] = 62;
        this.quantum_luminance[32] = 18;
        this.quantum_luminance[33] = 22;
        this.quantum_luminance[34] = 37;
        this.quantum_luminance[35] = 56;
        this.quantum_luminance[36] = 68;
        this.quantum_luminance[37] = 109;
        this.quantum_luminance[38] = 103;
        this.quantum_luminance[39] = 77;
        this.quantum_luminance[40] = 24;
        this.quantum_luminance[41] = 35;
        this.quantum_luminance[42] = 55;
        this.quantum_luminance[43] = 64;
        this.quantum_luminance[44] = 81;
        this.quantum_luminance[45] = 104;
        this.quantum_luminance[46] = 113;
        this.quantum_luminance[47] = 92;
        this.quantum_luminance[48] = 49;
        this.quantum_luminance[49] = 64;
        this.quantum_luminance[50] = 78;
        this.quantum_luminance[51] = 87;
        this.quantum_luminance[52] = 103;
        this.quantum_luminance[53] = 121;
        this.quantum_luminance[54] = 120;
        this.quantum_luminance[55] = 101;
        this.quantum_luminance[56] = 72;
        this.quantum_luminance[57] = 92;
        this.quantum_luminance[58] = 95;
        this.quantum_luminance[59] = 98;
        this.quantum_luminance[60] = 112;
        this.quantum_luminance[61] = 100;
        this.quantum_luminance[62] = 103;
        this.quantum_luminance[63] = 99;
        for (n4 = 0; n4 < 64; ++n4) {
            n3 = (this.quantum_luminance[n4] * n5 + 50) / 100;
            if (n3 <= 0) {
                n3 = 1;
            }
            if (n3 > 255) {
                n3 = 255;
            }
            this.quantum_luminance[n4] = n3;
        }
        int n6 = 0;
        for (n2 = 0; n2 < 8; ++n2) {
            for (n4 = 0; n4 < 8; ++n4) {
                this.DivisorsLuminance[n6] = 1.0 / ((double)this.quantum_luminance[n6] * dArray[n2] * dArray[n4] * 8.0);
                ++n6;
            }
        }
        this.quantum_chrominance[0] = 17;
        this.quantum_chrominance[1] = 18;
        this.quantum_chrominance[2] = 24;
        this.quantum_chrominance[3] = 47;
        this.quantum_chrominance[4] = 99;
        this.quantum_chrominance[5] = 99;
        this.quantum_chrominance[6] = 99;
        this.quantum_chrominance[7] = 99;
        this.quantum_chrominance[8] = 18;
        this.quantum_chrominance[9] = 21;
        this.quantum_chrominance[10] = 26;
        this.quantum_chrominance[11] = 66;
        this.quantum_chrominance[12] = 99;
        this.quantum_chrominance[13] = 99;
        this.quantum_chrominance[14] = 99;
        this.quantum_chrominance[15] = 99;
        this.quantum_chrominance[16] = 24;
        this.quantum_chrominance[17] = 26;
        this.quantum_chrominance[18] = 56;
        this.quantum_chrominance[19] = 99;
        this.quantum_chrominance[20] = 99;
        this.quantum_chrominance[21] = 99;
        this.quantum_chrominance[22] = 99;
        this.quantum_chrominance[23] = 99;
        this.quantum_chrominance[24] = 47;
        this.quantum_chrominance[25] = 66;
        this.quantum_chrominance[26] = 99;
        this.quantum_chrominance[27] = 99;
        this.quantum_chrominance[28] = 99;
        this.quantum_chrominance[29] = 99;
        this.quantum_chrominance[30] = 99;
        this.quantum_chrominance[31] = 99;
        this.quantum_chrominance[32] = 99;
        this.quantum_chrominance[33] = 99;
        this.quantum_chrominance[34] = 99;
        this.quantum_chrominance[35] = 99;
        this.quantum_chrominance[36] = 99;
        this.quantum_chrominance[37] = 99;
        this.quantum_chrominance[38] = 99;
        this.quantum_chrominance[39] = 99;
        this.quantum_chrominance[40] = 99;
        this.quantum_chrominance[41] = 99;
        this.quantum_chrominance[42] = 99;
        this.quantum_chrominance[43] = 99;
        this.quantum_chrominance[44] = 99;
        this.quantum_chrominance[45] = 99;
        this.quantum_chrominance[46] = 99;
        this.quantum_chrominance[47] = 99;
        this.quantum_chrominance[48] = 99;
        this.quantum_chrominance[49] = 99;
        this.quantum_chrominance[50] = 99;
        this.quantum_chrominance[51] = 99;
        this.quantum_chrominance[52] = 99;
        this.quantum_chrominance[53] = 99;
        this.quantum_chrominance[54] = 99;
        this.quantum_chrominance[55] = 99;
        this.quantum_chrominance[56] = 99;
        this.quantum_chrominance[57] = 99;
        this.quantum_chrominance[58] = 99;
        this.quantum_chrominance[59] = 99;
        this.quantum_chrominance[60] = 99;
        this.quantum_chrominance[61] = 99;
        this.quantum_chrominance[62] = 99;
        this.quantum_chrominance[63] = 99;
        for (n4 = 0; n4 < 64; ++n4) {
            n3 = (this.quantum_chrominance[n4] * n5 + 50) / 100;
            if (n3 <= 0) {
                n3 = 1;
            }
            if (n3 >= 255) {
                n3 = 255;
            }
            this.quantum_chrominance[n4] = n3;
        }
        n6 = 0;
        for (n2 = 0; n2 < 8; ++n2) {
            for (n4 = 0; n4 < 8; ++n4) {
                this.DivisorsChrominance[n6] = 1.0 / ((double)this.quantum_chrominance[n6] * dArray[n2] * dArray[n4] * 8.0);
                ++n6;
            }
        }
        this.quantum[0] = this.quantum_luminance;
        this.Divisors[0] = this.DivisorsLuminance;
        this.quantum[1] = this.quantum_chrominance;
        this.Divisors[1] = this.DivisorsChrominance;
    }

    public double[][] forwardDCTExtreme(float[][] fArray2) {
        double[][] dArray = new double[this.N][this.N];
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                for (int k = 0; k < 8; ++k) {
                    for (int i2 = 0; i2 < 8; ++i2) {
                        double[] dArray2 = dArray[i];
                        int n = j;
                        dArray2[n] = dArray2[n] + (double)fArray2[k][i2] * Math.cos((double)(2 * k + 1) * (double)j * Math.PI / 16.0) * Math.cos((double)(2 * i2 + 1) * (double)i * Math.PI / 16.0);
                    }
                }
                double[] dArray3 = dArray[i];
                int n = j;
                dArray3[n] = dArray3[n] * (0.25 * (j == 0 ? 1.0 / Math.sqrt(2.0) : 1.0) * (i == 0 ? 1.0 / Math.sqrt(2.0) : 1.0));
            }
        }
        return dArray;
    }

    public double[][] forwardDCT(float[][] fArray2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        double d7;
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        double d13;
        double d14;
        double d15;
        double d16;
        double d17;
        double d18;
        double d19;
        int n;
        double[][] dArray = new double[this.N][this.N];
        for (n = 0; n < 8; ++n) {
            for (int i = 0; i < 8; ++i) {
                dArray[n][i] = (double)fArray2[n][i] - 128.0;
            }
        }
        for (n = 0; n < 8; ++n) {
            d19 = dArray[n][0] + dArray[n][7];
            d18 = dArray[n][0] - dArray[n][7];
            d17 = dArray[n][1] + dArray[n][6];
            d16 = dArray[n][1] - dArray[n][6];
            d15 = dArray[n][2] + dArray[n][5];
            d14 = dArray[n][2] - dArray[n][5];
            d13 = dArray[n][3] + dArray[n][4];
            d12 = dArray[n][3] - dArray[n][4];
            d11 = d19 + d13;
            d10 = d19 - d13;
            d9 = d17 + d15;
            d8 = d17 - d15;
            dArray[n][0] = d11 + d9;
            dArray[n][4] = d11 - d9;
            d7 = (d8 + d10) * 0.707106781;
            dArray[n][2] = d10 + d7;
            dArray[n][6] = d10 - d7;
            d11 = d12 + d14;
            d9 = d14 + d16;
            d8 = d16 + d18;
            d6 = (d11 - d8) * 0.382683433;
            d5 = 0.5411961 * d11 + d6;
            d4 = 1.306562965 * d8 + d6;
            d3 = d9 * 0.707106781;
            d2 = d18 + d3;
            d = d18 - d3;
            dArray[n][5] = d + d5;
            dArray[n][3] = d - d5;
            dArray[n][1] = d2 + d4;
            dArray[n][7] = d2 - d4;
        }
        for (n = 0; n < 8; ++n) {
            d19 = dArray[0][n] + dArray[7][n];
            d18 = dArray[0][n] - dArray[7][n];
            d17 = dArray[1][n] + dArray[6][n];
            d16 = dArray[1][n] - dArray[6][n];
            d15 = dArray[2][n] + dArray[5][n];
            d14 = dArray[2][n] - dArray[5][n];
            d13 = dArray[3][n] + dArray[4][n];
            d12 = dArray[3][n] - dArray[4][n];
            d11 = d19 + d13;
            d10 = d19 - d13;
            d9 = d17 + d15;
            d8 = d17 - d15;
            dArray[0][n] = d11 + d9;
            dArray[4][n] = d11 - d9;
            d7 = (d8 + d10) * 0.707106781;
            dArray[2][n] = d10 + d7;
            dArray[6][n] = d10 - d7;
            d11 = d12 + d14;
            d9 = d14 + d16;
            d8 = d16 + d18;
            d6 = (d11 - d8) * 0.382683433;
            d5 = 0.5411961 * d11 + d6;
            d4 = 1.306562965 * d8 + d6;
            d3 = d9 * 0.707106781;
            d2 = d18 + d3;
            d = d18 - d3;
            dArray[5][n] = d + d5;
            dArray[3][n] = d - d5;
            dArray[1][n] = d2 + d4;
            dArray[7][n] = d2 - d4;
        }
        return dArray;
    }

    public int[] quantizeBlock(double[][] dArray, int n) {
        int[] nArray = new int[this.N * this.N];
        int n2 = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                nArray[n2] = (int)Math.round(dArray[i][j] * ((double[])this.Divisors[n])[n2]);
                ++n2;
            }
        }
        return nArray;
    }

    public int[] quantizeBlockExtreme(double[][] dArray, int n) {
        int[] nArray = new int[this.N * this.N];
        int n2 = 0;
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                nArray[n2] = (int)Math.round(dArray[i][j] / (double)((int[])this.quantum[n])[n2]);
                ++n2;
            }
        }
        return nArray;
    }
}

