/*
 * Decompiled with CFR 0.152.
 */
package jet.util.image;

import com.jinfonet.util.JRLog;
import java.awt.Canvas;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;
import jet.export.util.ImageEncoder;
import jet.util.BitmapReader;
import jet.util.PictureFileFormatDetector;
import jet.util.image.ImageResource;

public class ImageResourceUtil {
    private static Canvas SEDU = new Canvas();
    private static int addImage = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageResource loadImageResourceFromBytes(byte[] byArray) throws IOException {
        int n = PictureFileFormatDetector.getPictureFileType(byArray);
        Image image = null;
        switch (n) {
            case 1: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
                try {
                    image = ImageResourceUtil.SEDU(dataInputStream);
                }
                catch (Throwable throwable) {
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        byteArrayInputStream = null;
                    }
                    throw throwable;
                }
                try {
                    byteArrayInputStream.close();
                    break;
                }
                catch (IOException iOException) {
                    break;
                }
                finally {
                    byteArrayInputStream = null;
                }
            }
            case 0: 
            case 3: {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                try {
                    image = ImageIO.read(byteArrayInputStream);
                }
                catch (Throwable throwable) {
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (IOException iOException) {
                    }
                    finally {
                        byteArrayInputStream = null;
                    }
                    throw throwable;
                }
                try {
                    byteArrayInputStream.close();
                    break;
                }
                catch (IOException iOException) {
                    break;
                }
                finally {
                    byteArrayInputStream = null;
                }
            }
            default: {
                MediaTracker mediaTracker = new MediaTracker(SEDU);
                image = Toolkit.getDefaultToolkit().createImage(byArray);
                int n2 = 0;
                Canvas canvas = SEDU;
                synchronized (canvas) {
                    n2 = addImage;
                    addImage = addImage == Integer.MAX_VALUE ? 0 : ++addImage;
                }
                mediaTracker.addImage(image, n2);
                try {
                    mediaTracker.waitForID(n2);
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    break;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                finally {
                    mediaTracker.removeImage(image, n2);
                    mediaTracker = null;
                }
            }
        }
        if (image == null || image.getWidth(SEDU) < 0 || image.getHeight(SEDU) < 0) {
            image = null;
            n = -100;
        }
        return new ImageResource(image, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image SEDU(DataInputStream dataInputStream) {
        BitmapReader bitmapReader = null;
        Image image = null;
        bitmapReader = BitmapReader.loadFromBMP(dataInputStream);
        if (bitmapReader != null) {
            image = Toolkit.getDefaultToolkit().createImage(bitmapReader.getMemImgSrc());
            MediaTracker mediaTracker = new MediaTracker(SEDU);
            int n = 0;
            Canvas canvas = SEDU;
            synchronized (canvas) {
                n = addImage;
                addImage = addImage == Integer.MAX_VALUE ? 0 : ++addImage;
            }
            mediaTracker.addImage(image, n);
            try {
                mediaTracker.waitForID(n);
            }
            catch (InterruptedException interruptedException) {
            }
            finally {
                mediaTracker.removeImage(image, n);
                mediaTracker = null;
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static ImageResource loadImageResourceFromFile(File var0) throws IOException {
        block29: {
            if (!var0.isFile()) break block29;
            var1_1 = ImageResourceUtil.getImageType(var0);
            var2_2 = null;
            switch (var1_1) {
                case 1: {
                    var3_3 = null;
                    var4_4 = null;
                    try {
                        var4_4 = new FileInputStream(var0);
                        var3_3 = new DataInputStream(var4_4);
                        var2_2 = ImageResourceUtil.SEDU((DataInputStream)var3_3);
                        if (var4_4 == null) ** GOTO lbl41
                    }
                    catch (Throwable var8_9) {
                        if (var4_4 != null) {
                            try {
                                var4_4.close();
                            }
                            catch (IOException var9_10) {
                            }
                            finally {
                                var4_4 = null;
                            }
                        }
                        if (var3_3 != null) {
                            try {
                                var3_3.close();
                            }
                            catch (IOException var9_11) {
                            }
                            finally {
                                var3_3 = null;
                            }
                        }
                        throw var8_9;
                    }
                    try {
                        var4_4.close();
                    }
                    catch (IOException var5_5) {
                    }
                    finally {
                        var4_4 = null;
                    }
lbl41:
                    // 3 sources

                    if (var3_3 == null) break;
                    try {
                        var3_3.close();
                        break;
                    }
                    catch (IOException var5_6) {
                        break;
                    }
                    finally {
                        var3_3 = null;
                    }
                }
                case 0: 
                case 3: {
                    var2_2 = ImageIO.read(var0);
                    break;
                }
                default: {
                    var2_2 = ImageResourceUtil.addImage(var0);
                }
            }
            if (var2_2 == null || var2_2.getWidth(ImageResourceUtil.SEDU) < 0 || var2_2.getHeight(ImageResourceUtil.SEDU) < 0) {
                var2_2 = null;
                var1_1 = -100;
            }
            return new ImageResource(var2_2, var1_1);
        }
        throw new FileNotFoundException(var0 + " is not a file");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Image addImage(File file) {
        Image image = Toolkit.getDefaultToolkit().createImage(file.getAbsolutePath());
        int n = 0;
        Serializable serializable = SEDU;
        synchronized (serializable) {
            n = addImage;
            addImage = addImage == Integer.MAX_VALUE ? 0 : ++addImage;
        }
        serializable = new MediaTracker(SEDU);
        ((MediaTracker)serializable).addImage(image, n);
        try {
            ((MediaTracker)serializable).waitForID(n);
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            ((MediaTracker)serializable).removeImage(image, n);
            serializable = null;
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getImageType(File file) {
        int n;
        block30: {
            String string = file.getName().toLowerCase();
            n = -100;
            if (string.endsWith(".jpg")) {
                n = 0;
            } else if (string.endsWith(".bmp")) {
                n = 1;
            } else if (string.endsWith(".gif")) {
                n = 4;
            } else if (string.endsWith(".png")) {
                n = 3;
            }
            InputStream inputStream = null;
            try {
                byte[] byArray = new byte[10];
                inputStream = new FileInputStream(file);
                inputStream.read(byArray);
                int n2 = PictureFileFormatDetector.getPictureFileType(byArray);
                if (n2 != 2) {
                    if (n2 == -100) {
                    } else {
                        n = n2;
                    }
                }
            }
            catch (Exception exception) {
                if (inputStream == null) break block30;
                try {
                    inputStream.close();
                }
                catch (Exception exception2) {
                }
                finally {
                    inputStream = null;
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        inputStream = null;
                    }
                }
            }
        }
        return n;
    }

    public static byte[] imageToByte(Image image, int n) {
        try {
            if (image != null) {
                ImageEncoder imageEncoder = new ImageEncoder();
                switch (n) {
                    case 4: {
                        return imageEncoder.renderImageToGif(image);
                    }
                    case 3: {
                        return imageEncoder.renderImageToPNG(image);
                    }
                    case 0: 
                    case 1: {
                        return imageEncoder.renderImageToJpeg(image);
                    }
                }
                return ImageResourceUtil.append(image);
            }
            return new byte[0];
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    private static byte[] append(Image image) {
        byte[] byArray;
        ImageOutputStream imageOutputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        ImageWriter imageWriter;
        block9: {
            Iterator<ImageWriter> iterator = ImageIO.getImageWritersByMIMEType("image/jpeg");
            ImageWriter imageWriter2 = imageWriter = iterator.hasNext() ? iterator.next() : null;
            if (imageWriter == null) {
                return new byte[0];
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            imageOutputStream = null;
            byArray = new byte[]{};
            try {
                imageOutputStream = ImageIO.createImageOutputStream(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                if (!JRLog.isError(2)) break block9;
                JRLog.error(2, 2200004, (Throwable)iOException);
            }
        }
        if (imageOutputStream != null) {
            block10: {
                imageWriter.setOutput(imageOutputStream);
                BufferedImage bufferedImage = null;
                int n = image.getWidth(null);
                int n2 = image.getHeight(null);
                if (n <= 0 || n2 <= 0) {
                    return byArray;
                }
                if (image instanceof BufferedImage) {
                    bufferedImage = (BufferedImage)image;
                } else {
                    bufferedImage = new BufferedImage(n, n2, 1);
                    Graphics2D graphics2D = bufferedImage.createGraphics();
                    graphics2D.drawImage(image, 0, 0, null);
                }
                try {
                    imageWriter.write(new IIOImage(bufferedImage, null, null));
                }
                catch (IOException iOException) {
                    if (!JRLog.isError(2)) break block10;
                    JRLog.error(2, 2200004, (Throwable)iOException);
                }
            }
            imageWriter.dispose();
            byArray = byteArrayOutputStream.toByteArray();
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageResource loadImageResourceFromURL(String string) throws IOException {
        URL uRL = new URL(string);
        int n = -100;
        Image image = null;
        n = ImageResourceUtil.close(uRL);
        switch (n) {
            case 1: {
                DataInputStream dataInputStream = null;
                try {
                    dataInputStream = new DataInputStream(uRL.openStream());
                    image = ImageResourceUtil.SEDU(dataInputStream);
                    if (dataInputStream == null) break;
                }
                catch (Throwable throwable) {
                    if (dataInputStream != null) {
                        try {
                            dataInputStream.close();
                        }
                        catch (IOException iOException) {
                        }
                        finally {
                            dataInputStream = null;
                        }
                    }
                    throw throwable;
                }
                try {
                    dataInputStream.close();
                    break;
                }
                catch (IOException iOException) {
                    break;
                }
                finally {
                    dataInputStream = null;
                }
            }
            case 0: 
            case 3: {
                image = ImageIO.read(uRL);
                break;
            }
            default: {
                MediaTracker mediaTracker = new MediaTracker(SEDU);
                image = Toolkit.getDefaultToolkit().createImage(uRL);
                int n2 = 0;
                Canvas canvas = SEDU;
                synchronized (canvas) {
                    n2 = addImage;
                    addImage = addImage == Integer.MAX_VALUE ? 0 : ++addImage;
                }
                mediaTracker.addImage(image, n2);
                try {
                    mediaTracker.waitForID(n2);
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    break;
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
                finally {
                    mediaTracker.removeImage(image, n2);
                    mediaTracker = null;
                }
            }
        }
        if (image == null || ((Image)image).getWidth(SEDU) < 0 || ((Image)image).getHeight(SEDU) < 0) {
            image = null;
            n = -100;
        }
        return new ImageResource(image, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int close(URL uRL) {
        int n;
        block21: {
            n = -100;
            InputStream inputStream = null;
            try {
                inputStream = uRL.openStream();
                byte[] byArray = new byte[10];
                inputStream.read(byArray);
                int n2 = PictureFileFormatDetector.getPictureFileType(byArray);
                if (n2 != 2 && n2 != -100) {
                    n = n2;
                }
            }
            catch (Exception exception) {
                if (inputStream == null) break block21;
                try {
                    inputStream.close();
                }
                catch (Throwable throwable) {
                }
                finally {
                    inputStream = null;
                }
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                    }
                    finally {
                        inputStream = null;
                    }
                }
            }
        }
        return n;
    }
}

