/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartLabelBase;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Graph2DGuageBars;
import chart.data.Chart1DDataSet;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartGradientPattern;
import chart.graphics.ChartPenStyle;
import chart.graphics.ChartTextStyle;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class Graph2DGuageBar {
    Graph2DGuageBars SEDU;
    ChartLabelBase abs;
    float axisY;
    float clone;
    float dataset = 0.0f;
    float draw = 0.0f;
    float drawAxis = 0.0f;
    float fill = 0.0f;
    float fillBackPattern;
    float fillTempPattern = 0.0f;
    int fillValuePattern = 0;
    float getAxisPen = 0.0f;
    float getAxisXProperties = 0.0f;
    float[][] getAxisY;
    float[][][] getAxisYProperties;
    Shape[] getContourPen;
    float getDimension = 0.0f;
    Line2D getGaugeAlertColor = null;

    public Graph2DGuageBar(Graph2DGuageBars graph2DGuageBars, int n) {
        this.SEDU = graph2DGuageBars;
        this.fillValuePattern = n;
    }

    public void locate() {
        float f = 0.25f;
        float f2 = 0.1f;
        float f3 = 0.3f;
        float f4 = 0.05f;
        float f5 = 0.3f;
        switch (this.SEDU.objectProperties.getGaugeBarLayout()) {
            case 0: {
                this.draw = this.SEDU.C * f;
                this.fill = this.SEDU.C * f2;
                this.fillTempPattern = this.SEDU.C * f3;
                this.getDimension = this.SEDU.C * f4;
                this.getAxisXProperties = this.SEDU.C * f5;
                this.dataset = this.SEDU.Z;
                this.drawAxis = this.SEDU.Z;
                this.fillBackPattern = this.SEDU.Z;
                this.getAxisPen = this.SEDU.Z;
                break;
            }
            case 1: {
                this.dataset = this.SEDU.Z * f;
                this.drawAxis = this.SEDU.Z * f2;
                this.fillBackPattern = this.SEDU.Z * f3;
                this.getDimension = this.SEDU.Z * f4;
                this.getAxisPen = this.SEDU.Z * f5;
                this.draw = this.SEDU.C;
                this.fill = this.SEDU.C;
                this.fillTempPattern = this.SEDU.C;
                this.getAxisXProperties = this.SEDU.C;
            }
        }
        this.getContourPen = new Shape[this.SEDU.I];
        for (int i = 0; i < this.SEDU.I; ++i) {
            this.getContourPen[i] = new GeneralPath();
        }
    }

    public void paint(Graphics2D graphics2D) {
        if (this.SEDU.getPaper().getProperties().getAxisXProperties().isShowTickMarkLabels()) {
            this.fillValuePattern(graphics2D);
        }
        switch (this.SEDU.getPaper().getProperties().getGraphProperties().getGaugeBarStyle()) {
            case 0: {
                this.fillTempPattern(graphics2D);
                this.fillValuePattern(graphics2D, true);
                break;
            }
            case 1: {
                this.fillTempPattern(graphics2D);
                this.fillValuePattern(graphics2D, false);
                break;
            }
            case 2: {
                this.fillBackPattern(graphics2D);
                break;
            }
        }
        if (this.SEDU.getPaper().getProperties().isShowAxisY()) {
            this.drawAxis(graphics2D);
        }
        this.getAxisPen(graphics2D);
    }

    public void drawAxis(Graphics2D graphics2D) {
        this.getGaugeAlertColor = new Line2D.Float();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        switch (this.SEDU.objectProperties.getGaugeBarLayout()) {
            case 0: {
                f = this.axisY;
                f2 = this.clone + this.draw + this.fill + this.fillTempPattern + this.getDimension;
                f3 = this.axisY + this.fillBackPattern;
                f4 = f2;
                break;
            }
            case 1: {
                f = this.axisY + this.dataset + this.drawAxis + this.fillBackPattern + this.getDimension;
                f2 = this.clone;
                f3 = f;
                f4 = this.clone + this.fillTempPattern;
            }
        }
        this.getGaugeAlertColor.setLine(f, f2, f3, f4);
        this.SEDU.getPaper().getProperties().getAxisYProperties().getAxisPen().draw(graphics2D, this.getGaugeAlertColor);
        this.axisY(graphics2D);
        if (this.SEDU.getPaper().getProperties().getAxisYProperties().isShowTickMarkLabels()) {
            this.draw(graphics2D);
        }
    }

    private void SEDU(float[][] fArray, float[][][] fArray2) {
        int n = ((ChartNumericAxis)this.SEDU.layer.getAxisY()).getNumOfTick();
        float f = this.fillBackPattern / (float)n;
        float f2 = f / 5.0f;
        float f3 = this.axisY;
        float f4 = this.clone + this.draw + this.fill + this.fillTempPattern + this.getDimension;
        for (int i = 0; i <= n; ++i) {
            fArray[i][0] = f3 + (float)i * f;
            fArray[i][1] = f4;
            if (i == n) continue;
            for (int j = 0; j < 4; ++j) {
                fArray2[i][j][0] = fArray[i][0] + (float)j * f2;
                fArray2[i][j][1] = fArray[i][1];
            }
        }
    }

    private void abs(float[][] fArray, float[][][] fArray2) {
        int n = ((ChartNumericAxis)this.SEDU.layer.getAxisY()).getNumOfTick();
        float f = this.fillTempPattern / (float)n;
        float f2 = f / 5.0f;
        float f3 = this.axisY + this.dataset + this.drawAxis + this.fillBackPattern + this.getDimension;
        float f4 = this.clone;
        for (int i = 0; i <= n; ++i) {
            fArray[i][0] = f3;
            fArray[i][1] = f4 + (float)i * f;
            if (i == n) continue;
            for (int j = 0; j < 4; ++j) {
                fArray2[i][j][0] = f3;
                fArray2[i][j][1] = fArray[i][1] + (float)j * f2;
            }
        }
    }

    private void axisY(Graphics2D graphics2D) {
        int n = ((ChartNumericAxis)this.SEDU.layer.getAxisY()).getNumOfTick();
        this.getAxisY = new float[n + 1][2];
        this.getAxisYProperties = new float[n][4][2];
        int n2 = this.SEDU.getPaper().getProperties().getAxisYProperties().getTickMarkType();
        ChartPenStyle chartPenStyle = this.SEDU.getPaper().getProperties().getAxisYProperties().getTickMarkPen();
        int n3 = (int)this.SEDU.getPaper().getProperties().getAxisYProperties().getTickMarkLength();
        int n4 = (int)this.SEDU.getPaper().getProperties().getAxisYProperties().getMinorTickMarkLength();
        int n5 = this.SEDU.getPaper().getProperties().getAxisYProperties().getMinorTickMarkType();
        switch (this.SEDU.objectProperties.getGaugeBarLayout()) {
            case 0: {
                this.SEDU(this.getAxisY, this.getAxisYProperties);
                this.clone(graphics2D, this.getAxisY, n2, chartPenStyle, n3);
                for (int i = 0; i < n; ++i) {
                    this.clone(graphics2D, this.getAxisYProperties[i], n5, chartPenStyle, n4);
                }
                break;
            }
            case 1: {
                this.abs(this.getAxisY, this.getAxisYProperties);
                this.dataset(graphics2D, this.getAxisY, n2, chartPenStyle, n3);
                for (int i = 0; i < n; ++i) {
                    this.dataset(graphics2D, this.getAxisYProperties[i], n5, chartPenStyle, n4);
                }
                break;
            }
        }
    }

    private void clone(Graphics2D graphics2D, float[][] fArray, int n, ChartPenStyle chartPenStyle, int n2) {
        int n3 = fArray.length;
        Line2D.Float float_ = new Line2D.Float();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n3; ++i) {
            switch (n) {
                case 0: {
                    break;
                }
                case 2: {
                    f = fArray[i][0];
                    f2 = fArray[i][1];
                    f3 = fArray[i][0];
                    f4 = fArray[i][1] - (float)n2;
                    break;
                }
                case 1: {
                    f = fArray[i][0];
                    f2 = fArray[i][1];
                    f3 = fArray[i][0];
                    f4 = fArray[i][1] + (float)n2;
                    break;
                }
                case 3: {
                    f = fArray[i][0];
                    f2 = fArray[i][1] - (float)n2;
                    f3 = fArray[i][0];
                    f4 = fArray[i][1] + (float)n2;
                }
            }
            ((Line2D)float_).setLine(f, f2, f3, f4);
            chartPenStyle.draw(graphics2D, float_);
        }
    }

    private void dataset(Graphics2D graphics2D, float[][] fArray, int n, ChartPenStyle chartPenStyle, int n2) {
        int n3 = fArray.length;
        Line2D.Float float_ = new Line2D.Float();
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        for (int i = 0; i < n3; ++i) {
            switch (n) {
                case 0: {
                    break;
                }
                case 2: {
                    f = fArray[i][0];
                    f2 = fArray[i][1];
                    f3 = fArray[i][0] - (float)n2;
                    f4 = fArray[i][1];
                    break;
                }
                case 1: {
                    f = fArray[i][0];
                    f2 = fArray[i][1];
                    f3 = fArray[i][0] + (float)n2;
                    f4 = fArray[i][1];
                    break;
                }
                case 3: {
                    f = fArray[i][0] - (float)n2;
                    f2 = fArray[i][1];
                    f3 = fArray[i][0] + (float)n2;
                    f4 = fArray[i][1];
                }
            }
            ((Line2D)float_).setLine(f, f2, f3, f4);
            chartPenStyle.draw(graphics2D, float_);
        }
    }

    private void draw(Graphics2D graphics2D) {
        String[] stringArray = ((ChartNumericAxis)this.SEDU.layer.axisY).getLabels();
        int n = stringArray.length;
        ChartTextStyle chartTextStyle = this.SEDU.getPaper().getProperties().getAxisYProperties().getLabelTextStyle();
        float f = 0.0f;
        float f2 = 0.0f;
        float[][] fArray = new float[n][2];
        switch (this.SEDU.objectProperties.getGaugeBarLayout()) {
            case 0: {
                this.drawAxis(graphics2D, this.getAxisY, chartTextStyle, fArray, stringArray);
                break;
            }
            case 1: {
                this.fill(graphics2D, this.getAxisY, chartTextStyle, fArray, stringArray);
            }
        }
        this.fillBackPattern(graphics2D, chartTextStyle, fArray, stringArray);
    }

    private void drawAxis(Graphics2D graphics2D, float[][] fArray, ChartTextStyle chartTextStyle, float[][] fArray2, String[] stringArray) {
        int n = stringArray.length;
        int n2 = this.SEDU.getPaper().getProperties().getAxisYProperties().getTickMarkType();
        int n3 = 0;
        int n4 = (int)this.SEDU.getPaper().getProperties().getAxisYProperties().getLabelAxisGap();
        if (n2 == 1) {
            n3 = (int)this.SEDU.getPaper().getProperties().getAxisYProperties().getTickMarkLength();
        } else if (n2 == 3) {
            n3 = (int)this.SEDU.getPaper().getProperties().getAxisYProperties().getTickMarkLength() / 2;
        }
        for (int i = 0; i < n; ++i) {
            Rectangle2D rectangle2D = chartTextStyle.getDimension(graphics2D, stringArray[i]);
            fArray2[i][0] = (float)((double)fArray[i][0] - rectangle2D.getWidth() / 2.0);
            fArray2[i][1] = fArray[i][1] + (float)n3 + (float)n4;
        }
    }

    private void fill(Graphics2D graphics2D, float[][] fArray, ChartTextStyle chartTextStyle, float[][] fArray2, String[] stringArray) {
        int n = stringArray.length;
        int n2 = this.SEDU.getPaper().getProperties().getAxisYProperties().getTickMarkType();
        int n3 = 0;
        int n4 = (int)this.SEDU.getPaper().getProperties().getAxisYProperties().getLabelAxisGap();
        if (n2 == 1) {
            n3 = (int)this.SEDU.getPaper().getProperties().getAxisYProperties().getTickMarkLength();
        } else if (n2 == 3) {
            n3 = (int)this.SEDU.getPaper().getProperties().getAxisYProperties().getTickMarkLength() / 2;
        }
        for (int i = 0; i < n; ++i) {
            Rectangle2D rectangle2D = chartTextStyle.getDimension(graphics2D, stringArray[i]);
            fArray2[i][0] = fArray[i][0] + (float)n3 + (float)n4;
            fArray2[i][1] = (float)((double)fArray[i][1] - rectangle2D.getHeight() / 2.0);
        }
    }

    private void fillBackPattern(Graphics2D graphics2D, ChartTextStyle chartTextStyle, float[][] fArray, String[] stringArray) {
        int n = stringArray.length;
        switch (this.SEDU.getPaper().getProperties().getGraphProperties().getGaugeBarLayout()) {
            case 0: {
                if (this.SEDU.getPaper().getProperties().getAxisYProperties().isBestEffort()) {
                    int n2 = 0;
                    for (int i = 0; i < n; ++i) {
                        if (i > 0 && this.fillTempPattern(chartTextStyle, Math.abs(fArray[n2][0] - fArray[i][0]), stringArray[n2], stringArray[i])) continue;
                        ChartLabelBase chartLabelBase = new ChartLabelBase(stringArray[i]);
                        chartLabelBase.setChartTextStyle(chartTextStyle);
                        chartLabelBase.paint(graphics2D, fArray[i][0], fArray[i][1]);
                        n2 = i;
                    }
                } else {
                    for (int i = 0; i < n; ++i) {
                        ChartLabelBase chartLabelBase = new ChartLabelBase(stringArray[i]);
                        chartLabelBase.setChartTextStyle(chartTextStyle);
                        chartLabelBase.paint(graphics2D, fArray[i][0], fArray[i][1]);
                    }
                }
                break;
            }
            case 1: {
                for (int i = 0; i < n; ++i) {
                    ChartLabelBase chartLabelBase = new ChartLabelBase(stringArray[n - i - 1]);
                    chartLabelBase.setChartTextStyle(chartTextStyle);
                    chartLabelBase.paint(graphics2D, fArray[i][0], fArray[i][1]);
                }
                break;
            }
        }
    }

    boolean fillTempPattern(ChartTextStyle chartTextStyle, float f, String string, String string2) {
        ChartTextStyle chartTextStyle2;
        float f2;
        boolean bl = false;
        if (chartTextStyle != null && string != null && string2 != null && (f2 = (float)(chartTextStyle2 = (ChartTextStyle)chartTextStyle.clone()).getDimension(string).getWidth()) > f) {
            return true;
        }
        return bl;
    }

    private void fillValuePattern(Graphics2D graphics2D) {
        if (this.abs != null) {
            Rectangle2D rectangle2D = this.SEDU.getPaper().getProperties().getAxisXProperties().getLabelTextStyle().getDimension(graphics2D, this.abs.getLabelText());
            this.dataset = (float)rectangle2D.getWidth();
            this.draw = (float)rectangle2D.getHeight();
            if (this.SEDU.getPaper().getProperties().getGraphProperties().getGaugeBarLayout() == 1) {
                this.dataset = (float)rectangle2D.getHeight();
                this.draw = (float)rectangle2D.getWidth();
            }
            float f = 0.0f;
            float f2 = 0.0f;
            switch (this.SEDU.getPaper().getProperties().getGraphProperties().getGaugeBarLayout()) {
                case 0: {
                    f = this.axisY + (this.SEDU.Z - this.dataset) / 2.0f;
                    f2 = this.clone;
                    this.abs.paint(graphics2D, f, f2);
                    break;
                }
                case 1: {
                    f = this.axisY;
                    f2 = this.clone + (this.SEDU.C - this.draw) / 2.0f;
                    graphics2D.rotate(1.5707963267948966, f, f2);
                    this.abs.paint(graphics2D, f, f2);
                    graphics2D.rotate(-1.5707963267948966, f, f2);
                }
            }
        }
    }

    private void getAxisPen(Graphics2D graphics2D) {
        switch (this.SEDU.getPaper().getProperties().getGraphProperties().getGaugeBarLayout()) {
            case 0: {
                this.getAxisXProperties(graphics2D);
                break;
            }
            case 1: {
                this.getAxisY(graphics2D);
            }
        }
    }

    private void getAxisXProperties(Graphics2D graphics2D) {
        GeneralPath generalPath = new GeneralPath();
        float[][] fArray = new float[4][2];
        float f = this.axisY;
        float f2 = this.clone + this.draw + this.fill + this.getDimension;
        for (int i = 0; i < this.SEDU.I; ++i) {
            if (((Chart1DDataSet)this.SEDU.dataset).getValue(i, this.fillValuePattern) == null || this.SEDU.B[i][this.fillValuePattern] > this.SEDU.S || this.SEDU.B[i][this.fillValuePattern] < this.SEDU.J) continue;
            fArray[0][0] = f + this.SEDU.Z * ((this.SEDU.B[i][this.fillValuePattern] - this.SEDU.J) / (this.SEDU.S - this.SEDU.J));
            fArray[0][1] = f2 + 12.0f;
            fArray[1][0] = fArray[0][0] - 6.0f;
            fArray[1][1] = f2 + this.SEDU.getPaper().getProperties().getAxisYProperties().getAxisPen().getPenWidth();
            fArray[2][0] = fArray[1][0] + 12.0f;
            fArray[2][1] = fArray[1][1];
            fArray[3][0] = fArray[0][0];
            fArray[3][1] = this.clone + this.draw + this.fill + this.fillTempPattern + this.getDimension;
            ((GeneralPath)this.getContourPen[i]).reset();
            ((GeneralPath)this.getContourPen[i]).moveTo(fArray[0][0], fArray[0][1]);
            ((GeneralPath)this.getContourPen[i]).lineTo(fArray[1][0], fArray[1][1]);
            ((GeneralPath)this.getContourPen[i]).lineTo(fArray[2][0], fArray[2][1]);
            ((GeneralPath)this.getContourPen[i]).lineTo(fArray[0][0], fArray[0][1]);
            if (this.SEDU.objectProperties.isContour()) {
                this.SEDU.objectProperties.getContourPen().draw(graphics2D, this.getContourPen[i]);
            }
            if (this.SEDU.getSeriesPattern()[i] != null) {
                this.SEDU.getSeriesPattern()[i].fill(graphics2D, this.getContourPen[i]);
            }
            generalPath.reset();
            generalPath.moveTo(fArray[0][0], fArray[0][1]);
            generalPath.lineTo(fArray[3][0], fArray[3][1]);
            if (!this.SEDU.objectProperties.isContour()) continue;
            this.SEDU.objectProperties.getContourPen().draw(graphics2D, generalPath);
        }
    }

    private void getAxisY(Graphics2D graphics2D) {
        GeneralPath generalPath = new GeneralPath();
        float[][] fArray = new float[4][2];
        float f = this.axisY + this.dataset + this.drawAxis + this.getDimension;
        float f2 = this.clone;
        for (int i = 0; i < this.SEDU.I; ++i) {
            if (((Chart1DDataSet)this.SEDU.dataset).getValue(i, this.fillValuePattern) == null || this.SEDU.B[i][this.fillValuePattern] > this.SEDU.S || this.SEDU.B[i][this.fillValuePattern] < this.SEDU.J) continue;
            fArray[0][1] = f2 + this.SEDU.C * (1.0f - (this.SEDU.B[i][this.fillValuePattern] - this.SEDU.J) / (this.SEDU.S - this.SEDU.J));
            fArray[0][0] = f + 12.0f;
            fArray[1][0] = f + this.SEDU.getPaper().getProperties().getAxisYProperties().getAxisPen().getPenWidth();
            fArray[1][1] = fArray[0][1] - 6.0f;
            fArray[2][0] = fArray[1][0];
            fArray[2][1] = fArray[1][1] + 12.0f;
            fArray[3][0] = f + this.fillBackPattern;
            fArray[3][1] = fArray[0][1];
            ((GeneralPath)this.getContourPen[i]).reset();
            ((GeneralPath)this.getContourPen[i]).moveTo(fArray[0][0], fArray[0][1]);
            ((GeneralPath)this.getContourPen[i]).lineTo(fArray[1][0], fArray[1][1]);
            ((GeneralPath)this.getContourPen[i]).lineTo(fArray[2][0], fArray[2][1]);
            ((GeneralPath)this.getContourPen[i]).lineTo(fArray[0][0], fArray[0][1]);
            if (this.SEDU.getSeriesPattern()[i] != null) {
                this.SEDU.getSeriesPattern()[i].fill(graphics2D, this.getContourPen[i]);
            }
            if (this.SEDU.objectProperties.isContour()) {
                this.SEDU.objectProperties.getContourPen().draw(graphics2D, this.getContourPen[i]);
            }
            generalPath.reset();
            generalPath.moveTo(fArray[0][0], fArray[0][1]);
            generalPath.lineTo(fArray[3][0], fArray[3][1]);
            if (!this.SEDU.objectProperties.isContour()) continue;
            this.SEDU.objectProperties.getContourPen().draw(graphics2D, generalPath);
        }
    }

    public void fillTempPattern(Graphics2D graphics2D) {
        float f = 0.0f;
        float f2 = 0.0f;
        switch (this.SEDU.getPaper().getProperties().getGraphProperties().getGaugeBarLayout()) {
            case 0: {
                f = this.axisY;
                f2 = this.clone + this.draw + this.getDimension / 2.0f;
                break;
            }
            case 1: {
                f = this.axisY + this.dataset + this.getDimension / 2.0f;
                f2 = this.clone;
            }
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, this.drawAxis, this.fill);
        switch (this.SEDU.getPaper().getProperties().getGraphProperties().getGaugeBarLayout()) {
            case 0: {
                this.getAxisYProperties(float_, graphics2D);
                break;
            }
            case 1: {
                this.getContourPen(float_, graphics2D);
            }
        }
        this.SEDU.getPaper().getProperties().getGraphProperties().getGaugeBarPen().draw(graphics2D, float_);
    }

    private void getAxisYProperties(Rectangle2D rectangle2D, Graphics2D graphics2D) {
        ChartGradientPattern chartGradientPattern = new ChartGradientPattern(0);
        float f = (float)rectangle2D.getX();
        float f2 = (float)rectangle2D.getY();
        float f3 = (float)rectangle2D.getHeight();
        float f4 = this.SEDU.F[0] == this.SEDU.F[1] ? 0.0f : (float)((double)(Math.abs(this.SEDU.F[1] - this.SEDU.F[0]) / (this.SEDU.S - this.SEDU.J)) * rectangle2D.getWidth());
        float f5 = f + f4;
        float f6 = f2;
        float f7 = (float)rectangle2D.getHeight();
        float f8 = (float)(rectangle2D.getWidth() - (double)f4);
        ChartColorPattern[] chartColorPatternArray = new ChartColorPattern[3];
        if (this.SEDU.objectProperties.getGuagePatterns()[0] instanceof ChartColorPattern) {
            chartColorPatternArray[0] = (ChartColorPattern)this.SEDU.objectProperties.getGuagePatterns()[0];
        } else if (this.SEDU.objectProperties.getGuagePatterns()[0] instanceof ChartGradientPattern) {
            chartColorPatternArray[0] = ((ChartGradientPattern)this.SEDU.objectProperties.getGuagePatterns()[0]).getStartColor();
        }
        if (this.SEDU.objectProperties.getGuagePatterns()[1] instanceof ChartColorPattern) {
            chartColorPatternArray[1] = (ChartColorPattern)this.SEDU.objectProperties.getGuagePatterns()[1];
        } else if (this.SEDU.objectProperties.getGuagePatterns()[1] instanceof ChartGradientPattern) {
            chartColorPatternArray[1] = ((ChartGradientPattern)this.SEDU.objectProperties.getGuagePatterns()[1]).getStartColor();
        }
        if (this.SEDU.objectProperties.getGuagePatterns()[2] instanceof ChartColorPattern) {
            chartColorPatternArray[2] = (ChartColorPattern)this.SEDU.objectProperties.getGuagePatterns()[2];
        } else if (this.SEDU.objectProperties.getGuagePatterns()[2] instanceof ChartGradientPattern) {
            chartColorPatternArray[2] = ((ChartGradientPattern)this.SEDU.objectProperties.getGuagePatterns()[2]).getStartColor();
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, f4, f3);
        if (chartColorPatternArray[0] != null && chartColorPatternArray[1] != null) {
            chartGradientPattern.setStartColor(chartColorPatternArray[0]);
            chartGradientPattern.setEndColor(chartColorPatternArray[1]);
            chartGradientPattern.setStartPoint(new Point2D.Float(0.0f, 0.0f));
            chartGradientPattern.setEndPoint(new Point2D.Float(1.0f, 0.0f));
            chartGradientPattern.fill(graphics2D, float_);
        } else if (chartColorPatternArray[0] == null && chartColorPatternArray[1] != null) {
            chartGradientPattern.setStartColor(chartColorPatternArray[1]);
            chartGradientPattern.setEndColor(chartColorPatternArray[1]);
            chartGradientPattern.setStartPoint(new Point2D.Float(0.0f, 0.0f));
            chartGradientPattern.setEndPoint(new Point2D.Float(1.0f, 0.0f));
            chartGradientPattern.fill(graphics2D, float_);
        } else if (chartColorPatternArray[0] != null && chartColorPatternArray[1] == null) {
            chartGradientPattern.setStartColor(chartColorPatternArray[0]);
            chartGradientPattern.setEndColor(chartColorPatternArray[0]);
            chartGradientPattern.setStartPoint(new Point2D.Float(0.0f, 0.0f));
            chartGradientPattern.setEndPoint(new Point2D.Float(1.0f, 0.0f));
            chartGradientPattern.fill(graphics2D, float_);
        }
        Rectangle2D.Float float_2 = new Rectangle2D.Float(f5, f6, f8, f7);
        if (chartColorPatternArray[1] != null && chartColorPatternArray[2] != null) {
            chartGradientPattern.setStartColor(chartColorPatternArray[1]);
            chartGradientPattern.setEndColor(chartColorPatternArray[2]);
            chartGradientPattern.setStartPoint(new Point2D.Float(0.0f, 0.0f));
            chartGradientPattern.setEndPoint(new Point2D.Float(1.0f, 0.0f));
            chartGradientPattern.fill(graphics2D, float_2);
        } else if (chartColorPatternArray[1] == null && chartColorPatternArray[2] != null) {
            chartGradientPattern.setStartColor(chartColorPatternArray[2]);
            chartGradientPattern.setEndColor(chartColorPatternArray[2]);
            chartGradientPattern.setStartPoint(new Point2D.Float(0.0f, 0.0f));
            chartGradientPattern.setEndPoint(new Point2D.Float(1.0f, 0.0f));
            chartGradientPattern.fill(graphics2D, float_2);
        } else if (chartColorPatternArray[1] != null && chartColorPatternArray[2] == null) {
            chartGradientPattern.setStartColor(chartColorPatternArray[1]);
            chartGradientPattern.setEndColor(chartColorPatternArray[1]);
            chartGradientPattern.setStartPoint(new Point2D.Float(0.0f, 0.0f));
            chartGradientPattern.setEndPoint(new Point2D.Float(1.0f, 0.0f));
            chartGradientPattern.fill(graphics2D, float_2);
        }
    }

    private void getContourPen(Rectangle2D rectangle2D, Graphics2D graphics2D) {
        ChartGradientPattern chartGradientPattern = new ChartGradientPattern(0);
        float f = (float)rectangle2D.getX();
        float f2 = this.SEDU.F[0] == this.SEDU.F[1] ? 0.0f : (float)((double)(Math.abs(this.SEDU.F[1] - this.SEDU.F[0]) / (this.SEDU.S - this.SEDU.J)) * rectangle2D.getHeight());
        float f3 = (float)rectangle2D.getWidth();
        float f4 = (float)(rectangle2D.getY() + rectangle2D.getHeight() - (double)f2);
        float f5 = (float)rectangle2D.getX();
        float f6 = (float)rectangle2D.getY();
        float f7 = (float)rectangle2D.getHeight() - f2;
        float f8 = (float)rectangle2D.getWidth();
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f4, f3, f2);
        chartGradientPattern.setStartColor(new ChartColorPattern(this.SEDU.objectProperties.getGaugeNormalColor()));
        chartGradientPattern.setEndColor(new ChartColorPattern(this.SEDU.objectProperties.getGaugeAlertColor()));
        chartGradientPattern.setStartPoint(new Point2D.Float(0.5f, 1.0f));
        chartGradientPattern.setEndPoint(new Point2D.Float(0.5f, 0.0f));
        chartGradientPattern.fill(graphics2D, float_);
        Rectangle2D.Float float_2 = new Rectangle2D.Float(f5, f6, f8, f7);
        chartGradientPattern.setStartColor(new ChartColorPattern(this.SEDU.objectProperties.getGaugeAlertColor()));
        chartGradientPattern.setEndColor(new ChartColorPattern(this.SEDU.objectProperties.getGaugeErrorColor()));
        chartGradientPattern.setStartPoint(new Point2D.Float(0.5f, 1.0f));
        chartGradientPattern.setEndPoint(new Point2D.Float(0.5f, 0.0f));
        chartGradientPattern.fill(graphics2D, float_2);
    }

    public void fillValuePattern(Graphics2D graphics2D, boolean bl) {
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        switch (this.SEDU.objectProperties.getGaugeBarLayout()) {
            case 0: {
                f = this.axisY;
                f2 = this.clone + this.draw + this.fill + this.getDimension;
                break;
            }
            case 1: {
                f = this.axisY + this.dataset + this.drawAxis + this.getDimension;
                f2 = this.clone;
            }
        }
        Rectangle2D.Float float_ = new Rectangle2D.Float(f, f2, this.fillBackPattern, this.fillTempPattern);
        if (bl) {
            switch (this.SEDU.objectProperties.getGaugeBarLayout()) {
                case 0: {
                    this.getAxisYProperties(float_, graphics2D);
                    f3 = f + this.fillBackPattern * (this.SEDU.D[this.fillValuePattern] - this.SEDU.F[0]) / (this.SEDU.S - this.SEDU.J);
                    f4 = f2;
                    f5 = this.fillBackPattern - this.fillBackPattern * (this.SEDU.D[this.fillValuePattern] - this.SEDU.F[0]) / (this.SEDU.S - this.SEDU.J);
                    f6 = this.fillTempPattern;
                    break;
                }
                case 1: {
                    this.getContourPen(float_, graphics2D);
                    f4 = f2;
                    f3 = f;
                    f6 = this.fillTempPattern - this.fillTempPattern * (this.SEDU.D[this.fillValuePattern] - this.SEDU.F[0]) / (this.SEDU.S - this.SEDU.J);
                    f5 = this.fillBackPattern;
                }
            }
            Rectangle2D.Float float_2 = new Rectangle2D.Float(f3, f4, f5, f6);
            graphics2D.setColor(Color.white);
            graphics2D.fill(float_2);
        }
        this.SEDU.objectProperties.getGaugeBarPen().draw(graphics2D, float_);
    }

    public void fillBackPattern(Graphics2D graphics2D) {
    }

    public Shape getItemShapes(int n) {
        return this.getContourPen[n];
    }

    public void setStartX(float f) {
        this.axisY = f;
    }

    public void setStartY(float f) {
        this.clone = f;
    }

    public void setCategoryLabel(ChartLabelBase chartLabelBase) {
        this.abs = chartLabelBase;
    }

    public Shape getAxisY1Shapes() {
        return this.getGaugeAlertColor;
    }
}

