/*
 * Decompiled with CFR 0.152.
 */
package chart.chart2d;

import chart.ChartDataObject;
import chart.ChartShowValueCondition;
import chart.axis.ChartNumericAxis;
import chart.chart2d.Chart2DLayer;
import chart.chart2d.Chart2DObject;
import chart.chart2d.Chart2DPaper;
import chart.chart2d.Chart2DRadarLayer;
import chart.chart2d.Graph2DLineNode;
import chart.chart2d.Graph2DStaticHint;
import chart.data.Chart1DDataSet;
import chart.data.ChartDataSet;
import chart.data.ChartDataUsedInfo;
import chart.graphics.ChartColorPattern;
import chart.graphics.ChartPenStyle;
import chart.properties.ChartNumericAxisProperties;
import chart.util.ChartHintLabel;
import com.jinfonet.util.JRLog;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.util.List;
import jet.util.JRInterruptedException;

public class Graph2DRadar
extends Chart2DObject {
    private float abs;
    private float axisY;
    private float contains;
    private double cos;
    private ChartPenStyle draw;
    private ChartPenStyle drawNode;
    private GeneralPath[][] error;
    private Graph2DLineNode fill = new Graph2DLineNode();
    private double floatValue;
    private int formatLineNode = 5;
    private int get;
    private int getAbsoluteValueSum;
    private float[] getAbsoluteValueSumOfCategory = new float[2];
    private GeneralPath[] getBorderPen;
    private Line2D.Float[][] getBounds;
    private float v;
    protected float[][] value;
    private float[][] getCategorySize;
    private float[][] getChartDataSetModel;
    private int[] getChartLegend;
    private String[][][] getChartLink;
    private double[] getChartLinkInfo;

    Graph2DRadar(ChartDataSet chartDataSet, Chart2DPaper chart2DPaper, Chart2DLayer chart2DLayer) {
        super(chartDataSet, chart2DPaper, chart2DLayer);
    }

    @Override
    public void init() {
        int n;
        int n2;
        int n3;
        super.init();
        this.drawNode = this.paper.getProperties().getGraphProperties().getContourPen();
        this.floatValue = Math.PI;
        this.get = ((Chart1DDataSet)this.dataset).getSeriesSize();
        this.getAbsoluteValueSum = ((Chart1DDataSet)this.dataset).getCategorySize();
        this.value = new float[this.get][this.getAbsoluteValueSum];
        this.paper.Z.setRadarArrowStyle(this.objectProperties.getRadarArrowStyle());
        this.getBorderPen = new GeneralPath[this.get];
        this.cos = (double)(2.0f / (float)this.getAbsoluteValueSum) * this.floatValue;
        this.error = new GeneralPath[this.get][this.getAbsoluteValueSum];
        this.getBounds = new Line2D.Float[this.get][this.getAbsoluteValueSum];
        this.getChartLink = new String[this.get][this.getAbsoluteValueSum][1];
        if (this.paper.I.getChartLegend() != null) {
            this.getChartLegend = this.paper.I.getChartLegend().getIconStyleList();
        }
        for (n3 = 0; n3 < this.get; ++n3) {
            this.getBorderPen[n3] = new GeneralPath();
            for (int i = 0; i < this.getAbsoluteValueSum; ++i) {
                this.error[n3][i] = new GeneralPath();
                this.getBounds[n3][i] = new Line2D.Float();
            }
        }
        this.getCategorySize = new float[this.getAbsoluteValueSum * this.get][2];
        this.getChartDataSetModel = new float[this.get * this.getAbsoluteValueSum][2];
        this.axisY = (float)((ChartNumericAxis)this.paper.Z).getMax();
        this.contains = (float)((ChartNumericAxis)this.paper.Z).getMin();
        this.getAbsoluteValueSumOfCategory[0] = this.paper.getBounds().width;
        this.getAbsoluteValueSumOfCategory[1] = this.paper.getBounds().height;
        this.axisY -= this.contains;
        this.abs = this.getAbsoluteValueSumOfCategory[1] > this.getAbsoluteValueSumOfCategory[0] ? this.getAbsoluteValueSumOfCategory[0] : this.getAbsoluteValueSumOfCategory[1];
        this.abs = ((Chart2DRadarLayer)this.layer).getRadarAxisLength((int)this.abs);
        n3 = this.dataset.getChartDataSetModel().isOneGroup() ? 1 : 0;
        float[] fArray = null;
        if (((ChartNumericAxisProperties)this.layer.axisY.getProperties()).getIsShowPercent()) {
            if (n3 != 0) {
                fArray = new float[]{(float)((Chart1DDataSet)this.dataset).getAbsoluteValueSum()};
            }
        } else {
            fArray = new float[this.getAbsoluteValueSum];
            for (int i = 0; i < this.getAbsoluteValueSum; ++i) {
                fArray[i] = (float)((Chart1DDataSet)this.dataset).getAbsoluteValueSumOfCategory(i);
            }
        }
        for (n2 = 0; n2 < this.get; ++n2) {
            this.v = 0.0f;
            for (n = 0; n < this.getAbsoluteValueSum; ++n) {
                Number number = ((Chart1DDataSet)this.dataset).getValue(n2, n);
                if (number == null) {
                    this.v = 0.0f;
                } else {
                    this.v = !((ChartNumericAxisProperties)this.layer.axisY.getProperties()).getIsShowPercent() ? number.floatValue() : (n3 == 0 ? number.floatValue() / fArray[n] : number.floatValue() / fArray[0]);
                    if (this.layer.isShowCategoryAndSeries()) {
                        ChartHintLabel chartHintLabel = new ChartHintLabel((ChartDataObject)this, this.dataset, this.paper, 3);
                        this.getChartLink[n2][n] = chartHintLabel.hintLabelShowCategoryAndSeriesFor2d(n2, n);
                    } else {
                        this.getChartLink[n2][n][0] = this.dataset.getFormatedHintValue(number);
                    }
                }
                this.v = this.v - this.contains > 0.0f ? this.v - this.contains : 0.0f;
                this.v = this.v > this.axisY ? this.axisY : this.v;
                this.getCategorySize[this.getAbsoluteValueSum * n2 + n][0] = this.getAbsoluteValueSumOfCategory[0] / 2.0f + this.v / this.axisY * this.abs * (float)Math.cos(this.cos * (double)n + 0.5 * this.floatValue);
                this.getCategorySize[this.getAbsoluteValueSum * n2 + n][1] = this.getAbsoluteValueSumOfCategory[1] / 2.0f + this.v / this.axisY * this.abs * (float)Math.sin(this.cos * (double)n + 0.5 * this.floatValue);
                this.value[n2][n] = this.v;
            }
        }
        if (this.dataset.getChartDataSetModel().isOneGroup()) {
            this.getChartLinkInfo = new double[this.get];
            for (n2 = 0; n2 < this.get; ++n2) {
                for (n = 0; n < this.getAbsoluteValueSum; ++n) {
                    if (!((ChartNumericAxisProperties)this.layer.axisY.getProperties()).getIsShowPercent()) {
                        int n4 = n2;
                        this.getChartLinkInfo[n4] = this.getChartLinkInfo[n4] + (double)Math.abs(this.value[n2][n]);
                        continue;
                    }
                    int n5 = n2;
                    this.getChartLinkInfo[n5] = this.getChartLinkInfo[n5] + (double)Math.abs(this.value[n2][n] * fArray[n2]);
                }
                if (this.getChartLinkInfo[n2] != 0.0) continue;
                this.getChartLinkInfo[n2] = 1.0;
            }
        } else {
            this.getChartLinkInfo = new double[this.getAbsoluteValueSum];
            for (n2 = 0; n2 < this.getAbsoluteValueSum; ++n2) {
                for (n = 0; n < this.get; ++n) {
                    if (!((ChartNumericAxisProperties)this.layer.axisY.getProperties()).getIsShowPercent()) {
                        int n6 = n2;
                        this.getChartLinkInfo[n6] = this.getChartLinkInfo[n6] + (double)Math.abs(this.value[n][n2]);
                        continue;
                    }
                    int n7 = n2;
                    this.getChartLinkInfo[n7] = this.getChartLinkInfo[n7] + (double)Math.abs(this.value[n][n2] * fArray[n2]);
                }
                if (this.getChartLinkInfo[n2] != 0.0) continue;
                this.getChartLinkInfo[n2] = 1.0;
            }
        }
    }

    @Override
    public void locate() {
        this.layer.I(this.getCategorySize, this.getChartDataSetModel);
    }

    @Override
    public void paint(Graphics2D graphics2D) {
        block12: {
            this.cos();
            this.abs(graphics2D);
            for (int i = 0; i < this.getAbsoluteValueSum; ++i) {
                for (int j = 0; j < this.get; ++j) {
                    if (((Chart1DDataSet)this.dataset).getValue(j, i) == null) continue;
                    this.axisY(graphics2D, j, i);
                }
            }
            try {
                this.contains();
            }
            catch (JRInterruptedException jRInterruptedException) {
                throw jRInterruptedException;
            }
            catch (Exception exception) {
                if (!JRLog.isError(2)) break block12;
                JRLog.error(2, exception);
            }
        }
        if (this.valueLabelPosition != 0) {
            Graph2DStaticHint graph2DStaticHint = new Graph2DStaticHint(this.paper.model, graphics2D, this.dataset, this.paper, this.layer, this.getChartDataSetModel, 0, this.get, this.valueLabelPosition, this.getChartLinkInfo);
            graph2DStaticHint.paint();
        }
        if (this.objectProperties.isRadarIsFill()) {
            for (int i = 0; i < this.get; ++i) {
                if (this.seriesPattern[i] != null) {
                    if (this.seriesPattern[i] instanceof ChartColorPattern) {
                        this.draw.setPenColor((ChartColorPattern)this.seriesPattern[i]);
                        graphics2D.setColor(this.draw.getPenColor().getColor());
                        this.seriesPattern[i] = new ChartColorPattern(ChartColorPattern.transparent(graphics2D.getColor(), this.objectProperties.getRadarFillTransparence()));
                        this.seriesPattern[i].fill(graphics2D, this.getBorderPen[i]);
                        if (this.seriesPattern[i] instanceof ChartColorPattern) {
                            this.seriesPattern[i] = new ChartColorPattern(ChartColorPattern.transparent(graphics2D.getColor(), 0.0f));
                        }
                    } else {
                        this.seriesPattern[i].fill(graphics2D, this.getBorderPen[i]);
                    }
                }
                if (!this.paper.getProperties().getGraphProperties().isContour()) continue;
                this.SEDU(graphics2D);
            }
        }
    }

    private void SEDU(Graphics2D graphics2D) {
        for (int i = 0; i < this.get; ++i) {
            this.paper.getProperties().getGraphProperties().getContourPen();
            if (this.drawNode == null) continue;
            this.drawNode.draw(graphics2D, this.getBorderPen[i]);
        }
    }

    private void abs(Graphics2D graphics2D) {
        for (int i = 0; i < this.get; ++i) {
            this.draw = new ChartPenStyle();
            this.paper.getProperties().getGraphProperties().getContourPen();
            if (!(this.seriesPattern[i] instanceof ChartColorPattern)) continue;
            this.draw.setPenColor((ChartColorPattern)this.seriesPattern[i]);
            this.draw.setPenWidth(this.objectProperties.getLineThickness());
            this.draw.draw(graphics2D, this.getBorderPen[i]);
        }
    }

    private void axisY(Graphics2D graphics2D, int n, int n2) {
        int n3 = 0;
        if (this.seriesPattern[n] instanceof ChartColorPattern) {
            ChartColorPattern chartColorPattern = null;
            chartColorPattern = (ChartColorPattern)this.seriesPattern[n];
            if (((Chart1DDataSet)this.dataset).getValue(n, n2) != null) {
                n3 = this.objectProperties.getLineNodeStyle();
            }
            if (this.getChartLegend != null && this.getChartLegend.length != 0) {
                n3 = this.paper.formatLineNode(this.objectProperties.getLineNodeStyle(), this.getChartLegend[n % this.getChartLegend.length]);
            }
            this.fill.getBorderPen().setPenWidth(1.0f);
            this.fill.getBorderPen().setPenColor(chartColorPattern);
            this.fill.setFillPattern(chartColorPattern);
            this.fill.drawNode(graphics2D, (int)this.getChartDataSetModel[this.getAbsoluteValueSum * n + n2][0], (int)this.getChartDataSetModel[this.getAbsoluteValueSum * n + n2][1], n3, this.paper.getProperties().getGraphProperties().getLineNodeWidth(), this.paper.getProperties().getGraphProperties().getLineNodeHeight());
        }
    }

    @Override
    Shape[][] getItemShapes() {
        return this.error;
    }

    private void contains() {
        for (int i = 0; i < this.get; ++i) {
            for (int j = 0; j < this.getAbsoluteValueSum; ++j) {
                this.error[i][j].reset();
                this.error[i][j].moveTo(this.getChartDataSetModel[i * this.getAbsoluteValueSum + j][0] - (float)this.formatLineNode, this.getChartDataSetModel[i * this.getAbsoluteValueSum + j][1] + (float)this.formatLineNode);
                this.error[i][j].lineTo(this.getChartDataSetModel[i * this.getAbsoluteValueSum + j][0] - (float)this.formatLineNode, this.getChartDataSetModel[i * this.getAbsoluteValueSum + j][1] - (float)this.formatLineNode);
                this.error[i][j].lineTo(this.getChartDataSetModel[i * this.getAbsoluteValueSum + j][0] + (float)this.formatLineNode, this.getChartDataSetModel[i * this.getAbsoluteValueSum + j][1] - (float)this.formatLineNode);
                this.error[i][j].lineTo(this.getChartDataSetModel[i * this.getAbsoluteValueSum + j][0] + (float)this.formatLineNode, this.getChartDataSetModel[i * this.getAbsoluteValueSum + j][1] + (float)this.formatLineNode);
                this.error[i][j].lineTo(this.getChartDataSetModel[i * this.getAbsoluteValueSum + j][0] - (float)this.formatLineNode, this.getChartDataSetModel[i * this.getAbsoluteValueSum + j][1] + (float)this.formatLineNode);
            }
        }
    }

    private void cos() {
        for (int i = 0; i < this.get; ++i) {
            this.getBorderPen[i].reset();
            this.getBorderPen[i].moveTo(this.getChartDataSetModel[i * this.getAbsoluteValueSum][0], this.getChartDataSetModel[i * this.getAbsoluteValueSum][1]);
            if (this.getAbsoluteValueSum > 1) {
                for (int j = 0; j < this.getAbsoluteValueSum; ++j) {
                    if (j > 0) {
                        this.getBorderPen[i].lineTo(this.getChartDataSetModel[i * this.getAbsoluteValueSum + j][0], this.getChartDataSetModel[i * this.getAbsoluteValueSum + j][1]);
                    }
                    this.dataset(i, j);
                }
            }
            this.getBorderPen[i].lineTo(this.getChartDataSetModel[i * this.getAbsoluteValueSum][0], this.getChartDataSetModel[i * this.getAbsoluteValueSum][1]);
        }
    }

    private void dataset(int n, int n2) {
        if (n2 == this.getAbsoluteValueSum - 1) {
            this.getBounds[n][n2].setLine(this.getChartDataSetModel[n * this.getAbsoluteValueSum + n2][0], this.getChartDataSetModel[n * this.getAbsoluteValueSum + n2][1], this.getChartDataSetModel[n * this.getAbsoluteValueSum][0], this.getChartDataSetModel[n * this.getAbsoluteValueSum][1]);
        } else {
            this.getBounds[n][n2].setLine(this.getChartDataSetModel[n * this.getAbsoluteValueSum + n2][0], this.getChartDataSetModel[n * this.getAbsoluteValueSum + n2][1], this.getChartDataSetModel[n * this.getAbsoluteValueSum + n2 + 1][0], this.getChartDataSetModel[n * this.getAbsoluteValueSum + n2 + 1][1]);
        }
    }

    public boolean contains(int n, int n2) {
        return false;
    }

    @Override
    public int searchSeries(int n, int n2) {
        for (int i = 0; i < this.get; ++i) {
            for (int j = 0; j < this.getAbsoluteValueSum; ++j) {
                if (!this.getBounds[i][j].intersects(n - 5, n2 - 5, 10.0, 10.0)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public float[][] getStaticHintLocation() {
        return null;
    }

    @Override
    public Shape getShapeBySeries(int n) {
        return this.getBorderPen[n];
    }

    @Override
    public Shape getShapeByItem(int n, int n2) {
        return null;
    }

    @Override
    public String[] search(int n, int n2) {
        this.drilldown = null;
        for (int i = 0; i < this.get; ++i) {
            for (int j = 0; j < this.getAbsoluteValueSum; ++j) {
                if (!this.error[i][j].contains(n, n2)) continue;
                this.drilldown = new int[2];
                this.drilldown[0] = i;
                this.drilldown[1] = j;
                return this.getChartLink[i][j];
            }
        }
        return null;
    }

    @Override
    public int[] searchLinkInfo(int n, int n2) {
        int[] nArray = null;
        int n3 = this.dataset.getShowValueBeginIndex();
        int n4 = this.dataset.getShowValueEndIndex();
        int n5 = n4 - n3;
        int n6 = this.get / n5;
        for (int i = 0; i < this.get; ++i) {
            for (int j = 0; j < this.getAbsoluteValueSum; ++j) {
                if (!this.error[i][j].contains(n, n2)) continue;
                ChartShowValueCondition chartShowValueCondition = this.dataset.getCondition(i, j);
                int n7 = 0;
                n7 = i + 1 > n6 ? i - i / n6 * n6 : i;
                if (chartShowValueCondition != null && chartShowValueCondition.getChartLink() != null) {
                    nArray = ((ChartDataUsedInfo)((List)chartShowValueCondition.getChartLink().get(n7)).get(j)).getChartLinkInfo();
                }
                return nArray;
            }
        }
        return null;
    }
}

