/*
 * Decompiled with CFR 0.152.
 */
package com.jinfonet.awt;

import com.jinfonet.awt.JGraphics;
import com.jinfonet.awt.Rasterable;
import com.jinfonet.awt.Rect2D;
import java.awt.Color;
import java.awt.Graphics;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExPolygon
implements Cloneable {
    public static final int UPWARDS = 1;
    public static final int HORIZONTAL = 0;
    public static final int DOWNWARDS = -1;
    public static final int CLOCKWISE = 1;
    public static final int ANTICLOCKWISE = -1;
    public int npoints = 0;
    public double[] xpoints = new double[4];
    public double[] ypoints = new double[4];
    protected Rect2D bounds = null;
    protected Vector children;
    protected int roundDir = 0;
    public static boolean VERIFY = false;
    static int D = 0;
    public static Graphics g;
    private static final Color[] SEDU;

    public ExPolygon dup() {
        ExPolygon exPolygon = new ExPolygon();
        int n = this.npoints;
        exPolygon.xpoints = new double[n];
        exPolygon.ypoints = new double[n];
        System.arraycopy(this.xpoints, 0, exPolygon.xpoints, 0, n);
        System.arraycopy(this.ypoints, 0, exPolygon.ypoints, 0, n);
        exPolygon.npoints = n;
        exPolygon.roundDir = this.roundDir;
        if (this.bounds != null) {
            exPolygon.bounds = this.bounds.dup();
        }
        if (this.children != null) {
            int n2 = this.children.size();
            Vector<ExPolygon> vector = new Vector<ExPolygon>(n2);
            for (int i = 0; i < n2; ++i) {
                vector.addElement(((ExPolygon)this.children.elementAt(i)).dup());
            }
            exPolygon.children = vector;
        }
        return exPolygon;
    }

    public void add(ExPolygon exPolygon) {
        if (exPolygon.npoints < 3) {
            return;
        }
        if (this.children == null) {
            this.children = new Vector();
        }
        exPolygon.closePath();
        if (VERIFY) {
            exPolygon.verify();
        }
        for (int i = this.children.size() - 1; i >= 0; --i) {
            int n;
            ExPolygon exPolygon2 = this.doubleValue(i);
            if (VERIFY) {
                exPolygon.verifyInterserction(exPolygon2);
            }
            if ((n = exPolygon.compareTo(exPolygon2)) > 0) {
                this.children.removeElementAt(i);
                exPolygon.add(exPolygon2);
                continue;
            }
            if (n >= 0) continue;
            exPolygon2.add(exPolygon);
            return;
        }
        this.children.addElement(exPolygon);
    }

    public void addPoint(double d, double d2) {
        if (this.npoints >= 1 && d == this.xpoints[this.npoints - 1] && d2 == this.ypoints[this.npoints - 1]) {
            return;
        }
        if (this.npoints >= 2) {
            if (this.xpoints[this.npoints - 2] == this.xpoints[this.npoints - 1] && d == this.xpoints[this.npoints - 1]) {
                this.xpoints[this.npoints - 1] = d;
                this.ypoints[this.npoints - 1] = d2;
                return;
            }
            if (this.ypoints[this.npoints - 2] == this.ypoints[this.npoints - 1] && d2 == this.ypoints[this.npoints - 1]) {
                if (ExPolygon.copyInto(this.ypoints[this.npoints - 2], this.ypoints[this.npoints - 1]) == ExPolygon.copyInto(this.ypoints[this.npoints - 1], d2)) {
                    this.xpoints[this.npoints - 1] = d;
                    this.ypoints[this.npoints - 1] = d2;
                    return;
                }
                throw new RuntimeException("Overlap segs");
            }
        }
        if (this.npoints == this.xpoints.length) {
            double[] dArray = new double[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, dArray, 0, this.npoints);
            this.xpoints = dArray;
            dArray = new double[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, dArray, 0, this.npoints);
            this.ypoints = dArray;
        }
        this.xpoints[this.npoints] = d;
        this.ypoints[this.npoints] = d2;
        ++this.npoints;
        if (this.bounds != null) {
            this.abs(d, d2);
        }
    }

    public Rect2D getBounds() {
        if (this.bounds == null) {
            if (this.npoints == 0) {
                return null;
            }
            this.VERIFY(this.xpoints, this.ypoints, this.npoints);
        }
        return this.bounds;
    }

    public void closePath() {
        if (this.npoints > 1 && (this.xpoints[this.npoints - 1] != this.xpoints[0] || this.ypoints[this.npoints - 1] != this.ypoints[0])) {
            this.addPoint(this.xpoints[0], this.ypoints[0]);
        }
    }

    private boolean D() {
        return this.xpoints[this.npoints - 1] == this.xpoints[0] && this.ypoints[this.npoints - 1] == this.ypoints[0];
    }

    private void SEDU() {
        double[] dArray = this.xpoints;
        double[] dArray2 = this.ypoints;
        for (int i = this.npoints - 3; i >= 0; --i) {
            if ((dArray[i] != dArray[i + 1] || dArray[i + 1] != dArray[i + 2] || ExPolygon.copyInto(dArray[i], dArray[i + 1]) != ExPolygon.copyInto(dArray[i + 1], dArray[i + 2])) && (dArray2[i] != dArray2[i + 1] || dArray2[i + 1] != dArray2[i + 2] || ExPolygon.copyInto(dArray2[i], dArray2[i + 1]) != ExPolygon.copyInto(dArray2[i + 1], dArray2[i + 2]))) continue;
            System.arraycopy(this.xpoints, i + 2, this.xpoints, i + 1, this.npoints - i - 2);
            System.arraycopy(this.ypoints, i + 2, this.ypoints, i + 1, this.npoints - i - 2);
            --this.npoints;
        }
    }

    public int getRoundDir() {
        if (this.roundDir != 0 || this.npoints <= 2) {
            return this.roundDir;
        }
        double[][] dArray = this.addPoint(this.getBounds().y, 8, -1);
        this.roundDir = (int)Math.round(dArray[0][7]);
        return this.roundDir;
    }

    private void VERIFY(double[] dArray, double[] dArray2, double d) {
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        double d4 = -1.7976931348623157E308;
        double d5 = -1.7976931348623157E308;
        int n = 0;
        while ((double)n < d) {
            double d6 = dArray[n];
            d2 = Math.min(d2, d6);
            d4 = Math.max(d4, d6);
            double d7 = dArray2[n];
            d3 = Math.min(d3, d7);
            d5 = Math.max(d5, d7);
            ++n;
        }
        this.bounds = new Rect2D(d2, d3, d4 - d2, d5 - d3);
    }

    private void abs(double d, double d2) {
        if (d < this.bounds.x) {
            this.bounds.width += this.bounds.x - d;
            this.bounds.x = d;
        } else {
            this.bounds.width = Math.max(this.bounds.width, d - this.bounds.x);
        }
        if (d2 < this.bounds.y) {
            this.bounds.height += this.bounds.y - d2;
            this.bounds.y = d2;
        } else {
            this.bounds.height = Math.max(this.bounds.height, d2 - this.bounds.y);
        }
    }

    private double add(double[] dArray, double d) {
        return dArray[0] + (dArray[2] - dArray[0]) * (d - dArray[1]) / (dArray[3] - dArray[1]);
    }

    private double[][] addElement(double d, int n, int n2) {
        Rect2D rect2D = this.getBounds();
        if (d < rect2D.y || d > rect2D.y + rect2D.height || n2 == -1 && d == rect2D.y + rect2D.height || n2 == 1 && d == rect2D.y) {
            return null;
        }
        Vector<double[]> vector = new Vector<double[]>();
        double d2 = this.xpoints[0];
        double d3 = this.ypoints[0];
        for (int i = 1; i < this.npoints; ++i) {
            double d4 = this.xpoints[i];
            double d5 = this.ypoints[i];
            boolean bl = false;
            double d6 = Math.max(d3, d5);
            double d7 = Math.min(d3, d5);
            if (d7 != d6 && (d7 < d && d < d6 || n2 == -1 && d7 == d || n2 == 1 && d6 == d)) {
                double[] dArray = new double[n];
                dArray[0] = d2;
                dArray[1] = d3;
                dArray[2] = d4;
                dArray[3] = d5;
                dArray[4] = this.add(new double[]{d2, d3, d4, d5}, d);
                dArray[5] = d;
                dArray[6] = i - 1;
                dArray[7] = ExPolygon.compareTo(d3, d5);
                vector.addElement(dArray);
            }
            d2 = d4;
            d3 = d5;
        }
        if (vector.size() == 0) {
            return null;
        }
        double[][] dArrayArray = new double[vector.size()][];
        vector.copyInto((Object[])dArrayArray);
        ExPolygon.compare(dArrayArray, n2 == 1 ? -1 : -2);
        return dArrayArray;
    }

    private double[][] addPoint(double d, int n, int n2) {
        double[][] dArray = this.addElement(d, n, n2);
        return new double[][]{dArray[0], dArray[dArray.length - 1]};
    }

    private ExPolygon[] adjust(double d, int n) {
        int n2;
        double[][] dArray = this.addElement(d, 8, n);
        this.bounds(dArray[0]);
        dArray = this.addElement(d, 11, n);
        int n3 = dArray.length;
        double[][] dArrayArray = new double[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            dArrayArray[n2] = dArray[n2];
            dArrayArray[n2][8] = n2;
        }
        double[][] dArrayArray2 = new double[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            dArrayArray2[n2] = dArray[n2];
        }
        ExPolygon.compare(dArrayArray2, 6);
        for (n2 = 0; n2 < n3; ++n2) {
            dArrayArray2[n2][9] = n2;
        }
        return this.append(n, dArrayArray, dArrayArray2, n3);
    }

    private ExPolygon[] append(int n, double[][] dArray, double[][] dArray2, int n2) {
        Object[] objectArray;
        Vector<ExPolygon> vector = new Vector<ExPolygon>();
        Vector<double[]> vector2 = new Vector<double[]>();
        if (n == 1) {
            int n3 = 0;
            while (true) {
                if (n3 < n2 && (int)dArray[n3][10] != 0) {
                    ++n3;
                    continue;
                }
                if (n3 != n2) {
                    vector2.setSize(0);
                    double[] dArray3 = dArray[n3];
                    double[] dArray4 = dArray2[(int)dArray3[9] + 1];
                    dArray3[10] = dArray3[10] + 1.0;
                    dArray4[10] = dArray4[10] + 1.0;
                    vector2.addElement(dArray3);
                    vector2.addElement(dArray4);
                    int n4 = (int)dArray3[8];
                    int n5 = (int)dArray4[8];
                    if (n5 - n4 >= 2) {
                        int n6 = n5 - 1;
                        while (true) {
                            double[] dArray5 = dArray[n6];
                            double[] dArray6 = dArray2[(int)dArray5[9] + 1];
                            int n7 = (int)dArray6[8];
                            vector2.addElement(dArray5);
                            vector2.addElement(dArray6);
                            dArray5[10] = dArray5[10] + 1.0;
                            dArray6[10] = dArray6[10] + 1.0;
                            if (n7 - n4 == 1) break;
                            n6 = n7 - 1;
                        }
                    }
                    objectArray = (Object[])new double[vector2.size()][];
                    vector2.copyInto(objectArray);
                    vector.addElement(this.arraycopy((double[][])objectArray, n));
                    ++n3;
                    continue;
                }
                break;
            }
        } else {
            int n8 = n2 - 1;
            while (true) {
                if (n8 >= 0 && (int)dArray[n8][10] != 0) {
                    --n8;
                    continue;
                }
                if (n8 < 0) break;
                vector2.setSize(0);
                double[] dArray7 = dArray[n8];
                double[] dArray8 = dArray2[(int)dArray7[9] + 1];
                int n9 = (int)dArray7[8];
                int n10 = (int)dArray8[8];
                if (n9 - n10 >= 2) {
                    int n11 = n10 + 1;
                    while (true) {
                        double[] dArray9 = dArray[n11];
                        double[] dArray10 = dArray2[(int)dArray9[9] + 1];
                        int n12 = (int)dArray10[8];
                        vector2.addElement(dArray9);
                        vector2.addElement(dArray10);
                        dArray9[10] = dArray9[10] + 1.0;
                        dArray10[10] = dArray10[10] + 1.0;
                        if (n9 - n12 == 1) break;
                        n11 = n12 + 1;
                    }
                }
                vector2.addElement(dArray7);
                vector2.addElement(dArray8);
                dArray7[10] = dArray7[10] + 1.0;
                dArray8[10] = dArray8[10] + 1.0;
                objectArray = (Object[])new double[vector2.size()][];
                vector2.copyInto(objectArray);
                vector.addElement(this.arraycopy((double[][])objectArray, n));
                --n8;
            }
        }
        objectArray = new ExPolygon[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    private ExPolygon arraycopy(double[][] dArray, int n) {
        int n2;
        ExPolygon exPolygon = new ExPolygon();
        int n3 = dArray.length;
        if (n == -1) {
            n2 = (int)dArray[n3 - 1][6] + 1;
            exPolygon.addPoint(this.xpoints[n2], this.ypoints[n2]);
        }
        for (n2 = 0; n2 < n3; n2 += 2) {
            double[] dArray2 = dArray[n2];
            int n4 = (int)dArray2[6];
            exPolygon.addPoint(dArray2[4], dArray2[5]);
            if (dArray2[4] != this.xpoints[n4 + 1] || dArray2[5] != this.ypoints[n4 + 1]) {
                exPolygon.addPoint(this.xpoints[n4 + 1], this.ypoints[n4 + 1]);
            }
            double[] dArray3 = dArray[n2 + 1];
            int n5 = (int)dArray3[6];
            for (int i = n4 + 2; i <= n5; ++i) {
                exPolygon.addPoint(this.xpoints[i], this.ypoints[i]);
            }
            if (dArray3[4] == this.xpoints[n5] && dArray3[5] == this.ypoints[n5]) continue;
            exPolygon.addPoint(dArray3[4], dArray3[5]);
        }
        exPolygon.closePath();
        return exPolygon;
    }

    private static ExPolygon[] black(ExPolygon exPolygon, ExPolygon exPolygon2) {
        int n;
        int n2;
        double[] dArray;
        int n3;
        int n4;
        double[][] dArray2 = exPolygon2.addElement(exPolygon2.getBounds().y, 8, -1);
        exPolygon2.bounds(dArray2[0]);
        dArray2 = exPolygon2.addElement(exPolygon2.getBounds().y, 9, -1);
        int n5 = dArray2.length;
        for (n4 = 0; n4 < n5; ++n4) {
            dArray2[n4][8] = -1.0;
        }
        n4 = 0;
        for (int i = exPolygon.npoints - 2; i >= 0; --i) {
            double d = exPolygon.xpoints[i];
            double d2 = exPolygon.ypoints[i];
            double d3 = exPolygon.xpoints[i + 1];
            double d4 = exPolygon.ypoints[i + 1];
            for (n3 = 0; n3 < n5 && n4 < n5; ++n3) {
                double[] dArray3 = dArray2[n3];
                if (dArray3[8] >= 0.0) continue;
                double d5 = dArray3[4];
                double d6 = dArray3[5];
                if ((d != d5 || d2 != d6) && (d2 != d4 || d2 != d6 || !(d <= d5) || !(d5 < d3))) continue;
                dArray3[8] = i;
                ++n4;
            }
        }
        double[] dArray4 = new double[(exPolygon.npoints + exPolygon2.npoints) * 2];
        double[] dArray5 = new double[(exPolygon.npoints + exPolygon2.npoints) * 2];
        int n6 = 0;
        int n7 = (n5 - 2) / 2;
        ExPolygon[] exPolygonArray = null;
        if (n7 > 0) {
            exPolygonArray = new ExPolygon[n7];
            for (int i = 0; i < n7; ++i) {
                int n8;
                dArray = dArray2[2 * i + 1];
                double[] dArray6 = dArray2[(i + 1) * 2];
                int n9 = (int)Math.round(dArray6[8]);
                n2 = (int)Math.round(dArray[8]);
                n3 = (int)Math.round(dArray6[6]) + 1;
                int n10 = (int)Math.round(dArray[6]);
                n6 = 0;
                for (n8 = n3; n8 >= n10; --n8) {
                    dArray4[n6] = exPolygon2.xpoints[n8];
                    dArray5[n6++] = exPolygon2.ypoints[n8];
                }
                for (n8 = n2 + 1; n8 <= n9; ++n8) {
                    dArray4[n6] = exPolygon.xpoints[n8];
                    dArray5[n6++] = exPolygon.ypoints[n8];
                }
                if (exPolygon.xpoints[n2] != dArray6[4] || exPolygon.ypoints[n2] != dArray6[5]) {
                    dArray4[n6] = dArray6[4];
                    dArray5[n6++] = dArray6[5];
                }
                ExPolygon exPolygon3 = new ExPolygon();
                exPolygon3.blue(dArray4, dArray5, n6);
                exPolygonArray[i] = exPolygon3;
            }
        }
        double[] dArray7 = dArray2[0];
        dArray = dArray2[n5 - 1];
        int n11 = (int)Math.round(dArray7[8]) + 1;
        n2 = (int)Math.round(dArray[8]);
        n3 = (int)Math.round(dArray7[6]) + 1;
        int n12 = (int)Math.round(dArray[6]);
        for (n = 0; n < n2; ++n) {
            dArray4[n6] = exPolygon.xpoints[n];
            dArray5[n6++] = exPolygon.ypoints[n];
        }
        if (exPolygon.xpoints[n2] != dArray7[4] || exPolygon.ypoints[n2] != dArray7[5]) {
            dArray4[n6] = exPolygon.xpoints[n2];
            dArray5[n6++] = exPolygon.ypoints[n2];
        }
        for (n = n3; n >= n12; --n) {
            dArray4[n6] = exPolygon2.xpoints[n];
            dArray5[n6++] = exPolygon2.ypoints[n];
        }
        for (n = n11; n < exPolygon.npoints; ++n) {
            dArray4[n6] = exPolygon.xpoints[n];
            dArray5[n6++] = exPolygon.ypoints[n];
        }
        exPolygon.blue(dArray4, dArray5, n6);
        exPolygon.closePath();
        return exPolygonArray;
    }

    public void unfold() {
        if (this.children == null || this.children.size() == 0) {
            return;
        }
        int n = 0;
        while (n < this.children.size()) {
            int n2;
            ExPolygon exPolygon = this.doubleValue(n);
            Vector vector = exPolygon.children;
            if (vector == null || vector.size() == 0) {
                ++n;
                continue;
            }
            int n3 = vector.size();
            double d = Double.MAX_VALUE;
            for (int i = 0; i < n3; ++i) {
                d = Math.min(d, ((ExPolygon)vector.elementAt((int)i)).getBounds().y);
            }
            ExPolygon[] exPolygonArray = exPolygon.adjust(d, 1);
            ExPolygon[] exPolygonArray2 = exPolygon.adjust(d, -1);
            int n4 = exPolygonArray.length;
            int n5 = exPolygonArray2.length;
            if (n4 > 0) {
                this.children.setElementAt(exPolygonArray[0], n);
            } else {
                this.children.setElementAt(exPolygonArray2[0], n);
            }
            for (n2 = 1; n2 < n4; ++n2) {
                this.children.addElement(exPolygonArray[n2]);
            }
            int n6 = n2 = n4 > 0 ? 0 : 1;
            while (n2 < n5) {
                this.children.addElement(exPolygonArray2[n2]);
                ++n2;
            }
            for (n2 = 0; n2 < n5 && vector.size() > 0; ++n2) {
                ExPolygon exPolygon2 = exPolygonArray2[n2];
                for (int i = vector.size() - 1; i >= 0; --i) {
                    ExPolygon exPolygon3 = (ExPolygon)vector.elementAt(i);
                    if (exPolygon2.compareTo(exPolygon3) <= 0) continue;
                    if (ExPolygon.copyInto(exPolygon2.getBounds().y, exPolygon3.getBounds().y) == 0) {
                        int n7;
                        ExPolygon[] exPolygonArray3;
                        if (exPolygon3.children != null) {
                            exPolygonArray3 = exPolygon3.children;
                            for (n7 = 0; n7 < exPolygonArray3.size(); ++n7) {
                                this.children.addElement((ExPolygon)exPolygonArray3.elementAt(n7));
                            }
                        }
                        if ((exPolygonArray3 = ExPolygon.black(exPolygon2, exPolygon3)) != null) {
                            for (n7 = 0; n7 < exPolygonArray3.length; ++n7) {
                                this.children.addElement(exPolygonArray3[n7]);
                            }
                        }
                    } else {
                        if (exPolygon2.children == null) {
                            exPolygon2.children = new Vector();
                        }
                        exPolygon2.children.addElement(exPolygon3);
                    }
                    vector.removeElementAt(i);
                }
            }
        }
        int n8 = this.children.size();
        for (int i = 0; i < n8; ++i) {
            this.doubleValue(i).SEDU();
        }
    }

    private void blue(double[] dArray, double[] dArray2, int n) {
        if (this.xpoints.length < n) {
            this.xpoints = new double[n];
            this.ypoints = new double[n];
        }
        System.arraycopy(dArray, 0, this.xpoints, 0, n);
        System.arraycopy(dArray2, 0, this.ypoints, 0, n);
        this.npoints = n;
        this.bounds = null;
        this.roundDir = 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.getClass().getName()).append("@").append(this.hashCode());
        stringBuffer.append("{n=").append(this.npoints).append(" ");
        stringBuffer.append("round=").append(this.getRoundDir() == 1 ? "CLK" : "ACLK").append(" ");
        Rect2D rect2D = this.getBounds();
        if (rect2D != null) {
            stringBuffer.append("bounds ").append(rect2D.x + "_" + rect2D.y + "_" + rect2D.width + "_" + rect2D.height + " ");
        }
        for (int i = 0; i < this.npoints; ++i) {
            stringBuffer.append(" ");
            stringBuffer.append((int)this.xpoints[i]).append("_").append((int)this.ypoints[i]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void bounds(double[] dArray) {
        boolean bl;
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[2];
        double d4 = dArray[3];
        double d5 = dArray[4];
        double d6 = dArray[5];
        int n = (int)Math.round(dArray[6]);
        int n2 = (int)Math.round(dArray[7]);
        int n3 = this.getRoundDir();
        boolean bl2 = d5 == d && d6 == d2;
        boolean bl3 = bl = d5 == d3 && d6 == d4;
        if (bl2 && n == 0 && n3 == 1) {
            return;
        }
        if (this.xpoints[this.npoints - 1] == this.xpoints[0] && this.ypoints[this.npoints - 1] == this.ypoints[0]) {
            --this.npoints;
        }
        int n4 = this.npoints + (bl2 || bl ? 1 : 2);
        double[] dArray2 = new double[n4];
        double[] dArray3 = new double[n4];
        dArray2[0] = d5;
        dArray3[0] = d6;
        dArray2[n4 - 1] = d5;
        dArray3[n4 - 1] = d6;
        if (n3 == 1) {
            if (bl) {
                n = n == this.npoints - 1 ? 0 : n + 1;
                d = this.xpoints[n];
                d2 = this.ypoints[n];
                d3 = this.xpoints[n + 1];
                d4 = this.ypoints[n + 1];
                bl2 = true;
                bl = false;
            }
            System.arraycopy(this.xpoints, n + 1, dArray2, 1, this.npoints - n - 1);
            System.arraycopy(this.ypoints, n + 1, dArray3, 1, this.npoints - n - 1);
            System.arraycopy(this.xpoints, 0, dArray2, this.npoints - n, n + 1);
            System.arraycopy(this.ypoints, 0, dArray3, this.npoints - n, n + 1);
        } else {
            int n5;
            if (bl2) {
                n = n == 0 ? this.npoints - 1 : n - 1;
                d = this.xpoints[n];
                d2 = this.ypoints[n];
                d3 = this.xpoints[n + 1];
                d4 = this.ypoints[n + 1];
                bl2 = false;
                bl = true;
            }
            int n6 = 1;
            for (n5 = n; n5 >= 0; --n5) {
                dArray2[n6] = this.xpoints[n5];
                dArray3[n6] = this.ypoints[n5];
                ++n6;
            }
            for (n5 = this.npoints - 1; n5 > n; --n5) {
                dArray2[n6] = this.xpoints[n5];
                dArray3[n6] = this.ypoints[n5];
                ++n6;
            }
        }
        this.npoints = n4;
        this.xpoints = dArray2;
        this.ypoints = dArray3;
        this.roundDir = 1;
    }

    public int compareTo(ExPolygon exPolygon) {
        return ExPolygon.compare(this, exPolygon);
    }

    public static int compare(ExPolygon exPolygon, ExPolygon exPolygon2) {
        int n;
        int n2;
        Rect2D rect2D = exPolygon.getBounds();
        Rect2D rect2D2 = exPolygon2.getBounds();
        Rect2D rect2D3 = rect2D.intersection(rect2D2);
        if (rect2D3.width <= 0.0 || rect2D3.height <= 0.0) {
            return 0;
        }
        double d = rect2D3.y;
        double[][] dArray = exPolygon.addElement(d, 9, -1);
        double[][] dArray2 = exPolygon2.addElement(d, 9, -1);
        int n3 = dArray.length;
        int n4 = dArray2.length;
        for (n2 = 0; n2 < n3; ++n2) {
            dArray[n2][8] = 1.0;
        }
        for (n2 = 0; n2 < n4; ++n2) {
            dArray2[n2][8] = 2.0;
        }
        n2 = n3 + n4;
        double[][] dArrayArray = new double[n2][];
        System.arraycopy(dArray, 0, dArrayArray, 0, n3);
        System.arraycopy(dArray2, 0, dArrayArray, n3, n4);
        ExPolygon.compare(dArrayArray, -2);
        if (dArrayArray[0][8] != dArrayArray[n2 - 1][8]) {
            return 0;
        }
        double d2 = dArrayArray[0][8];
        for (n = 1; dArrayArray[n][8] == d2 && n < n2 - 1; ++n) {
        }
        if (n % 2 == 0) {
            return 0;
        }
        return ExPolygon.copyInto(dArrayArray[n][8], d2);
    }

    private static final int children(double[] dArray, double[] dArray2, int n) {
        if (n >= 0) {
            return ExPolygon.copyInto(dArray[n], dArray2[n]);
        }
        switch (n) {
            case -2: 
            case -1: {
                double[] dArray3;
                double[] dArray4;
                double d = dArray[4];
                double d2 = dArray2[4];
                if (d != d2) {
                    return ExPolygon.copyInto(d, d2);
                }
                if (n == -1) {
                    dArray4 = dArray[7] == 1.0 ? new double[]{dArray[4], dArray[5], dArray[2], dArray[3]} : new double[]{dArray[4], dArray[5], dArray[0], dArray[1]};
                    dArray3 = dArray2[7] == 1.0 ? new double[]{dArray2[4], dArray2[5], dArray2[2], dArray2[3]} : new double[]{dArray2[4], dArray2[5], dArray2[0], dArray2[1]};
                } else if (n == -2) {
                    dArray4 = dArray[7] == 1.0 ? new double[]{dArray[4], dArray[5], dArray[0], dArray[1]} : new double[]{dArray[4], dArray[5], dArray[2], dArray[3]};
                    dArray3 = dArray2[7] == 1.0 ? new double[]{dArray2[4], dArray2[5], dArray2[0], dArray2[1]} : new double[]{dArray2[4], dArray2[5], dArray2[2], dArray2[3]};
                } else {
                    throw new RuntimeException("unsupport type " + n);
                }
                int n2 = ExPolygon.closePath(dArray4, dArray3);
                return n2;
            }
        }
        throw new RuntimeException("Unsupport compareTo type " + n);
    }

    private static int close(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        int n = ExPolygon.copyInto(d, d5);
        return n != 0 ? n : ExPolygon.copyInto((d3 - d) * (d8 - d6), (d4 - d2) * (d7 - d5)) * ExPolygon.copyInto(d4, d2);
    }

    private static int closePath(double[] dArray, double[] dArray2) {
        return ExPolygon.close(dArray[0], dArray[1], dArray[2], dArray[3], dArray2[0], dArray2[1], dArray2[2], dArray2[3]);
    }

    private static final void compare(double[][] dArray, int n) {
        ExPolygon.sort(dArray, 0, dArray.length - 1, n);
    }

    public static final void sort(double[][] dArray, int n, int n2, int n3) {
        if (ExPolygon.children(dArray[n], dArray[n2], n3) > 0) {
            double[] dArray2 = dArray[n];
            dArray[n] = dArray[n2];
            dArray[n2] = dArray2;
        }
        if (n + 1 >= n2) {
            return;
        }
        int n4 = (n2 - n + 1) / 3;
        ExPolygon.sort(dArray, n, n2 - n4, n3);
        ExPolygon.sort(dArray, n + n4, n2, n3);
        ExPolygon.sort(dArray, n, n2 - n4, n3);
    }

    private static final int compareTo(double d, double d2) {
        return d == d2 ? 0 : (d > d2 ? 1 : -1);
    }

    private static final int copyInto(double d, double d2) {
        if (Math.abs(d - d2) < 1.0E-5) {
            return 0;
        }
        return d > d2 ? 1 : (d < d2 ? -1 : 0);
    }

    private final ExPolygon doubleValue(int n) {
        return (ExPolygon)this.children.elementAt(n);
    }

    public void fill(Graphics graphics, double d, double d2) {
        this.fillOutline(graphics, d, d2);
        if (this.children != null) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                this.doubleValue(i).fill(graphics, d, d2);
            }
        }
    }

    public void fillOutline(Graphics graphics, double d, double d2) {
        if (this.npoints < 2) {
            return;
        }
        if (graphics instanceof JGraphics) {
            graphics = ((JGraphics)graphics).getImpl();
        }
        if (graphics instanceof Rasterable) {
            double[] dArray = new double[this.npoints];
            double[] dArray2 = new double[this.npoints];
            for (int i = 0; i < this.npoints; ++i) {
                dArray[i] = this.xpoints[i] + d;
                dArray2[i] = this.ypoints[i] + d2;
            }
            ((Rasterable)((Object)graphics)).fillPolygon(dArray, dArray2, this.npoints);
        } else {
            int[] nArray = new int[this.npoints];
            int[] nArray2 = new int[this.npoints];
            for (int i = 0; i < this.npoints; ++i) {
                nArray[i] = (int)Math.round(this.xpoints[i]) + (int)Math.round(d);
                nArray2[i] = (int)Math.round(this.ypoints[i]) + (int)Math.round(d2);
            }
            graphics.fillPolygon(nArray, nArray2, this.npoints);
        }
    }

    public void draw(Graphics graphics, double d, double d2) {
        this.draw(graphics, d, d2, false);
    }

    public void draw(Graphics graphics, double d, double d2, boolean bl) {
        this.drawOutline(graphics, d, d2, bl);
        if (this.children != null) {
            for (int i = this.children.size() - 1; i >= 0; --i) {
                this.doubleValue(i).draw(graphics, d, d2, bl);
            }
        }
    }

    public void drawOutline(Graphics graphics, double d, double d2, boolean bl) {
        if (this.npoints <= 1) {
            return;
        }
        double d3 = this.xpoints[0];
        double d4 = this.ypoints[0];
        double d5 = d3;
        double d6 = d4;
        for (int i = 1; i < this.npoints; ++i) {
            d5 = this.xpoints[i];
            d6 = this.ypoints[i];
            ExPolygon.drawLine(graphics, d + d3, d2 + d4, d + d5, d2 + d6);
            d3 = d5;
            d4 = d6;
        }
        d5 = this.xpoints[0];
        d6 = this.ypoints[0];
        if (d3 != d5 || d4 != d6) {
            ExPolygon.drawLine(graphics, d + d3, d2 + d4, d + d5, d2 + d6);
        }
    }

    public static void drawLine(Graphics graphics, double d, double d2, double d3, double d4) {
        graphics.drawLine((int)Math.round(d), (int)Math.round(d2), (int)Math.round(d3), (int)Math.round(d4));
    }

    public void adjust(double d, double d2) {
        int n = 0;
        while (n < this.npoints) {
            int n2 = n;
            this.xpoints[n2] = this.xpoints[n2] - d;
            int n3 = n++;
            this.ypoints[n3] = this.ypoints[n3] - d2;
        }
        if (this.bounds != null) {
            this.bounds.x -= d;
            this.bounds.y -= d2;
        }
        if (this.children == null || this.children.size() == 0) {
            return;
        }
        for (n = 0; n < this.children.size(); ++n) {
            this.doubleValue(n).adjust(d, d2);
        }
    }

    public void zoom(double d) {
        int n = 0;
        while (n < this.npoints) {
            int n2 = n;
            this.xpoints[n2] = this.xpoints[n2] * d;
            int n3 = n++;
            this.ypoints[n3] = this.ypoints[n3] * d;
            this.bounds = null;
            this.roundDir = 0;
        }
        if (this.children == null) {
            return;
        }
        for (n = 0; n < this.children.size(); ++n) {
            this.doubleValue(n).zoom(d);
        }
    }

    public boolean verifyInterserction(ExPolygon exPolygon) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.npoints - 1; ++i) {
            double d = this.xpoints[i];
            double d2 = this.ypoints[i];
            double d3 = this.xpoints[i + 1];
            double d4 = this.ypoints[i + 1];
            for (int j = 0; j < exPolygon.npoints - 1; ++j) {
                double[][] dArray = ExPolygon.getLineJunc(d, d2, d3, d4, exPolygon.xpoints[j], exPolygon.ypoints[j], exPolygon.xpoints[j + 1], exPolygon.ypoints[j + 1]);
                if (dArray == null || dArray.length <= 0) continue;
                stringBuffer.append("this seg " + d + "_" + d2 + "_" + d3 + "_" + d4 + " intersects with other " + exPolygon.xpoints[j] + "_" + exPolygon.ypoints[j] + "_" + exPolygon.xpoints[j + 1] + "_" + exPolygon.ypoints[j + 1] + "\n");
            }
        }
        if (stringBuffer.length() == 0) {
            return true;
        }
        System.err.println("*** Verify intersection ***");
        this.dump(1);
        exPolygon.dump(1);
        System.err.println("Found following errors");
        System.err.print(stringBuffer);
        new Exception().printStackTrace(System.err);
        System.err.println("***************************");
        return false;
    }

    public void verify() {
        int n;
        int n2 = this.npoints;
        double[] dArray = this.xpoints;
        double[] dArray2 = this.ypoints;
        StringBuffer stringBuffer = new StringBuffer();
        if (n2 <= 2) {
            stringBuffer.append("Points are less than 3\n");
        }
        if (!this.D()) {
            stringBuffer.append("Unclosed\n");
        }
        for (n = 0; n < n2 - 1; ++n) {
            if (dArray[n] != dArray[n + 1] || dArray2[n] != dArray2[n + 1]) continue;
            stringBuffer.append("Dup points are at " + n + " " + dArray[n] + "_" + dArray2[n] + "\n");
        }
        for (n = 0; n < n2 - 2; ++n) {
            if (dArray[n] == dArray[n + 1] && dArray[n + 1] == dArray[n + 2] && ExPolygon.copyInto(dArray[n], dArray[n + 1]) != ExPolygon.copyInto(dArray[n + 1], dArray[n + 2])) {
                stringBuffer.append("Overlap segs at X, pos " + n + " " + dArray[n] + "_" + dArray2[n] + " " + dArray[n + 1] + "_" + dArray2[n + 1] + " " + dArray[n + 2] + "_" + dArray2[n + 2] + "\n");
            }
            if (dArray2[n] != dArray2[n + 1] || dArray2[n + 1] != dArray2[n + 2] || ExPolygon.copyInto(dArray2[n], dArray2[n + 1]) == ExPolygon.copyInto(dArray2[n + 1], dArray2[n + 2])) continue;
            stringBuffer.append("Overlap segs at Y, pos " + n + " " + dArray[n] + "_" + dArray2[n] + " " + dArray[n + 1] + "_" + dArray2[n + 1] + " " + dArray[n + 2] + "_" + dArray2[n + 2] + "\n");
        }
        for (n = 0; n < n2 - 3; ++n) {
            for (int i = n + 3; i < n2 - 2; ++i) {
                double[][] dArray3 = ExPolygon.getLineJunc(dArray[n], dArray2[n], dArray[n + 1], dArray2[n + 1], dArray[i], dArray2[i], dArray[i + 1], dArray2[i + 1]);
                if (dArray3 == null || dArray3.length != 1) continue;
                stringBuffer.append("intersects seg " + n + " and " + i + ", " + dArray[n] + "_" + dArray2[n] + "_" + dArray[n + 1] + "_" + dArray2[n + 1] + " " + dArray[i] + "_" + dArray2[i] + "_" + dArray[i + 1] + "_" + dArray2[i + 1] + ", junc:" + dArray3[0][0] + "_" + dArray3[0][1]);
            }
        }
        if (this.bounds != null) {
            Rect2D rect2D = this.bounds;
            this.bounds = null;
            if (!rect2D.equals(this.getBounds())) {
                stringBuffer.append("Exprired bounds, org " + this.bounds + ", new " + this.getBounds() + "\n");
                this.bounds = rect2D;
            }
        }
        if (this.roundDir != 0) {
            int n3 = this.roundDir;
            this.roundDir = 0;
            if (n3 != this.getRoundDir()) {
                stringBuffer.append("Exprired roundDir, org " + n3 + ", new " + this.roundDir + "\n");
                this.roundDir = n3;
            }
        }
        if (stringBuffer.length() > 0) {
            System.err.println("*** Verify polygon ***");
            this.dump(1);
            System.err.println("Found Following errors:");
            System.err.print(stringBuffer.toString());
            new Exception().printStackTrace();
            System.err.println("**********************");
        }
    }

    public static double[][] getLineJunc(double[] dArray, double[] dArray2) {
        return ExPolygon.getLineJunc(dArray[0], dArray[1], dArray[2], dArray[3], dArray2[0], dArray2[1], dArray2[2], dArray2[3]);
    }

    public static double[][] getLineJunc(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9;
        double d10;
        if (d == d3) {
            if (d5 == d7) {
                return d == d5 ? (double[][])null : (double[][])new double[0][];
            }
            d10 = d;
            d = d5;
            d5 = d10;
            d10 = d3;
            d3 = d7;
            d7 = d10;
            d10 = d2;
            d2 = d6;
            d6 = d10;
            d10 = d4;
            d4 = d8;
            d8 = d10;
        }
        d10 = (d4 - d2) / (d3 - d);
        double d11 = d2 - d10 * d;
        if (d5 == d7) {
            d9 = d5;
        } else {
            double d12 = (d8 - d6) / (d7 - d5);
            double d13 = d6 - d12 * d5;
            if (d12 == d10) {
                return d13 == d11 ? (double[][])null : (double[][])new double[0][];
            }
            d9 = (d11 - d13) / (d12 - d10);
        }
        double d14 = d10 * d9 + d11;
        if (ExPolygon.copyInto(d, d9) == 0 && ExPolygon.copyInto(d2, d14) == 0 || ExPolygon.copyInto(d3, d9) == 0 && ExPolygon.copyInto(d4, d14) == 0 || ExPolygon.copyInto(d5, d9) == 0 && ExPolygon.copyInto(d6, d14) == 0 || ExPolygon.copyInto(d7, d9) == 0 && ExPolygon.copyInto(d8, d14) == 0) {
            return new double[0][];
        }
        if (ExPolygon.copyInto(d, d9) == ExPolygon.copyInto(d9, d3) && ExPolygon.copyInto(d2, d14) == ExPolygon.copyInto(d14, d4) && ExPolygon.copyInto(d5, d9) == ExPolygon.copyInto(d9, d7) && ExPolygon.copyInto(d6, d14) == ExPolygon.copyInto(d14, d8)) {
            return new double[][]{{d9, d14}};
        }
        return new double[0][];
    }

    public Rect2D getOutlineRect() {
        if (this.children == null || this.children.size() == 0) {
            throw new RuntimeException("Null ExPolygon");
        }
        Rect2D rect2D = this.doubleValue(0).getBounds();
        for (int i = 1; i < this.children.size(); ++i) {
            rect2D = rect2D.union(this.doubleValue(i).getBounds());
        }
        return rect2D;
    }

    public double[] adjust() {
        Rect2D rect2D = this.getOutlineRect();
        this.adjust(rect2D.x, rect2D.y);
        return new double[]{rect2D.x, rect2D.y};
    }

    public static void drawRect(Graphics graphics, double d, double d2, double d3, double d4) {
        graphics.drawRect((int)Math.round(d), (int)Math.round(d2), (int)Math.round(d3), (int)Math.round(d4));
    }

    public static void fillRect(Graphics graphics, double d, double d2, double d3, double d4) {
        graphics.fillRect((int)Math.round(d), (int)Math.round(d2), (int)Math.round(d3), (int)Math.round(d4));
    }

    public static void drawString(Graphics graphics, String string, double d, double d2) {
        graphics.drawString(string, (int)Math.round(d), (int)Math.round(d2));
    }

    public static void dump(double[] dArray) {
        ExPolygon.dump(dArray, System.out, false);
    }

    public static void dump(double[] dArray, PrintStream printStream, boolean bl) {
        if (bl) {
            printStream.print("seg:" + dArray[0] + "_" + dArray[1] + "_" + dArray[2] + "_" + dArray[3] + " junc:" + dArray[4] + "_" + dArray[5] + " segnum:" + dArray[6] + ((int)dArray[7] == 1 ? " UP" : ((int)dArray[7] == -1 ? " DOWN" : ((int)dArray[7] == 0 ? " HORI" : " UNKNOWN DIR " + dArray[7]))));
        } else {
            printStream.print("seg:" + (int)dArray[0] + "_" + (int)dArray[1] + "_" + (int)dArray[2] + "_" + (int)dArray[3] + " junc:" + (int)dArray[4] + "_" + (int)dArray[5] + " segnum:" + dArray[6] + ((int)dArray[7] == 1 ? " UP" : ((int)dArray[7] == -1 ? " DOWN" : ((int)dArray[7] == 0 ? " HORI" : " UNKNOWN DIR " + dArray[7]))));
        }
        if (dArray.length > 10) {
            printStream.print(" xodr:" + (int)dArray[8]);
            printStream.print(" segodr:" + (int)dArray[9]);
            printStream.print(" touched:" + (int)dArray[10]);
        } else {
            for (int i = 8; i < dArray.length; ++i) {
                printStream.print(" " + i + ":" + dArray[i]);
            }
        }
        printStream.println();
    }

    public void dump(int n) {
        this.dump(n, true);
    }

    public void dump(int n, boolean bl) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            System.out.print("  ");
        }
        System.out.print("" + n + ": ");
        if (bl) {
            System.out.println(this);
        } else {
            System.out.println(this.hashCode());
        }
        if (this.children != null) {
            for (n2 = 0; n2 < this.children.size(); ++n2) {
                this.doubleValue(n2).dump(n + 1);
            }
        }
    }

    public void dump(Graphics graphics, int n, int n2) {
        this.drawLine(graphics, n, n2, 0);
    }

    public void save(String string) {
        try {
            PrintStream printStream = new PrintStream(new FileOutputStream(string));
            this.draw(printStream, -1);
            printStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void draw(PrintStream printStream, int n) throws IOException {
        int n2;
        if (this.npoints > 0) {
            for (n2 = 0; n2 < n; ++n2) {
                printStream.print("   ");
            }
            for (n2 = 0; n2 < this.npoints; ++n2) {
                printStream.print("" + this.xpoints[n2] + "_" + this.ypoints[n2] + ",");
            }
        }
        printStream.println();
        if (this.children == null) {
            return;
        }
        for (n2 = 0; n2 < this.children.size(); ++n2) {
            this.doubleValue(n2).draw(printStream, n + 1);
        }
    }

    public static ExPolygon read(String string) {
        try {
            String string2;
            DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
            ExPolygon exPolygon = new ExPolygon();
            while ((string2 = dataInputStream.readLine()) != null) {
                if ((string2 = string2.trim()).length() == 0 || string2.startsWith("#") || string2.startsWith(";")) continue;
                ExPolygon exPolygon2 = new ExPolygon();
                StringTokenizer stringTokenizer = new StringTokenizer(string2, " ,_");
                while (stringTokenizer.hasMoreTokens()) {
                    double d = new Double(stringTokenizer.nextToken());
                    double d2 = new Double(stringTokenizer.nextToken());
                    exPolygon2.addPoint(d, d2);
                }
                exPolygon.add(exPolygon2);
            }
            dataInputStream.close();
            return exPolygon;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private void drawLine(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(SEDU[n3]);
        this.fill(graphics, n, n2);
        if (this.children == null) {
            return;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            this.doubleValue(i).drawLine(graphics, n, n2, n3 + 1);
        }
    }

    static {
        SEDU = new Color[]{Color.white, Color.black, Color.blue, Color.red, Color.green, Color.yellow};
    }
}

