
import jet.api.*;
import jet.jetc.WriteFailureException;
import jet.universe.exception.FMLFileException;
import java.io.*;


/**
 * This class is used to test CatalogAPI.
 * It will open an existing catalog file or create a new catalog if one does not exist
 *     add a new connection and list the connection information from all datasources in the catalog
 * If the specified catalog does not exist, the save method will fail
 * Requires this database be available: c:\\JReport\\Designer\\Demo\\db\\DemoDB
 * Usage: TellMeConnection -path=<path> -catalog=<catalog> 
 */

public class TellMeConnection
{	
	private final static String catArg = "-catalog=";
	private final static String pathArg = "-path=";
	private jet.api.Designer dr = null;
	private jet.api.CatalogAPI cat = null;
	
	 private final static void showUsage() {
	        System.out.println( "TellMeConnection - show connections in catalog.");
	        System.out.println( "Usage:  java TellMeConnection <-options>");
	        System.out.println("\nwhere options include:");
	        System.out.println("    " + pathArg +   "<path to catalog>  indicates the full path name to the report catalog directory");
	        System.out.println("    " + catArg +    "<catalog name>  indicates the name of the report catalog");	       
	        System.out.println("\nExample to create a catalog ane get information of connection from the command line:");
	        System.out.println("java TellMeConnection -path=C:\\JReport\\Designer\\Demo\\TutorialReports  -catalog=JinfonetGourmetJava.cat");
	    }
	
	/**
	* Constructor
	*/
	public TellMeConnection(String path, String catName)
	{
		File f = new File(path);
		if(!f.exists())
		{
			f.mkdirs();
		}
		try
		{			
			DesignerUserInfo userInfo=new DesignerUserInfo("Jinfonet","XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
			dr = new Designer(path, catName,userInfo);
			cat = dr.getCatalogAPI();
			if (cat == null)
			{
				System.out.println("Catalog is null, most likely the license key or user id is invalid");
				System.exit(1);
			}
			// Add a new datasource called DemoDB and connection Jinfonet demo.
			ConnectionInfo info = new ConnectionInfo("sa", "");
			String con = cat.insert("DemoDB", false,"Jinfonet demo", "demo db", "jdbc:hsqldb:C:\\JReport\\Designer\\Demo\\db\\DemoDB", "org.hsqldb.jdbcDriver", info);			
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}	
	
	/**
	* Gets the connection information from a catalog file
	*/
	public void printConnectionInfo()
	{
		String h[] = cat.getHandles();
		
		for(int i = 0; i < h.length; i++)
		{
			if(cat.getClassType(h[i]) == CatalogAPI.CONNECTION)
			{
				System.out.println("---------------------------------------------------------------");
				System.out.println("Name\t\t\t" + cat.getString(h[i], "Name") );
				System.out.println("URL\t\t\t" + cat.getString(h[i], "URL"));
				System.out.println("Driver\t\t" + cat.getString(h[i], "Driver"));
				System.out.println("User\t\t\t" + cat.getString(h[i], "User"));
				System.out.println("Password\t\t\t" + cat.getString(h[i], "Password"));
				System.out.println("TimestampFormat\t\t\t" + cat.getString(h[i], "TimestampFormat"));
				System.out.println("TimeFormat\t\t\t" + cat.getString(h[i], "TimeFormat"));
				System.out.println("DateFormat\t\t\t" + cat.getString(h[i], "DateFormat"));
				System.out.println("ExtraNamePattern\t\t\t" + cat.getString(h[i], "ExtraNamePattern"));				
			}
		}
	}
	
	/**
	* Close all, release all resource.	
	*/	
	public void closeAll()
	{
		try
		{				
			cat.closeLog();			
			dr.closeLog();	
			dr.exit();
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
	}
	
	
	public static void main(String[] argv)
	{		
		 // values of command line arguments.
        String path = "";
        String catalog = "";
     
        // get values of command line arguments
        if (argv.length < 2)
        {
        	showUsage();
        	System.exit(1);
        }
        for (int i = 0; i < argv.length; i++) {
            if (argv[i].toLowerCase().startsWith(catArg)) {
                catalog = argv[i].substring(catArg.length(), argv[i].length());
            } else if (argv[i].toLowerCase().startsWith(pathArg)) {
                path = argv[i].substring(pathArg.length(), argv[i].length());
            }  else {
                // is not a valid command line argument
                showUsage();
                System.exit(1);
            }
         }    
		
		TellMeConnection t = new TellMeConnection(path,catalog);
		try {
			t.dr.setLog(new FileOutputStream("./desgLog.txt"), "8859_1");
			t.cat.setLog(new FileOutputStream("./catLog.txt"), "8859_1");//Catalog Message
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}		
		t.printConnectionInfo();
		// Save the updates to the catalog
		try {
				t.cat.save();			
		} catch (WriteFailureException e) {
			e.printStackTrace();
		} catch (FMLFileException e) {
			e.printStackTrace();
		}
		t.closeAll();
		System.exit(0);
	}
}
