import java.util.*;
import jet.util.*;

/**
 * When you group/sort data dynamically with a parameter, when viewing the report, a dialog will be displayed, 
 * in which you will find many default values in the drop-down list. 
 * However, since you do not need so many values with which to group/sort, 
 * you can specify your required default values in a Java class, and then import them by specifying your class 
 * in the Import Parameter Value property in Designer.
 *
 */
public class TestParamList implements ImportParamValues
{
	
	public TestParamList()
	{
		;
	}

	public Hashtable promptValues(String paramsName[])
	{
		
		String name;
		
		Vector values;
		Hashtable ret = new Hashtable();	
		
		for ( int t = paramsName.length; --t >= 0; )
		{
			name = paramsName[t];
			
			if ( name.compareToIgnoreCase("importpara")==0 )    //The "importpara" is parameter defined in Catalog.
			{
				values = new Vector();
				values.addElement("Orders_Order ID");     //Set values to vector to get the parameter default values.
				values.addElement("Orders_Customer ID");
				values.addElement("Orders Detail_Order ID");
				values.addElement("Orders Detail_Product ID");				
				ret.put(name, values);
				
			}
			else if (name.compareToIgnoreCase("subgroup1")==0)			
			{
				values = new Vector();
				values.addElement("Product Name");
				values.addElement("Products_ProductID");
				values.addElement("Products_Product Type ID");
				values.addElement("Productclass");				
				ret.put(name, values);
				
			}
							
			else if (name.compareToIgnoreCase("subsort1")==0)			
			{
				values = new Vector();
				values.addElement("Product Name");
				values.addElement("Products_ProductID");
				values.addElement("Products_Product Type ID");
				values.addElement("Productclass");				
				ret.put(name, values);
				
			}
						
			else if (name.compareToIgnoreCase("mainsort1")==0)			
			{
				values = new Vector();
				values.addElement("Orders_Order ID");
				values.addElement("Orders_Customer ID");
				values.addElement("Orders Detail_Order ID");
				values.addElement("Orders Detail_Product ID");				
				ret.put(name, values);
				
			}
			else if (name.compareToIgnoreCase("maingroup1")==0)			
			{
				values = new Vector();
				values.addElement("Orders_Order ID");
				values.addElement("Orders_Customer ID");
				values.addElement("Orders Detail_Order ID");
				values.addElement("Orders Detail_Product ID");				
				ret.put(name, values);
				
			}						
			else
			{				
			}
			
		}

		return ret;
	}
}
