import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

import jet.cs.util.APIConst;
import jet.server.api.ExportedFileList;
import jet.server.api.RemoteFileService;
import jet.server.api.rmi.RemoteReportServerToolkit;
import jet.server.api.rmi.RemoteRptServer;
/**
 * This demo is created to demonstrate the usage of the JReport Server API methods to run and export results
 * using a remote interface to JReport Server.  It may be on the same computer but running in a different JVM.
 * This is the normal way to make requests to a stand-alone JReport Server.
 * Assume that there is a catalog SampleReports.cat, a report CustomerAnalysis.cls 
 * already deployed to /SampleReports in Public Reports.
 * Requires that the C:\JReport\Server\temp directory exists.
 */
public class RemoteAPIDemoRunAndExportReport {

	public static void main(String[] args) {
		try {
			//set report home for logging and location of rmi.auth file for security
			System.getProperties().put("reporthome", "C:\\JReport\\Server");
			System.getProperties().put("jrs.rmi.auth_file", "C:\\JReport\\Server\\bin\\rmi.auth");
			String host = "localhost";	// Default value for host
			String port = "1129";		// Default value for port
			System.out.println("*******************************************************************************");									
			System.out.println("You must input your server's IP before running the APIDemo!");
			System.out.println("Please input your server's IP, and make sure it is correct! For example '111.111.111.111'");
			System.out.println("*******************************************************************************");
			// get Server's IP input by user
			BufferedReader inputIP = new BufferedReader(new InputStreamReader(System.in));	    
			host = inputIP.readLine();
			System.out.println();
		    
			// print the note and description
			System.out.println("******************************************************************************");									
			System.out.println("You must input the port to connect server before running the APIDemo!");
			System.out.println("Please input the port, and make sure it is correct! For example '1129'");
			System.out.println("******************************************************************************");
			// get port input by user
			BufferedReader inputPort = new BufferedReader(new InputStreamReader(System.in));	    
			port = inputPort.readLine();
			System.out.println();

            // get a RemoteRptServer instance
			RemoteRptServer server = RemoteReportServerToolkit.getRemoteRptServer(host, port);
			System.out.println("========server="+server);

			// get a RemoteFileService instance
			RemoteFileService remoteFileService = RemoteReportServerToolkit.getRemoteFileService(host, port);
			System.out.println("========remoteFileService="+remoteFileService);

			String catalog = "/SampleReports/SampleReports.cat";
			String rptName = "/SampleReports/Banded_Link.cls";

			//set report properties
			Properties props = new Properties();
			
			props.put(APIConst.TAG_REPORT_LANGUAGE, "en_US");
			String today = DateFormat.getDateInstance(DateFormat.LONG, new Locale("en", "US")).format(new Date());
			//set value of parameter "p_StartDate" & "p_EndDate".
			props.put(APIConst.TAG_PARAM_PREFIX + "p_StartDate", "January 1, 2006");
			props.put(APIConst.TAG_PARAM_PREFIX + "p_EndDate", today);
			
			//set result type as .rst format
			props.put(APIConst.TAG_RESULT_TYPE, String.valueOf(APIConst.RST));

			System.out.println("\n========to rst="+props);
			String tempResult = server.runReport("admin", catalog, rptName, props);
			System.out.println("========tempResult="+tempResult);
			
			String localFolder = "c:\\JReport\\Server\\temp\\";
			//copy remote temp result file to local folder.
			remoteFileService.copyFromRemote(tempResult, localFolder);

			//export to pdf
			props.put(APIConst.TAG_PDF, "true");
			props.put(APIConst.TAG_PDF_DIR, "c:\\JReport\\Server\\temp\\");			
			props.put(APIConst.TAG_TO_DISK,true);
			//export to html, and specify html result name
			//(to html and to rtf need specify result name)
			props.put(APIConst.TAG_HTML, "html_CustomerAnalysis");

			System.out.println("\n========exportResult="+props);
			ExportedFileList fileList = server.exportResult("admin", tempResult, props);

			System.out.println("\n========fileList.getPDFFilename()="+fileList.getPDFFilename());
			System.out.println("\n========fileList.getHTMLFilenameList()="+fileList.getHTMLFilenameList());
			
			server = null;
			System.out.println("\n========after exit, server=" + server);
		} catch (Throwable t) {
			t.printStackTrace();
		}
		System.exit(0);
	}
}
